/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.geo;

import com.google.common.base.Preconditions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.awt.geom.Area;
import java.io.IOException;
import java.util.List;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.RegionUtils;
import org.opensha.commons.geo.json.Feature;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_RegionLoader;

@JsonAdapter(value=Adapter.class)
public class CubedGriddedRegion {
    static final boolean D = false;
    static final double DEFAULT_MAX_DEPTH = 24.0;
    static final int DEFAULT_NUM_CUBE_DEPTHS = 12;
    static final int DEFAULT_NUM_CUBES_PER_GRID_EDGE = 5;
    private double maxDepth;
    private int numCubeDepths;
    private int numCubesPerGridEdge;
    private double cubeLatLonSpacing;
    private double cubeDepthDiscr;
    private int numCubesPerDepth;
    private int numCubes;
    private int numCubesPerGridCell;
    private GriddedRegion griddedRegion;
    private GriddedRegion griddedRegionModified;
    private GriddedRegion gridRegForCubes;
    public static final String JSON_MAX_DEPTH = "MaxDepth";
    public static final String JSON_NUM_CUBE_DEPTHS = "NumCubeDepths";
    public static final String JSON_NUM_CUBES_PER_GRID_EDGE = "NumCubesPerGridEdge";

    public CubedGriddedRegion(GriddedRegion griddedRegion) {
        this(griddedRegion, 24.0, 12, 5);
    }

    public CubedGriddedRegion(GriddedRegion griddedRegion, double maxDepth, int numCubeDepths, int numCubesPerGridEdge) {
        this.maxDepth = maxDepth;
        this.numCubeDepths = numCubeDepths;
        this.numCubesPerGridEdge = numCubesPerGridEdge;
        this.griddedRegion = griddedRegion;
        if (!griddedRegion.isSpacingUniform()) {
            throw new RuntimeException("Lat and Lon discretization must be equal in griddedRegion");
        }
        Region exactRegion = CubedGriddedRegion.getRegionDefinedByExteriorCellEdges(griddedRegion);
        this.griddedRegionModified = new GriddedRegion(exactRegion, griddedRegion.getSpacing(), griddedRegion.getLocation(0));
        if (this.griddedRegionModified.getNodeCount() != griddedRegion.getNodeCount()) {
            System.err.println("WARNING: modified exterior cell edges failed for region, reverting to original");
            this.griddedRegionModified = griddedRegion;
        }
        this.cubeLatLonSpacing = this.griddedRegionModified.getLatSpacing() / (double)numCubesPerGridEdge;
        this.cubeDepthDiscr = maxDepth / (double)numCubeDepths;
        this.gridRegForCubes = numCubesPerGridEdge % 2 == 0 ? new GriddedRegion(this.griddedRegionModified, this.cubeLatLonSpacing, new Location(this.cubeLatLonSpacing / 2.0, this.cubeLatLonSpacing / 2.0)) : new GriddedRegion(this.griddedRegionModified, this.cubeLatLonSpacing, GriddedRegion.ANCHOR_0_0);
        this.numCubesPerDepth = this.gridRegForCubes.getNumLocations();
        this.numCubes = this.numCubesPerDepth * numCubeDepths;
        this.numCubesPerGridCell = numCubeDepths * numCubesPerGridEdge * numCubesPerGridEdge;
        this.testNumCubesInEachCell();
        this.testGetCubeIndicesForGridCell();
    }

    private int[] getCubeRegAndDepIndicesForIndex(int cubeIndex) {
        int[] indices = new int[2];
        indices[1] = (int)Math.floor((double)cubeIndex / (double)this.numCubesPerDepth);
        if (indices[1] >= this.numCubeDepths) {
            System.out.println("PROBLEM: " + cubeIndex + "\t" + this.numCubesPerDepth + "\t" + indices[1] + "\t" + this.numCubeDepths);
        }
        indices[0] = cubeIndex - indices[1] * this.numCubesPerDepth;
        return indices;
    }

    public Location getCubeLocationForIndex(int cubeIndex) {
        int[] regAndDepIndex = this.getCubeRegAndDepIndicesForIndex(cubeIndex);
        Location regLoc = this.gridRegForCubes.getLocation(regAndDepIndex[0]);
        return new Location(regLoc.getLatitude(), regLoc.getLongitude(), this.getCubeDepth(regAndDepIndex[1]));
    }

    public int getRegionIndexForCubeIndex(int cubeIndex) {
        Location cubeLoc = this.getCubeLocationForIndex(cubeIndex);
        int ret = this.griddedRegionModified.indexForLocation(cubeLoc);
        return ret;
    }

    public int getDepthIndexForCubeIndex(int cubeIndex) {
        return this.getCubeRegAndDepIndicesForIndex(cubeIndex)[1];
    }

    public int getCubeIndexForLocation(Location loc) {
        int iReg = this.gridRegForCubes.indexForLocation(loc);
        if (iReg == -1) {
            return -1;
        }
        int iDep = this.getCubeDepthIndex(loc.getDepth());
        return this.getCubeIndexForRegAndDepIndices(iReg, iDep);
    }

    public int getCubeIndexForRegAndDepIndices(int iReg, int iDep) {
        int index = iDep * this.numCubesPerDepth + iReg;
        if (index < this.numCubes && index >= 0) {
            return index;
        }
        return -1;
    }

    public int getCubeDepthIndex(double depth) {
        int index = (int)Math.round((depth - this.cubeDepthDiscr / 2.0) / this.cubeDepthDiscr);
        return index;
    }

    public double getCubeDepth(int depthIndex) {
        return (double)depthIndex * this.cubeDepthDiscr + this.cubeDepthDiscr / 2.0;
    }

    public static Region getRegionDefinedByExteriorCellEdges(GriddedRegion griddedRegion) {
        double latSpacing = griddedRegion.getLatSpacing();
        double lonSpacing = griddedRegion.getLonSpacing();
        double[] latNodes = griddedRegion.getLatNodes();
        double[] lonNodes = griddedRegion.getLonNodes();
        Area area = null;
        for (int i = 0; i < latNodes.length; ++i) {
            int j;
            double lat = latNodes[i];
            int[] indexes = new int[lonNodes.length];
            Location[] locs = new Location[lonNodes.length];
            for (j = 0; j < lonNodes.length; ++j) {
                double lon = lonNodes[j];
                locs[j] = new Location(lat, lon);
                indexes[j] = griddedRegion.indexForLocation(locs[j]);
            }
            for (j = 0; j < lonNodes.length; ++j) {
                if (indexes[j] < 0) continue;
                Location loc1 = locs[j];
                Location loc2 = locs[j];
                int j1 = j + 1;
                while (j1 < lonNodes.length && indexes[j1] >= 0) {
                    loc2 = locs[j1];
                    j = j1++;
                }
                Area subArea = CubedGriddedRegion.areaForGridCell(loc1, loc2, latSpacing * 0.5, lonSpacing * 0.5);
                if (area == null) {
                    area = subArea;
                    continue;
                }
                area.add(subArea);
            }
        }
        List<LocationList> modLocList = RegionUtils.areaToLocLists(area);
        Preconditions.checkState((modLocList.size() == 1 ? 1 : 0) != 0, (String)"LocListList size=%s", (int)modLocList.size());
        return new Region(modLocList.get(0), BorderType.MERCATOR_LINEAR);
    }

    private static Area areaForGridCell(Location loc1, Location loc2, double deltaLat, double deltaLon) {
        Region reg = new Region(new Location(loc1.getLatitude() - deltaLat, loc1.getLongitude() - deltaLon), new Location(loc2.getLatitude() + deltaLat * 1.05, loc2.getLongitude() + deltaLon * 1.05));
        return reg.getShape();
    }

    public int[] getCubeIndicesForGridCell(int gridIndex) {
        int[] cubeIndexArray = new int[this.numCubesPerGridCell];
        Location loc = this.griddedRegionModified.getLocation(gridIndex);
        double gridSpacing = this.griddedRegionModified.getSpacing();
        int index = 0;
        for (double lat = loc.getLatitude() - gridSpacing / 2.0 + this.cubeLatLonSpacing / 2.0; lat < loc.getLatitude() + gridSpacing / 2.0; lat += this.cubeLatLonSpacing) {
            for (double lon = loc.getLongitude() - gridSpacing / 2.0 + this.cubeLatLonSpacing / 2.0; lon < loc.getLongitude() + gridSpacing / 2.0; lon += this.cubeLatLonSpacing) {
                for (double dep = this.cubeDepthDiscr / 2.0; dep < this.maxDepth; dep += this.cubeDepthDiscr) {
                    cubeIndexArray[index] = this.getCubeIndexForLocation(new Location(lat, lon, dep));
                    ++index;
                }
            }
        }
        return cubeIndexArray;
    }

    public GriddedRegion getGriddedRegion() {
        return this.griddedRegion;
    }

    public double getMaxDepth() {
        return this.maxDepth;
    }

    public int getNumCubes() {
        return this.numCubes;
    }

    @Deprecated
    public int getNumPtSrcSubPts() {
        return this.getNumCubesPerGridEdge();
    }

    public int getNumCubesPerGridEdge() {
        return this.numCubesPerGridEdge;
    }

    @Deprecated
    public double getDepthDiscr() {
        return this.getCubeDepthDiscr();
    }

    public double getCubeDepthDiscr() {
        return this.cubeDepthDiscr;
    }

    public int getNumCubeDepths() {
        return this.numCubeDepths;
    }

    @Deprecated
    public double getPointSrcDiscr() {
        return this.getGriddedRegionSpacing();
    }

    public double getGriddedRegionSpacing() {
        return this.griddedRegion.getSpacing();
    }

    public double getCubeLatLonSpacing() {
        return this.cubeLatLonSpacing;
    }

    public GriddedRegion getGridRegForCubes() {
        return this.gridRegForCubes;
    }

    private void testGetCubeIndicesForGridCell() {
        int[] cubeUsed = new int[this.numCubes];
        for (int g = 0; g < this.griddedRegionModified.getNumLocations(); ++g) {
            int[] nArray = this.getCubeIndicesForGridCell(g);
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int i2;
                int n2 = i2 = nArray[i];
                cubeUsed[n2] = cubeUsed[n2] + 1;
            }
        }
        for (int i : cubeUsed) {
            if (i == 1) continue;
            throw new RuntimeException("testGetCubeIndicesForGridCell() failed");
        }
    }

    private void testNumCubesInEachCell() {
        int[] numCubesInGrid = new int[this.griddedRegionModified.getNumLocations()];
        for (int c = 0; c < this.numCubes; ++c) {
            int gridIndex = this.getRegionIndexForCubeIndex(c);
            if (gridIndex == -1) {
                throw new RuntimeException("Cube is outside region; there is no cell for the cube at " + String.valueOf(this.getCubeLocationForIndex(c)));
            }
            int n = gridIndex;
            numCubesInGrid[n] = numCubesInGrid[n] + 1;
        }
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int val : numCubesInGrid) {
            if (min > val) {
                min = val;
            }
            if (max >= val) continue;
            max = val;
        }
        if (min != this.numCubesPerGridCell || max != this.numCubesPerGridCell) {
            System.out.println("maxNumCubesInGrid=" + max + "\nminNumCubesInGrid=" + min);
            throw new RuntimeException("Problem: non-equal number of cubes in each cell\n\n\tmaxNumCubesInGrid=" + max + "\n\tminNumCubesInGrid=" + min);
        }
    }

    public Feature toFeature() {
        Feature feature = this.getGriddedRegion().toFeature();
        feature.properties.put(JSON_MAX_DEPTH, this.maxDepth);
        feature.properties.put(JSON_NUM_CUBE_DEPTHS, this.numCubeDepths);
        feature.properties.put(JSON_NUM_CUBES_PER_GRID_EDGE, this.numCubesPerGridEdge);
        return feature;
    }

    public static CubedGriddedRegion fromFeature(Feature feature) {
        GriddedRegion gridReg = GriddedRegion.fromFeature(feature);
        return CubedGriddedRegion.fromFeature(gridReg, feature);
    }

    public static CubedGriddedRegion fromFeature(GriddedRegion gridReg, Feature feature) {
        double maxDepth = feature.properties.getDouble(JSON_MAX_DEPTH, Double.NaN);
        Preconditions.checkState((boolean)Double.isFinite(maxDepth), (Object)"GeoJSON must contain MaxDepth");
        int numCubeDepths = feature.properties.getInt(JSON_NUM_CUBE_DEPTHS, -1);
        Preconditions.checkState((numCubeDepths > 0 ? 1 : 0) != 0, (Object)"GeoJSON must contain NumCubeDepths");
        int numCubesPerGridEdge = feature.properties.getInt(JSON_NUM_CUBES_PER_GRID_EDGE, -1);
        Preconditions.checkState((numCubesPerGridEdge > 0 ? 1 : 0) != 0, (Object)"GeoJSON must contain NumCubesPerGridEdge");
        return new CubedGriddedRegion(gridReg, maxDepth, numCubeDepths, numCubesPerGridEdge);
    }

    public static void main(String[] args) throws IOException {
        for (NSHM23_RegionLoader.SeismicityRegions seisReg : NSHM23_RegionLoader.SeismicityRegions.values()) {
            System.out.println("Testing CubedGriddedRegion instantiation for " + String.valueOf(seisReg));
            Region reg = seisReg.load();
            GriddedRegion griddedRegion = new GriddedRegion(reg, 0.1, GriddedRegion.ANCHOR_0_0);
            System.out.println("Original gridded region has " + griddedRegion.getNodeCount() + " locations");
            new CubedGriddedRegion(griddedRegion);
        }
    }

    public static class Adapter
    extends TypeAdapter<CubedGriddedRegion> {
        private Feature.FeatureAdapter featureAdapter = new Feature.FeatureAdapter();

        public void write(JsonWriter out, CubedGriddedRegion value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.featureAdapter.write(out, value.toFeature());
            }
        }

        public CubedGriddedRegion read(JsonReader in) throws IOException {
            Feature feature = this.featureAdapter.read(in);
            return CubedGriddedRegion.fromFeature(feature);
        }
    }
}

