/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.geo;

import com.google.common.base.Preconditions;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.DataUtils;

public class GeoTools {
    public static final double EARTH_RADIUS_MEAN = 6371.0072;
    public static final double EARTH_RADIUS_EQUATORIAL = 6378.137;
    public static final double EARTH_RADIUS_POLAR = 6356.7523;
    public static final double LAT_MIN = -90.0;
    public static final double LAT_MAX = 90.0;
    public static final double LON_MIN = -180.0;
    public static final double LON_MAX = 360.0;
    public static final double DEPTH_MIN = -5.0;
    public static final double DEPTH_MAX = 700.0;
    public static final double TO_RAD = Math.toRadians(1.0);
    public static final double TO_DEG = Math.toDegrees(1.0);
    public static final double TWOPI = Math.PI * 2;
    public static final double PI_BY_2 = 1.5707963267948966;
    public static final double SECONDS_PER_DEGREE = 3600.0;
    public static final double MINUTES_PER_DEGREE = 60.0;

    public static final void validateLats(double[] lats) {
        DataUtils.validate(-90.0, 90.0, lats);
    }

    public static final void validateLat(double lat) {
        DataUtils.validate(-90.0, 90.0, lat);
    }

    public static void validateLons(double[] lons) {
        DataUtils.validate(-180.0, 360.0, lons);
    }

    public static void validateLon(double lon) {
        DataUtils.validate(-180.0, 360.0, lon);
    }

    public static void validateDepths(double[] depths) {
        DataUtils.validate(-5.0, 700.0, depths);
    }

    public static void validateDepth(double depth) {
        DataUtils.validate(-5.0, 700.0, depth);
    }

    public static double radiusAtLocation(Location p) {
        Preconditions.checkNotNull((Object)p, (Object)"Supplied location is null");
        double cosL = Math.cos(p.getLatRad());
        double sinL = Math.sin(p.getLatRad());
        double C12 = cosL * 6378.137;
        double C22 = C12 * 6378.137;
        double C3 = sinL * 6356.7523;
        double C4 = C3 * 6356.7523;
        return Math.sqrt((C22 * C22 + C4 * C4) / (C12 * C12 + C3 * C3));
    }

    public static double degreesLatPerKm(Location p) {
        return TO_DEG / GeoTools.radiusAtLocation((Location)Preconditions.checkNotNull((Object)p));
    }

    public static double degreesLonPerKm(Location p) {
        return TO_DEG / (6378.137 * Math.cos(((Location)Preconditions.checkNotNull((Object)p)).getLatRad()));
    }

    public static double secondsToDeg(double seconds) {
        return seconds / 3600.0;
    }

    public static double minutesToDeg(double minutes) {
        return minutes / 60.0;
    }

    public static double toDecimalDegrees(double degrees, double minutes) {
        return degrees < 0.0 ? degrees - GeoTools.minutesToDeg(minutes) : degrees + GeoTools.minutesToDeg(minutes);
    }
}

