/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.geo;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;

public class RegionUtils {
    private static final String NL = SystemUtils.LINE_SEPARATOR;

    public static void regionToKML(Region region, String filename, Color c) {
        String kmlFileName = filename + ".kml";
        Document doc = DocumentHelper.createDocument();
        DefaultElement root = new DefaultElement("kml", new Namespace("", "http://www.opengis.net/kml/2.2"));
        doc.add((Element)root);
        Element e_doc = root.addElement("Document");
        Element e_doc_name = e_doc.addElement("name");
        e_doc_name.addText(kmlFileName);
        RegionUtils.addBorderStyle(e_doc, c);
        RegionUtils.addBorderVertexStyle(e_doc);
        RegionUtils.addGridNodeStyle(e_doc, c);
        Element e_folder = e_doc.addElement("Folder");
        Element e_folder_name = e_folder.addElement("name");
        e_folder_name.addText("region");
        Element e_open = e_folder.addElement("open");
        e_open.addText("1");
        RegionUtils.addBorder(e_folder, region);
        RegionUtils.addPoints(e_folder, "Border Nodes", region.getBorder(), Style.BORDER_VERTEX);
        if (region.getInteriors() != null) {
            for (LocationList interior : region.getInteriors()) {
                RegionUtils.addPoints(e_folder, "Interior Nodes", interior, Style.BORDER_VERTEX);
            }
        }
        if (region instanceof GriddedRegion) {
            RegionUtils.addPoints(e_folder, "Grid Nodes", ((GriddedRegion)region).getNodeList(), Style.GRID_NODE);
        }
        String outDirName = "sha_kml/";
        File outDir = new File(outDirName);
        outDir.mkdirs();
        String tmpFile = outDirName + kmlFileName;
        try {
            OutputFormat format = new OutputFormat("\t", true);
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(tmpFile), format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void locListToKML(LocationList locs, String filename, Color c) {
        String kmlFileName = filename + ".kml";
        Document doc = DocumentHelper.createDocument();
        DefaultElement root = new DefaultElement("kml", new Namespace("", "http://www.opengis.net/kml/2.2"));
        doc.add((Element)root);
        Element e_doc = root.addElement("Document");
        Element e_doc_name = e_doc.addElement("name");
        e_doc_name.addText(kmlFileName);
        RegionUtils.addBorderStyle(e_doc, c);
        RegionUtils.addBorderVertexStyle(e_doc);
        RegionUtils.addGridNodeStyle(e_doc, c);
        Element e_folder = e_doc.addElement("Folder");
        Element e_folder_name = e_folder.addElement("name");
        e_folder_name.addText("region");
        Element e_open = e_folder.addElement("open");
        e_open.addText("1");
        RegionUtils.addLocationLine(e_folder, locs);
        RegionUtils.addPoints(e_folder, "Border Nodes", locs, Style.BORDER_VERTEX);
        String outDirName = "sha_kml/";
        File outDir = new File(outDirName);
        outDir.mkdirs();
        String tmpFile = outDirName + kmlFileName;
        try {
            OutputFormat format = new OutputFormat("\t", true);
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(tmpFile), format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static Element addBorder(Element e, Region region) {
        Element e_placemark = e.addElement("Placemark");
        Element e_name = e_placemark.addElement("name");
        e_name.addText("Border");
        Element e_style = e_placemark.addElement("styleUrl");
        e_style.addText("#" + Style.BORDER.toString());
        Element e_poly = e_placemark.addElement("Polygon");
        Element e_tessellate = e_poly.addElement("tessellate");
        e_tessellate.addText("1");
        RegionUtils.addPoly(e_poly, "outerBoundaryIs", region.getBorder());
        if (region.getInteriors() != null) {
            for (LocationList interior : region.getInteriors()) {
                RegionUtils.addPoly(e_poly, "innerBoundaryIs", interior);
            }
        }
        return e;
    }

    private static Element addLocationPoly(Element e, LocationList locs) {
        Element e_placemark = e.addElement("Placemark");
        Element e_name = e_placemark.addElement("name");
        e_name.addText("Border");
        Element e_style = e_placemark.addElement("styleUrl");
        e_style.addText("#" + Style.BORDER.toString());
        Element e_poly = e_placemark.addElement("Polygon");
        Element e_tessellate = e_poly.addElement("tessellate");
        e_tessellate.addText("1");
        RegionUtils.addPoly(e_poly, "outerBoundaryIs", locs);
        return e;
    }

    private static Element addPoly(Element e, String polyName, LocationList locations) {
        Element e_BI = e.addElement(polyName);
        Element e_LR = e_BI.addElement("LinearRing");
        Element e_coord = e_LR.addElement("coordinates");
        StringBuffer sb = new StringBuffer(NL);
        for (Location loc : locations) {
            sb.append(loc.toKML() + NL);
        }
        sb.append(((Location)locations.get(0)).toKML() + NL);
        e_coord.addText(sb.toString());
        return e;
    }

    private static Element addLocationLine(Element e, LocationList locs) {
        Element e_placemark = e.addElement("Placemark");
        Element e_name = e_placemark.addElement("name");
        e_name.addText("Trace");
        Element e_style = e_placemark.addElement("styleUrl");
        e_style.addText("#" + Style.BORDER.toString());
        Element e_line = e_placemark.addElement("LineString");
        Element e_tessellate = e_line.addElement("tessellate");
        e_tessellate.addText("1");
        Element e_coord = e_line.addElement("coordinates");
        StringBuffer sb = new StringBuffer(NL);
        for (Location loc : locs) {
            sb.append(loc.toKML() + NL);
        }
        e_coord.addText(sb.toString());
        return e;
    }

    private static Element addPoints(Element e, String folderName, LocationList locations, Style style) {
        Element e_folder = e.addElement("Folder");
        Element e_folder_name = e_folder.addElement("name");
        e_folder_name.addText(folderName);
        Element e_open = e_folder.addElement("open");
        e_open.addText("0");
        for (Location loc : locations) {
            Element e_placemark = e_folder.addElement("Placemark");
            Element e_style = e_placemark.addElement("styleUrl");
            e_style.addText("#" + style.toString());
            Element e_poly = e_placemark.addElement("Point");
            Element e_coord = e_poly.addElement("coordinates");
            e_coord.addText(loc.toKML());
        }
        return e;
    }

    private static Element addBorderStyle(Element e, Color c) {
        Element e_style = e.addElement("Style");
        e_style.addAttribute("id", Style.BORDER.toString());
        Element e_lineStyle = e_style.addElement("LineStyle");
        Element e_color = e_lineStyle.addElement("color");
        e_color.addText(RegionUtils.colorToHex(c));
        Element e_width = e_lineStyle.addElement("width");
        e_width.addText("3");
        Element e_polyStyle = e_style.addElement("PolyStyle");
        e_polyStyle.add((Element)e_color.clone());
        Element e_fill = e_polyStyle.addElement("fill");
        e_fill.addText("0");
        return e;
    }

    private static Element addBorderVertexStyle(Element e) {
        Element e_style = e.addElement("Style");
        e_style.addAttribute("id", Style.BORDER_VERTEX.toString());
        Element e_iconStyle = e_style.addElement("IconStyle");
        Element e_color = e_iconStyle.addElement("color");
        e_color.addText(RegionUtils.colorToHex(Color.RED));
        Element e_scale = e_iconStyle.addElement("scale");
        e_scale.addText("0.6");
        Element e_icon = e_iconStyle.addElement("Icon");
        Element e_href = e_icon.addElement("href");
        e_href.addText("http://maps.google.com/mapfiles/kml/shapes/open-diamond.png");
        return e;
    }

    private static Element addGridNodeStyle(Element e, Color c) {
        Element e_style = e.addElement("Style");
        e_style.addAttribute("id", Style.GRID_NODE.toString());
        Element e_iconStyle = e_style.addElement("IconStyle");
        Element e_color = e_iconStyle.addElement("color");
        e_color.addText(RegionUtils.colorToHex(c));
        Element e_scale = e_iconStyle.addElement("scale");
        e_scale.addText("0.6");
        Element e_icon = e_iconStyle.addElement("Icon");
        Element e_href = e_icon.addElement("href");
        e_href.addText("http://maps.google.com/mapfiles/kml/shapes/placemark_circle.png");
        return e;
    }

    private static String colorToHex(Color c) {
        StringBuffer sb = new StringBuffer();
        sb.append(RegionUtils.toHex(c.getAlpha()));
        sb.append(RegionUtils.toHex(c.getBlue()));
        sb.append(RegionUtils.toHex(c.getGreen()));
        sb.append(RegionUtils.toHex(c.getRed()));
        return sb.toString();
    }

    private static String toHex(int i) {
        return StringUtils.leftPad((String)Integer.toHexString(i), (int)2, (char)'0');
    }

    public static double getFractionInside(Region region, Iterable<Location> locs) throws NullPointerException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)region, (Object)"region cannot be null");
        Preconditions.checkNotNull(locs, (Object)"locations cannot be null");
        int numInside = 0;
        int cnt = 0;
        for (Location loc : locs) {
            if (region.contains(loc)) {
                ++numInside;
            }
            ++cnt;
        }
        Preconditions.checkArgument((cnt > 0 ? 1 : 0) != 0, (Object)"locs must contain at least one location!");
        return (double)numInside / (double)cnt;
    }

    public static Area getNodeShape(Location p, double w, double h) {
        double halfW = w / 2.0;
        double halfH = h / 2.0;
        double nodeLat = p.getLatitude();
        double nodeLon = p.getLongitude();
        LocationList locs = new LocationList();
        locs.add(new Location(nodeLat + halfH, nodeLon + halfW));
        locs.add(new Location(nodeLat - halfH, nodeLon + halfW));
        locs.add(new Location(nodeLat - halfH, nodeLon - halfW));
        locs.add(new Location(nodeLat + halfH, nodeLon - halfW));
        return new Area(locs.toPath());
    }

    public static List<LocationList> areaToLocLists(Area area) {
        ArrayList<LocationList> locLists = new ArrayList<LocationList>();
        LocationList locs = null;
        double[] vertex = new double[6];
        PathIterator pi = area.getPathIterator(null);
        while (!pi.isDone()) {
            int type = pi.currentSegment(vertex);
            double lon = vertex[0];
            double lat = vertex[1];
            if (type == 0) {
                locs = new LocationList();
                locLists.add(locs);
                locs.add(new Location(lat, lon));
            } else if (type == 1) {
                locs.add(new Location(lat, lon));
            }
            pi.next();
        }
        return locLists;
    }

    public static void main(String[] args) {
    }

    public static enum Style {
        BORDER,
        BORDER_VERTEX,
        GRID_NODE;

    }
}

