/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.geo.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.AbstractGeoJSON_TypeAdapter;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.geo.json.GeoJSON_Type;

@JsonAdapter(value=GeometryAdapter.class)
public class Geometry {
    public final GeoJSON_Type type;
    private boolean serializeZeroDepth;
    public static final DepthSerializationType DEPTH_SERIALIZATION_DEFAULT = DepthSerializationType.DEPTH_KM;

    private Geometry(GeoJSON_Type type, boolean serializeZeroDepth) {
        Preconditions.checkState((boolean)GeoJSON_Type.GEOM_TYPES.contains((Object)type), (String)"Type is not a valid geometry type: %s", (Object)((Object)type));
        this.type = type;
        this.serializeZeroDepth = serializeZeroDepth;
    }

    public boolean isSerializeZeroDepths() {
        return this.serializeZeroDepth;
    }

    public void setSerializeZeroDepths(boolean serializeZeroDepth) {
        this.serializeZeroDepth = serializeZeroDepth;
    }

    private static boolean coordsHaveDepths(List<Coordinates> coords) {
        for (Coordinates coord : coords) {
            if (!(coord.location == null ? Geometry.coordsHaveDepths(coord.coords) : coord.location.length > 2)) continue;
            return true;
        }
        return false;
    }

    private static boolean geomsHaveDepths(List<? extends Geometry> geometries) {
        for (Geometry geometry : geometries) {
            if (!geometry.serializeZeroDepth) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNonZeroDepth(List<Location> locs) {
        for (Location loc : locs) {
            if (!Geometry.hasNonZeroDepth(loc)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNonZeroDepths(List<? extends List<Location>> lines) {
        for (List<Location> list : lines) {
            if (!Geometry.hasNonZeroDepth(list)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNonZeroDepth(Location ... locs) {
        for (Location loc : locs) {
            if (!Geometry.hasNonZeroDepth(loc)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNonZeroDepth(Location loc) {
        return loc.getDepth() != 0.0;
    }

    private static void parseCoordsRecursive(JsonReader in, Coordinates coords) throws IOException {
        Geometry.doParseCoordsRecursive(in, coords);
        LonRange range = new LonRange();
        Geometry.lonRangeRecursive(coords, range);
        double span = range.max - range.min;
        if (range.min < -180.0 || range.max > 360.0) {
            if (span > 360.0) {
                System.err.println("WARNING loading GeoJSON coordinates: longitudes range outside of [-180, 360] and can't correct because span is > 360: [" + (float)range.min + ", " + (float)range.max + "]");
            } else {
                double delta = 0.0;
                if (range.min < -180.0) {
                    double min = range.min;
                    while (min < -180.0) {
                        min = range.min + (delta += 360.0);
                    }
                } else {
                    double max = range.max;
                    while (max > 360.0) {
                        max = range.max + (delta -= 360.0);
                    }
                }
                System.err.println("WARNING loading GeoJSON coordinates: longitudes range outside of [-180, 360], shifting by " + (float)delta + " degrees. Original range: [" + (float)range.min + ", " + (float)range.max + "]");
                Geometry.coordLonShiftRecursive(coords, delta);
            }
        }
    }

    private static void doParseCoordsRecursive(JsonReader in, Coordinates coords) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return;
        }
        in.beginArray();
        JsonToken token = in.peek();
        if (token == JsonToken.BEGIN_ARRAY) {
            coords.coords = new ArrayList<Coordinates>();
            while (in.hasNext()) {
                Coordinates subCoords = new Coordinates(coords.depthType);
                coords.coords.add(subCoords);
                Geometry.doParseCoordsRecursive(in, subCoords);
            }
        } else {
            coords.location = Geometry.deserializeLocWithinArray(in);
        }
        in.endArray();
    }

    private static void lonRangeRecursive(Coordinates coords, LonRange range) {
        if (coords.location != null) {
            double lon = coords.location[0];
            range.min = Math.min(lon, range.min);
            range.max = Math.max(lon, range.max);
        }
        if (coords.coords != null) {
            for (Coordinates subCoords : coords.coords) {
                Geometry.lonRangeRecursive(subCoords, range);
            }
        }
    }

    private static void coordLonShiftRecursive(Coordinates coords, double delta) {
        if (coords.location != null) {
            coords.location[0] = coords.location[0] + delta;
        }
        if (coords.coords != null) {
            for (Coordinates subCoords : coords.coords) {
                Geometry.coordLonShiftRecursive(subCoords, delta);
            }
        }
    }

    public static void serializeLoc(JsonWriter out, Location loc, DepthSerializationType depthType, boolean serializeZeros) throws IOException {
        if (loc == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        out.value(loc.getLongitude());
        out.value(loc.getLatitude());
        if (serializeZeros || loc.getDepth() != 0.0) {
            out.value(depthType.toGeoJSON(loc.getDepth()));
        }
        out.endArray();
    }

    private static double[] deserializeLocWithinArray(JsonReader in) throws IOException {
        double lon = in.nextDouble();
        double lat = in.nextDouble();
        if (in.peek() != JsonToken.END_ARRAY) {
            return new double[]{lon, lat, in.nextDouble()};
        }
        return new double[]{lon, lat};
    }

    private static LocationList deserializePoints(List<Coordinates> coords) {
        LocationList points = new LocationList();
        if (coords == null || coords.isEmpty()) {
            return points;
        }
        for (Coordinates subCoords : coords) {
            Preconditions.checkState((subCoords.coords == null ? 1 : 0) != 0);
            points.add(subCoords.toLoc());
        }
        return points;
    }

    private static void serializePolygon(JsonWriter out, Polygon polygon, DepthSerializationType depthType, boolean serializeZeros) throws IOException {
        out.beginArray();
        out.beginArray();
        for (Location loc : Geometry.getPolygonBorder(polygon.polygon, false)) {
            Geometry.serializeLoc(out, loc, depthType, serializeZeros);
        }
        out.endArray();
        if (polygon.holes != null) {
            for (LocationList interior : polygon.holes) {
                out.beginArray();
                for (Location loc : Geometry.getPolygonBorder(interior, true)) {
                    Geometry.serializeLoc(out, loc, depthType, serializeZeros);
                }
                out.endArray();
            }
        }
        out.endArray();
    }

    public static LocationList getPolygonBorder(LocationList border, boolean hole) {
        if (!(border = border.clone()).first().equals(border.last())) {
            border.add(border.first());
        }
        Location prev = null;
        double directionTest = 0.0;
        for (Location loc : border) {
            if (prev != null) {
                directionTest += (loc.getLongitude() - prev.getLongitude()) * (loc.getLatitude() + prev.getLatitude());
            }
            prev = loc;
        }
        if (hole && directionTest < 0.0 || !hole && directionTest > 0.0) {
            border.reverse();
        }
        return border;
    }

    public String toJSON() throws IOException {
        StringWriter writer = new StringWriter();
        Geometry.write(this, writer);
        return writer.toString();
    }

    public static Geometry fromJSON(String json) throws IOException {
        StringReader reader = new StringReader(json);
        return Geometry.read(reader);
    }

    public static Geometry read(File jsonFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        return Geometry.read(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Geometry read(Reader reader) throws IOException {
        Geometry ret;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        Gson gson = FeatureCollection.gson_default;
        synchronized (gson) {
            ret = (Geometry)FeatureCollection.gson_default.fromJson(reader, Geometry.class);
            reader.close();
        }
        return ret;
    }

    public static void write(Geometry geometry, File jsonFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(jsonFile));
        Geometry.write(geometry, writer);
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Geometry geometry, Writer writer) throws IOException {
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        Gson gson = FeatureCollection.gson_default;
        synchronized (gson) {
            FeatureCollection.gson_default.toJson((Object)geometry, Geometry.class, (Appendable)writer);
            writer.flush();
        }
    }

    private static class Coordinates {
        private double[] location;
        private List<Coordinates> coords;
        private DepthSerializationType depthType;

        public Coordinates(DepthSerializationType depthType) {
            this.depthType = depthType;
        }

        public Location toLoc() {
            Preconditions.checkNotNull((Object)this.location);
            if (this.location.length > 2) {
                return new Location(this.location[1], this.location[0], this.depthType.fromGeoJSON(this.location[2]));
            }
            return new Location(this.location[1], this.location[0]);
        }
    }

    private static class LonRange {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;

        private LonRange() {
        }
    }

    public static enum DepthSerializationType {
        ELEVATION_M,
        DEPTH_M,
        DEPTH_KM;


        public double toGeoJSON(double depth) {
            switch (this.ordinal()) {
                case 0: {
                    return -depth * 1000.0;
                }
                case 1: {
                    return depth * 1000.0;
                }
                case 2: {
                    return depth;
                }
            }
            throw new IllegalStateException();
        }

        public double fromGeoJSON(double depth) {
            switch (this.ordinal()) {
                case 0: {
                    return depth * -0.001;
                }
                case 1: {
                    return depth * 0.001;
                }
                case 2: {
                    return depth;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static class Polygon
    extends Geometry {
        public final LocationList polygon;
        public final LocationList[] holes;

        public Polygon(Region region) {
            super(GeoJSON_Type.Polygon, Geometry.hasNonZeroDepth(region.getBorder()));
            this.polygon = Polygon.getPolygonBorder(region.getBorder(), false);
            List<LocationList> interiors = region.getInteriors();
            if (interiors != null) {
                this.holes = new LocationList[interiors.size()];
                for (int i = 0; i < this.holes.length; ++i) {
                    this.holes[i] = Polygon.getPolygonBorder(interiors.get(i), true);
                    if (!Geometry.hasNonZeroDepth(this.holes[i])) continue;
                    this.setSerializeZeroDepths(true);
                }
            } else {
                this.holes = null;
            }
        }

        public Polygon(LocationList polygon) {
            this(polygon, null);
        }

        public Polygon(LocationList polygon, LocationList[] holes) {
            super(GeoJSON_Type.Polygon, Geometry.hasNonZeroDepth(polygon));
            this.polygon = polygon;
            this.holes = holes;
            if (holes != null && !this.isSerializeZeroDepths()) {
                for (LocationList hole : holes) {
                    if (!Geometry.hasNonZeroDepth(hole)) continue;
                    this.setSerializeZeroDepths(true);
                }
            }
        }

        private Polygon(List<Coordinates> coords) {
            super(GeoJSON_Type.Polygon, Geometry.coordsHaveDepths(coords));
            LocationList border = null;
            ArrayList<LocationList> holes = new ArrayList<LocationList>();
            for (Coordinates subCoords : coords) {
                LocationList points = Geometry.deserializePoints(subCoords.coords);
                if (border == null) {
                    border = points;
                    continue;
                }
                holes.add(points);
            }
            this.polygon = border;
            this.holes = holes.isEmpty() ? null : holes.toArray(new LocationList[0]);
        }

        public Region asRegion() {
            if (this.polygon == null) {
                return null;
            }
            Region region = new Region(this.polygon, null);
            if (this.holes != null) {
                for (LocationList interior : this.holes) {
                    region.addInterior(new Region(interior, null));
                }
            }
            return region;
        }
    }

    public static class GeometryAdapter
    extends AbstractGeoJSON_TypeAdapter<Geometry> {
        private DepthSerializationType depthType;

        public GeometryAdapter() {
            this(DEPTH_SERIALIZATION_DEFAULT);
        }

        public GeometryAdapter(DepthSerializationType depthType) {
            this.depthType = depthType;
        }

        public void write(JsonWriter out, Geometry value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value(value.type.name());
            if (value instanceof GeometryCollection) {
                out.name("geometries").beginArray();
                for (Geometry geometry : ((GeometryCollection)value).geometries) {
                    this.write(out, geometry);
                }
                out.endArray();
            } else {
                out.name("coordinates");
                boolean serializeZeros = value.isSerializeZeroDepths();
                switch (value.type) {
                    case Point: {
                        Geometry.serializeLoc(out, ((Point)value).point, this.depthType, serializeZeros);
                        break;
                    }
                    case MultiPoint: {
                        out.beginArray();
                        for (Location point : ((MultiPoint)value).points) {
                            Geometry.serializeLoc(out, point, this.depthType, serializeZeros);
                        }
                        out.endArray();
                        break;
                    }
                    case LineString: {
                        out.beginArray();
                        for (Location point : ((LineString)value).line) {
                            Geometry.serializeLoc(out, point, this.depthType, serializeZeros);
                        }
                        out.endArray();
                        break;
                    }
                    case MultiLineString: {
                        out.beginArray();
                        for (LocationList line : ((MultiLineString)value).lines) {
                            out.beginArray();
                            for (Location point : line) {
                                Geometry.serializeLoc(out, point, this.depthType, serializeZeros);
                            }
                            out.endArray();
                        }
                        out.endArray();
                        break;
                    }
                    case Polygon: {
                        Geometry.serializePolygon(out, (Polygon)value, this.depthType, serializeZeros);
                        break;
                    }
                    case MultiPolygon: {
                        out.beginArray();
                        for (Polygon polygon : ((MultiPolygon)value).polygons) {
                            Geometry.serializePolygon(out, polygon, this.depthType, serializeZeros);
                        }
                        out.endArray();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected type for a Geometry: " + String.valueOf((Object)value.type));
                    }
                }
            }
            out.endObject();
        }

        public Geometry read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            Geometry geometry = this.innerReadAsType(in, null);
            in.endObject();
            return geometry;
        }

        @Override
        public Geometry innerReadAsType(JsonReader in, GeoJSON_Type type) throws IOException {
            Geometry geometry = null;
            Coordinates coords = null;
            block18: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "type": {
                        Preconditions.checkState((type == null ? 1 : 0) != 0, (Object)"Type already declared");
                        type = GeoJSON_Type.valueOf(in.nextString());
                        Preconditions.checkState((boolean)GeoJSON_Type.GEOM_TYPES.contains((Object)type), (String)"Not a valid geometry type: %s", (Object)type.name());
                        continue block18;
                    }
                    case "geometries": {
                        Preconditions.checkState((type == null || type == GeoJSON_Type.GeometryCollection ? 1 : 0) != 0, (Object)"Only GeometryCollections should have a geometries array");
                        Preconditions.checkState((geometry == null ? 1 : 0) != 0, (Object)"Geometry already defined and geometries array encountered");
                        Preconditions.checkState((coords == null ? 1 : 0) != 0, (Object)"Coordinates already defined and geometries array encountered");
                        ImmutableList.Builder geometries = new ImmutableList.Builder();
                        in.beginArray();
                        while (in.hasNext()) {
                            geometries.add((Object)this.read(in));
                        }
                        in.endArray();
                        geometry = new GeometryCollection((List<Geometry>)geometries.build());
                        continue block18;
                    }
                    case "coordinates": {
                        Preconditions.checkState((type != GeoJSON_Type.GeometryCollection ? 1 : 0) != 0, (Object)"GeometryCollections should not have a coordinates array");
                        Preconditions.checkState((geometry == null ? 1 : 0) != 0, (Object)"Geometry already defined and coordinate array encountered");
                        Preconditions.checkState((coords == null ? 1 : 0) != 0, (Object)"Coordinates already defined and coordinate array encountered");
                        coords = new Coordinates(this.depthType);
                        Geometry.parseCoordsRecursive(in, coords);
                        continue block18;
                    }
                }
                in.skipValue();
            }
            Preconditions.checkNotNull((Object)((Object)type), (Object)"Geometry type required");
            if (geometry != null) {
                Preconditions.checkState((type == GeoJSON_Type.GeometryCollection ? 1 : 0) != 0, (Object)"Only GeometryCollections should have a geometries array");
            } else if (type == GeoJSON_Type.GeometryCollection) {
                Preconditions.checkState((coords == null ? 1 : 0) != 0, (Object)"GeometryCollection should not supply coordinates array");
                geometry = new GeometryCollection(new ArrayList<Geometry>());
            } else {
                switch (type) {
                    case Point: {
                        if (coords == null) {
                            geometry = new Point();
                            break;
                        }
                        Preconditions.checkState((coords.coords == null ? 1 : 0) != 0);
                        geometry = new Point(coords);
                        break;
                    }
                    case MultiPoint: {
                        geometry = new MultiPoint(coords.coords);
                        break;
                    }
                    case LineString: {
                        geometry = new LineString(coords.coords);
                        break;
                    }
                    case MultiLineString: {
                        Preconditions.checkState((coords.location == null ? 1 : 0) != 0);
                        if (coords.coords == null) {
                            geometry = new MultiLineString(new ArrayList<LocationList>());
                            break;
                        }
                        geometry = new MultiLineString(coords);
                        break;
                    }
                    case Polygon: {
                        geometry = new Polygon(coords.coords);
                        break;
                    }
                    case MultiPolygon: {
                        Preconditions.checkState((coords.location == null ? 1 : 0) != 0);
                        if (coords.coords == null) {
                            geometry = new MultiPolygon(new ArrayList<Polygon>());
                            break;
                        }
                        ImmutableList.Builder polys = new ImmutableList.Builder();
                        for (Coordinates subCoords : coords.coords) {
                            polys.add((Object)new Polygon(subCoords.coords));
                        }
                        geometry = new MultiPolygon((List<Polygon>)polys.build());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected type for a Geometry: " + String.valueOf((Object)type));
                    }
                }
            }
            Preconditions.checkNotNull(geometry);
            return geometry;
        }
    }

    public static class GeometryCollection
    extends Geometry {
        public final ImmutableList<Geometry> geometries;

        public GeometryCollection(Geometry ... geometries) {
            this(List.of(geometries));
        }

        public GeometryCollection(List<Geometry> geometries) {
            super(GeoJSON_Type.GeometryCollection, Geometry.geomsHaveDepths(geometries));
            this.geometries = ImmutableList.copyOf(geometries);
        }
    }

    public static class MultiPolygon
    extends Geometry {
        public final ImmutableList<Polygon> polygons;

        public MultiPolygon(List<Polygon> polygons) {
            super(GeoJSON_Type.MultiPolygon, Geometry.geomsHaveDepths(polygons));
            this.polygons = ImmutableList.copyOf(polygons);
        }

        public List<Region> asRegions() {
            ArrayList<Region> ret = new ArrayList<Region>();
            for (Polygon polygon : this.polygons) {
                ret.add(polygon.asRegion());
            }
            return ret;
        }
    }

    public static class MultiPoint
    extends Geometry {
        public final LocationList points;

        public MultiPoint(LocationList points) {
            super(GeoJSON_Type.MultiPoint, Geometry.hasNonZeroDepth(points));
            this.points = points;
        }

        private MultiPoint(List<Coordinates> coords) {
            super(GeoJSON_Type.MultiPoint, Geometry.coordsHaveDepths(coords));
            this.points = new LocationList();
            for (Coordinates coord : coords) {
                this.points.add(coord.toLoc());
            }
        }
    }

    public static class Point
    extends Geometry {
        public final Location point;

        public Point(Location point) {
            super(GeoJSON_Type.Point, Geometry.hasNonZeroDepth(point));
            this.point = point;
        }

        private Point() {
            super(GeoJSON_Type.Point, false);
            this.point = null;
        }

        public Point(Coordinates coords) {
            super(GeoJSON_Type.Point, coords.location.length > 2);
            this.point = coords.toLoc();
        }
    }

    public static class MultiLineString
    extends Geometry {
        public final ImmutableList<LocationList> lines;

        public MultiLineString(List<LocationList> lines) {
            super(GeoJSON_Type.MultiLineString, Geometry.hasNonZeroDepths(lines));
            this.lines = ImmutableList.copyOf(lines);
        }

        private MultiLineString(Coordinates coords) {
            super(GeoJSON_Type.MultiLineString, Geometry.coordsHaveDepths(coords.coords));
            ImmutableList.Builder lines = new ImmutableList.Builder();
            for (Coordinates subCoords : coords.coords) {
                lines.add((Object)new LineString(subCoords.coords).line);
            }
            this.lines = lines.build();
        }
    }

    public static class LineString
    extends Geometry {
        public final LocationList line;

        public LineString(Location ... locs) {
            super(GeoJSON_Type.LineString, Geometry.hasNonZeroDepth(locs));
            this.line = new LocationList();
            for (Location loc : locs) {
                this.line.add(loc);
            }
        }

        public LineString(LocationList line) {
            super(GeoJSON_Type.LineString, Geometry.hasNonZeroDepth(line));
            this.line = line;
        }

        private LineString(List<Coordinates> coords) {
            super(GeoJSON_Type.LineString, Geometry.coordsHaveDepths(coords));
            this.line = new LocationList();
            for (Coordinates coord : coords) {
                this.line.add(coord.toLoc());
            }
        }
    }
}

