/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensha.commons.gui.AppVersionDialog;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.BrowserUtils;
import org.opensha.commons.util.bugReports.BugReport;

public class HelpMenuBuilder
implements ActionListener {
    public static String OPENSHA_HOMEPAGE_URL = "http://www.opensha.org";
    public static String OPENSHA_DOCUMENTATION_URL = OPENSHA_HOMEPAGE_URL + "/docs";
    public static String OPENSHA_CONTACT_URL = OPENSHA_HOMEPAGE_URL + "/contact";
    private String appName;
    private String appShortName;
    private ApplicationVersion appVersion;
    private Component application;
    private JMenuItem homepageItem;
    private JMenuItem docsItem;
    private JMenuItem submitBugItem;
    private JMenuItem contactItem;
    private JMenuItem aboutItem;
    private AppVersionDialog appVersionDialog;
    private JMenuItem guideItem;
    private String guideURL;
    private JMenuItem tutorialItem;
    private String tutorialURL;

    public HelpMenuBuilder(String appName, String appShortName, ApplicationVersion appVersion, Component application) {
        this.appName = appName;
        this.appShortName = appShortName;
        this.appVersion = appVersion;
        this.application = application;
    }

    public void setGuideURL(String guideURL) {
        this.guideURL = guideURL;
    }

    public void setTutorialURL(String tutorialURL) {
        this.tutorialURL = tutorialURL;
    }

    public JMenu buildMenu() {
        JMenu helpMenu = new JMenu("Help");
        if (this.guideURL != null) {
            this.guideItem = new JMenuItem("View User Guide");
            this.guideItem.addActionListener(this);
            helpMenu.add(this.guideItem);
        }
        if (this.tutorialURL != null) {
            this.tutorialItem = new JMenuItem("View Tutorial");
            this.tutorialItem.addActionListener(this);
            helpMenu.add(this.tutorialItem);
        }
        if (helpMenu.getItemCount() > 0) {
            helpMenu.addSeparator();
        }
        this.homepageItem = new JMenuItem("OpenSHA Home Page");
        this.homepageItem.addActionListener(this);
        helpMenu.add(this.homepageItem);
        this.docsItem = new JMenuItem("Online Documentation");
        this.docsItem.addActionListener(this);
        helpMenu.add(this.docsItem);
        this.submitBugItem = new JMenuItem("Submit Bug Report");
        this.submitBugItem.addActionListener(this);
        helpMenu.add(this.submitBugItem);
        this.contactItem = new JMenuItem("Contact Developers");
        this.contactItem.addActionListener(this);
        helpMenu.add(this.contactItem);
        helpMenu.addSeparator();
        this.aboutItem = new JMenuItem("About - License");
        this.aboutItem.addActionListener(this);
        helpMenu.add(this.aboutItem);
        return helpMenu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.homepageItem) {
                BrowserUtils.launch(new URL(OPENSHA_HOMEPAGE_URL));
            } else if (e.getSource() == this.docsItem) {
                BrowserUtils.launch(new URL(OPENSHA_DOCUMENTATION_URL));
            } else if (e.getSource() == this.contactItem) {
                BrowserUtils.launch(new URL(OPENSHA_CONTACT_URL));
            } else if (e.getSource() == this.submitBugItem) {
                BugReport bug = new BugReport(null, null, this.appShortName, this.appVersion, this.application);
                BrowserUtils.launch(bug.buildIssueURL());
            } else if (this.guideItem != null && e.getSource() == this.guideItem) {
                BrowserUtils.launch(new URL(this.guideURL));
            } else if (this.tutorialItem != null && e.getSource() == this.tutorialItem) {
                BrowserUtils.launch(new URL(this.tutorialURL));
            } else if (e.getSource() == this.aboutItem) {
                if (this.appVersionDialog == null) {
                    this.appVersionDialog = new AppVersionDialog(this.appName, this.appVersion);
                }
                this.appVersionDialog.setLocationRelativeTo(this.application);
                this.appVersionDialog.setVisible(true);
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
    }
}

