/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class UserAuthDialog
extends JDialog
implements ActionListener {
    private static final boolean D = false;
    private boolean canceled = false;
    private boolean exitOnCancel = false;
    private boolean allowReadOnly = false;
    private boolean readOnly = false;
    private static final String ACTION_KEY = "theAction";
    private JPanel passwordPanel = new JPanel();
    private JButton continueButton = new JButton();
    private JButton readOnlyButton = new JButton("Read Only");
    private JPasswordField passwordText = new JPasswordField();
    private JLabel jLabel5 = new JLabel();
    private JButton cancelButton = new JButton();
    private JLabel jLabel2 = new JLabel();
    JTextField usernameText = new JTextField();
    JLabel jLabel1 = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    Action actionListener = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == UserAuthDialog.this.cancelButton) {
                UserAuthDialog.this.cancelAction();
            } else {
                UserAuthDialog.this.continueAction();
            }
        }
    };

    public UserAuthDialog(Frame owner, boolean exitOnCancel) {
        this(owner, exitOnCancel, false);
    }

    public UserAuthDialog(Frame owner, boolean exitOnCancel, boolean allowReadOnly) {
        super(owner, "Enter Username and Password", true);
        this.allowReadOnly = allowReadOnly;
        this.exitOnCancel = exitOnCancel;
        this.init();
        this.setLocationRelativeTo(owner);
    }

    private void addEnterAction(JComponent comp) {
        InputMap in = comp.getInputMap();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0, true);
        in.put(enter, ACTION_KEY);
        ActionMap actionMap = comp.getActionMap();
        actionMap.put(ACTION_KEY, this.actionListener);
    }

    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.usernameText.setForeground(new Color(80, 80, 133));
        this.usernameText.setBackground(Color.white);
        this.passwordText.setBackground(Color.white);
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().add((Component)this.passwordPanel, "Center");
        this.passwordPanel.setLayout(this.gridBagLayout1);
        this.continueButton.setFont(new Font("Dialog", 1, 12));
        this.continueButton.setForeground(new Color(80, 80, 133));
        this.continueButton.setText("Continue");
        this.continueButton.addActionListener(this);
        this.readOnlyButton.setFont(new Font("Dialog", 1, 12));
        this.readOnlyButton.setForeground(new Color(80, 80, 133));
        this.readOnlyButton.addActionListener(this);
        this.passwordText.setBackground(Color.white);
        this.passwordText.setFont(new Font("Dialog", 1, 12));
        this.passwordText.setForeground(new Color(80, 80, 133));
        this.jLabel5.setFont(new Font("Dialog", 1, 16));
        this.jLabel5.setForeground(new Color(80, 80, 133));
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setHorizontalTextPosition(0);
        this.jLabel5.setText("Authorizing User");
        this.cancelButton.setFont(new Font("Dialog", 1, 12));
        this.cancelButton.setForeground(new Color(80, 80, 133));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        this.jLabel2.setFont(new Font("Dialog", 1, 12));
        this.jLabel2.setForeground(new Color(80, 80, 133));
        this.jLabel2.setText("Enter Password:");
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setForeground(new Color(80, 80, 133));
        this.jLabel1.setText("Enter Username:");
        this.passwordPanel.add((Component)this.jLabel5, null);
        this.passwordPanel.add((Component)this.jLabel5, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 17, 0, new Insets(6, 2, 0, 4), 271, 13));
        this.passwordPanel.add((Component)this.usernameText, new GridBagConstraints(2, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(24, 0, 0, 83), 186, 7));
        this.passwordPanel.add((Component)this.passwordText, new GridBagConstraints(2, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(8, 0, 0, 83), 186, 9));
        this.passwordPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(25, 8, 0, 0), 20, 13));
        this.passwordPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 8, 0, 0), 20, 13));
        this.passwordPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(24, 0, 24, 0), 9, 0));
        this.passwordPanel.add((Component)this.continueButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(24, 25, 24, 0), 5, 0));
        if (this.allowReadOnly) {
            this.passwordPanel.add((Component)this.readOnlyButton, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(24, 25, 24, 0), 5, 0));
        }
        this.addEnterAction(this.passwordPanel);
        this.addEnterAction(this.passwordText);
        this.addEnterAction(this.usernameText);
        this.addEnterAction(this.continueButton);
        this.addEnterAction(this.cancelButton);
        this.pack();
        this.usernameText.requestFocusInWindow();
    }

    public void setUsername(String username) {
        this.usernameText.setText(username);
    }

    public String getUsername() {
        return this.usernameText.getText();
    }

    public char[] getPassword() {
        return this.passwordText.getPassword();
    }

    public static void main(String[] args) {
        System.out.println("Start");
        UserAuthDialog box = new UserAuthDialog(null, true);
        System.out.println("Middle");
        box.setVisible(true);
        System.out.println("End");
        System.exit(0);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.canceled = false;
            this.readOnly = false;
        }
        super.setVisible(visible);
    }

    public void continueAction() {
        this.setVisible(false);
        this.canceled = false;
    }

    public void cancelAction() {
        this.canceled = true;
        if (this.exitOnCancel) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.continueButton) {
            this.continueAction();
        } else if (e.getSource() == this.cancelButton) {
            this.cancelAction();
        } else if (e.getSource() == this.readOnlyButton) {
            this.readOnly = true;
            this.continueAction();
        }
    }
}

