/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageOutputStream;

public class AnimatedGIFRenderer {
    private ImageWriter writer;
    private FileImageOutputStream output;
    private ImageWriteParam imageWriteParam;
    private IIOMetadata imageMetaData;

    public AnimatedGIFRenderer(File outputFile, double fps, boolean doLoop) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersBySuffix("gif");
        Preconditions.checkArgument((boolean)iter.hasNext(), (Object)"No GIF image writers available!");
        this.writer = iter.next();
        this.imageWriteParam = this.writer.getDefaultWriteParam();
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        this.imageMetaData = this.writer.getDefaultImageMetadata(imageTypeSpecifier, this.imageWriteParam);
        String metaFormatName = this.imageMetaData.getNativeMetadataFormatName();
        IIOMetadataNode root = (IIOMetadataNode)this.imageMetaData.getAsTree(metaFormatName);
        IIOMetadataNode graphicsControlExtensionNode = AnimatedGIFRenderer.getNode(root, "GraphicControlExtension");
        int delayTime = (int)(100.0 / fps);
        graphicsControlExtensionNode.setAttribute("disposalMethod", "none");
        graphicsControlExtensionNode.setAttribute("userInputFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("transparentColorFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("delayTime", "" + delayTime);
        graphicsControlExtensionNode.setAttribute("transparentColorIndex", "0");
        IIOMetadataNode commentsNode = AnimatedGIFRenderer.getNode(root, "CommentExtensions");
        commentsNode.setAttribute("CommentExtension", "Created by OpenSHA");
        IIOMetadataNode appEntensionsNode = AnimatedGIFRenderer.getNode(root, "ApplicationExtensions");
        IIOMetadataNode child = new IIOMetadataNode("ApplicationExtension");
        child.setAttribute("applicationID", "NETSCAPE");
        child.setAttribute("authenticationCode", "2.0");
        int loop = 0;
        if (!doLoop) {
            loop = 1;
        }
        child.setUserObject(new byte[]{1, (byte)(loop & 0xFF), (byte)(loop >> 8 & 0xFF)});
        appEntensionsNode.appendChild(child);
        this.imageMetaData.setFromTree(metaFormatName, root);
        if (outputFile.exists()) {
            Preconditions.checkState((boolean)outputFile.delete());
        }
        this.output = new FileImageOutputStream(outputFile);
        this.writer.setOutput(this.output);
        this.writer.prepareWriteSequence(this.imageMetaData);
    }

    public void writeFrame(BufferedImage img) throws IOException {
        this.writer.writeToSequence(new IIOImage(img, null, this.imageMetaData), this.imageWriteParam);
    }

    public void finalizeAnimation() throws IOException {
        this.writer.endWriteSequence();
        this.output.close();
    }

    private static IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        for (int i = 0; i < nNodes; ++i) {
            if (rootNode.item(i).getNodeName().compareToIgnoreCase(nodeName) != 0) continue;
            return (IIOMetadataNode)rootNode.item(i);
        }
        IIOMetadataNode node = new IIOMetadataNode(nodeName);
        rootNode.appendChild(node);
        return node;
    }
}

