/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.data.Range;
import org.opensha.commons.gui.plot.AxisLimitsControlPanel;
import org.opensha.commons.gui.plot.GraphWidget;
import org.opensha.commons.gui.plot.PlotColorAndLineTypeSelectorControlPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotPreferences;

public class ButtonControlPanel
extends JPanel
implements ActionListener {
    private static final String AXIS_RANGE_NOT_ALLOWED = new String("First Choose Add Graph. Then choose Axis Scale option");
    private JPanel buttonPanel;
    private JPanel checkboxPanel;
    private JCheckBox jCheckylog;
    private JCheckBox jCheckxlog;
    private JButton setAxisButton;
    private JButton toggleButton;
    private JButton plotPrefsButton;
    private AxisLimitsControlPanel axisControlPanel;
    private PlotColorAndLineTypeSelectorControlPanel plotControl;
    private PlotPreferences plotPrefs;
    private GraphWidget gw;

    public ButtonControlPanel(GraphWidget gw, PlotPreferences plotPrefs) {
        Preconditions.checkNotNull((Object)gw, (Object)"GraphWidget cannot be null");
        Preconditions.checkNotNull((Object)plotPrefs, (Object)"PlotPreferences cannot be null");
        this.gw = gw;
        this.plotPrefs = plotPrefs;
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 4, 0, 4));
        this.plotPrefsButton = new JButton("Plot Prefs");
        this.plotPrefsButton.addActionListener(this);
        this.plotPrefsButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.plotPrefsButton.putClientProperty("JButton.segmentPosition", "first");
        this.plotPrefsButton.putClientProperty("JComponent.sizeVariant", "small");
        this.toggleButton = new JButton("Show Data");
        this.toggleButton.addActionListener(this);
        this.toggleButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.toggleButton.putClientProperty("JButton.segmentPosition", "middle");
        this.toggleButton.putClientProperty("JComponent.sizeVariant", "small");
        this.setAxisButton = new JButton("Set Axis");
        this.setAxisButton.addActionListener(this);
        this.setAxisButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.setAxisButton.putClientProperty("JButton.segmentPosition", "last");
        this.setAxisButton.putClientProperty("JComponent.sizeVariant", "small");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.plotPrefsButton);
        this.buttonPanel.add(this.toggleButton);
        this.buttonPanel.add(this.setAxisButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        JLabel logScale = new JLabel("Log scale: ");
        logScale.putClientProperty("JComponent.sizeVariant", "small");
        this.jCheckxlog = new JCheckBox("X");
        this.jCheckxlog.addActionListener(this);
        this.jCheckxlog.putClientProperty("JComponent.sizeVariant", "small");
        this.jCheckylog = new JCheckBox("Y");
        this.jCheckylog.addActionListener(this);
        this.jCheckylog.putClientProperty("JComponent.sizeVariant", "small");
        this.checkboxPanel = new JPanel();
        this.checkboxPanel.setLayout(new BoxLayout(this.checkboxPanel, 2));
        this.checkboxPanel.add(Box.createHorizontalGlue());
        this.checkboxPanel.add(logScale);
        this.checkboxPanel.add(this.jCheckxlog);
        this.checkboxPanel.add(this.jCheckylog);
        this.checkboxPanel.add(Box.createHorizontalGlue());
        this.add((Component)this.buttonPanel, "Center");
        this.add((Component)this.checkboxPanel, "Last");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.jCheckxlog)) {
            this.gw.setX_Log(this.jCheckxlog.isSelected());
        } else if (src.equals(this.jCheckylog)) {
            this.gw.setY_Log(this.jCheckylog.isSelected());
        } else if (src.equals(this.setAxisButton)) {
            this.setAxisAction();
        } else if (src.equals(this.toggleButton)) {
            this.gw.togglePlot();
        } else if (src.equals(this.plotPrefsButton)) {
            this.plotPrefsAction();
        }
    }

    public JPanel getButtonRow() {
        return this.buttonPanel;
    }

    public JPanel getCheckboxRow() {
        return this.checkboxPanel;
    }

    public void setToggleButtonText(String text) {
        this.toggleButton.setText(text);
    }

    public void updateToggleButtonText(boolean graphOn) {
        if (graphOn) {
            this.setToggleButtonText("Show Data");
        } else {
            this.setToggleButtonText("Show Plot");
        }
    }

    private void setAxisAction() {
        Range xAxisRange = this.gw.getX_AxisRange();
        Range yAxisRange = this.gw.getY_AxisRange();
        if (xAxisRange == null || yAxisRange == null) {
            JOptionPane.showMessageDialog(this, AXIS_RANGE_NOT_ALLOWED);
            return;
        }
        double minX = xAxisRange.getLowerBound();
        double maxX = xAxisRange.getUpperBound();
        double minY = yAxisRange.getLowerBound();
        double maxY = yAxisRange.getUpperBound();
        Range customXRange = this.gw.getUserX_AxisRange();
        Range customYRange = this.gw.getUserY_AxisRange();
        if (this.axisControlPanel == null) {
            this.axisControlPanel = new AxisLimitsControlPanel(this.gw, this);
        } else {
            this.axisControlPanel.updateParams();
        }
        if (!this.axisControlPanel.isInitialized()) {
            this.axisControlPanel.init();
        }
        this.axisControlPanel.getComponent().pack();
        this.axisControlPanel.getComponent().setVisible(true);
    }

    public void setXLog(boolean flag) {
        this.jCheckxlog.setSelected(flag);
    }

    public boolean isXLogSelected() {
        return this.jCheckxlog.isSelected();
    }

    public void setYLog(boolean flag) {
        this.jCheckylog.setSelected(flag);
    }

    public boolean isYLogSelected() {
        return this.jCheckylog.isSelected();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.jCheckxlog.setEnabled(flag);
        this.jCheckylog.setEnabled(flag);
        for (Component c : this.buttonPanel.getComponents()) {
            c.setEnabled(flag);
        }
    }

    private void plotPrefsAction() {
        List<PlotCurveCharacterstics> plotFeatures = this.gw.getPlottingFeatures();
        if (this.plotControl == null) {
            this.plotControl = new PlotColorAndLineTypeSelectorControlPanel(this.gw, plotFeatures);
        } else {
            this.plotControl.setPlotColorAndLineType(plotFeatures);
        }
        this.plotControl.setVisible(true);
    }

    public void setPlotPreferencesButtonVisible(boolean flag) {
        this.plotPrefsButton.setVisible(false);
    }
}

