/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.geo.json.FeatureProperties;
import org.opensha.commons.geo.json.Geometry;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZPlotSpec;
import org.opensha.commons.mapping.PoliticalBoundariesData;
import org.opensha.commons.util.ComparablePairing;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.faultSurface.utils.GriddedSurfaceUtils;

public class GeographicMapMaker {
    protected Region region;
    protected Location regionCenter;
    public static final int PLOT_WIDTH_DEFAULT = 800;
    protected PlotCurveCharacterstics politicalBoundaryChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY);
    protected PlotCurveCharacterstics sectOutlineChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.LIGHT_GRAY);
    protected PlotCurveCharacterstics sectTraceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.DARK_GRAY);
    protected PlotCurveCharacterstics sectPolyChar = new PlotCurveCharacterstics(PlotLineType.POLYGON_SOLID, 1.0f, new Color(127, 127, 127, 26));
    protected PlotCurveCharacterstics regionOutlineChar = null;
    protected boolean plotRectangularRegionOutlines = false;
    protected boolean legendVisible = true;
    protected RectangleAnchor insetLegendLocation = null;
    protected boolean skipNaNs = false;
    protected boolean writePDFs = true;
    protected boolean writeGeoJSON = true;
    protected boolean sort = true;
    protected boolean reverseSort = false;
    protected Boolean absoluteSort = null;
    protected int widthDefault = 800;
    protected boolean axisLabels = true;
    protected boolean axisTicks = true;
    private boolean plotRegionsAboveFaults = false;
    protected List<? extends FaultSection> sects;
    protected Map<FaultSection, Integer> sectIndexMap;
    protected List<LocationList> sectUpperEdges;
    protected List<LocationList> sectPerimeters;
    protected boolean plotAseisReducedSurfaces = false;
    protected boolean fillSurfaces = false;
    protected boolean plotTracesForFilledSurfaces = true;
    protected boolean plotOutlinesForFilledSurfaces = true;
    protected boolean plotAllSectPolys = false;
    protected boolean plotProxySectPolys = true;
    protected boolean plotSectPolysOnTop = false;
    protected XY_DataSet[] politicalBoundaries;
    protected List<Double> sectScalars;
    protected List<Double> sectSortables;
    protected CPT sectScalarCPT;
    protected String sectScalarLabel;
    protected float sectScalarThickness = 3.0f;
    protected PlotCurveCharacterstics sectNaNChar;
    protected List<Color> sectColors = null;
    protected List<Double> sectColorComparables;
    protected CPT sectColorsCPT;
    protected String sectColorsLabel;
    protected List<PlotCurveCharacterstics> sectChars = null;
    protected List<Double> sectCharsComparables;
    protected CPT sectCharsCPT;
    protected String sectCharsLabel;
    protected Collection<FaultSection> highlightSections;
    protected PlotCurveCharacterstics highlightTraceChar;
    protected List<Collection<Jump>> jumpLists;
    protected List<Color> jumpColors;
    protected List<String> jumpLabels;
    protected float jumpLineThickness = 3.0f;
    protected List<Jump> scalarJumps;
    protected List<Double> scalarJumpValues;
    protected CPT scalarJumpsCPT;
    protected String scalarJumpsLabel;
    protected List<Location> scatterLocs;
    protected List<FeatureProperties> scatterProps;
    protected List<Double> scatterScalars;
    protected List<PlotCurveCharacterstics> scatterChars;
    protected CPT scatterScalarCPT;
    protected String scatterScalarLabel;
    protected Color scatterColor;
    protected PlotSymbol scatterSymbol = PlotSymbol.FILLED_TRIANGLE;
    protected float scatterSymbolWidth = 5.0f;
    protected PlotSymbol scatterOutline = PlotSymbol.TRIANGLE;
    protected Color scatterOutlineColor = new Color(0, 0, 0, 127);
    protected List<LocationList> lines;
    protected Color linesColor;
    protected List<Color> lineColors;
    protected List<PlotCurveCharacterstics> lineChars;
    protected float lineThickness = 2.0f;
    protected List<LocationList> arrows;
    protected Color arrowColor;
    protected Color arrowheadColor;
    protected double arrowheadLenKM;
    protected List<Color> arrowColors;
    protected float arrowThickness = 2.0f;
    protected float arrowheadThickness = 2.0f;
    protected double arrowAngle = 35.0;
    protected boolean fillArrowheads = false;
    protected Color arrowheadOutlineColor;
    protected float arrowheadOutlineThickness;
    protected boolean closeArrowheads = false;
    protected GeoDataSet xyzData;
    protected CPT xyzCPT;
    protected String xyzLabel;
    protected List<Region> insetRegions;
    protected List<PlotCurveCharacterstics> insetRegionOutlineChars;
    protected List<Color> insetRegionFillColors;
    protected double insetRegionFillOpacity;
    protected List<String> customLegendLabels;
    protected List<PlotCurveCharacterstics> customLegendChars;
    protected RectangleEdge cptEdge = RectangleEdge.BOTTOM;
    private List<XYAnnotation> annotations;
    protected List<Feature> features;
    protected List<RuptureSurface> sectSurfs;
    protected List<Location> surfMiddles;
    public static PlotPreferences PLOT_PREFS_DEFAULT = PlotUtils.getDefaultFigurePrefs();

    public GeographicMapMaker(Region region) {
        this(region, PoliticalBoundariesData.loadDefaultOutlines(region));
    }

    public GeographicMapMaker(List<? extends FaultSection> sects) {
        this(GeographicMapMaker.buildBufferedRegion(sects), sects);
    }

    public GeographicMapMaker(Region region, List<? extends FaultSection> sects) {
        this(region);
        this.setFaultSections(sects);
    }

    public GeographicMapMaker(Region region, XY_DataSet[] politicalBoundaries) {
        this.setRegion(region);
        this.politicalBoundaries = politicalBoundaries;
    }

    public static Region buildBufferedRegion(Collection<? extends FaultSection> sects) {
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        for (FaultSection faultSection : sects) {
            for (Location loc : GeographicMapMaker.bufferPerimLocsForSect(faultSection)) {
                latTrack.addValue(loc.getLatitude());
                lonTrack.addValue(loc.getLongitude());
            }
        }
        double minLat = Math.floor(latTrack.getMin() - 0.05);
        double maxLat = Math.ceil(latTrack.getMax() + 0.05);
        double minLon = Math.floor(lonTrack.getMin() - 0.05);
        double maxLon = Math.ceil(lonTrack.getMax() + 0.05);
        return new Region(new Location(minLat, minLon), new Location(maxLat, maxLon));
    }

    private static LocationList bufferPerimLocsForSect(FaultSection sect) {
        RuptureSurface surf = sect.getFaultSurface(1.0);
        if (surf != null) {
            try {
                return surf.getPerimeter();
            }
            catch (Exception exception) {
                try {
                    return surf.getEvenlyDiscritizedPerimeter();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return sect.getFaultTrace();
    }

    public static Region buildBufferedRegion(Collection<? extends FaultSection> sects, double buffDistKM, boolean fullPerims) {
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        for (FaultSection faultSection : sects) {
            if (fullPerims) {
                for (Location loc : faultSection.getFaultSurface(1.0).getPerimeter()) {
                    latTrack.addValue(loc.getLatitude());
                    lonTrack.addValue(loc.getLongitude());
                }
                continue;
            }
            for (Location loc : faultSection.getFaultTrace()) {
                latTrack.addValue(loc.getLatitude());
                lonTrack.addValue(loc.getLongitude());
            }
        }
        double minLat = latTrack.getMin();
        double maxLat = latTrack.getMax();
        double minLon = lonTrack.getMin();
        double maxLon = lonTrack.getMax();
        Location lowLeft = new Location(minLat, minLon);
        Location upRight = new Location(maxLat, maxLon);
        lowLeft = LocationUtils.location(lowLeft, 3.9269908169872414, buffDistKM);
        upRight = LocationUtils.location(upRight, 0.7853981633974483, buffDistKM);
        return new Region(lowLeft, upRight);
    }

    public void setFaultSections(List<? extends FaultSection> sects) {
        this.clearFaultSections();
        this.sects = sects;
        this.sectIndexMap = new HashMap<FaultSection, Integer>();
        for (int s = 0; s < sects.size(); ++s) {
            this.sectIndexMap.put(sects.get(s), s);
        }
        Preconditions.checkState((this.sectIndexMap.size() == sects.size() ? 1 : 0) != 0, (Object)"Duplicate section ID?");
    }

    public void clearFaultSections() {
        this.sects = null;
        this.sectIndexMap = null;
        this.sectUpperEdges = null;
        this.sectPerimeters = null;
        this.sectSurfs = null;
        this.surfMiddles = null;
        this.clearSectScalars();
        this.clearSectColors();
        this.clearSectHighlights();
        this.highlightSections = null;
    }

    public boolean hasFaultSections() {
        return this.sects != null && !this.sects.isEmpty();
    }

    private void checkHasSections() {
        Preconditions.checkState((boolean)this.hasFaultSections(), (Object)"Not supported (no fault sections)");
    }

    public void setRegion(Region region) {
        this.region = region;
        this.regionCenter = new Location(0.5 * (region.getMinLat() + region.getMaxLat()), 0.5 * (region.getMinLon() + region.getMaxLon()));
    }

    public void setPoliticalBoundaryChar(PlotCurveCharacterstics politicalBoundaryChar) {
        this.politicalBoundaryChar = politicalBoundaryChar;
    }

    public void setRegionOutlineChar(PlotCurveCharacterstics regionOutlineChar) {
        this.regionOutlineChar = regionOutlineChar;
    }

    public void setRegionOutlineChar(PlotCurveCharacterstics regionOutlineChar, boolean plotIfRectangular) {
        this.regionOutlineChar = regionOutlineChar;
        this.plotRectangularRegionOutlines = plotIfRectangular;
    }

    public void setSectOutlineChar(PlotCurveCharacterstics sectOutlineChar) {
        this.sectOutlineChar = sectOutlineChar;
    }

    public void setSectTraceChar(PlotCurveCharacterstics sectTraceChar) {
        this.sectTraceChar = sectTraceChar;
    }

    public void setSectPolygonChar(PlotCurveCharacterstics sectPolyChar) {
        this.sectPolyChar = sectPolyChar;
    }

    public void setScalarThickness(float scalarThickness) {
        this.sectScalarThickness = scalarThickness;
    }

    public void setJumpLineThickness(float jumpLineThickness) {
        this.jumpLineThickness = jumpLineThickness;
    }

    public void setPoliticalBoundaries(XY_DataSet[] politicalBoundaries) {
        this.politicalBoundaries = politicalBoundaries;
    }

    public void setLegendVisible(boolean legendVisible) {
        this.legendVisible = legendVisible;
    }

    public void setLegendInset(boolean legendInset) {
        this.insetLegendLocation = legendInset ? RectangleAnchor.TOP_RIGHT : null;
    }

    public void setLegendInset(RectangleAnchor insetLegendLocation) {
        this.insetLegendLocation = insetLegendLocation;
    }

    public void setSkipNaNs(boolean skipNaNs) {
        this.skipNaNs = skipNaNs;
    }

    public void setSectNaNChar(PlotCurveCharacterstics sectNaNChar) {
        this.sectNaNChar = sectNaNChar;
    }

    public void setCustomLegendItems(List<String> labels, List<PlotCurveCharacterstics> chars) {
        this.customLegendLabels = labels;
        this.customLegendChars = chars;
    }

    public void clearCustomLegendItems() {
        this.customLegendLabels = null;
        this.customLegendChars = null;
    }

    public void setCPTLocation(RectangleEdge cptEdge) {
        this.cptEdge = cptEdge;
    }

    public void setAnnotations(List<? extends XYAnnotation> anns) {
        this.annotations = new ArrayList<XYAnnotation>(anns);
    }

    public void addAnnotations(List<? extends XYAnnotation> anns) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<XYAnnotation>(anns);
        } else {
            this.annotations.addAll(anns);
        }
    }

    public void addAnnotation(XYAnnotation ann) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<XYAnnotation>();
        }
        this.annotations.add(ann);
    }

    public void clearAnnotations() {
        this.annotations = null;
    }

    public void setSectHighlights(Collection<FaultSection> highlightSections, PlotCurveCharacterstics highlightTraceChar) {
        this.highlightSections = highlightSections;
        this.highlightTraceChar = highlightTraceChar;
    }

    public void clearSectHighlights() {
        this.highlightSections = null;
        this.highlightTraceChar = null;
    }

    public void plotInsetRegions(List<Region> regions, PlotCurveCharacterstics outlineChar, Color fillColor, double fillOpacity) {
        ArrayList<PlotCurveCharacterstics> chars = null;
        if (outlineChar != null) {
            chars = new ArrayList<PlotCurveCharacterstics>(regions.size());
            for (int i = 0; i < regions.size(); ++i) {
                chars.add(outlineChar);
            }
        }
        ArrayList<Color> colors = null;
        if (fillColor != null) {
            colors = new ArrayList<Color>(regions.size());
            for (int i = 0; i < regions.size(); ++i) {
                colors.add(fillColor);
            }
        }
        this.plotInsetRegions(regions, chars, colors, fillOpacity);
    }

    public void plotInsetRegions(List<Region> regions, List<PlotCurveCharacterstics> outlineChars, List<Color> fillColors, double fillOpacity) {
        if (regions == null || regions.isEmpty()) {
            this.clearInsetRegions();
        } else {
            Preconditions.checkState((outlineChars != null || fillColors != null ? 1 : 0) != 0);
            this.insetRegions = regions;
            Preconditions.checkState((outlineChars == null || outlineChars.size() == regions.size() ? 1 : 0) != 0);
            this.insetRegionOutlineChars = outlineChars;
            Preconditions.checkState((fillColors == null || fillColors.size() == regions.size() ? 1 : 0) != 0);
            this.insetRegionFillColors = fillColors;
            this.insetRegionFillOpacity = fillOpacity;
        }
    }

    public void setPlotRegionsAboveFaults(boolean plotRegionsAboveFaults) {
        this.plotRegionsAboveFaults = plotRegionsAboveFaults;
    }

    public void clearInsetRegions() {
        this.insetRegions = null;
        this.insetRegionOutlineChars = null;
        this.insetRegionFillColors = null;
        this.insetRegionFillOpacity = Double.NaN;
    }

    public void setWritePDFs(boolean writePDFs) {
        this.writePDFs = writePDFs;
    }

    public void setWriteGeoJSON(boolean writeGeoJSON) {
        this.writeGeoJSON = writeGeoJSON;
    }

    public void setFillSurfaces(boolean fillSurfaces) {
        this.fillSurfaces = fillSurfaces;
    }

    public void setPlotTracesForFilledSurfaces(boolean plotTracesForFilledSurfaces) {
        this.plotTracesForFilledSurfaces = plotTracesForFilledSurfaces;
    }

    public void setPlotOutlinesForFilledSurfaces(boolean plotOutlinesForFilledSurfaces) {
        this.plotOutlinesForFilledSurfaces = plotOutlinesForFilledSurfaces;
    }

    public void setPlotAseisReducedSurfaces(boolean plotAseisReducedSurfaces) {
        this.plotAseisReducedSurfaces = plotAseisReducedSurfaces;
    }

    public void setPlotAllSectPolys(boolean plotAllSectPolys) {
        this.plotAllSectPolys = plotAllSectPolys;
    }

    public void setPlotProxySectPolys(boolean plotProxySectPolys) {
        this.plotProxySectPolys = plotProxySectPolys;
    }

    public void setPlotSectPolysOnTop(boolean plotSectPolysOnTop) {
        this.plotSectPolysOnTop = plotSectPolysOnTop;
    }

    public void setReverseSort(boolean reverseSort) {
        this.reverseSort = reverseSort;
    }

    public boolean isReverseSort() {
        return this.reverseSort;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
    }

    public boolean isSort() {
        return this.sort;
    }

    public void setAbsoluteSort(boolean absoluteSort) {
        this.absoluteSort = absoluteSort;
    }

    public void plotSectScalars(double[] scalars, CPT cpt, String label) {
        this.plotSectScalars(Doubles.asList((double[])scalars), cpt, label);
    }

    public void plotSectScalars(double[] scalars, double[] sortables, CPT cpt, String label) {
        this.plotSectScalars(Doubles.asList((double[])scalars), sortables == null ? null : Doubles.asList((double[])sortables), cpt, label);
    }

    public void plotSectScalars(List<Double> scalars, CPT cpt, String label) {
        this.plotSectScalars(scalars, null, cpt, label);
    }

    public void plotSectScalars(List<Double> scalars, List<Double> sortables, CPT cpt, String label) {
        this.checkHasSections();
        Preconditions.checkState((scalars.size() == this.sects.size() ? 1 : 0) != 0);
        Preconditions.checkState((sortables == null || scalars.size() == sortables.size() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)cpt);
        this.sectScalars = scalars;
        this.sectSortables = sortables;
        this.sectScalarCPT = cpt;
        this.sectScalarLabel = label;
        this.sectColors = null;
    }

    public void clearSectScalars() {
        this.sectScalars = null;
        this.sectSortables = null;
        this.sectScalarCPT = null;
        this.sectScalarLabel = null;
    }

    public void plotSectColors(List<Color> sectColors) {
        this.plotSectColors(sectColors, null, null);
    }

    public void plotSectColors(List<Color> sectColors, CPT colorsCPT, String colorsLabel) {
        this.plotSectColors(sectColors, colorsCPT, colorsLabel, null);
    }

    public void plotSectColors(List<Color> sectColors, CPT colorsCPT, String colorsLabel, List<Double> sectColorComparables) {
        if (sectColors != null) {
            this.clearSectScalars();
            this.clearSectChars();
            this.checkHasSections();
            Preconditions.checkState((sectColors.size() == this.sects.size() ? 1 : 0) != 0);
            if (sectColorComparables != null) {
                Preconditions.checkState((sectColorComparables.size() == this.sects.size() ? 1 : 0) != 0);
            }
        }
        this.sectColors = sectColors;
        this.sectColorsCPT = colorsCPT;
        this.sectColorsLabel = colorsLabel;
        this.sectColorComparables = sectColorComparables;
    }

    public void plotSectChars(List<PlotCurveCharacterstics> sectChars) {
        this.plotSectChars(sectChars, null, null);
    }

    public void plotSectChars(List<PlotCurveCharacterstics> sectChars, CPT cpt, String label) {
        this.plotSectChars(sectChars, cpt, label, null);
    }

    public void plotSectChars(List<PlotCurveCharacterstics> sectChars, CPT cpt, String label, List<Double> sectCharComparables) {
        if (sectChars != null) {
            this.clearSectScalars();
            this.clearSectColors();
            this.checkHasSections();
            Preconditions.checkState((sectChars.size() == this.sects.size() ? 1 : 0) != 0);
            if (sectCharComparables != null) {
                Preconditions.checkState((sectCharComparables.size() == this.sects.size() ? 1 : 0) != 0);
            }
        }
        this.sectChars = sectChars;
        this.sectCharsCPT = cpt;
        this.sectCharsLabel = label;
        this.sectCharsComparables = sectCharComparables;
    }

    public void clearSectColors() {
        this.sectColors = null;
        this.sectColorsCPT = null;
        this.sectColorsLabel = null;
        this.sectColorComparables = null;
    }

    public void clearSectChars() {
        this.sectChars = null;
        this.sectCharsCPT = null;
        this.sectCharsLabel = null;
        this.sectCharsComparables = null;
    }

    public void plotJumps(Collection<Jump> jumps, Color color, String label) {
        if (this.jumpLists == null) {
            this.jumpLists = new ArrayList<Collection<Jump>>();
            this.jumpColors = new ArrayList<Color>();
            this.jumpLabels = new ArrayList<String>();
        }
        this.checkHasSections();
        this.jumpLists.add(jumps);
        this.jumpColors.add(color);
        this.jumpLabels.add(label);
    }

    public void clearJumps() {
        this.jumpLists = null;
        this.jumpColors = null;
        this.jumpLabels = null;
    }

    public void plotJumpScalars(Map<Jump, Double> jumpVals, CPT cpt, String label) {
        this.checkHasSections();
        ArrayList<Jump> jumps = new ArrayList<Jump>();
        ArrayList<Double> values = new ArrayList<Double>();
        for (Jump jump : jumpVals.keySet()) {
            jumps.add(jump);
            values.add(jumpVals.get(jump));
        }
        this.plotJumpScalars(jumps, values, cpt, label);
    }

    public void plotJumpScalars(List<Jump> jumps, List<Double> values, CPT cpt, String label) {
        this.checkHasSections();
        Preconditions.checkState((jumps.size() == values.size() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)cpt);
        this.scalarJumps = jumps;
        this.scalarJumpValues = values;
        this.scalarJumpsCPT = cpt;
        this.scalarJumpsLabel = label;
    }

    public void clearJumpScalars() {
        this.scalarJumps = null;
        this.scalarJumpValues = null;
        this.scalarJumpsCPT = null;
        this.scalarJumpsLabel = null;
    }

    public void plotScatters(List<Location> locs, Color color) {
        this.clearScatters();
        this.scatterLocs = locs;
        this.scatterColor = color;
    }

    public void plotScatters(List<Location> locs, List<PlotCurveCharacterstics> chars) {
        this.plotScatters(locs, chars, null, null);
    }

    public void plotScatters(List<Location> locs, List<PlotCurveCharacterstics> chars, CPT cptForLegend, String label) {
        this.plotScatters(locs, chars, null, cptForLegend, label);
    }

    public void plotScatters(List<Location> locs, List<PlotCurveCharacterstics> chars, PlotSymbol outlineSymbol) {
        this.plotScatters(locs, chars, outlineSymbol, null, null);
    }

    public void plotScatters(List<Location> locs, List<PlotCurveCharacterstics> chars, PlotSymbol outlineSymbol, CPT cptForLegend, String label) {
        this.clearScatters();
        Preconditions.checkState((locs.size() == chars.size() ? 1 : 0) != 0);
        this.scatterLocs = locs;
        this.scatterChars = chars;
        this.scatterOutline = outlineSymbol;
        if (label != null) {
            Preconditions.checkState((cptForLegend != null && label != null ? 1 : 0) != 0, (Object)"If you specify a label, must also specify a CPT");
        }
        this.scatterScalarLabel = label;
        this.scatterScalarCPT = cptForLegend;
        this.scatterScalarLabel = label;
    }

    public void plotScatterScalars(List<Location> locs, List<Double> values, CPT cpt, String label) {
        this.clearScatters();
        Preconditions.checkState((locs.size() == values.size() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)cpt);
        this.scatterLocs = locs;
        this.scatterScalars = values;
        this.scatterScalarCPT = cpt;
        this.scatterScalarLabel = label;
    }

    public void setScatterProperties(List<FeatureProperties> scatterProps) {
        Preconditions.checkNotNull(this.scatterLocs);
        Preconditions.checkState((this.scatterLocs.size() == scatterProps.size() ? 1 : 0) != 0);
        this.scatterProps = scatterProps;
    }

    public void clearScatters() {
        this.scatterLocs = null;
        this.scatterProps = null;
        this.scatterScalars = null;
        this.scatterChars = null;
        this.scatterScalarCPT = null;
        this.scatterScalarLabel = null;
        this.scatterColor = null;
    }

    public void setScatterSymbol(PlotSymbol symbol, float width) {
        this.setScatterSymbol(symbol, width, null, null);
    }

    public void setScatterSymbol(PlotSymbol symbol, float width, PlotSymbol outline, Color outlineColor) {
        this.scatterSymbol = symbol;
        this.scatterSymbolWidth = width;
        this.scatterOutline = outline;
        this.scatterOutlineColor = outlineColor;
    }

    public void plotLines(List<LocationList> lines, Color color, float thickness) {
        this.clearLines();
        Preconditions.checkNotNull(lines);
        Preconditions.checkNotNull((Object)color);
        this.lines = lines;
        this.linesColor = color;
        this.lineThickness = thickness;
    }

    public void plotLines(List<LocationList> lines, List<Color> colors, float thickness) {
        this.clearLines();
        Preconditions.checkNotNull(lines);
        Preconditions.checkNotNull(colors);
        Preconditions.checkState((lines.size() == colors.size() ? 1 : 0) != 0);
        this.lines = lines;
        this.lineColors = colors;
        this.lineThickness = thickness;
    }

    public void plotLines(List<LocationList> lines, List<PlotCurveCharacterstics> chars) {
        this.clearLines();
        Preconditions.checkNotNull(lines);
        Preconditions.checkNotNull(chars);
        Preconditions.checkState((lines.size() == chars.size() ? 1 : 0) != 0);
        this.lines = lines;
        this.lineChars = chars;
    }

    public void clearLines() {
        this.lines = null;
        this.lineColors = null;
        this.linesColor = null;
        this.lineChars = null;
    }

    public void plotArrows(List<LocationList> arrows, double arrowheadLenKM, Color color, float thickness) {
        this.plotArrows(arrows, arrowheadLenKM, color, thickness, null, thickness);
    }

    public void plotArrows(List<LocationList> arrows, double arrowheadLenKM, Color color, float thickness, Color headColor, float headThickness) {
        this.clearArrows();
        Preconditions.checkState((arrowheadLenKM > 0.0 ? 1 : 0) != 0);
        Preconditions.checkNotNull(arrows);
        Preconditions.checkNotNull((Object)color);
        this.arrows = arrows;
        this.arrowheadLenKM = arrowheadLenKM;
        this.arrowColor = color;
        this.arrowThickness = thickness;
        this.arrowheadColor = headColor;
        this.arrowheadThickness = headThickness;
    }

    public void plotArrows(List<LocationList> arrows, double arrowheadLenKM, List<Color> colors, float thickness) {
        this.plotArrows(arrows, arrowheadLenKM, colors, thickness, null, thickness);
    }

    public void plotArrows(List<LocationList> arrows, double arrowheadLenKM, List<Color> colors, float thickness, Color headColor, float headThickness) {
        this.clearArrows();
        Preconditions.checkState((arrowheadLenKM > 0.0 ? 1 : 0) != 0);
        Preconditions.checkNotNull(arrows);
        Preconditions.checkNotNull(colors);
        Preconditions.checkState((arrows.size() == colors.size() ? 1 : 0) != 0);
        this.arrows = arrows;
        this.arrowheadLenKM = arrowheadLenKM;
        this.arrowColors = colors;
        this.arrowThickness = thickness;
        this.arrowheadColor = headColor;
        this.arrowheadThickness = headThickness;
    }

    public void setArrowAngle(double arrowAngle) {
        this.arrowAngle = arrowAngle;
    }

    public void setFillArrowheads(boolean fillArrowheads) {
        this.setFillArrowheads(fillArrowheads, null, 0.0f);
    }

    public void setFillArrowheads(boolean fillArrowheads, Color outlineColor, float outlineThickness) {
        this.fillArrowheads = fillArrowheads;
        this.arrowheadOutlineColor = outlineColor;
        this.arrowheadOutlineThickness = outlineThickness;
    }

    public void setCloseArrowheads(boolean closeArrowheads) {
        this.closeArrowheads = closeArrowheads;
    }

    public void clearArrows() {
        this.arrows = null;
        this.arrowColors = null;
        this.arrowheadColor = null;
        this.arrowColor = null;
    }

    public void plotXYZData(GeoDataSet xyzData, CPT xyzCPT, String xyzLabel) {
        Preconditions.checkNotNull((Object)xyzData);
        Preconditions.checkNotNull((Object)xyzCPT);
        this.xyzData = xyzData;
        this.xyzCPT = xyzCPT;
        this.xyzLabel = xyzLabel;
    }

    public void clearXYZData() {
        this.xyzData = null;
        this.xyzCPT = null;
        this.xyzLabel = null;
    }

    private RuptureSurface getSectSurface(FaultSection sect) {
        if (this.sectSurfs == null) {
            this.checkHasSections();
            ArrayList<RuptureSurface> surfs = new ArrayList<RuptureSurface>();
            for (FaultSection faultSection : this.sects) {
                surfs.add(faultSection.getFaultSurface(1.0, false, this.plotAseisReducedSurfaces));
            }
            this.sectSurfs = surfs;
        }
        return this.sectSurfs.get(this.sectIndexMap.get(sect));
    }

    private Location getSectMiddle(FaultSection sect) {
        if (this.surfMiddles == null) {
            ArrayList<Location> middles = new ArrayList<Location>();
            for (FaultSection faultSection : this.sects) {
                middles.add(GriddedSurfaceUtils.getSurfaceMiddleLoc(this.getSectSurface(faultSection)));
            }
            this.surfMiddles = middles;
        }
        return this.surfMiddles.get(this.sectIndexMap.get(sect));
    }

    private LocationList getPerimeter(FaultSection sect) {
        this.checkInitPerims();
        return this.sectPerimeters.get(this.sectIndexMap.get(sect));
    }

    private LocationList getUpperEdge(FaultSection sect) {
        this.checkInitPerims();
        return this.sectUpperEdges.get(this.sectIndexMap.get(sect));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitPerims() {
        if (this.sectPerimeters == null) {
            GeographicMapMaker geographicMapMaker = this;
            synchronized (geographicMapMaker) {
                if (this.sectPerimeters == null) {
                    this.checkHasSections();
                    ArrayList<LocationList> upperEdges = new ArrayList<LocationList>();
                    ArrayList<LocationList> perimeters = new ArrayList<LocationList>();
                    for (FaultSection faultSection : this.sects) {
                        LocationList discrPerim;
                        LocationList lowerEdge;
                        LocationList upperEdge;
                        if (faultSection.getAveDip() == 90.0) {
                            upperEdges.add(faultSection.getFaultTrace());
                            perimeters.add(null);
                            continue;
                        }
                        FaultTrace trace = faultSection.getFaultTrace();
                        if (faultSection.getLowerFaultTrace() == null) {
                            double ddw;
                            double upperDepth;
                            upperEdge = new LocationList();
                            lowerEdge = new LocationList();
                            double dipDirDeg = faultSection.getDipDirection();
                            double aveDipRad = Math.toRadians(faultSection.getAveDip());
                            if (this.plotAseisReducedSurfaces) {
                                upperDepth = faultSection.getReducedAveUpperDepth();
                                ddw = faultSection.getReducedDownDipWidth();
                            } else {
                                upperDepth = faultSection.getOrigAveUpperDepth();
                                ddw = faultSection.getOrigDownDipWidth();
                            }
                            double horzToBottom = ddw * Math.cos(aveDipRad);
                            double vertToBottom = ddw * Math.sin(aveDipRad);
                            for (Location traceLoc : trace) {
                                Location upperLoc = StirlingGriddedSurface.getTopLocation(traceLoc, upperDepth, aveDipRad, dipDirDeg);
                                upperEdge.add(upperLoc);
                                LocationVector dir = new LocationVector(dipDirDeg, horzToBottom, vertToBottom);
                                Location lowerLoc = LocationUtils.location(upperLoc, dir);
                                lowerEdge.add(lowerLoc);
                            }
                        } else {
                            upperEdge = new LocationList();
                            upperEdge.addAll(faultSection.getFaultTrace());
                            lowerEdge = new LocationList();
                            lowerEdge.addAll(faultSection.getLowerFaultTrace());
                        }
                        LocationList perimeter = new LocationList();
                        perimeter.addAll(upperEdge);
                        Collections.reverse(lowerEdge);
                        perimeter.addAll(lowerEdge);
                        perimeter.add(perimeter.first());
                        RuptureSurface surf = this.getSectSurface(faultSection);
                        FaultTrace discrUpperEdge = surf.getEvenlyDiscritizedUpperEdge();
                        if (discrUpperEdge.size() < upperEdge.size()) {
                            upperEdge = discrUpperEdge;
                        }
                        if ((discrPerim = surf.getEvenlyDiscritizedPerimeter()).size() < perimeter.size()) {
                            if (!discrPerim.first().equals(discrPerim.last())) {
                                discrPerim.add(discrPerim.first());
                            }
                            perimeter = discrPerim;
                        }
                        upperEdges.add(upperEdge);
                        perimeters.add(perimeter);
                    }
                    this.sectUpperEdges = upperEdges;
                    this.sectPerimeters = perimeters;
                }
            }
        }
    }

    protected Feature surfFeature(FaultSection sect, PlotCurveCharacterstics pChar) {
        Geometry.Polygon poly = new Geometry.Polygon(this.getPerimeter(sect));
        FeatureProperties props = new FeatureProperties();
        props.set("name", sect.getSectionName());
        props.set("id", sect.getSectionId());
        if (sect.getParentSectionId() >= 0) {
            props.set("parentID", sect.getParentSectionId());
        }
        if (pChar.getLineType() != null) {
            props.set("stroke-width", Float.valueOf(pChar.getLineWidth()));
            props.set("stroke", pChar.getColor());
        }
        props.set("fill-opacity", 0.05);
        return new Feature(sect.getSectionName(), (Geometry)poly, props);
    }

    protected Feature traceFeature(FaultSection sect, PlotCurveCharacterstics pChar) {
        Geometry.LineString line = new Geometry.LineString(this.getUpperEdge(sect));
        FeatureProperties props = new FeatureProperties();
        props.set("name", sect.getSectionName());
        props.set("id", sect.getSectionId());
        if (sect.getParentSectionId() >= 0) {
            props.set("parentID", sect.getParentSectionId());
        }
        if (pChar.getLineType() != null) {
            props.set("stroke-width", Float.valueOf(pChar.getLineWidth()));
            props.set("stroke", pChar.getColor());
        }
        return new Feature(sect.getSectionName(), (Geometry)line, props);
    }

    protected PlotBuilder initPlotBuilder() {
        return new PlotBuilder();
    }

    public PlotSpec buildPlot(String title) {
        PlotBuilder builder = this.initPlotBuilder();
        PlotSpec spec = builder.buildPlot(title);
        this.features = builder.features;
        return spec;
    }

    private double getPlotRegionBuffer() {
        return this.regionOutlineChar == null ? 0.0 : 0.05;
    }

    public Range getXRange() {
        GriddedGeoDataSet geoXYZ;
        double buffer = this.getPlotRegionBuffer();
        double minLon = this.region.getMinLon() - buffer;
        double maxLon = this.region.getMaxLon() + buffer;
        if (this.xyzData != null && this.xyzData instanceof GriddedGeoDataSet && this.region.equalsRegion((geoXYZ = (GriddedGeoDataSet)this.xyzData).getRegion())) {
            double spacing = geoXYZ.getRegion().getLonSpacing();
            minLon = Math.min(minLon, geoXYZ.getMinLon() - 0.5 * spacing);
            maxLon = Math.max(maxLon, geoXYZ.getMaxLon() + 0.5 * spacing);
        }
        return new Range(minLon, maxLon);
    }

    public Range getYRange() {
        GriddedGeoDataSet geoXYZ;
        double buffer = this.getPlotRegionBuffer();
        double minLat = this.region.getMinLat() - buffer;
        double maxLat = this.region.getMaxLat() + buffer;
        if (this.xyzData != null && this.xyzData instanceof GriddedGeoDataSet && this.region.equalsRegion((geoXYZ = (GriddedGeoDataSet)this.xyzData).getRegion())) {
            double spacing = geoXYZ.getRegion().getLatSpacing();
            minLat = Math.min(minLat, geoXYZ.getMinLat() - 0.5 * spacing);
            maxLat = Math.max(maxLat, geoXYZ.getMaxLat() + 0.5 * spacing);
        }
        return new Range(minLat, maxLat);
    }

    public static PaintScaleLegend buildCPTLegend(CPT cpt, String label) {
        return GeographicMapMaker.buildCPTLegend(cpt, label, RectangleEdge.BOTTOM);
    }

    public static PaintScaleLegend buildCPTLegend(CPT cpt, String label, RectangleEdge edge) {
        double cptLen = cpt.getMaxValue() - cpt.getMinValue();
        double cptTick = cpt.getPreferredTickInterval();
        if (!Double.isFinite(cptTick)) {
            cptTick = cptLen > 5000.0 ? 1000.0 : (cptLen > 2500.0 ? 500.0 : (cptLen > 1000.0 ? 250.0 : (cptLen > 500.0 ? 100.0 : (cptLen > 100.0 ? 50.0 : (cptLen > 50.0 ? 10.0 : (cptLen > 10.0 ? 5.0 : (cptLen > 5.0 ? 1.0 : (cptLen > 1.0 ? 0.5 : (cptLen > 0.5 ? 0.1 : cptLen / 10.0)))))))));
        }
        return GraphPanel.getLegendForCPT(cpt, label, PLOT_PREFS_DEFAULT.getAxisLabelFontSize(), PLOT_PREFS_DEFAULT.getTickLabelFontSize(), cptTick, edge);
    }

    public void setDefaultPlotWidth(int widthDefault) {
        this.widthDefault = widthDefault;
    }

    public int getDefaultPlotWidth() {
        return this.widthDefault;
    }

    public void setAxisLabelsVisible(boolean axisLabels) {
        this.axisLabels = axisLabels;
    }

    public void setAxisTicksVisible(boolean axisTicks) {
        this.axisTicks = axisTicks;
    }

    public Location getLocationWithConstantProjectedDistance(Location fromLoc, double azimuthDeg, double distance) {
        return GeographicMapMaker.getLocationWithConstantProjectedDistance(fromLoc, this.regionCenter, azimuthDeg, distance);
    }

    public static Location getLocationWithConstantProjectedDistance(Location fromLoc, Location refCenterLoc, double azimuthDeg, double distance) {
        Location toLoc = LocationUtils.location(refCenterLoc, Math.toRadians(azimuthDeg), distance);
        return new Location(fromLoc.lat - (refCenterLoc.lat - toLoc.lat), fromLoc.lon - (refCenterLoc.lon - toLoc.lon));
    }

    public double getRotationAngleCorrectedForAspectRatio(double angleRad) {
        return GeographicMapMaker.getRotationAngleCorrectedForAspectRatio(angleRad, this.regionCenter);
    }

    public static double getRotationAngleCorrectedForAspectRatio(double angleRad, Location refCenterLoc) {
        return Math.atan(Math.tan(angleRad) * Math.cos(refCenterLoc.getLatRad()));
    }

    public void plot(File outputDir, String prefix, String title) throws IOException {
        this.plot(outputDir, prefix, this.buildPlot(title), this.widthDefault);
    }

    public void plot(File outputDir, String prefix, String title, int width) throws IOException {
        this.plot(outputDir, prefix, this.buildPlot(title), width);
    }

    public void plot(File outputDir, String prefix, PlotSpec spec) throws IOException {
        this.plot(outputDir, prefix, spec, this.widthDefault);
    }

    public void plot(File outputDir, String prefix, PlotSpec spec, int width) throws IOException {
        this.plot(outputDir, prefix, spec, width, null);
    }

    public void plot(File outputDir, String prefix, PlotSpec spec, int width, Consumer<? super HeadlessGraphPanel> customizer) throws IOException {
        HeadlessGraphPanel gp = new HeadlessGraphPanel(PLOT_PREFS_DEFAULT);
        Range xRange = this.getXRange();
        Range yRange = this.getYRange();
        gp.drawGraphPanel(spec, false, false, xRange, yRange);
        if (this.axisTicks) {
            double maxSpan = Math.max(xRange.getLength(), yRange.getLength());
            double tick = maxSpan > 20.0 ? 5.0 : (maxSpan > 8.0 ? 2.0 : (maxSpan > 3.0 ? 1.0 : (maxSpan > 1.0 ? 0.5 : 0.2)));
            PlotUtils.setXTick(gp, tick);
            PlotUtils.setYTick(gp, tick);
        } else {
            gp.getPlot().setDomainGridlinesVisible(false);
            gp.getPlot().setRangeGridlinesVisible(false);
            gp.getXAxis().setTickLabelsVisible(false);
            gp.getXAxis().setTickMarksVisible(false);
            gp.getXAxis().setMinorTickMarksVisible(false);
            gp.getYAxis().setTickLabelsVisible(false);
            gp.getYAxis().setTickMarksVisible(false);
            gp.getYAxis().setMinorTickMarksVisible(false);
        }
        if (customizer != null) {
            customizer.accept(gp);
        }
        PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, width, true, true, this.writePDFs, false);
        if (this.writeGeoJSON && this.features != null && !this.features.isEmpty() && !(spec instanceof XYZPlotSpec)) {
            FeatureCollection features = new FeatureCollection(this.features);
            FeatureCollection.write(features, new File(outputDir, prefix + ".geojson"));
        }
    }

    public static String getGeoJSONViewerLink(String url) {
        Object ret = "http://geojson.io/#data=data:text/x-url,";
        try {
            ret = (String)ret + URLEncoder.encode(url, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        return ret;
    }

    public static String getGeoJSONViewerRelativeLink(String linkText, String relLink) {
        String script = "<script>var a = document.createElement('a'); a.appendChild(document.createTextNode('" + linkText + "'));a.href = 'http://geojson.io/#data=data:text/x-url,'+encodeURIComponent(new URL('" + relLink + "', document.baseURI).href); document.scripts[ document.scripts.length - 1 ].parentNode.appendChild( a );</script>";
        return script;
    }

    protected class PlotBuilder {
        protected List<XY_DataSet> funcs;
        protected List<PlotCurveCharacterstics> chars;
        protected List<Feature> features;
        protected boolean writeGeoJSON;
        protected List<PaintScaleLegend> cptLegend = new ArrayList<PaintScaleLegend>();
        protected boolean hasLegend = false;

        protected PlotBuilder() {
        }

        protected Comparator<ComparablePairing<Double, ?>> buildComparator(CPT cpt) {
            final boolean absoluteSort = GeographicMapMaker.this.absoluteSort != null ? GeographicMapMaker.this.absoluteSort : cpt != null && cpt.getMinValue() < -0.0 && cpt.getMaxValue() > 0.0 && cpt.getMinValue() == -cpt.getMaxValue() && (cpt.getName() == null || !cpt.getName().toLowerCase().contains("rainbow") && !cpt.getName().toLowerCase().contains("max"));
            return new Comparator<ComparablePairing<Double, ?>>(){
                final /* synthetic */ PlotBuilder this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public int compare(ComparablePairing<Double, ?> o1, ComparablePairing<Double, ?> o2) {
                    Double d1 = o1.getComparable();
                    Double d2 = o2.getComparable();
                    if ((d1 == null || Double.isNaN(d1)) && (d2 == null || Double.isNaN(d2))) {
                        return 0;
                    }
                    if (d1 == null || Double.isNaN(d1)) {
                        return -1;
                    }
                    if (d2 == null || Double.isNaN(d2)) {
                        return 1;
                    }
                    if (absoluteSort) {
                        d1 = Math.abs(d1);
                        d2 = Math.abs(d2);
                    }
                    if (this.this$1.GeographicMapMaker.this.reverseSort) {
                        return Double.compare(d2, d1);
                    }
                    return Double.compare(d1, d2);
                }
            };
        }

        protected void plotFirst() {
        }

        protected void plotPoliticalBoundaries() {
            if (GeographicMapMaker.this.politicalBoundaries != null && GeographicMapMaker.this.politicalBoundaryChar != null) {
                for (XY_DataSet xy : GeographicMapMaker.this.politicalBoundaries) {
                    this.funcs.add(xy);
                    this.chars.add(GeographicMapMaker.this.politicalBoundaryChar);
                }
            }
        }

        protected void plotRegionOutlines() {
            if (GeographicMapMaker.this.regionOutlineChar != null && (GeographicMapMaker.this.plotRectangularRegionOutlines || !GeographicMapMaker.this.region.isRectangular())) {
                DefaultXY_DataSet outline = new DefaultXY_DataSet();
                for (Location loc : GeographicMapMaker.this.region.getBorder()) {
                    outline.set(loc.getLongitude(), loc.getLatitude());
                }
                outline.set(outline.get(0));
                this.funcs.add(outline);
                this.chars.add(GeographicMapMaker.this.regionOutlineChar);
            }
            if (GeographicMapMaker.this.insetRegions != null) {
                Preconditions.checkState((GeographicMapMaker.this.insetRegionOutlineChars != null || GeographicMapMaker.this.insetRegionFillColors != null ? 1 : 0) != 0);
                for (int r = 0; r < GeographicMapMaker.this.insetRegions.size(); ++r) {
                    Region region = GeographicMapMaker.this.insetRegions.get(r);
                    DefaultXY_DataSet outline = new DefaultXY_DataSet();
                    for (Location loc : region.getBorder()) {
                        outline.set(loc.getLongitude(), loc.getLatitude());
                    }
                    outline.set(outline.get(0));
                    PlotCurveCharacterstics insetRegionOutlineChar = GeographicMapMaker.this.insetRegionOutlineChars == null ? null : GeographicMapMaker.this.insetRegionOutlineChars.get(r);
                    Color insetRegionFillColor = GeographicMapMaker.this.insetRegionFillColors == null ? null : GeographicMapMaker.this.insetRegionFillColors.get(r);
                    PlotCurveCharacterstics insetRegionFillChar = null;
                    if (insetRegionFillColor != null) {
                        if (GeographicMapMaker.this.insetRegionFillOpacity != 1.0) {
                            insetRegionFillColor = new Color(insetRegionFillColor.getRed(), insetRegionFillColor.getGreen(), insetRegionFillColor.getBlue(), (int)(255.0 * GeographicMapMaker.this.insetRegionFillOpacity + 0.5));
                        }
                        insetRegionFillChar = new PlotCurveCharacterstics(PlotLineType.POLYGON_SOLID, 1.0f, insetRegionFillColor);
                    }
                    if (insetRegionFillChar != null) {
                        this.funcs.add(0, outline);
                        this.chars.add(0, insetRegionFillChar);
                    }
                    if (insetRegionOutlineChar != null) {
                        this.funcs.add(outline);
                        this.chars.add(insetRegionOutlineChar);
                    }
                    if (!this.writeGeoJSON) continue;
                    Feature feature = region.toFeature();
                    FeatureProperties props = feature.properties;
                    if (region.getName() != null) {
                        props.set("name", region.getName());
                    }
                    if (insetRegionOutlineChar != null && insetRegionOutlineChar.getLineType() != null) {
                        props.set("stroke-width", Float.valueOf(insetRegionOutlineChar.getLineWidth()));
                        props.set("stroke", insetRegionOutlineChar.getColor());
                    }
                    if (insetRegionFillColor != null) {
                        props.set("fill", insetRegionFillColor);
                        props.set("fill-opacity", GeographicMapMaker.this.insetRegionFillOpacity);
                    }
                    this.features.add(feature);
                }
            }
        }

        protected void plotBeforeSects() {
        }

        /*
         * WARNING - void declaration
         */
        protected void plotSects() {
            DefaultXY_DataSet outline;
            if (GeographicMapMaker.this.sects == null || GeographicMapMaker.this.sects.isEmpty()) {
                return;
            }
            Range xRange = GeographicMapMaker.this.getXRange();
            Range yRange = GeographicMapMaker.this.getYRange();
            Region plotRegion = new Region(new Location(yRange.getLowerBound(), xRange.getLowerBound()), new Location(yRange.getUpperBound(), xRange.getUpperBound()));
            HashSet<FaultSection> plotSects = new HashSet<FaultSection>();
            for (FaultSection faultSection : GeographicMapMaker.this.sects) {
                RuptureSurface surf = GeographicMapMaker.this.getSectSurface(faultSection);
                boolean include = false;
                for (Location loc : surf.getEvenlyDiscritizedPerimeter()) {
                    if (!plotRegion.contains(loc)) continue;
                    include = true;
                    break;
                }
                if (!include) continue;
                plotSects.add(faultSection);
            }
            if (!GeographicMapMaker.this.plotSectPolysOnTop) {
                this.plotSectPolys(plotSects);
            }
            XY_DataSet prevTrace = null;
            Object var6_7 = null;
            DefaultXY_DataSet prevOutline = null;
            ArrayList<DefaultXY_DataSet> traces = new ArrayList<DefaultXY_DataSet>();
            HashMap<Integer, Feature> outlineFeatures = this.writeGeoJSON ? new HashMap<Integer, Feature>() : null;
            for (int s = 0; s < GeographicMapMaker.this.sects.size(); ++s) {
                FaultSection sect = GeographicMapMaker.this.sects.get(s);
                if (!plotSects.contains(sect)) {
                    traces.add(null);
                    continue;
                }
                DefaultXY_DataSet trace = new DefaultXY_DataSet();
                for (Location loc : GeographicMapMaker.this.getUpperEdge(sect)) {
                    trace.set(loc.getLongitude(), loc.getLatitude());
                }
                if (traces.isEmpty()) {
                    trace.setName("Fault Sections");
                }
                traces.add(trace);
                boolean sectsAreColored = GeographicMapMaker.this.sectScalars != null || GeographicMapMaker.this.sectColors != null || GeographicMapMaker.this.sectChars != null;
                boolean doTraces = !sectsAreColored;
                boolean bl = false;
                if (GeographicMapMaker.this.sectScalars != null) {
                    bl = Double.isNaN(GeographicMapMaker.this.sectScalars.get(s));
                } else if (GeographicMapMaker.this.sectColors != null) {
                    bl = GeographicMapMaker.this.sectColors.get(s) == null;
                } else if (GeographicMapMaker.this.sectChars != null) {
                    boolean bl2 = bl = GeographicMapMaker.this.sectChars.get(s) == null;
                }
                if (!(doTraces || GeographicMapMaker.this.skipNaNs && GeographicMapMaker.this.sectNaNChar == null)) {
                    doTraces = bl;
                }
                if (sectsAreColored && GeographicMapMaker.this.fillSurfaces && GeographicMapMaker.this.plotTracesForFilledSurfaces && sect.getAveDip() != 90.0) {
                    boolean bl3 = doTraces = !bl && GeographicMapMaker.this.sectSortables == null && GeographicMapMaker.this.sectColorComparables == null && GeographicMapMaker.this.sectCharsComparables == null;
                }
                if (GeographicMapMaker.this.sectOutlineChar != null && sect.getAveDip() != 90.0) {
                    outline = new DefaultXY_DataSet();
                    for (Location loc : GeographicMapMaker.this.getPerimeter(sect)) {
                        outline.set(loc.getLongitude(), loc.getLatitude());
                    }
                    boolean reused = false;
                    if (prevOutline != null && this.funcs.get(0) == prevOutline) {
                        int matchIndex = -1;
                        Point2D myFirst = outline.get(0);
                        for (int i = 0; i < prevOutline.size(); ++i) {
                            Point2D pt = prevOutline.get(i);
                            if ((float)pt.getX() != (float)myFirst.getX() || (float)pt.getY() != (float)myFirst.getY()) continue;
                            matchIndex = i;
                            break;
                        }
                        if (matchIndex >= 0) {
                            int i;
                            reused = true;
                            DefaultXY_DataSet merged = new DefaultXY_DataSet();
                            for (i = 0; i <= matchIndex; ++i) {
                                merged.set(prevOutline.get(i));
                            }
                            for (i = 1; i < outline.size(); ++i) {
                                merged.set(outline.get(i));
                            }
                            for (i = matchIndex + 1; i < prevOutline.size(); ++i) {
                                merged.set(prevOutline.get(i));
                            }
                            this.funcs.set(0, merged);
                            prevOutline = merged;
                        }
                    }
                    if (!reused) {
                        this.funcs.add(0, outline);
                        prevOutline = outline;
                        this.chars.add(0, GeographicMapMaker.this.sectOutlineChar);
                        if (doTraces && GeographicMapMaker.this.sectTraceChar == null && s == 0) {
                            outline.setName("Fault Sections");
                        }
                    }
                    if (this.writeGeoJSON) {
                        Feature feature = GeographicMapMaker.this.surfFeature(sect, GeographicMapMaker.this.sectOutlineChar);
                        outlineFeatures.put(sect.getSectionId(), feature);
                        this.features.add(0, feature);
                    }
                }
                if (!doTraces) continue;
                if (bl && GeographicMapMaker.this.sectNaNChar != null) {
                    void var6_8;
                    boolean reused = false;
                    if (var6_8 != null) {
                        Point2D prevLast = var6_8.get(var6_8.size() - 1);
                        Point2D newFirst = trace.get(0);
                        if ((float)prevLast.getX() == (float)newFirst.getX() && (float)prevLast.getY() == (float)newFirst.getY()) {
                            for (int i = 1; i < trace.size(); ++i) {
                                var6_8.set(trace.get(i));
                            }
                            reused = true;
                        }
                    }
                    if (!reused) {
                        this.funcs.add(trace);
                        DefaultXY_DataSet defaultXY_DataSet = trace;
                        this.chars.add(GeographicMapMaker.this.sectNaNChar);
                    }
                    if (!this.writeGeoJSON) continue;
                    this.features.add(GeographicMapMaker.this.traceFeature(sect, GeographicMapMaker.this.sectNaNChar));
                    continue;
                }
                if (GeographicMapMaker.this.sectTraceChar == null) continue;
                boolean reused = false;
                if (prevTrace != null) {
                    Point2D prevLast = prevTrace.get(prevTrace.size() - 1);
                    Point2D newFirst = trace.get(0);
                    if ((float)prevLast.getX() == (float)newFirst.getX() && (float)prevLast.getY() == (float)newFirst.getY()) {
                        for (int i = 1; i < trace.size(); ++i) {
                            prevTrace.set(trace.get(i));
                        }
                        reused = true;
                    }
                }
                if (!reused) {
                    this.funcs.add(trace);
                    prevTrace = trace;
                    this.chars.add(GeographicMapMaker.this.sectTraceChar);
                }
                if (!this.writeGeoJSON) continue;
                this.features.add(GeographicMapMaker.this.traceFeature(sect, GeographicMapMaker.this.sectTraceChar));
            }
            if (GeographicMapMaker.this.sectScalars != null) {
                List<Integer> sectOrder = new ArrayList<Integer>(GeographicMapMaker.this.sects.size());
                for (int s = 0; s < GeographicMapMaker.this.sects.size(); ++s) {
                    sectOrder.add(s);
                }
                if (GeographicMapMaker.this.sort) {
                    List<Double> comps = GeographicMapMaker.this.sectSortables == null ? GeographicMapMaker.this.sectScalars : GeographicMapMaker.this.sectSortables;
                    sectOrder = ComparablePairing.getSortedData(comps, sectOrder);
                }
                Iterator comps = sectOrder.iterator();
                while (comps.hasNext()) {
                    void var15_44;
                    int s = (Integer)comps.next();
                    FaultSection sect = GeographicMapMaker.this.sects.get(s);
                    float scalar = GeographicMapMaker.this.sectScalars.get(s).floatValue();
                    Color color = GeographicMapMaker.this.sectScalarCPT.getColor(scalar);
                    if (!plotSects.contains(sect) || GeographicMapMaker.this.skipNaNs && Double.isNaN(scalar)) continue;
                    if (Double.isNaN(scalar) && GeographicMapMaker.this.sectNaNChar != null) {
                        Color color2 = GeographicMapMaker.this.sectNaNChar.getColor();
                    }
                    if (GeographicMapMaker.this.fillSurfaces && sect.getAveDip() != 90.0) {
                        outline = new DefaultXY_DataSet();
                        for (Location loc : GeographicMapMaker.this.getPerimeter(sect)) {
                            outline.set(loc.getLongitude(), loc.getLatitude());
                        }
                        PlotCurveCharacterstics fillChar = new PlotCurveCharacterstics(PlotLineType.POLYGON_SOLID, 0.5f, (Color)var15_44);
                        if (GeographicMapMaker.this.sectSortables == null) {
                            this.funcs.add(0, outline);
                            this.chars.add(0, fillChar);
                            continue;
                        }
                        this.funcs.add(outline);
                        this.chars.add(fillChar);
                        if (GeographicMapMaker.this.plotOutlinesForFilledSurfaces && GeographicMapMaker.this.sectOutlineChar != null && !Double.isNaN(scalar)) {
                            this.funcs.add(outline);
                            this.chars.add(GeographicMapMaker.this.sectOutlineChar);
                        }
                        if (!GeographicMapMaker.this.plotTracesForFilledSurfaces || GeographicMapMaker.this.sectTraceChar == null || Double.isNaN(scalar)) continue;
                        this.funcs.add((XY_DataSet)traces.get(s));
                        this.chars.add(GeographicMapMaker.this.sectTraceChar);
                        continue;
                    }
                    DefaultXY_DataSet trace = new DefaultXY_DataSet();
                    for (Location loc : GeographicMapMaker.this.getUpperEdge(sect)) {
                        trace.set(loc.getLongitude(), loc.getLatitude());
                    }
                    this.funcs.add(trace);
                    PlotCurveCharacterstics scalarChar = new PlotCurveCharacterstics(PlotLineType.SOLID, GeographicMapMaker.this.sectScalarThickness, (Color)var15_44);
                    this.chars.add(scalarChar);
                    if (!this.writeGeoJSON) continue;
                    Feature feature = GeographicMapMaker.this.traceFeature(sect, scalarChar);
                    if (GeographicMapMaker.this.sectScalarLabel != null && Float.isFinite(scalar)) {
                        feature.properties.set(GeographicMapMaker.this.sectScalarLabel, Float.valueOf(scalar));
                        Feature outlineFeature = (Feature)outlineFeatures.get(sect.getSectionId());
                        if (outlineFeature != null) {
                            outlineFeature.properties.set(GeographicMapMaker.this.sectScalarLabel, Float.valueOf(scalar));
                        }
                    }
                    this.features.add(feature);
                }
                if (GeographicMapMaker.this.sectScalarLabel != null && GeographicMapMaker.this.sectScalarCPT != null) {
                    this.cptLegend.add(GeographicMapMaker.buildCPTLegend(GeographicMapMaker.this.sectScalarCPT, GeographicMapMaker.this.sectScalarLabel, GeographicMapMaker.this.cptEdge));
                }
            } else if (GeographicMapMaker.this.sectColors != null || GeographicMapMaker.this.sectChars != null) {
                ArrayList<Integer> sectOrder;
                boolean colors;
                List<Double> comps = null;
                if (GeographicMapMaker.this.sectColors != null) {
                    Preconditions.checkState((GeographicMapMaker.this.sectColors.size() == GeographicMapMaker.this.sects.size() ? 1 : 0) != 0);
                    comps = GeographicMapMaker.this.sectColorComparables;
                    colors = true;
                } else {
                    Preconditions.checkState((GeographicMapMaker.this.sectChars.size() == GeographicMapMaker.this.sects.size() ? 1 : 0) != 0);
                    comps = GeographicMapMaker.this.sectCharsComparables;
                    colors = false;
                }
                if (comps != null) {
                    Preconditions.checkState((comps.size() == GeographicMapMaker.this.sects.size() ? 1 : 0) != 0);
                    ArrayList<ComparablePairing<Double, Integer>> sortables = new ArrayList<ComparablePairing<Double, Integer>>();
                    for (int s = 0; s < comps.size(); ++s) {
                        sortables.add(new ComparablePairing<Double, Integer>(comps.get(s), s));
                    }
                    if (GeographicMapMaker.this.sort) {
                        Collections.sort(sortables, this.buildComparator(colors ? GeographicMapMaker.this.sectColorsCPT : GeographicMapMaker.this.sectCharsCPT));
                    }
                    sectOrder = new ArrayList(GeographicMapMaker.this.sects.size());
                    for (ComparablePairing comparablePairing : sortables) {
                        sectOrder.add((Integer)comparablePairing.getData());
                    }
                } else {
                    sectOrder = new ArrayList<Integer>(GeographicMapMaker.this.sects.size());
                    for (int s = 0; s < GeographicMapMaker.this.sects.size(); ++s) {
                        sectOrder.add(s);
                    }
                }
                Iterator iterator = sectOrder.iterator();
                while (iterator.hasNext()) {
                    void var15_48;
                    FaultSection sect;
                    Color color;
                    int s = (Integer)iterator.next();
                    if (colors) {
                        color = GeographicMapMaker.this.sectColors.get(s);
                        if (color == null) continue;
                        PlotCurveCharacterstics plotCurveCharacterstics = new PlotCurveCharacterstics(PlotLineType.SOLID, GeographicMapMaker.this.sectScalarThickness, color);
                    } else {
                        PlotCurveCharacterstics plotCurveCharacterstics = GeographicMapMaker.this.sectChars.get(s);
                        if (plotCurveCharacterstics == null) continue;
                        color = plotCurveCharacterstics.getColor();
                    }
                    if (!plotSects.contains(sect = GeographicMapMaker.this.sects.get(s))) continue;
                    if (GeographicMapMaker.this.fillSurfaces && sect.getAveDip() != 90.0) {
                        DefaultXY_DataSet outline2 = new DefaultXY_DataSet();
                        LocationList perimeter = GeographicMapMaker.this.getPerimeter(sect);
                        Iterator merged = perimeter.iterator();
                        while (merged.hasNext()) {
                            Location loc = (Location)merged.next();
                            outline2.set(loc.getLongitude(), loc.getLatitude());
                        }
                        PlotCurveCharacterstics fillChar = new PlotCurveCharacterstics(PlotLineType.POLYGON_SOLID, 0.5f, color);
                        if (comps == null) {
                            this.funcs.add(0, outline2);
                            this.chars.add(0, fillChar);
                        } else {
                            this.funcs.add(outline2);
                            this.chars.add(fillChar);
                            if (GeographicMapMaker.this.plotOutlinesForFilledSurfaces && GeographicMapMaker.this.sectOutlineChar != null) {
                                this.funcs.add(outline2);
                                this.chars.add(GeographicMapMaker.this.sectOutlineChar);
                            }
                            if (GeographicMapMaker.this.plotTracesForFilledSurfaces && GeographicMapMaker.this.sectTraceChar != null) {
                                this.funcs.add((XY_DataSet)traces.get(s));
                                this.chars.add(GeographicMapMaker.this.sectTraceChar);
                            }
                        }
                    }
                    DefaultXY_DataSet trace = new DefaultXY_DataSet();
                    for (Location loc : GeographicMapMaker.this.getUpperEdge(sect)) {
                        trace.set(loc.getLongitude(), loc.getLatitude());
                    }
                    this.funcs.add(trace);
                    this.chars.add((PlotCurveCharacterstics)var15_48);
                    if (!this.writeGeoJSON) continue;
                    Feature feature = GeographicMapMaker.this.traceFeature(sect, (PlotCurveCharacterstics)var15_48);
                    this.features.add(feature);
                }
                if (colors && GeographicMapMaker.this.sectColorsCPT != null) {
                    this.cptLegend.add(GeographicMapMaker.buildCPTLegend(GeographicMapMaker.this.sectColorsCPT, GeographicMapMaker.this.sectColorsLabel, GeographicMapMaker.this.cptEdge));
                }
                if (!colors && GeographicMapMaker.this.sectCharsCPT != null) {
                    this.cptLegend.add(GeographicMapMaker.buildCPTLegend(GeographicMapMaker.this.sectCharsCPT, GeographicMapMaker.this.sectCharsLabel, GeographicMapMaker.this.cptEdge));
                }
            }
            if (GeographicMapMaker.this.highlightSections != null && GeographicMapMaker.this.highlightTraceChar != null) {
                for (FaultSection hightlight : GeographicMapMaker.this.highlightSections) {
                    DefaultXY_DataSet trace = new DefaultXY_DataSet();
                    for (Location loc : GeographicMapMaker.this.getUpperEdge(hightlight)) {
                        trace.set(loc.getLongitude(), loc.getLatitude());
                    }
                    this.funcs.add(trace);
                    this.chars.add(GeographicMapMaker.this.highlightTraceChar);
                    if (!this.writeGeoJSON) continue;
                    this.features.add(GeographicMapMaker.this.traceFeature(hightlight, GeographicMapMaker.this.highlightTraceChar));
                }
            }
            if (GeographicMapMaker.this.plotSectPolysOnTop) {
                this.plotSectPolys(plotSects);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void plotSectPolys(Set<FaultSection> plotSects) {
            if (GeographicMapMaker.this.plotAllSectPolys || GeographicMapMaker.this.plotProxySectPolys) {
                void var5_7;
                boolean first = true;
                boolean hasNonProxy = false;
                for (FaultSection faultSection : GeographicMapMaker.this.sects) {
                    hasNonProxy = !faultSection.isProxyFault() && faultSection.getZonePolygon() != null;
                }
                Region prevPoly = null;
                boolean bl = false;
                while (var5_7 < GeographicMapMaker.this.sects.size()) {
                    FaultSection sect = GeographicMapMaker.this.sects.get((int)var5_7);
                    Region poly = sect.getZonePolygon();
                    if (plotSects.contains(sect) && poly != null && (GeographicMapMaker.this.plotAllSectPolys || sect.isProxyFault()) && (prevPoly == null || !prevPoly.equals(poly))) {
                        prevPoly = poly;
                        DefaultXY_DataSet xy = new DefaultXY_DataSet();
                        for (Location loc : poly.getBorder()) {
                            xy.set(loc.lon, loc.lat);
                        }
                        if (!xy.get(0).equals(xy.get(xy.size() - 1))) {
                            xy.set(xy.get(0));
                        }
                        if (first) {
                            if (hasNonProxy && GeographicMapMaker.this.plotAllSectPolys) {
                                xy.setName("Fault Polygons");
                            } else {
                                xy.setName("Proxy Fault Polygons");
                            }
                            first = false;
                        }
                        this.funcs.add(xy);
                        this.chars.add(GeographicMapMaker.this.sectPolyChar);
                        if (this.writeGeoJSON) {
                            double opacity;
                            Color color;
                            Feature feature = poly.toFeature();
                            FeatureProperties props = feature.properties;
                            props.set("name", sect.getSectionName());
                            props.set("id", sect.getSectionId());
                            if (sect.getParentSectionId() >= 0) {
                                props.set("parentID", sect.getParentSectionId());
                            }
                            if (GeographicMapMaker.this.sectPolyChar.getLineType() == PlotLineType.POLYGON_SOLID) {
                                props.set("stroke-opacity", 0.0);
                                color = GeographicMapMaker.this.sectPolyChar.getColor();
                                if (color.getAlpha() == 255) {
                                    props.set("fill", color);
                                } else {
                                    opacity = (double)color.getAlpha() / 255.0;
                                    props.set("fill-opacity", opacity);
                                    props.set("fill", new Color(color.getRed(), color.getGreen(), color.getBlue()));
                                }
                            } else if (GeographicMapMaker.this.sectPolyChar.getLineType() != null) {
                                props.set("fill-opacity", 0.0);
                                props.set("stroke-width", Float.valueOf(GeographicMapMaker.this.sectPolyChar.getLineWidth()));
                                color = GeographicMapMaker.this.sectPolyChar.getColor();
                                if (color.getAlpha() == 255) {
                                    props.set("stroke", color);
                                } else {
                                    opacity = (double)color.getAlpha() / 255.0;
                                    props.set("stroke-opacity", opacity);
                                    props.set("stroke", new Color(color.getRed(), color.getGreen(), color.getBlue()));
                                }
                            }
                            this.features.add(feature);
                        }
                    }
                    ++var5_7;
                }
            }
        }

        protected void plotAfterSects() {
        }

        protected void plotJumps() {
            if (GeographicMapMaker.this.jumpLists != null && !GeographicMapMaker.this.jumpLists.isEmpty()) {
                for (int i = 0; i < GeographicMapMaker.this.jumpLists.size(); ++i) {
                    Collection<Jump> jumps = GeographicMapMaker.this.jumpLists.get(i);
                    Color color = GeographicMapMaker.this.jumpColors.get(i);
                    String label = GeographicMapMaker.this.jumpLabels.get(i);
                    this.hasLegend = this.hasLegend || label != null && !label.isEmpty();
                    PlotCurveCharacterstics jumpChar = new PlotCurveCharacterstics(PlotLineType.SOLID, GeographicMapMaker.this.jumpLineThickness, color);
                    boolean first = true;
                    for (Jump jump : jumps) {
                        Location loc1 = GeographicMapMaker.this.getSectMiddle(jump.fromSection);
                        Location loc2 = GeographicMapMaker.this.getSectMiddle(jump.toSection);
                        DefaultXY_DataSet xy = new DefaultXY_DataSet();
                        if (first) {
                            first = false;
                            if (label != null) {
                                xy.setName(label);
                            }
                        }
                        xy.set(loc1.getLongitude(), loc1.getLatitude());
                        xy.set(loc2.getLongitude(), loc2.getLatitude());
                        this.funcs.add(xy);
                        this.chars.add(jumpChar);
                        if (!this.writeGeoJSON) continue;
                        Geometry.LineString line = new Geometry.LineString(loc1, loc2);
                        FeatureProperties props = new FeatureProperties();
                        props.set("stroke-width", Float.valueOf(GeographicMapMaker.this.jumpLineThickness));
                        props.set("stroke", color);
                        if (color.getAlpha() != 255) {
                            props.set("stroke-opacity", Float.valueOf((float)((double)color.getAlpha() / 255.0)));
                        }
                        props.set("label", label);
                        props.set("fromSection", jump.fromSection.getName());
                        props.set("toSection", jump.toSection.getName());
                        props.set("distance", jump.distance);
                        this.features.add(new Feature(line, props));
                    }
                }
            }
            if (GeographicMapMaker.this.scalarJumps != null) {
                ArrayList<ComparablePairing<Double, DefaultXY_DataSet>> sortables = new ArrayList<ComparablePairing<Double, DefaultXY_DataSet>>();
                for (int j = 0; j < GeographicMapMaker.this.scalarJumps.size(); ++j) {
                    double d = GeographicMapMaker.this.scalarJumpValues.get(j);
                    if (GeographicMapMaker.this.skipNaNs && Double.isNaN(d)) continue;
                    Jump jump = GeographicMapMaker.this.scalarJumps.get(j);
                    Location loc1 = GeographicMapMaker.this.getSectMiddle(jump.fromSection);
                    Location loc2 = GeographicMapMaker.this.getSectMiddle(jump.toSection);
                    DefaultXY_DataSet xy = new DefaultXY_DataSet();
                    xy.set(loc1.getLongitude(), loc1.getLatitude());
                    xy.set(loc2.getLongitude(), loc2.getLatitude());
                    sortables.add(new ComparablePairing<Double, DefaultXY_DataSet>(d, xy));
                    if (!this.writeGeoJSON) continue;
                    Geometry.LineString line = new Geometry.LineString(loc1, loc2);
                    FeatureProperties props = new FeatureProperties();
                    props.set("stroke-width", Float.valueOf(GeographicMapMaker.this.jumpLineThickness));
                    Color color = GeographicMapMaker.this.scalarJumpsCPT.getColor((float)d);
                    props.set("stroke", color);
                    if (color.getAlpha() != 255) {
                        props.set("stroke-opacity", Float.valueOf((float)((double)color.getAlpha() / 255.0)));
                    }
                    if (Double.isFinite(d) && GeographicMapMaker.this.scalarJumpsLabel != null) {
                        props.set(GeographicMapMaker.this.scalarJumpsLabel, Float.valueOf((float)d));
                    }
                    props.set("fromSection", jump.fromSection.getName());
                    props.set("toSection", jump.toSection.getName());
                    props.set("distance", jump.distance);
                    this.features.add(new Feature(line, props));
                }
                if (GeographicMapMaker.this.sort) {
                    Collections.sort(sortables, this.buildComparator(GeographicMapMaker.this.scalarJumpsCPT));
                }
                for (ComparablePairing comparablePairing : sortables) {
                    float scalar = ((Double)comparablePairing.getComparable()).floatValue();
                    Color color = GeographicMapMaker.this.scalarJumpsCPT.getColor(scalar);
                    this.funcs.add((XY_DataSet)comparablePairing.getData());
                    this.chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, GeographicMapMaker.this.jumpLineThickness, color));
                }
                if (GeographicMapMaker.this.scalarJumpsLabel != null && GeographicMapMaker.this.scalarJumpsCPT != null) {
                    this.cptLegend.add(GeographicMapMaker.buildCPTLegend(GeographicMapMaker.this.scalarJumpsCPT, GeographicMapMaker.this.scalarJumpsLabel, GeographicMapMaker.this.cptEdge));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void plotScatters() {
            if (GeographicMapMaker.this.scatterLocs == null || GeographicMapMaker.this.scatterLocs.isEmpty()) {
                return;
            }
            if (GeographicMapMaker.this.scatterScalars != null) {
                DefaultXY_DataSet outlines = GeographicMapMaker.this.scatterOutline == null ? null : new DefaultXY_DataSet();
                ArrayList<ComparablePairing<Double, DefaultXY_DataSet>> sortables = new ArrayList<ComparablePairing<Double, DefaultXY_DataSet>>();
                for (int j = 0; j < GeographicMapMaker.this.scatterLocs.size(); ++j) {
                    double d = GeographicMapMaker.this.scatterScalars.get(j);
                    if (GeographicMapMaker.this.skipNaNs && Double.isNaN(d)) continue;
                    Location loc = GeographicMapMaker.this.scatterLocs.get(j);
                    DefaultXY_DataSet xy = new DefaultXY_DataSet();
                    xy.set(loc.getLongitude(), loc.getLatitude());
                    sortables.add(new ComparablePairing<Double, DefaultXY_DataSet>(d, xy));
                    if (this.writeGeoJSON) {
                        FeatureProperties extProps;
                        Color color = GeographicMapMaker.this.scatterScalarCPT.getColor((float)d);
                        FeatureProperties props = new FeatureProperties();
                        if (GeographicMapMaker.this.scatterProps != null && (extProps = GeographicMapMaker.this.scatterProps.get(j)) != null) {
                            props.putAll(extProps);
                        }
                        props.set("marker-color", color);
                        if (GeographicMapMaker.this.scatterSymbolWidth > 8.0f) {
                            props.set("marker-size", "large");
                        } else if (GeographicMapMaker.this.scatterSymbolWidth > 4.0f) {
                            props.set("marker-size", "medium");
                        } else {
                            props.set("marker-size", "small");
                        }
                        this.features.add(new Feature(new Geometry.Point(loc), props));
                    }
                    if (outlines == null) continue;
                    outlines.set(xy.get(0));
                }
                if (GeographicMapMaker.this.sort) {
                    Collections.sort(sortables, this.buildComparator(GeographicMapMaker.this.scatterScalarCPT));
                }
                for (ComparablePairing comparablePairing : sortables) {
                    float scalar = ((Double)comparablePairing.getComparable()).floatValue();
                    Color color = GeographicMapMaker.this.scatterScalarCPT.getColor(scalar);
                    this.funcs.add((XY_DataSet)comparablePairing.getData());
                    this.chars.add(new PlotCurveCharacterstics(GeographicMapMaker.this.scatterSymbol, GeographicMapMaker.this.scatterSymbolWidth, color));
                }
                if (outlines != null) {
                    this.funcs.add(outlines);
                    this.chars.add(new PlotCurveCharacterstics(GeographicMapMaker.this.scatterOutline, GeographicMapMaker.this.scatterSymbolWidth, GeographicMapMaker.this.scatterOutlineColor));
                }
                if (GeographicMapMaker.this.scatterScalarLabel != null && GeographicMapMaker.this.scatterScalarCPT != null) {
                    this.cptLegend.add(GeographicMapMaker.buildCPTLegend(GeographicMapMaker.this.scatterScalarCPT, GeographicMapMaker.this.scatterScalarLabel, GeographicMapMaker.this.cptEdge));
                }
            } else if (GeographicMapMaker.this.scatterChars != null) {
                for (int j = 0; j < GeographicMapMaker.this.scatterLocs.size(); ++j) {
                    FeatureProperties extProps;
                    Location loc = GeographicMapMaker.this.scatterLocs.get(j);
                    PlotCurveCharacterstics xyChar = GeographicMapMaker.this.scatterChars.get(j);
                    DefaultXY_DataSet defaultXY_DataSet = new DefaultXY_DataSet();
                    defaultXY_DataSet.set(loc.getLongitude(), loc.getLatitude());
                    this.funcs.add(defaultXY_DataSet);
                    this.chars.add(xyChar);
                    if (!this.writeGeoJSON) continue;
                    Color color = xyChar.getColor();
                    FeatureProperties props = new FeatureProperties();
                    if (GeographicMapMaker.this.scatterProps != null && (extProps = GeographicMapMaker.this.scatterProps.get(j)) != null) {
                        props.putAll(extProps);
                    }
                    props.set("marker-color", color);
                    float width = xyChar.getSymbolWidth();
                    if (width > 8.0f) {
                        props.set("marker-size", "large");
                    } else if (width > 4.0f) {
                        props.set("marker-size", "medium");
                    } else {
                        props.set("marker-size", "small");
                    }
                    this.features.add(new Feature(new Geometry.Point(loc), props));
                }
                if (GeographicMapMaker.this.scatterScalarLabel != null && GeographicMapMaker.this.scatterScalarCPT != null) {
                    this.cptLegend.add(GeographicMapMaker.buildCPTLegend(GeographicMapMaker.this.scatterScalarCPT, GeographicMapMaker.this.scatterScalarLabel, GeographicMapMaker.this.cptEdge));
                }
            } else {
                void var4_15;
                DefaultXY_DataSet outlines = GeographicMapMaker.this.scatterOutline == null ? null : new DefaultXY_DataSet();
                Preconditions.checkNotNull((Object)GeographicMapMaker.this.scatterColor);
                DefaultXY_DataSet xy = new DefaultXY_DataSet();
                LocationList locs = new LocationList();
                boolean bl = false;
                while (var4_15 < GeographicMapMaker.this.scatterLocs.size()) {
                    Location loc = GeographicMapMaker.this.scatterLocs.get((int)var4_15);
                    locs.add(loc);
                    xy.set(loc.getLongitude(), loc.getLatitude());
                    if (outlines != null) {
                        outlines.set(loc.getLongitude(), loc.getLatitude());
                    }
                    if (this.writeGeoJSON && GeographicMapMaker.this.scatterProps != null) {
                        FeatureProperties extProps;
                        FeatureProperties props = new FeatureProperties();
                        if (GeographicMapMaker.this.scatterProps != null && (extProps = GeographicMapMaker.this.scatterProps.get((int)var4_15)) != null) {
                            props.putAll(extProps);
                        }
                        props.set("marker-color", GeographicMapMaker.this.scatterColor);
                        if (GeographicMapMaker.this.scatterSymbolWidth > 8.0f) {
                            props.set("marker-size", "large");
                        } else if (GeographicMapMaker.this.scatterSymbolWidth > 4.0f) {
                            props.set("marker-size", "medium");
                        } else {
                            props.set("marker-size", "small");
                        }
                        this.features.add(new Feature(new Geometry.Point(loc), props));
                    }
                    ++var4_15;
                }
                this.funcs.add(xy);
                this.chars.add(new PlotCurveCharacterstics(GeographicMapMaker.this.scatterSymbol, GeographicMapMaker.this.scatterSymbolWidth, GeographicMapMaker.this.scatterColor));
                if (outlines != null) {
                    this.funcs.add(outlines);
                    this.chars.add(new PlotCurveCharacterstics(GeographicMapMaker.this.scatterOutline, GeographicMapMaker.this.scatterSymbolWidth, GeographicMapMaker.this.scatterOutlineColor));
                }
                if (this.writeGeoJSON && GeographicMapMaker.this.scatterProps == null) {
                    FeatureProperties featureProperties = new FeatureProperties();
                    featureProperties.set("marker-color", GeographicMapMaker.this.scatterColor);
                    if (GeographicMapMaker.this.scatterSymbolWidth > 8.0f) {
                        featureProperties.set("marker-size", "large");
                    } else if (GeographicMapMaker.this.scatterSymbolWidth > 4.0f) {
                        featureProperties.set("marker-size", "medium");
                    } else {
                        featureProperties.set("marker-size", "small");
                    }
                    this.features.add(new Feature(new Geometry.MultiPoint(locs), featureProperties));
                }
            }
        }

        protected void plotLine(LocationList line, Color color, float lineThickness) {
            this.plotLine(line, new PlotCurveCharacterstics(PlotLineType.SOLID, lineThickness, color));
        }

        protected void plotLine(LocationList line, PlotCurveCharacterstics lineChar) {
            this.plotLines(List.of(line), List.of(lineChar));
        }

        protected void plotLines(List<LocationList> lines, List<PlotCurveCharacterstics> lineChars) {
            PlotCurveCharacterstics lineChar;
            LocationList line;
            int i;
            for (i = 0; i < lines.size(); ++i) {
                line = lines.get(i);
                lineChar = lineChars.size() == 1 ? lineChars.get(0) : lineChars.get(i);
                DefaultXY_DataSet xy = new DefaultXY_DataSet();
                for (Location loc : line) {
                    xy.set(loc.getLongitude(), loc.getLatitude());
                }
                this.funcs.add(xy);
                this.chars.add(lineChar);
            }
            if (this.writeGeoJSON) {
                if (lines.size() > 1 && lineChars.size() == 1) {
                    PlotCurveCharacterstics lineChar2 = lineChars.get(0);
                    FeatureProperties props = new FeatureProperties();
                    float width = lineChar2.getLineWidth();
                    props.set("stroke-width", Float.valueOf(width));
                    props.set("stroke", lineChar2.getColor());
                    this.features.add(new Feature(new Geometry.MultiLineString(lines), props));
                } else {
                    for (i = 0; i < lines.size(); ++i) {
                        line = lines.get(i);
                        lineChar = lineChars.get(i);
                        FeatureProperties props = new FeatureProperties();
                        float width = lineChar.getLineWidth();
                        props.set("stroke-width", Float.valueOf(width));
                        props.set("stroke", lineChar.getColor());
                        this.features.add(new Feature(new Geometry.LineString(line), props));
                    }
                }
            }
        }

        protected void plotLines() {
            if (GeographicMapMaker.this.lines == null || GeographicMapMaker.this.lines.isEmpty()) {
                return;
            }
            if (GeographicMapMaker.this.lineColors != null) {
                for (int j = 0; j < GeographicMapMaker.this.lines.size(); ++j) {
                    LocationList line = GeographicMapMaker.this.lines.get(j);
                    Color color = GeographicMapMaker.this.lineColors.get(j);
                    this.plotLine(line, color, GeographicMapMaker.this.lineThickness);
                }
            } else if (GeographicMapMaker.this.lineChars != null) {
                for (int j = 0; j < GeographicMapMaker.this.lines.size(); ++j) {
                    LocationList line = GeographicMapMaker.this.lines.get(j);
                    PlotCurveCharacterstics xyChar = GeographicMapMaker.this.lineChars.get(j);
                    this.plotLine(line, xyChar);
                }
            } else {
                this.plotLines(GeographicMapMaker.this.lines, List.of(new PlotCurveCharacterstics(PlotLineType.SOLID, GeographicMapMaker.this.lineThickness, GeographicMapMaker.this.linesColor)));
            }
        }

        protected void plotArrows() {
            if (GeographicMapMaker.this.arrows == null || GeographicMapMaker.this.arrows.isEmpty()) {
                return;
            }
            if (GeographicMapMaker.this.arrowColors != null) {
                for (int j = 0; j < GeographicMapMaker.this.arrows.size(); ++j) {
                    LocationList arrow = GeographicMapMaker.this.arrows.get(j);
                    Color color = GeographicMapMaker.this.arrowColors.get(j);
                    PlotCurveCharacterstics xyChar = new PlotCurveCharacterstics(PlotLineType.SOLID, GeographicMapMaker.this.arrowThickness, color);
                    this.plotLine(arrow, xyChar);
                    Color headColor = GeographicMapMaker.this.arrowheadColor == null ? color : GeographicMapMaker.this.arrowheadColor;
                    LocationList arrowhead = this.buildArrowhead(arrow);
                    if (GeographicMapMaker.this.fillArrowheads) {
                        this.plotLine(arrowhead, new PlotCurveCharacterstics(PlotLineType.POLYGON_SOLID, 1.0f, headColor));
                        if (GeographicMapMaker.this.arrowheadOutlineColor == null) continue;
                        this.plotLine(arrowhead, new PlotCurveCharacterstics(PlotLineType.SOLID, GeographicMapMaker.this.arrowheadOutlineThickness, GeographicMapMaker.this.arrowheadOutlineColor));
                        continue;
                    }
                    this.plotLine(arrowhead, new PlotCurveCharacterstics(PlotLineType.SOLID, GeographicMapMaker.this.arrowheadThickness, headColor));
                }
            } else {
                Color headColor;
                this.plotLines(GeographicMapMaker.this.arrows, List.of(new PlotCurveCharacterstics(PlotLineType.SOLID, GeographicMapMaker.this.arrowThickness, GeographicMapMaker.this.arrowColor)));
                ArrayList<LocationList> arrowheads = new ArrayList<LocationList>(GeographicMapMaker.this.arrows.size());
                for (LocationList arrow : GeographicMapMaker.this.arrows) {
                    arrowheads.add(this.buildArrowhead(arrow));
                }
                Color color = headColor = GeographicMapMaker.this.arrowheadColor == null ? GeographicMapMaker.this.arrowColor : GeographicMapMaker.this.arrowheadColor;
                if (GeographicMapMaker.this.fillArrowheads) {
                    this.plotLines(arrowheads, List.of(new PlotCurveCharacterstics(PlotLineType.POLYGON_SOLID, 1.0f, headColor)));
                    if (GeographicMapMaker.this.arrowheadOutlineColor != null) {
                        this.plotLines(arrowheads, List.of(new PlotCurveCharacterstics(PlotLineType.SOLID, GeographicMapMaker.this.arrowheadOutlineThickness, GeographicMapMaker.this.arrowheadOutlineColor)));
                    }
                } else {
                    this.plotLines(arrowheads, List.of(new PlotCurveCharacterstics(PlotLineType.SOLID, GeographicMapMaker.this.arrowheadThickness, headColor)));
                }
            }
        }

        protected LocationList buildArrowhead(LocationList arrowLine) {
            Preconditions.checkState((arrowLine.size() > 1 ? 1 : 0) != 0);
            Location end = arrowLine.last();
            Location prev = (Location)arrowLine.get(arrowLine.size() - 2);
            return this.buildArrowhead(end, LocationUtils.azimuth(prev, end));
        }

        protected LocationList buildArrowhead(Location end, double lineAzimuth) {
            if (GeographicMapMaker.this.fillArrowheads) {
                double middleDist = 0.5 * GeographicMapMaker.this.arrowheadLenKM * Math.cos(Math.toRadians(GeographicMapMaker.this.arrowAngle));
                end = GeographicMapMaker.this.getLocationWithConstantProjectedDistance(end, lineAzimuth, middleDist);
            }
            Location arrowStart = GeographicMapMaker.this.getLocationWithConstantProjectedDistance(end, lineAzimuth - 180.0 + GeographicMapMaker.this.arrowAngle, GeographicMapMaker.this.arrowheadLenKM);
            Location arrowEnd = GeographicMapMaker.this.getLocationWithConstantProjectedDistance(end, lineAzimuth + 180.0 - GeographicMapMaker.this.arrowAngle, GeographicMapMaker.this.arrowheadLenKM);
            if (GeographicMapMaker.this.closeArrowheads || GeographicMapMaker.this.fillArrowheads) {
                return LocationList.of(arrowStart, end, arrowEnd, arrowStart);
            }
            return LocationList.of(arrowStart, end, arrowEnd);
        }

        protected void plotLast() {
        }

        public PlotSpec buildPlot(String title) {
            PlotSpec spec;
            String yAxisLabel;
            this.funcs = new ArrayList<XY_DataSet>();
            this.chars = new ArrayList<PlotCurveCharacterstics>();
            boolean bl = this.writeGeoJSON = GeographicMapMaker.this.writeGeoJSON && GeographicMapMaker.this.xyzData == null;
            if (this.writeGeoJSON) {
                this.features = new ArrayList<Feature>();
            }
            this.cptLegend = new ArrayList<PaintScaleLegend>();
            this.hasLegend = false;
            this.plotFirst();
            this.plotPoliticalBoundaries();
            if (!GeographicMapMaker.this.plotRegionsAboveFaults) {
                this.plotRegionOutlines();
            }
            this.plotBeforeSects();
            this.plotSects();
            this.plotAfterSects();
            if (GeographicMapMaker.this.plotRegionsAboveFaults) {
                this.plotRegionOutlines();
            }
            this.plotJumps();
            this.plotLines();
            this.plotArrows();
            this.plotScatters();
            this.plotLast();
            String xAxisLabel = GeographicMapMaker.this.axisLabels ? "Longitude" : " ";
            String string = yAxisLabel = GeographicMapMaker.this.axisLabels ? "Latitude" : " ";
            if (GeographicMapMaker.this.xyzData != null) {
                Preconditions.checkNotNull((Object)GeographicMapMaker.this.xyzCPT);
                spec = new XYZPlotSpec(GeographicMapMaker.this.xyzData, this.funcs, this.chars, GeographicMapMaker.this.xyzCPT, title, xAxisLabel, yAxisLabel, GeographicMapMaker.this.xyzLabel);
                if (GeographicMapMaker.this.xyzLabel == null) {
                    ((XYZPlotSpec)spec).setCPTVisible(false);
                } else {
                    ((XYZPlotSpec)spec).setCPTPosition(GeographicMapMaker.this.cptEdge);
                }
            } else {
                spec = new PlotSpec(this.funcs, this.chars, title, xAxisLabel, yAxisLabel);
            }
            if (GeographicMapMaker.this.customLegendLabels != null) {
                Preconditions.checkState((GeographicMapMaker.this.customLegendLabels.size() == GeographicMapMaker.this.customLegendChars.size() ? 1 : 0) != 0);
                for (int i = 0; i < GeographicMapMaker.this.customLegendLabels.size(); ++i) {
                    this.hasLegend = true;
                    String label = GeographicMapMaker.this.customLegendLabels.get(i);
                    PlotCurveCharacterstics pChar = GeographicMapMaker.this.customLegendChars.get(i);
                    DefaultXY_DataSet xy = new DefaultXY_DataSet();
                    xy.set(-1000.0, -1000.0);
                    xy.set(-1001.0, -1001.0);
                    xy.setName(label);
                    this.funcs.add(xy);
                    this.chars.add(pChar);
                }
            }
            spec.setLegendVisible(GeographicMapMaker.this.legendVisible && this.hasLegend);
            if (this.hasLegend) {
                if (GeographicMapMaker.this.insetLegendLocation == null) {
                    spec.setLegendInset(false);
                } else {
                    spec.setLegendInset(GeographicMapMaker.this.insetLegendLocation);
                }
            }
            for (PaintScaleLegend legend : this.cptLegend) {
                spec.addSubtitle((Title)legend);
            }
            if (GeographicMapMaker.this.annotations != null) {
                spec.setPlotAnnotations(GeographicMapMaker.this.annotations);
            }
            return spec;
        }
    }
}

