/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.commons.lang3.SystemUtils;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.Range;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.WeightedFuncListforPlotting;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotElement;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.jfreechart.CustomOffsetNumberAxis;
import org.opensha.commons.gui.plot.jfreechart.DiscretizedFunctionXYDataSet;
import org.opensha.commons.gui.plot.jfreechart.JFreeLogarithmicAxis;
import org.opensha.commons.gui.plot.jfreechart.MyTickUnits;
import org.opensha.commons.gui.plot.jfreechart.PixelSpacePaintScaleLegend;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.PaintScaleWrapper;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYIntervalBlockRenderer;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZDatasetWrapper;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZPlotSpec;
import org.opensha.commons.gui.plot.pdf.PDF_UTF8_FontMapper;
import org.opensha.commons.util.CustomFileFilter;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.cpt.CPT;

public class GraphPanel
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    private static final String NO_PLOT_MSG = "No Plot Data Available";
    private JFileChooser chooser;
    private DatasetRenderingOrder renderingOrder = DatasetRenderingOrder.FORWARD;
    public static final Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.green, Color.darkGray, Color.magenta, Color.cyan, Color.orange, Color.pink, Color.yellow, Color.gray};
    private SimpleAttributeSet setLegend;
    private JPanel chartPane;
    private JTextPane metadataText;
    private JScrollPane dataScrollPane;
    private JTextArea dataTextArea;
    private ChartPanel chartPanel;
    private static Dimension minPanelSize = new Dimension(320, 120);
    private XY_DataSetList plottedFuncs = new XY_DataSetList();
    private List<PlotCurveCharacterstics> plottedChars = Lists.newArrayList();
    private HashSet<Integer> weightedfuncListIndexes;
    public static final double LOG_Y_MIN_VAL = 1.0E-16;
    private XYPlot plot;
    ValueAxis xAxis;
    ValueAxis prevXAxis;
    ValueAxis yAxis;
    ValueAxis prevYAxis;
    private boolean xAxisInverted = false;
    private boolean[] xAxisInverteds = null;
    private boolean yAxisInverted = false;
    private boolean[] yAxisInverteds = null;
    private boolean combinedYAxis = false;
    private Color backgroundColor = new Color(200, 200, 230);
    private boolean graphOn = false;
    private List<String> legendString;
    private PlotPreferences plotPrefs;
    JPanel emptyPlotPanel;
    private boolean griddedFuncAxesTicks = false;

    public GraphPanel(PlotPreferences plotPrefs) {
        super(0, true);
        this.plotPrefs = plotPrefs;
        this.backgroundColor = plotPrefs.getBackgroundColor();
        this.setResizeWeight(1.0);
        this.setBorder(null);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.dataTextArea = new JTextArea(NO_PLOT_MSG);
        this.dataTextArea.setLineWrap(true);
        this.dataScrollPane = new JScrollPane();
        this.dataScrollPane.getViewport().add((Component)this.dataTextArea, null);
        this.chartPane = new JPanel(new BorderLayout());
        this.chartPane.setMinimumSize(minPanelSize);
        this.chartPane.setPreferredSize(minPanelSize);
        this.emptyPlotPanel = new JPanel();
        this.emptyPlotPanel.setBorder(new LineBorder(Color.gray));
        this.emptyPlotPanel.setBackground(Color.white);
        this.chartPane.add((Component)this.emptyPlotPanel, "Center");
        this.metadataText = new JTextPane();
        this.metadataText.setEditable(false);
        JScrollPane metadataScrollPane = new JScrollPane();
        metadataScrollPane.getViewport().add(this.metadataText);
        metadataScrollPane.setMinimumSize(minPanelSize);
        metadataScrollPane.setPreferredSize(minPanelSize);
        metadataScrollPane.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.setTopComponent(this.chartPane);
        this.setBottomComponent(metadataScrollPane);
    }

    private boolean isBlankCurve(PlotCurveCharacterstics chars) {
        return (chars.getLineType() == null || chars.getLineWidth() <= 0.0f) && (chars.getSymbol() == null || chars.getSymbolWidth() <= 0.0f);
    }

    public void drawGraphPanel(String xAxisName, String yAxisName, List<? extends PlotElement> elems, List<PlotCurveCharacterstics> plotChars, boolean xLog, boolean yLog, String title) {
        this.drawGraphPanel(xAxisName, yAxisName, elems, plotChars, xLog, yLog, title, null, null);
    }

    public void drawGraphPanel(String xAxisName, String yAxisName, List<? extends PlotElement> elems, List<PlotCurveCharacterstics> plotChars, boolean xLog, boolean yLog, String title, Range xRange, Range yRange) {
        PlotSpec spec = new PlotSpec(elems, plotChars, title, xAxisName, yAxisName);
        this.drawGraphPanel(spec, xLog, yLog, xRange, yRange);
    }

    public void drawGraphPanel(PlotSpec spec, boolean xLog, boolean yLog) {
        this.drawGraphPanel(spec.getXAxisLabel(), spec.getYAxisLabel(), spec.getPlotElems(), spec.getChars(), xLog, yLog, spec.getTitle(), null, null);
    }

    public void drawGraphPanel(PlotSpec spec, boolean xLog, boolean yLog, Range xRange, Range yRange) {
        ArrayList specs = Lists.newArrayList((Object[])new PlotSpec[]{spec});
        ArrayList xRanges = xRange == null ? null : Lists.newArrayList((Object[])new Range[]{xRange});
        ArrayList yRanges = yRange == null ? null : Lists.newArrayList((Object[])new Range[]{yRange});
        this.drawGraphPanel((List<? extends PlotSpec>)specs, xLog, yLog, (List<Range>)xRanges, (List<Range>)yRanges);
    }

    public void drawGraphPanel(List<? extends PlotSpec> specs, boolean xLog, boolean yLog, List<Range> xRanges, List<Range> yRanges) {
        this.drawGraphPanel(specs, Lists.newArrayList((Object[])new Boolean[]{xLog}), Lists.newArrayList((Object[])new Boolean[]{yLog}), xRanges, yRanges);
    }

    /*
     * WARNING - void declaration
     */
    public void drawGraphPanel(List<? extends PlotSpec> specs, List<Boolean> xLogs, List<Boolean> yLogs, List<Range> xRanges, List<Range> yRanges) {
        String S = "drawGraphPanel(): ";
        Preconditions.checkArgument((xRanges == null || yRanges == null || xRanges.size() <= 1 || yRanges.size() <= 1 ? 1 : 0) != 0);
        if (specs.size() > 1) {
            if (xRanges != null && xRanges.size() > 1) {
                this.combinedYAxis = true;
            } else if (yRanges != null && yRanges.size() > 1) {
                this.combinedYAxis = false;
            } else if (xRanges != null && xRanges.size() == 1) {
                this.combinedYAxis = false;
            } else if (yRanges != null && yRanges.size() == 1) {
                this.combinedYAxis = true;
            }
        }
        this.plottedFuncs.clear();
        ArrayList plottedElems = Lists.newArrayList();
        boolean logErrorFlag = false;
        int axisFontSize = this.plotPrefs.getAxisLabelFontSize();
        int tickFontSize = this.plotPrefs.getTickLabelFontSize();
        int legendFontSize = this.plotPrefs.getLegendFontSize();
        TickUnits units = MyTickUnits.createStandardTickUnits();
        ArrayList subXAxis = Lists.newArrayList();
        ArrayList subYAxis = Lists.newArrayList();
        for (int i = 0; i < specs.size(); ++i) {
            JFreeLogarithmicAxis yAxis;
            boolean inverted;
            Font axisLabelFont;
            Object xAxis;
            PlotSpec spec = specs.get(i);
            boolean xLog = xLogs.size() > 1 ? xLogs.get(i) : xLogs.get(0);
            boolean yLog = yLogs.size() > 1 ? yLogs.get(i) : yLogs.get(0);
            try {
                if (xLog) {
                    JFreeLogarithmicAxis logAxis = new JFreeLogarithmicAxis(spec.getXAxisLabel());
                    logAxis.setVerticalAnchorShift(4.0f);
                    xAxis = logAxis;
                } else {
                    xAxis = new NumberAxis(spec.getXAxisLabel());
                }
                if (!xLog && this.griddedFuncAxesTicks && i == 0) {
                    for (PlotElement plotElement : spec.getPlotElems()) {
                        if (!(plotElement instanceof EvenlyDiscretizedFunc)) continue;
                        xAxis = new CustomOffsetNumberAxis((EvenlyDiscretizedFunc)plotElement, spec.getXAxisLabel());
                        break;
                    }
                }
                if (xAxis instanceof NumberAxis) {
                    xAxis.setAutoRangeIncludesZero(false);
                }
                if (!(xAxis instanceof CustomOffsetNumberAxis)) {
                    xAxis.setStandardTickUnits((TickUnitSource)units);
                }
                xAxis.setTickMarksVisible(false);
                xAxis.setTickLabelInsets(new RectangleInsets(3.0, 10.0, 3.0, 10.0));
                axisLabelFont = xAxis.getLabelFont();
                xAxis.setLabelFont(new Font(axisLabelFont.getFontName(), axisLabelFont.getStyle(), axisFontSize));
                Font font = xAxis.getTickLabelFont();
                xAxis.setTickLabelFont(new Font(font.getFontName(), font.getStyle(), tickFontSize));
                inverted = this.xAxisInverted || this.xAxisInverteds != null && this.xAxisInverteds.length > i && this.xAxisInverteds[i];
                xAxis.setInverted(inverted);
                if (xRanges != null && xRanges.size() > i && xRanges.get(i) != null) {
                    Range xRange = xRanges.get(i);
                    xAxis.setRange(xRange);
                    if (xLog) {
                        Preconditions.checkState((xRange.getLowerBound() > 0.0 && Double.isFinite(xRange.getUpperBound()) ? 1 : 0) != 0, (String)"X is log spacing, but x range contains 0 or is infinite: [%s %s]", (Object)xRange.getLowerBound(), (Object)xRange.getUpperBound());
                    }
                    Preconditions.checkState((xRange.getUpperBound() > xRange.getLowerBound() ? 1 : 0) != 0, (String)"X range upper bound is not above lower bound: [%s %s]", (Object)xRange.getLowerBound(), (Object)xRange.getUpperBound());
                    Preconditions.checkState((Double.isFinite(xRange.getUpperBound()) && Double.isFinite(xRange.getLowerBound()) ? 1 : 0) != 0, (String)"X range not finite: [%s %s]", (Object)xRange.getLowerBound(), (Object)xRange.getUpperBound());
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "X-Plot Error", 0);
                this.graphOn = false;
                xLog = false;
                xAxis = this.prevXAxis;
                logErrorFlag = true;
            }
            try {
                yAxis = yLog ? new JFreeLogarithmicAxis(spec.getYAxisLabel()) : new NumberAxis(spec.getYAxisLabel());
                if (yAxis instanceof NumberAxis) {
                    if (!yLog) {
                        ((NumberAxis)yAxis).setAutoRangeIncludesZero(true);
                    } else {
                        ((NumberAxis)yAxis).setAutoRangeIncludesZero(false);
                    }
                }
                yAxis.setStandardTickUnits((TickUnitSource)units);
                yAxis.setTickMarksVisible(false);
                axisLabelFont = yAxis.getLabelFont();
                yAxis.setLabelFont(new Font(axisLabelFont.getFontName(), axisLabelFont.getStyle(), axisFontSize));
                Font font = yAxis.getTickLabelFont();
                yAxis.setTickLabelFont(new Font(font.getFontName(), font.getStyle(), tickFontSize));
                inverted = this.yAxisInverted || this.yAxisInverteds != null && this.yAxisInverteds.length > i && this.yAxisInverteds[i];
                yAxis.setInverted(inverted);
                if (yRanges != null && yRanges.size() > i && yRanges.get(i) != null) {
                    Range yRange = yRanges.get(i);
                    yAxis.setRange(yRange);
                    if (yLog) {
                        Preconditions.checkState((yRange.getLowerBound() > 0.0 && Double.isFinite(yRange.getUpperBound()) ? 1 : 0) != 0, (String)"Y is log spacing, but y range contains 0 or is infinite: [%s %s]", (Object)yRange.getLowerBound(), (Object)yRange.getUpperBound());
                    }
                    Preconditions.checkState((yRange.getUpperBound() > yRange.getLowerBound() ? 1 : 0) != 0, (String)"Y range upper bound is not above lower bound: [%s %s]", (Object)yRange.getLowerBound(), (Object)yRange.getUpperBound());
                    Preconditions.checkState((Double.isFinite(yRange.getUpperBound()) && Double.isFinite(yRange.getLowerBound()) ? 1 : 0) != 0, (String)"Y range not finite: [%s %s]", (Object)yRange.getLowerBound(), (Object)yRange.getUpperBound());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getMessage(), "Y-Plot Error", 0);
                this.graphOn = false;
                yLog = false;
                yAxis = this.prevYAxis;
                logErrorFlag = false;
            }
            subXAxis.add(xAxis);
            subYAxis.add(yAxis);
            if (i != 0) continue;
            this.xAxis = xAxis;
            this.yAxis = yAxis;
        }
        this.plot = null;
        final HashMap<IntervalXYDataset, Integer> datasetIndexMap = new HashMap<IntervalXYDataset, Integer>();
        if (specs.size() == 1) {
            this.plot = new XYPlot(this, null, this.xAxis, this.yAxis, null){
                final /* synthetic */ GraphPanel this$0;
                {
                    this.this$0 = this$0;
                    super(arg0, arg1, arg2, arg3);
                }

                public int indexOf(XYDataset dataset) {
                    Integer ret = (Integer)datasetIndexMap.get(dataset);
                    if (ret != null) {
                        return ret;
                    }
                    return super.indexOf(dataset);
                }
            };
        } else if (this.combinedYAxis) {
            this.plot = new CombinedRangeXYPlot(this, this.yAxis){
                final /* synthetic */ GraphPanel this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                public int indexOf(XYDataset dataset) {
                    Integer ret = (Integer)datasetIndexMap.get(dataset);
                    if (ret != null) {
                        return ret;
                    }
                    return super.indexOf(dataset);
                }
            };
            ((CombinedRangeXYPlot)this.plot).setGap(30.0);
        } else {
            this.plot = new CombinedDomainXYPlot(this, this.xAxis){
                final /* synthetic */ GraphPanel this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                public int indexOf(XYDataset dataset) {
                    Integer ret = (Integer)datasetIndexMap.get(dataset);
                    if (ret != null) {
                        return ret;
                    }
                    return super.indexOf(dataset);
                }
            };
            ((CombinedDomainXYPlot)this.plot).setGap(30.0);
        }
        GraphPanel.setupPlot(this.plot, tickFontSize);
        ArrayList plottedChars = Lists.newArrayList();
        LegendItemCollection legendItems = null;
        RectangleEdge legendLocation = null;
        List<PaintScaleLegend> cptSubtitles = null;
        RectangleEdge cptLocation = null;
        for (int p = 0; p < specs.size(); ++p) {
            void var26_41;
            ValueAxis myXAxis;
            ValueAxis myYAxis;
            PlotSpec plotSpec = specs.get(p);
            int datasetIndex = 0;
            if (specs.size() > 1) {
                if (this.combinedYAxis) {
                    myYAxis = this.yAxis;
                    myXAxis = (ValueAxis)subXAxis.get(p);
                } else {
                    myXAxis = this.xAxis;
                    myYAxis = (ValueAxis)subYAxis.get(p);
                }
                XYPlot xYPlot = new XYPlot(null, myXAxis, myYAxis, null);
                GraphPanel.setupPlot(xYPlot, tickFontSize);
            } else {
                XYPlot xYPlot = this.plot;
                myXAxis = this.xAxis;
                myYAxis = this.yAxis;
            }
            myXAxis.setInverted(plotSpec.isXAxisInverted());
            myYAxis.setInverted(plotSpec.isYAxisInverted());
            boolean xLog = xLogs.size() > 1 ? xLogs.get(p) : xLogs.get(0);
            boolean yLog = yLogs.size() > 1 ? yLogs.get(p) : yLogs.get(0);
            if (plotSpec instanceof XYZPlotSpec) {
                XYZPlotSpec xyzSpec = (XYZPlotSpec)plotSpec;
                XYZDatasetWrapper dataset = new XYZDatasetWrapper(xyzSpec, xLog, yLog);
                XYIntervalBlockRenderer renderer = new XYIntervalBlockRenderer();
                PaintScaleWrapper scale = new PaintScaleWrapper(xyzSpec.getCPT());
                renderer.setPaintScale(scale);
                var26_41.setRenderer(datasetIndex, (XYItemRenderer)renderer);
                var26_41.setDataset(datasetIndex, (XYDataset)dataset);
                datasetIndexMap.put(dataset, datasetIndex);
                ++datasetIndex;
                if (xyzSpec.isCPTVisible()) {
                    if (cptSubtitles == null) {
                        cptSubtitles = new ArrayList();
                        cptLocation = xyzSpec.getCPTPosition();
                    }
                    cptSubtitles.add(GraphPanel.getLegendForCPT(scale, xyzSpec.getZAxisLabel(), axisFontSize, tickFontSize, xyzSpec.getCPTTickUnit(), xyzSpec.getCPTPosition()));
                }
            }
            List<? extends PlotElement> elems = plotSpec.getPlotElems();
            plottedElems.addAll(elems);
            List<PlotCurveCharacterstics> plotChars = plotSpec.getChars();
            if (plotChars == null) {
                plotChars = new ArrayList<PlotCurveCharacterstics>();
                plotSpec.setChars(plotChars);
            }
            int charIndex = 0;
            int defaultColorIndex = 0;
            PlotCurveCharacterstics prevChars = null;
            DiscretizedFunctionXYDataSet prevDataset = null;
            XYItemRenderer prevRenderer = null;
            boolean reusable = false;
            int numDatasetsReused = 0;
            for (PlotElement plotElement : elems) {
                XY_DataSetList elemDatasets = plotElement.getDatasetsToPlot();
                List<Integer> elemPlotNumbs = plotElement.getPlotNumColorList();
                int totNumDatasets = elemDatasets.size();
                int datasetInElemIndex = 0;
                for (int numShared : elemPlotNumbs) {
                    int prevNum;
                    PlotCurveCharacterstics chars;
                    if (charIndex < plotChars.size()) {
                        chars = plotChars.get(charIndex);
                    } else {
                        PlotSymbol symbol;
                        PlotLineType lineType;
                        XY_DataSet func = (XY_DataSet)elemDatasets.get(datasetInElemIndex);
                        if (func instanceof DiscretizedFunc) {
                            lineType = PlotLineType.SOLID;
                            symbol = null;
                        } else {
                            lineType = null;
                            symbol = PlotSymbol.DIAMOND;
                        }
                        chars = new PlotCurveCharacterstics(lineType, 1.0f, symbol, 4.0f, defaultColor[defaultColorIndex % defaultColor.length]);
                        plotChars.add(chars);
                    }
                    ++defaultColorIndex;
                    Preconditions.checkState((datasetInElemIndex + numShared <= totNumDatasets ? 1 : 0) != 0, (Object)"elem.getDatasetsToPlot() and elem.getPlotNumColorList() are inconsistent");
                    XY_DataSetList dataFunctions = new XY_DataSetList();
                    boolean reuseCandidate = prevDataset != null && chars == prevChars;
                    for (int i = 0; i < numShared; ++i) {
                        XY_DataSet func = (XY_DataSet)elemDatasets.get(datasetInElemIndex++);
                        dataFunctions.add(func);
                        this.plottedFuncs.add(func);
                        plottedChars.add(chars);
                        reuseCandidate = reuseCandidate && (!plotSpec.isLegendVisible() || func.getName() == null);
                    }
                    ++charIndex;
                    if (this.isBlankCurve(chars)) continue;
                    if (reuseCandidate) {
                        prevNum = prevDataset.getFunctions().size();
                        if (prevNum == 0) {
                            reuseCandidate = false;
                        } else if (plotSpec.isLegendVisible() && ((XY_DataSet)prevDataset.getFunctions().get(prevNum - 1)).getName() != null && chars.getLineType() != null) {
                            reuseCandidate = false;
                        }
                    }
                    if (reuseCandidate) {
                        prevNum = prevDataset.getFunctions().size();
                        if (prevNum == 0 || plotSpec.isLegendVisible() && ((XY_DataSet)prevDataset.getFunctions().get(prevNum - 1)).getName() != null && chars.getLineType() != null) continue;
                        prevDataset.getFunctions().addAll(dataFunctions);
                        int newNum = prevDataset.getFunctions().size();
                        GraphPanel.copyRendererSeriesValues(prevRenderer, 0, prevNum, newNum - 1);
                        ++numDatasetsReused;
                        continue;
                    }
                    Color color = chars.getColor();
                    float lineWidth = chars.getLineWidth();
                    PlotLineType lineType = chars.getLineType();
                    float symbolWidth = chars.getSymbolWidth();
                    PlotSymbol symbol = chars.getSymbol();
                    DiscretizedFunctionXYDataSet dataset = new DiscretizedFunctionXYDataSet();
                    dataset.setXLog(xLog);
                    dataset.setYLog(yLog);
                    dataset.setConvertZeroToMin(true, 1.0E-16);
                    dataset.setFunctions(dataFunctions);
                    var26_41.setDataset(datasetIndex, (XYDataset)dataset);
                    datasetIndexMap.put(dataset, datasetIndex);
                    XYItemRenderer renderer = PlotLineType.buildRenderer(lineType, symbol, lineWidth, symbolWidth);
                    var26_41.setRenderer(datasetIndex, renderer);
                    renderer.setSeriesPaint(0, (Paint)color);
                    GraphPanel.copyRendererSeriesValues(renderer, 0, 1, numShared - 1);
                    ++datasetIndex;
                    prevDataset = dataset;
                    prevChars = chars;
                    prevRenderer = renderer;
                    reusable = renderer instanceof XYLineAndShapeRenderer && !plotSpec.isLegendVisible();
                    for (int i = 0; reusable && i < dataFunctions.size(); ++i) {
                        reusable = dataFunctions.getName() == null;
                    }
                }
                Preconditions.checkState((datasetInElemIndex == totNumDatasets ? 1 : 0) != 0, (Object)"elem.getDatasetsToPlot() and elem.getPlotNumColorList() are inconsistent");
            }
            if (plotSpec.getPlotAnnotations() != null) {
                for (XYAnnotation xYAnnotation : plotSpec.getPlotAnnotations()) {
                    var26_41.addAnnotation(xYAnnotation);
                }
            }
            if (plotSpec.isLegendVisible()) {
                LegendItemCollection subLegend = plotSpec.getLegendItems((XYPlot)var26_41);
                if (plotSpec.isLegendInset()) {
                    var26_41.addAnnotation((XYAnnotation)plotSpec.buildInsetLegend(subLegend, this.plotPrefs, xLog, yLog, myXAxis.getRange(), myYAxis.getRange()));
                } else {
                    if (legendItems == null) {
                        legendItems = new LegendItemCollection();
                        legendLocation = plotSpec.getLegendLocation();
                    }
                    legendItems.addAll(subLegend);
                }
            }
            if (this.plot instanceof CombinedRangeXYPlot) {
                ((CombinedRangeXYPlot)this.plot).add((XYPlot)var26_41);
            } else if (this.plot instanceof CombinedDomainXYPlot) {
                ((CombinedDomainXYPlot)this.plot).add((XYPlot)var26_41);
            }
            var26_41.setDatasetRenderingOrder(this.renderingOrder);
            var26_41.setBackgroundAlpha(0.8f);
        }
        int plotLabelFontSize = this.plotPrefs.getPlotLabelFontSize();
        Font font = JFreeChart.DEFAULT_TITLE_FONT;
        Font newPlotLabelFont = new Font(font.getFontName(), font.getStyle(), plotLabelFontSize);
        JFreeChart chart = new JFreeChart(specs.get(0).getTitle(), newPlotLabelFont, (Plot)this.plot, false);
        chart.setBackgroundPaint((Paint)this.backgroundColor);
        if (legendItems != null) {
            final LegendItemCollection legendItemsFin = legendItems;
            LegendTitle legendTitle = new LegendTitle(new LegendItemSource(){
                final /* synthetic */ GraphPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public LegendItemCollection getLegendItems() {
                    return legendItemsFin;
                }
            });
            legendTitle.setPosition(legendLocation);
            Font legendFont = legendTitle.getItemFont();
            legendTitle.setItemFont(new Font(legendFont.getName(), legendFont.getStyle(), legendFontSize));
            chart.addLegend(legendTitle);
        }
        for (PlotSpec plotSpec : specs) {
            if (plotSpec.getSubtitles() == null) continue;
            for (Title subtitle : plotSpec.getSubtitles()) {
                chart.addSubtitle(subtitle);
            }
        }
        if (cptSubtitles != null) {
            if (cptSubtitles.size() > 1) {
                boolean bl;
                Iterator cpt = null;
                boolean bl2 = true;
                for (PaintScaleLegend legend : cptSubtitles) {
                    Object myCPT = ((PaintScaleWrapper)legend.getScale()).getCPT();
                    if (cpt == null) {
                        myCPT = cpt;
                        continue;
                    }
                    if (cpt == myCPT) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    cptSubtitles = cptSubtitles.subList(0, 1);
                }
            }
            for (PaintScaleLegend paintScaleLegend : cptSubtitles) {
                if (paintScaleLegend == null) continue;
                chart.addSubtitle((Title)paintScaleLegend);
            }
        }
        this.chartPanel = new ChartPanel(chart, true, true, true, true, false);
        this.chartPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.chartPanel.setMouseZoomable(true);
        this.chartPanel.setDisplayToolTips(true);
        this.chartPanel.setHorizontalAxisTrace(false);
        this.chartPanel.setVerticalAxisTrace(false);
        int numOfColors = this.plot.getSeriesCount();
        this.metadataText.removeAll();
        this.metadataText.setEditable(false);
        this.setLegend = new SimpleAttributeSet();
        this.setLegend.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
        StyledDocument styledDocument = this.metadataText.getStyledDocument();
        this.weightedfuncListIndexes = new HashSet();
        try {
            styledDocument.remove(0, styledDocument.getLength());
            int totalNumofFunctions = plottedElems.size();
            this.legendString = new ArrayList<String>();
            int plotPrefIndex = 0;
            for (int i = 0; i < totalNumofFunctions; ++i) {
                Color color;
                String legend = null;
                this.setLegend = new SimpleAttributeSet();
                StyleConstants.setFontSize(this.setLegend, 12);
                PlotElement elem = (PlotElement)plottedElems.get(i);
                PlotCurveCharacterstics chars = (PlotCurveCharacterstics)plottedChars.get(plotPrefIndex);
                String datasetName = "DATASET #" + (i + 1);
                if (elem instanceof WeightedFuncListforPlotting) {
                    WeightedFuncListforPlotting weightedList = (WeightedFuncListforPlotting)elem;
                    String listInfo = weightedList.getInfo();
                    legend = new String(datasetName + " (" + String.valueOf(chars) + ")\n" + listInfo + System.lineSeparator());
                    this.legendString.add(legend);
                    StyleConstants.setForeground(this.setLegend, Color.black);
                    styledDocument.insertString(styledDocument.getLength(), legend, this.setLegend);
                    this.weightedfuncListIndexes.add(this.legendString.size() - 1);
                    if (weightedList.areIndividualCurvesToPlot()) {
                        ((PlotCurveCharacterstics)plottedChars.get(plotPrefIndex)).setName(datasetName + " Curves");
                        String listFunctionsInfo = weightedList.getFunctionTraceInfo();
                        legend = new String(listFunctionsInfo + System.lineSeparator());
                        this.legendString.add(legend);
                        color = ((PlotCurveCharacterstics)plottedChars.get(plotPrefIndex)).getColor();
                        StyleConstants.setForeground(this.setLegend, color);
                        styledDocument.insertString(styledDocument.getLength(), legend, this.setLegend);
                        ++plotPrefIndex;
                    }
                    if (weightedList.areFractilesToPlot()) {
                        ((PlotCurveCharacterstics)plottedChars.get(plotPrefIndex)).setName(datasetName + " Fractiles");
                        String fractileListInfo = weightedList.getFractileInfo();
                        legend = new String(fractileListInfo + System.lineSeparator());
                        this.legendString.add(legend);
                        color = ((PlotCurveCharacterstics)plottedChars.get(plotPrefIndex)).getColor();
                        StyleConstants.setForeground(this.setLegend, color);
                        styledDocument.insertString(styledDocument.getLength(), legend, this.setLegend);
                        ++plotPrefIndex;
                    }
                    if (!weightedList.isMeanToPlot()) continue;
                    ((PlotCurveCharacterstics)plottedChars.get(plotPrefIndex)).setName(datasetName + " Mean");
                    String meanInfo = weightedList.getMeanFunctionInfo();
                    legend = new String(meanInfo + System.lineSeparator());
                    this.legendString.add(legend);
                    color = ((PlotCurveCharacterstics)plottedChars.get(plotPrefIndex)).getColor();
                    StyleConstants.setForeground(this.setLegend, color);
                    styledDocument.insertString(styledDocument.getLength(), legend, this.setLegend);
                    ++plotPrefIndex;
                    continue;
                }
                if (elem instanceof XY_DataSet) {
                    ((PlotCurveCharacterstics)plottedChars.get(plotPrefIndex)).setName(datasetName);
                    XY_DataSet func = (XY_DataSet)plottedElems.get(i);
                    String functionInfo = func.getInfo();
                    String name = func.getName();
                    legend = new String(datasetName + " (" + String.valueOf(chars) + ")\n" + name + "  " + SystemUtils.LINE_SEPARATOR + functionInfo + SystemUtils.LINE_SEPARATOR);
                    this.legendString.add(legend);
                    color = ((PlotCurveCharacterstics)plottedChars.get(plotPrefIndex)).getColor();
                    StyleConstants.setForeground(this.setLegend, color);
                    styledDocument.insertString(styledDocument.getLength(), legend, this.setLegend);
                    ++plotPrefIndex;
                    continue;
                }
                ((PlotCurveCharacterstics)plottedChars.get(plotPrefIndex)).setName(datasetName);
                String functionInfo = elem.getInfo();
                legend = new String(datasetName + " (" + String.valueOf(chars) + ")\n" + functionInfo + SystemUtils.LINE_SEPARATOR);
                this.legendString.add(legend);
                Color color2 = ((PlotCurveCharacterstics)plottedChars.get(plotPrefIndex)).getColor();
                StyleConstants.setForeground(this.setLegend, color2);
                styledDocument.insertString(styledDocument.getLength(), legend, this.setLegend);
                ++plotPrefIndex;
            }
        }
        catch (BadLocationException e) {
            return;
        }
        this.graphOn = false;
        if (!logErrorFlag && !xLogs.get(0).booleanValue()) {
            this.prevXAxis = this.xAxis;
        }
        if (!logErrorFlag && !yLogs.get(0).booleanValue()) {
            this.prevYAxis = this.yAxis;
        }
        this.dataTextArea.setText(this.showDataInWindow(plottedElems, specs.get(0).getXAxisLabel(), specs.get(0).getYAxisLabel()));
        this.plottedChars = plottedChars;
    }

    private static void copyRendererSeriesValues(XYItemRenderer renderer, int refIndex, int startIndex, int endIndex) {
        Paint paint = renderer.getSeriesPaint(refIndex);
        Stroke stroke = renderer.getSeriesStroke(refIndex);
        Shape shape = renderer.getSeriesShape(refIndex);
        Paint outlinePaint = renderer.getSeriesOutlinePaint(refIndex);
        Stroke outlineStroke = renderer.getSeriesOutlineStroke(refIndex);
        Paint fillPaint = renderer.getSeriesFillPaint(refIndex);
        for (int i = startIndex; i <= endIndex; ++i) {
            renderer.setSeriesPaint(i, paint);
            renderer.setSeriesStroke(i, stroke);
            renderer.setSeriesShape(i, shape);
            renderer.setSeriesOutlinePaint(i, outlinePaint);
            renderer.setSeriesOutlineStroke(i, outlineStroke);
            renderer.setSeriesFillPaint(i, fillPaint);
        }
    }

    public static void setupPlot(XYPlot plot, int tickFontSize) {
        plot.setDomainCrosshairLockedOnData(false);
        plot.setDomainCrosshairVisible(false);
        plot.setRangeCrosshairLockedOnData(false);
        plot.setRangeCrosshairVisible(false);
        plot.setInsets(new RectangleInsets(10.0, 0.0, 0.0, (double)(tickFontSize + 15)));
        plot.setDomainGridlineStroke((Stroke)new BasicStroke(0.5f, 0, 2, 0.0f));
        plot.setDomainGridlinePaint((Paint)new Color(225, 225, 225));
        plot.setRangeGridlineStroke((Stroke)new BasicStroke(0.5f, 0, 2, 0.0f));
        plot.setRangeGridlinePaint((Paint)new Color(225, 225, 225));
    }

    private String showDataInWindow(List<? extends PlotElement> elemList, String xAxisName, String yAxisName) {
        int size = elemList.size();
        StringBuffer b = new StringBuffer();
        b.append("\n");
        b.append("X-Axis: " + xAxisName + "\n");
        b.append("Y-Axis: " + yAxisName + "\n");
        b.append("Number of Data Sets: " + size + "\n\n");
        for (int i = 0; i < size; ++i) {
            PlotElement elem = elemList.get(i);
            if (elem instanceof XY_DataSet) {
                XY_DataSet function = (XY_DataSet)elem;
                b.append("\nDATASET #" + (i + 1) + "\n\n");
                b.append(function.toString() + "\n");
                continue;
            }
            if (elem instanceof WeightedFuncListforPlotting) {
                DiscretizedFunc function;
                int j;
                int listSize;
                XY_DataSetList list;
                WeightedFuncListforPlotting weightedList = (WeightedFuncListforPlotting)elem;
                b.append("\nDATASET #" + (i + 1) + "   Weighted Function List\n");
                b.append(weightedList.getInfo() + "\n\n");
                if (weightedList.areIndividualCurvesToPlot()) {
                    list = weightedList.getWeightedFunctionList();
                    List<Double> wtList = weightedList.getRelativeWtList();
                    listSize = list.size();
                    for (j = 0; j < listSize; ++j) {
                        b.append("\nFunction #" + (j + 1) + " of " + listSize + ", from Dataset #" + (i + 1) + ", with relative wt = " + wtList.get(j) + "\n");
                        function = (DiscretizedFunc)list.get(j);
                        b.append(function.getMetadataString() + "\n");
                    }
                }
                if (weightedList.areFractilesToPlot()) {
                    list = weightedList.getFractileList();
                    List<Double> fractileValueList = weightedList.getFractileValuesList();
                    listSize = list.size();
                    for (j = 0; j < listSize; ++j) {
                        b.append("\n" + fractileValueList.get(j) + " Fractile for Dataset #" + (i + 1) + "\n");
                        function = (DiscretizedFunc)list.get(j);
                        b.append(function.getMetadataString() + "\n");
                    }
                }
                if (!weightedList.isMeanToPlot()) continue;
                b.append("\nMean for Dataset #" + (i + 1) + "\n");
                b.append(weightedList.getMean().getMetadataString() + "\n");
                continue;
            }
            b.append("\nDATASET #" + (i + 1) + "\n\n");
            b.append(elem.getInfo() + "\n");
        }
        return b.toString();
    }

    public void setMetadata(String metadata) {
        this.dataTextArea.setText(metadata);
    }

    public void setBackgroundColor(Color background) {
        this.backgroundColor = background;
    }

    public void setCombinedOnYAxis(boolean combinedYAxis) {
        this.combinedYAxis = combinedYAxis;
    }

    public void removeChartAndMetadata() {
        this.chartPane.removeAll();
        this.chartPane.add((Component)this.emptyPlotPanel, "Center");
        this.chartPanel = null;
        this.metadataText.setText("");
        this.dataTextArea.setText(NO_PLOT_MSG);
    }

    @Deprecated
    public void addSubtitle(Title subtitle) {
        JFreeChart chart = this.chartPanel.getChart();
        chart.addSubtitle(subtitle);
    }

    public void togglePlot() {
        this.chartPane.removeAll();
        if (this.graphOn) {
            this.graphOn = false;
            this.chartPane.add((Component)this.dataScrollPane, "Center");
        } else {
            this.graphOn = true;
            if (this.chartPanel != null) {
                this.chartPane.add((Component)this.chartPanel, "Center");
            } else {
                this.chartPane.add((Component)this.dataScrollPane, "Center");
            }
        }
    }

    public boolean isGraphOn() {
        return this.graphOn;
    }

    public void setPlotBackgroundColor(Color color) {
        if (this.plot != null) {
            this.plot.setBackgroundPaint((Paint)color);
        }
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    public Range getX_AxisRange() {
        return this.xAxis.getRange();
    }

    public Range getY_AxisRange() {
        return this.yAxis.getRange();
    }

    public ValueAxis getXAxis() {
        return this.xAxis;
    }

    public ValueAxis getYAxis() {
        return this.yAxis;
    }

    public void save() throws IOException {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            CustomFileFilter pdfFF = new CustomFileFilter("pdf", "PDF File");
            CustomFileFilter pngFF = new CustomFileFilter("png", "PNG File");
            CustomFileFilter txtFF = new CustomFileFilter("txt", "TXT File");
            this.chooser.addChoosableFileFilter(pdfFF);
            this.chooser.addChoosableFileFilter(pngFF);
            this.chooser.addChoosableFileFilter(txtFF);
            this.chooser.setAcceptAllFileFilterUsed(false);
            this.chooser.setFileFilter(pdfFF);
        }
        int option = this.chooser.showSaveDialog(this);
        Object fileName = null;
        if (option == 0) {
            fileName = this.chooser.getSelectedFile().getAbsolutePath();
            CustomFileFilter filter = (CustomFileFilter)this.chooser.getFileFilter();
            String ext = filter.getExtension();
            System.out.println(ext);
            if (!((String)fileName).toLowerCase().endsWith(ext)) {
                fileName = (String)fileName + ext;
            }
            if (ext.equals(".pdf")) {
                this.saveAsPDF((String)fileName);
            } else if (ext.equals(".png")) {
                this.saveAsPNG((String)fileName);
            } else if (ext.equals(".txt")) {
                this.saveAsTXT((String)fileName);
            } else {
                throw new RuntimeException("Unknown extension selected: " + ext);
            }
        }
    }

    public void saveAsPNG(String fileName) throws IOException {
        this.saveAsPNG(fileName, this.chartPanel.getWidth(), this.chartPanel.getHeight());
    }

    public void saveAsTXT(String fileName) throws IOException {
        FileUtils.save(fileName, this.dataTextArea.getText());
    }

    public void saveAsPNG(String fileName, int width, int height) throws IOException {
        ChartUtils.saveChartAsPNG((File)new File(fileName), (JFreeChart)this.chartPanel.getChart(), (int)width, (int)height);
    }

    public void saveAsPDF(String fileName) throws IOException {
        int width = this.chartPanel.getWidth();
        int height = this.chartPanel.getHeight();
        this.saveAsPDF(fileName, width, height);
    }

    public BufferedImage getBufferedImage(int width, int height) {
        return this.chartPanel.getChart().createBufferedImage(width, height, null);
    }

    public void saveAsPDF(String fileName, int width, int height) throws IOException {
        int textLength = this.metadataText.getStyledDocument().getLength();
        int totalLength = textLength + height;
        Document metadataDocument = new Document(new Rectangle((float)width, (float)height));
        metadataDocument.addAuthor("OpenSHA");
        metadataDocument.addCreationDate();
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)metadataDocument, (OutputStream)new BufferedOutputStream(new FileOutputStream(fileName)));
            metadataDocument.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            PDF_UTF8_FontMapper fontMapper = new PDF_UTF8_FontMapper();
            PdfGraphics2D g2d = new PdfGraphics2D((PdfContentByte)tp, (float)width, (float)height, (FontMapper)fontMapper);
            Rectangle2D.Double r2d = new Rectangle2D.Double(0.0, 0.0, width, height);
            this.chartPanel.getChart().draw((Graphics2D)g2d, (Rectangle2D)r2d);
            g2d.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            metadataDocument.newPage();
            int size = this.legendString.size();
            int i = 0;
            int legendColor = 0;
            while (i < size) {
                Paragraph para = new Paragraph();
                if (this.weightedfuncListIndexes != null && this.weightedfuncListIndexes.contains(i)) {
                    para.add((Element)new Phrase(this.legendString.get(i), FontFactory.getFont((String)"Arimo-Regular", (float)10.0f, (int)0, (BaseColor)BaseColor.BLACK)));
                    --legendColor;
                } else {
                    Color c = this.plottedChars.get(legendColor).getColor();
                    BaseColor bc = new BaseColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
                    para.add((Element)new Phrase(this.legendString.get(i), FontFactory.getFont((String)"Arimo-Regular", (float)10.0f, (int)0, (BaseColor)bc)));
                }
                metadataDocument.add((Element)para);
                ++i;
                ++legendColor;
            }
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
        metadataDocument.close();
    }

    public void print() {
        if (this.graphOn) {
            this.chartPanel.createChartPrintJob();
        } else {
            try {
                this.dataTextArea.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Printing failed:\n" + e.getMessage(), "Printing Failed!", 0);
            }
        }
    }

    public String getXAxisLabel() {
        if (this.xAxis != null) {
            return this.xAxis.getLabel();
        }
        return null;
    }

    public String getYAxisLabel() {
        if (this.yAxis != null) {
            return this.yAxis.getLabel();
        }
        return null;
    }

    public String getPlotLabel() {
        if (this.chartPanel != null) {
            return this.chartPanel.getChart().getTitle().getText();
        }
        return null;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public DatasetRenderingOrder getRenderingOrder() {
        return this.renderingOrder;
    }

    public void setRenderingOrder(DatasetRenderingOrder renderingOrder) {
        this.renderingOrder = renderingOrder;
    }

    public void setxAxisInverted(boolean xAxisInverted) {
        this.xAxisInverted = xAxisInverted;
        if (this.xAxis != null) {
            this.xAxis.setInverted(xAxisInverted);
        }
    }

    public void setxAxisInverteds(boolean[] xAxisInverteds) {
        this.xAxisInverteds = xAxisInverteds;
    }

    public void setyAxisInverted(boolean yAxisInverted) {
        this.yAxisInverted = yAxisInverted;
        if (this.yAxis != null) {
            this.yAxis.setInverted(yAxisInverted);
        }
    }

    public void setyAxisInverteds(boolean[] yAxisInverteds) {
        this.yAxisInverteds = yAxisInverteds;
    }

    public void setAxisLabelFontSize(int axisLabelFontSize) {
        this.plotPrefs.setAxisLabelFontSize(axisLabelFontSize);
    }

    public void setTickLabelFontSize(int tickLabelFontSize) {
        this.plotPrefs.setTickLabelFontSize(tickLabelFontSize);
    }

    public void setPlotLabelFontSize(int plotLabelFontSize) {
        this.plotPrefs.setPlotLabelFontSize(plotLabelFontSize);
    }

    public void setLegendFontSize(int legendFontSize) {
        this.plotPrefs.setLegendFontSize(legendFontSize);
    }

    public PlotPreferences getPlotPrefs() {
        return this.plotPrefs;
    }

    public void setGriddedFuncAxesTicks(boolean histogramAxesTicks) {
        this.griddedFuncAxesTicks = histogramAxesTicks;
    }

    public static PaintScaleLegend getLegendForCPT(CPT cpt, String zAxisLabel, int axisFontSize, int tickFontSize, double tickUnit, RectangleEdge position) {
        return GraphPanel.getLegendForCPT(new PaintScaleWrapper(cpt), zAxisLabel, axisFontSize, tickFontSize, tickUnit, position);
    }

    private static PaintScaleLegend getLegendForCPT(PaintScaleWrapper scale, String zAxisLabel, int axisFontSize, int tickFontSize, double tickUnit, RectangleEdge position) {
        JFreeLogarithmicAxis fakeZAxis;
        CPT cpt = scale.getCPT();
        if (cpt.isLog10()) {
            JFreeLogarithmicAxis logAxis = new JFreeLogarithmicAxis(zAxisLabel);
            logAxis.setVerticalAnchorShift(4.0f);
            logAxis.setLowerBound(scale.getLowerBound());
            logAxis.setUpperBound(scale.getUpperBound());
            fakeZAxis = logAxis;
        } else {
            NumberAxis linearAxis = new NumberAxis();
            linearAxis.setLowerBound(scale.getLowerBound());
            linearAxis.setUpperBound(scale.getUpperBound());
            linearAxis.setLabel(zAxisLabel);
            if (tickUnit > 0.0) {
                linearAxis.setTickUnit(new NumberTickUnit(tickUnit));
            }
            fakeZAxis = linearAxis;
        }
        Font axisLabelFont = fakeZAxis.getLabelFont();
        fakeZAxis.setLabelFont(new Font(axisLabelFont.getFontName(), axisLabelFont.getStyle(), axisFontSize));
        Font axisTickFont = fakeZAxis.getTickLabelFont();
        fakeZAxis.setTickLabelFont(new Font(axisTickFont.getFontName(), axisTickFont.getStyle(), tickFontSize));
        PixelSpacePaintScaleLegend legend = new PixelSpacePaintScaleLegend(scale, (ValueAxis)fakeZAxis, 1.0);
        legend.setSubdivisionCount(500);
        if (position != null) {
            legend.setPosition(position);
        }
        if (legend.getPosition() == RectangleEdge.BOTTOM || legend.getPosition() == RectangleEdge.TOP) {
            legend.setPadding(5.0, 50.0, 5.0, 50.0);
        } else if (legend.getPosition() == RectangleEdge.LEFT) {
            legend.setPadding(5.0, 5.0, 50.0, 20.0);
        } else {
            legend.setPadding(5.0, 20.0, 50.0, 5.0);
        }
        return legend;
    }
}

