/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import com.google.common.base.Preconditions;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.ui.Size2D;
import org.jfree.data.Range;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.gui.plot.pdf.PDF_UTF8_FontMapper;

public class PlotUtils {
    private static final int ASPECT_CALC_ITERATIONS = 2;
    public static boolean HEIGHT_ASPECT_D = false;

    public static PlotPreferences getDefaultAppPrefs() {
        PlotPreferences pref = PlotPreferences.getDefault();
        pref.setTickLabelFontSize(12);
        pref.setAxisLabelFontSize(14);
        pref.setPlotLabelFontSize(16);
        pref.setLegendFontSize(14);
        pref.setBackgroundColor(new Color(200, 200, 230));
        return pref;
    }

    public static PlotPreferences getDefaultFigurePrefs() {
        PlotPreferences pref = PlotPreferences.getDefault();
        pref.setTickLabelFontSize(18);
        pref.setAxisLabelFontSize(24);
        pref.setPlotLabelFontSize(24);
        pref.setLegendFontSize(20);
        pref.setBackgroundColor(Color.WHITE);
        return pref;
    }

    public static HeadlessGraphPanel initHeadless() {
        return new HeadlessGraphPanel(PlotUtils.getDefaultFigurePrefs());
    }

    public static void setAxisVisible(GraphPanel gp, boolean xVisible, boolean yVisible) {
        gp.getXAxis().setTickLabelsVisible(xVisible);
        gp.getYAxis().setTickLabelsVisible(yVisible);
    }

    public static void setGridLinesVisible(GraphPanel gp, boolean xVisible, boolean yVisible) {
        gp.getPlot().setDomainGridlinesVisible(xVisible);
        gp.getPlot().setRangeGridlinesVisible(yVisible);
    }

    public static void fixAspectRatio(GraphPanel gp, int width, boolean isLatLon) {
        PlotUtils.fixAspectRatio(gp, width, true, isLatLon);
    }

    public static void fixAspectRatio(GraphPanel gp, int dimension, boolean haveWidth, boolean isLatLon) {
        PlotUtils.fixAspectRatio(gp, dimension, haveWidth, PlotUtils.calcAspectRatio(gp.getX_AxisRange(), gp.getY_AxisRange(), isLatLon));
    }

    public static void fixAspectRatio(GraphPanel gp, int width, double aspectRatio) {
        PlotUtils.fixAspectRatio(gp, width, true, aspectRatio);
    }

    public static void fixAspectRatio(GraphPanel gp, int dimension, boolean haveWidth, double aspectRatio) {
        int height;
        int width;
        int calculated = PlotUtils.calcDimension(gp.getChartPanel(), dimension, haveWidth, aspectRatio);
        if (haveWidth) {
            width = dimension;
            height = calculated;
        } else {
            height = dimension;
            width = calculated;
        }
        gp.getChartPanel().setSize(width, height);
    }

    public static double calcAspectRatio(Range xRange, Range yRange, boolean isLatLon) {
        Preconditions.checkNotNull((Object)xRange, (Object)"Cannot determine aspect ratio if x range not supplied");
        Preconditions.checkNotNull((Object)yRange, (Object)"Cannot determine aspect ratio if y range not supplied");
        if (isLatLon) {
            Location left = new Location(yRange.getCentralValue(), xRange.getLowerBound());
            Location right = new Location(yRange.getCentralValue(), xRange.getUpperBound());
            Location top = new Location(yRange.getUpperBound(), xRange.getCentralValue());
            Location bottom = new Location(yRange.getLowerBound(), xRange.getCentralValue());
            double height = LocationUtils.horzDistance(top, bottom);
            double width = LocationUtils.horzDistance(left, right);
            return width / height;
        }
        return xRange.getLength() / yRange.getLength();
    }

    public static int calcHeight(GraphPanel gp, int width, boolean isLatLon) {
        return PlotUtils.calcHeight(gp.getChartPanel(), width, PlotUtils.calcAspectRatio(gp.getX_AxisRange(), gp.getY_AxisRange(), isLatLon));
    }

    public static int calcHeight(ChartPanel cp, int width, double aspectRatio) {
        return PlotUtils.calcDimension(cp, width, true, aspectRatio);
    }

    public static int calcWidth(ChartPanel cp, int height, double aspectRatio) {
        return PlotUtils.calcDimension(cp, height, false, aspectRatio);
    }

    private static int calcDimension(ChartPanel cp, int fixed, boolean haveWidth, double aspectRatio) {
        ChartRenderingInfo chartInfo = new ChartRenderingInfo();
        int height = fixed;
        int width = fixed;
        for (int i = 0; i < 2; ++i) {
            double gap;
            int num;
            if (HEIGHT_ASPECT_D) {
                System.out.println("Height calc iteration " + i + ", currently " + width + " x " + height + "; AR=" + (float)((double)width / (double)height) + "; targetAR=" + (float)aspectRatio);
            }
            cp.getChart().createBufferedImage(width, height, chartInfo);
            Rectangle2D plotArea = chartInfo.getPlotInfo().getDataArea();
            double myWidth = plotArea.getWidth();
            double myHeight = plotArea.getHeight();
            Plot plot = cp.getChart().getPlot();
            ArrayList<Double> plotHeights = new ArrayList<Double>();
            ArrayList<Double> plotWidths = new ArrayList<Double>();
            List<XYPlot> subPlots = null;
            if (plot instanceof CombinedRangeXYPlot) {
                CombinedRangeXYPlot combPlot = (CombinedRangeXYPlot)plot;
                subPlots = PlotUtils.getSubPlots((XYPlot)combPlot);
                num = subPlots.size();
                int sumWeights = 0;
                for (XYPlot subPlot : subPlots) {
                    sumWeights += subPlot.getWeight();
                }
                gap = combPlot.getGap();
                double widthMinusGaps = myWidth - gap * (double)(num - 1);
                for (XYPlot subPlot : subPlots) {
                    int weight = subPlot.getWeight();
                    double subWidth = widthMinusGaps * (double)weight / (double)sumWeights;
                    plotWidths.add(subWidth);
                }
                plotHeights.add(myHeight);
            } else if (plot instanceof CombinedDomainXYPlot) {
                CombinedDomainXYPlot combPlot = (CombinedDomainXYPlot)plot;
                subPlots = PlotUtils.getSubPlots((XYPlot)combPlot);
                num = subPlots.size();
                int sumWeights = 0;
                for (XYPlot subPlot : subPlots) {
                    sumWeights += subPlot.getWeight();
                }
                gap = combPlot.getGap();
                double heightMinusGaps = myHeight - gap * (double)(num - 1);
                for (XYPlot subPlot : subPlots) {
                    int weight = subPlot.getWeight();
                    double subHeight = heightMinusGaps * (double)weight / (double)sumWeights;
                    plotHeights.add(subHeight);
                }
                plotWidths.add(myWidth);
            } else {
                plotHeights.add(myHeight);
                plotWidths.add(myWidth);
            }
            double totalPlotHeight = plotHeights.stream().mapToDouble(D -> D).sum();
            double totalPlotWidth = plotWidths.stream().mapToDouble(D -> D).sum();
            boolean evenlyWeighted = true;
            if (subPlots != null) {
                int weight0 = subPlots.get(0).getWeight();
                for (int j = 1; evenlyWeighted && j < subPlots.size(); ++j) {
                    evenlyWeighted = weight0 == subPlots.get(j).getWeight();
                }
            }
            if (haveWidth) {
                double extraHeight = (double)height - totalPlotHeight;
                if (HEIGHT_ASPECT_D) {
                    System.out.println("\tCurrent plot area dimensions: " + (float)totalPlotWidth + " x " + (float)totalPlotHeight + "; AR=" + (float)(totalPlotWidth / totalPlotHeight));
                    System.out.println("\tExtra height: " + extraHeight);
                }
                if (evenlyWeighted) {
                    double plotHeight = (Double)plotWidths.get(0) / aspectRatio;
                    height = (int)(extraHeight + plotHeight * (double)plotHeights.size() + 0.5);
                    continue;
                }
                double origHeight1 = (Double)plotHeights.get(0);
                double targetHeight1 = (Double)plotWidths.get(0) / aspectRatio;
                if (HEIGHT_ASPECT_D) {
                    System.out.println("\tFirst subplot is currently " + ((Double)plotWidths.get(0)).floatValue() + " x " + (float)origHeight1 + "; AR=" + (float)((Double)plotWidths.get(0) / origHeight1));
                }
                double heightScale1 = targetHeight1 / origHeight1;
                if (HEIGHT_ASPECT_D) {
                    System.out.println("\tScaling height by " + (float)heightScale1 + " to get to " + ((Double)plotWidths.get(0)).floatValue() + " x " + (float)targetHeight1 + "; AR=" + (float)((Double)plotWidths.get(0) / targetHeight1));
                }
                Preconditions.checkState((heightScale1 > 0.0 ? 1 : 0) != 0);
                height = (int)(extraHeight + totalPlotHeight * heightScale1 + 0.5);
                continue;
            }
            double extraWidth = (double)width - totalPlotWidth;
            if (evenlyWeighted) {
                double plotWidth = (Double)plotHeights.get(0) * aspectRatio;
                width = (int)(extraWidth + plotWidth * (double)plotWidths.size() + 0.5);
                continue;
            }
            double origWidth1 = (Double)plotWidths.get(0);
            double targetWidth1 = (Double)plotHeights.get(0) * aspectRatio;
            double widthScale1 = targetWidth1 / origWidth1;
            Preconditions.checkState((widthScale1 > 0.0 ? 1 : 0) != 0);
            width = (int)(extraWidth + totalPlotWidth * widthScale1 + 0.5);
        }
        return haveWidth ? height : width;
    }

    public static void addSubplotTitles(GraphPanel gp, List<String> names, Font font) {
        PlotUtils.addSubplotTitles(PlotUtils.getSubPlots(gp), names, font);
    }

    public static void addSubplotTitles(List<XYPlot> subplots, List<String> names, Font font) {
        Preconditions.checkState((subplots.size() == names.size() ? 1 : 0) != 0);
        for (int i = 0; i < subplots.size(); ++i) {
            String name = names.get(i);
            if (name == null) continue;
            NumberAxis title = new NumberAxis(name);
            title.setLabelFont(font);
            title.setTickLabelsVisible(false);
            title.setTickMarksVisible(false);
            title.setAxisLineVisible(false);
            subplots.get(i).setDomainAxis(1, (ValueAxis)title);
        }
    }

    public static void writePlots(File outputDir, String prefix, GraphPanel gp, int width, int height, boolean writePNG, boolean writePDF, boolean writeTXT) throws IOException {
        PlotUtils.writePlots(outputDir, prefix, gp, width, height, false, writePNG, writePDF, writeTXT);
    }

    public static void writePlots(File outputDir, String prefix, GraphPanel gp, int width, boolean isLatLon, boolean writePNG, boolean writePDF, boolean writeTXT) throws IOException {
        PlotUtils.writePlots(outputDir, prefix, gp, width, -1, isLatLon, writePNG, writePDF, writeTXT);
    }

    public static void writePlots(File outputDir, String prefix, GraphPanel gp, int width, int height, boolean isLatLon, boolean writePNG, boolean writePDF, boolean writeTXT) throws IOException {
        File file = new File(outputDir, prefix);
        Preconditions.checkArgument((width > 0 || height > 0 ? 1 : 0) != 0, (Object)"must specify either width or height");
        if (height <= 0) {
            PlotUtils.fixAspectRatio(gp, width, isLatLon);
        } else if (width <= 0) {
            PlotUtils.fixAspectRatio(gp, height, false, isLatLon);
        } else {
            gp.getChartPanel().setSize(width, height);
        }
        if (writePNG) {
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
        }
        if (writePDF) {
            gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        }
        if (writeTXT) {
            gp.saveAsTXT(file.getAbsolutePath() + ".txt");
        }
    }

    public static void setXTick(GraphPanel gp, double tick) {
        if (PlotUtils.isCombinedPlot(gp.getPlot())) {
            for (XYPlot subPlot : PlotUtils.getSubPlots(gp)) {
                PlotUtils.setTick(subPlot.getDomainAxis(), tick);
            }
        } else {
            PlotUtils.setTick(gp.getXAxis(), tick);
        }
    }

    public static void setYTick(GraphPanel gp, double tick) {
        if (PlotUtils.isCombinedPlot(gp.getPlot())) {
            for (XYPlot subPlot : PlotUtils.getSubPlots(gp)) {
                PlotUtils.setTick(subPlot.getRangeAxis(), tick);
            }
        } else {
            PlotUtils.setTick(gp.getYAxis(), tick);
        }
    }

    public static void setTick(ValueAxis axis, double tick) {
        TickUnits tus = new TickUnits();
        NumberTickUnit tu = new NumberTickUnit(tick);
        tus.add((TickUnit)tu);
        axis.setStandardTickUnits((TickUnitSource)tus);
    }

    public static void setSubplotGap(GraphPanel gp, double gap) {
        XYPlot plot = gp.getPlot();
        if (plot instanceof CombinedDomainXYPlot) {
            ((CombinedDomainXYPlot)plot).setGap(gap);
        } else if (plot instanceof CombinedRangeXYPlot) {
            ((CombinedRangeXYPlot)plot).setGap(gap);
        } else {
            throw new IllegalStateException("Can only set gap for CombinedDomainXYPlot or CombinedRangeXYPlot");
        }
    }

    public static void setSubPlotWeights(GraphPanel gp, int ... weights) {
        List<XYPlot> subPlots = PlotUtils.getSubPlots(gp);
        Preconditions.checkState((subPlots.size() == weights.length ? 1 : 0) != 0, (String)"Have %s subplots but %s weights", (int)subPlots.size(), (int)weights.length);
        for (int i = 0; i < subPlots.size(); ++i) {
            subPlots.get(i).setWeight(weights[i]);
        }
    }

    public static List<XYPlot> getSubPlots(GraphPanel gp) {
        return PlotUtils.getSubPlots(gp.getPlot());
    }

    private static boolean isCombinedPlot(XYPlot plot) {
        return plot instanceof CombinedDomainXYPlot || plot instanceof CombinedRangeXYPlot;
    }

    public static List<XYPlot> getSubPlots(XYPlot plot) {
        if (plot instanceof CombinedDomainXYPlot) {
            return ((CombinedDomainXYPlot)plot).getSubplots();
        }
        if (plot instanceof CombinedRangeXYPlot) {
            return ((CombinedRangeXYPlot)plot).getSubplots();
        }
        throw new IllegalStateException("Can only get sub plots for CombinedDomainXYPlot or CombinedRangeXYPlot");
    }

    public static void writeScaleLegendOnly(File outputDir, String prefix, PaintScaleLegend legend, int width, boolean writePNG, boolean writePDF) throws IOException {
        Graphics2D dummyGraphics = new BufferedImage(1, 1, 2).createGraphics();
        RectangleConstraint constraint = new RectangleConstraint(new Range((double)width, (double)width), new Range(0.05 * (double)width, (double)width));
        Size2D preferredSize = legend.arrange(dummyGraphics, constraint);
        int height = (int)Math.ceil(preferredSize.getHeight());
        dummyGraphics.dispose();
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        legend.draw(g2, (Rectangle2D)new java.awt.Rectangle(0, 0, width, height));
        g2.dispose();
        if (writePNG) {
            File outputFile = new File(outputDir, prefix + ".png");
            ImageIO.write((RenderedImage)image, "png", outputFile);
        }
        if (writePDF) {
            Document metadataDocument = new Document(new Rectangle((float)width, (float)height));
            metadataDocument.addAuthor("OpenSHA");
            metadataDocument.addCreationDate();
            try {
                PdfWriter writer = PdfWriter.getInstance((Document)metadataDocument, (OutputStream)new BufferedOutputStream(new FileOutputStream(new File(outputDir, prefix + ".pdf"))));
                metadataDocument.open();
                PdfContentByte cb = writer.getDirectContent();
                PdfTemplate tp = cb.createTemplate((float)width, (float)height);
                PDF_UTF8_FontMapper fontMapper = new PDF_UTF8_FontMapper();
                PdfGraphics2D g2d = new PdfGraphics2D((PdfContentByte)tp, (float)width, (float)height, (FontMapper)fontMapper);
                g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle2D.Double r2d = new Rectangle2D.Double(0.0, 0.0, width, height);
                legend.draw((Graphics2D)g2d, (Rectangle2D)r2d);
                g2d.dispose();
                cb.addTemplate(tp, 0.0f, 0.0f);
            }
            catch (DocumentException de) {
                de.printStackTrace();
            }
            metadataDocument.close();
        }
    }
}

