/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.jfreechart;

import java.util.ArrayList;
import java.util.ListIterator;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;

public class DiscretizedFunctionXYDataSet
extends AbstractXYDataset
implements Named,
IntervalXYDataset,
TableXYDataset {
    private static final long serialVersionUID = 1L;
    protected static final String C = "DiscretizedFunctionXYDataSet";
    protected static final boolean D = false;
    protected boolean yLog = false;
    protected boolean xLog = false;
    protected XY_DataSetList functions = null;
    protected ArrayList<DatasetChangeListener> listeners = new ArrayList();
    private double minVal = Double.MIN_VALUE;
    private boolean convertZeroToMin = false;
    private DatasetGroup group = new DatasetGroup();

    public boolean isYLog() {
        return this.yLog;
    }

    public void setYLog(boolean yLog) {
        this.yLog = yLog;
    }

    public boolean isXLog() {
        return this.xLog;
    }

    public void setXLog(boolean xLog) {
        this.xLog = xLog;
    }

    public void setName(String name) {
        this.functions.setName(name);
    }

    @Override
    public String getName() {
        return this.functions.getName();
    }

    public ListIterator<XY_DataSet> listIterator() {
        return this.functions.listIterator();
    }

    public int getSeriesCount() {
        return this.functions.size();
    }

    public String getSeriesName(int series) {
        if (series < this.functions.size()) {
            String str = ((XY_DataSet)this.functions.get(series)).getName();
            if (str == null) {
                str = "";
            }
            return str;
        }
        return "";
    }

    public int getItemCount(int series) {
        int num = -1;
        if (series < this.functions.size()) {
            XY_DataSet f = (XY_DataSet)this.functions.get(series);
            num = f.size();
            if (DiscretizedFunctionXYDataSet.isAdjustedIndexIfFirstXZero(f, this.xLog, this.yLog)) {
                --num;
            }
        }
        return num;
    }

    public int getItemCount() {
        return this.getItemCount(0);
    }

    public double getXValue(int series, int item) {
        XY_DataSet dataset;
        if (series < this.functions.size() && (dataset = (XY_DataSet)this.functions.get(series)) != null) {
            if (DiscretizedFunctionXYDataSet.isAdjustedIndexIfFirstXZero(dataset, this.xLog, this.yLog)) {
                ++item;
            }
            double x = dataset.getX(item);
            return x;
        }
        return Double.NaN;
    }

    public XY_DataSet getXYDataset(int series) {
        return (XY_DataSet)this.functions.get(series);
    }

    public double getYValue(int series, int item) {
        XY_DataSet dataset;
        if (series < this.functions.size() && (dataset = (XY_DataSet)this.functions.get(series)) != null) {
            if (DiscretizedFunctionXYDataSet.isAdjustedIndexIfFirstXZero(dataset, this.xLog, this.yLog)) {
                ++item;
            }
            double y = dataset.getY(item);
            if (this.convertZeroToMin && y <= this.minVal && this.yLog) {
                return this.minVal;
            }
            return y;
        }
        return Double.NaN;
    }

    protected static final boolean isAdjustedIndexIfFirstXZero(XY_DataSet func, boolean xLog, boolean yLog) {
        return xLog && (func.getX(0) == 0.0 || func.getX(0) == Double.MIN_VALUE) || yLog && func.getY(0) == 0.0;
    }

    public void clear() {
        this.functions.clear();
    }

    public int size() {
        return this.functions.size();
    }

    public boolean equals(Object list) {
        return list instanceof DiscretizedFunctionXYDataSet && ((DiscretizedFunctionXYDataSet)list).getFunctions().equals(this.functions);
    }

    public DiscretizedFunctionXYDataSet deepClone() {
        DiscretizedFunctionXYDataSet set = new DiscretizedFunctionXYDataSet();
        XY_DataSetList list = this.functions.deepClone();
        set.setFunctions(list);
        return set;
    }

    public void addChangeListener(DatasetChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(DatasetChangeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public XY_DataSetList getFunctions() {
        return this.functions;
    }

    public void setFunctions(XY_DataSetList functions) {
        this.functions = functions;
    }

    public void setConvertZeroToMin(boolean zeroToMin) {
        this.convertZeroToMin = zeroToMin;
    }

    public void setConvertZeroToMin(boolean zeroMin, double minVal) {
        this.convertZeroToMin = zeroMin;
        this.minVal = minVal;
    }

    public DatasetGroup getGroup() {
        return this.group;
    }

    public void setGroup(DatasetGroup group) {
        this.group = group;
    }

    public double getStartXValue(int series, int item) {
        double x = this.getXValue(series, item);
        XY_DataSet dataset = (XY_DataSet)this.functions.get(series);
        if (dataset != null) {
            if (dataset instanceof EvenlyDiscretizedFunc) {
                x -= ((EvenlyDiscretizedFunc)dataset).getDelta() / 2.0;
            } else if (dataset.size() > 1) {
                if (item > 0) {
                    double prevX = this.getXValue(series, item - 1);
                    x = this.xLog ? Math.pow(10.0, 0.5 * (Math.log10(prevX) + Math.log10(x))) : 0.5 * (prevX + x);
                } else {
                    double nextX = this.getXValue(series, item + 1);
                    if (this.xLog) {
                        double logDelta = Math.log10(nextX) - Math.log10(x);
                        x = Math.pow(10.0, Math.log10(x) - 0.5 * logDelta);
                    } else {
                        x -= 0.5 * (nextX - x);
                    }
                }
            }
        }
        return x;
    }

    public double getEndXValue(int series, int item) {
        double x = this.getXValue(series, item);
        XY_DataSet dataset = (XY_DataSet)this.functions.get(series);
        if (dataset != null) {
            if (dataset instanceof EvenlyDiscretizedFunc) {
                x += ((EvenlyDiscretizedFunc)dataset).getDelta() / 2.0;
            } else if (dataset.size() > 1) {
                int maxIndex = dataset.size() - 2;
                if (DiscretizedFunctionXYDataSet.isAdjustedIndexIfFirstXZero(dataset, this.xLog, this.yLog)) {
                    --maxIndex;
                }
                if (item <= maxIndex) {
                    DiscretizedFunctionXYDataSet.isAdjustedIndexIfFirstXZero(dataset, this.xLog, this.yLog);
                    double nextX = this.getXValue(series, item + 1);
                    x = this.xLog ? Math.pow(10.0, 0.5 * (Math.log10(nextX) + Math.log10(x))) : 0.5 * (nextX + x);
                } else {
                    double prevX = this.getXValue(series, item - 1);
                    if (this.xLog) {
                        double logDelta = Math.log10(x) - Math.log10(prevX);
                        x = Math.pow(10.0, Math.log10(x) + 0.5 * logDelta);
                    } else {
                        x += 0.5 * (x - prevX);
                    }
                }
            }
        }
        return x;
    }

    public double getStartYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public double getEndYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public Number getEndX(int series, int item) {
        return this.getEndXValue(series, item);
    }

    public Number getEndY(int series, int item) {
        return this.getEndYValue(series, item);
    }

    public Number getStartX(int series, int item) {
        return this.getStartXValue(series, item);
    }

    public Number getStartY(int series, int item) {
        return this.getStartYValue(series, item);
    }

    public Number getX(int series, int item) {
        return this.getXValue(series, item);
    }

    public Number getY(int series, int item) {
        return this.getYValue(series, item);
    }

    public Comparable getSeriesKey(int series) {
        return new String(this.getSeriesName(series));
    }
}

