/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.jfreechart.xyzPlot;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jfree.data.xy.AbstractXYZDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.opensha.commons.data.xyz.EvenlyDiscrXYZ_DataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZPlotSpec;
import org.opensha.commons.util.DataUtils;

public class XYZDatasetWrapper
extends AbstractXYZDataset
implements IntervalXYDataset {
    private XYZ_DataSet xyz;
    private String zLabel;
    private boolean xLog;
    private boolean yLog;
    private double spacingX;
    private double spacingY;
    private double halfSpacingX;
    private double halfSpacingY;

    public XYZDatasetWrapper(XYZPlotSpec spec, boolean xLog, boolean yLog) {
        this.xyz = spec.getXYZ_Data();
        this.zLabel = spec.isIncludeZlabelInLegend() ? spec.getZAxisLabel() : "";
        this.xLog = xLog;
        this.yLog = yLog;
        Double thicknessX = spec.getThicknessX();
        Double thicknessY = spec.getThicknessY();
        if (thicknessX != null && thicknessY != null) {
            this.spacingX = thicknessX;
            this.spacingY = thicknessY;
        } else if (this.xyz instanceof EvenlyDiscrXYZ_DataSet) {
            this.spacingX = thicknessX == null ? ((EvenlyDiscrXYZ_DataSet)this.xyz).getGridSpacingX() : thicknessX.doubleValue();
            this.spacingY = thicknessY == null ? ((EvenlyDiscrXYZ_DataSet)this.xyz).getGridSpacingY() : thicknessY.doubleValue();
        } else {
            Preconditions.checkState((this.xyz.size() > 1 ? 1 : 0) != 0, (String)"Can't detect spacing if we only have %s value", (int)this.xyz.size());
            int numToCheck = Integer.min(1000, this.xyz.size());
            Preconditions.checkState((numToCheck > 0 ? 1 : 0) != 0);
            ArrayList<Double> xDiffs = new ArrayList<Double>(numToCheck);
            ArrayList<Double> yDiffs = new ArrayList<Double>(numToCheck);
            Point2D prevPt = this.xyz.getPoint(0);
            for (int i = 1; i < this.xyz.size(); ++i) {
                Point2D pt = this.xyz.getPoint(i);
                double diffX = Math.abs(pt.getX() - prevPt.getX());
                double diffY = Math.abs(pt.getY() - prevPt.getY());
                if ((float)diffX > 0.0f) {
                    xDiffs.add(diffX);
                }
                if ((float)diffY > 0.0f) {
                    yDiffs.add(diffY);
                }
                if (xDiffs.size() >= numToCheck && yDiffs.size() > numToCheck) break;
                prevPt = pt;
            }
            Preconditions.checkState((!xDiffs.isEmpty() || !yDiffs.isEmpty() ? 1 : 0) != 0, (String)"Can't detect spacing with %x xDiffs, %s yDiffs, and %s values", (Object)xDiffs.size(), (Object)yDiffs.size(), (Object)this.xyz.size());
            if (xDiffs.isEmpty()) {
                this.spacingX = this.spacingY = yDiffs.size() == 1 ? (Double)yDiffs.get(0) : DataUtils.median(Doubles.toArray(yDiffs));
            } else if (yDiffs.isEmpty()) {
                this.spacingY = this.spacingX = xDiffs.size() == 1 ? (Double)xDiffs.get(0) : DataUtils.median(Doubles.toArray(xDiffs));
            } else {
                this.spacingX = xDiffs.size() == 1 ? (Double)xDiffs.get(0) : DataUtils.median(Doubles.toArray(xDiffs));
                double d = this.spacingY = yDiffs.size() == 1 ? (Double)yDiffs.get(0) : DataUtils.median(Doubles.toArray(yDiffs));
            }
            if (thicknessX != null) {
                this.spacingX = thicknessX;
            }
            if (thicknessY != null) {
                this.spacingY = thicknessY;
            }
        }
        this.halfSpacingX = 0.5 * this.spacingX;
        this.halfSpacingY = 0.5 * this.spacingY;
    }

    public Number getZ(int series, int item) {
        return this.xyz.get(item);
    }

    public int getItemCount(int series) {
        return this.xyz.size();
    }

    public Number getX(int series, int item) {
        double x = this.xyz.getPoint(item).getX();
        if (this.xLog) {
            return Math.pow(10.0, x);
        }
        return x;
    }

    public Number getY(int series, int item) {
        double y = this.xyz.getPoint(item).getY();
        if (this.yLog) {
            return Math.pow(10.0, y);
        }
        return y;
    }

    public int getSeriesCount() {
        return 1;
    }

    public Comparable getSeriesKey(int arg0) {
        return this.zLabel;
    }

    public double getStartXValue(int series, int item) {
        double x = this.xyz.getPoint(item).getX() - this.halfSpacingX;
        if (this.xLog) {
            return Math.pow(10.0, x);
        }
        return x;
    }

    public double getEndXValue(int series, int item) {
        double x = this.xyz.getPoint(item).getX() + this.halfSpacingX;
        if (this.xLog) {
            return Math.pow(10.0, x);
        }
        return x;
    }

    public double getStartYValue(int series, int item) {
        double y = this.xyz.getPoint(item).getY() - this.halfSpacingY;
        if (this.yLog) {
            return Math.pow(10.0, y);
        }
        return y;
    }

    public double getEndYValue(int series, int item) {
        double y = this.xyz.getPoint(item).getY() + this.halfSpacingY;
        if (this.yLog) {
            return Math.pow(10.0, y);
        }
        return y;
    }

    public Number getStartX(int series, int item) {
        return this.getStartXValue(series, item);
    }

    public Number getEndX(int series, int item) {
        return this.getEndXValue(series, item);
    }

    public Number getStartY(int series, int item) {
        return this.getStartYValue(series, item);
    }

    public Number getEndY(int series, int item) {
        return this.getEndYValue(series, item);
    }
}

