/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.hpc.pbs;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public abstract class BatchScriptWriter {
    public abstract List<String> getBatchHeader(int var1, int var2, int var3, String var4);

    public List<String> buildScript(List<String> script, int mins, int nodes, int ppn, String queue) {
        script = Lists.newArrayList(script);
        List<String> pbs = this.getBatchHeader(mins, nodes, ppn, queue);
        if (!pbs.get(pbs.size() - 1).isEmpty()) {
            pbs.add("");
        }
        script.addAll(2, pbs);
        return script;
    }

    public void writeScript(File file, List<String> script, int mins, int nodes, int ppn, String queue) throws IOException {
        List<String> pbs = this.buildScript(script, mins, nodes, ppn, queue);
        this.writeScript(file, pbs);
    }

    public void writeScript(File file, List<String> script) throws IOException {
        FileWriter fw = new FileWriter(file);
        for (String line : script) {
            fw.write(line + "\n");
        }
        fw.close();
    }
}

