/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.logicTree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.logicTree.BranchWeightProvider;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.modules.helpers.JSON_BackedModule;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;

@JsonAdapter(value=Adapter.class)
public class LogicTree<E extends LogicTreeNode>
implements Iterable<LogicTreeBranch<E>>,
JSON_BackedModule {
    private ImmutableList<LogicTreeLevel<? extends E>> levels;
    private ImmutableList<LogicTreeBranch<E>> branches;
    private HashSet<LogicTreeBranch<E>> branchesSet;
    private static final BranchWeightProvider DEFAULT_WEIGHTS = new BranchWeightProvider.OriginalWeights();
    private BranchWeightProvider weightProvider = DEFAULT_WEIGHTS;
    private transient IntegerPDF_FunctionSampler sampler = null;

    private LogicTree(BranchWeightProvider weightProvider) {
        this.weightProvider = weightProvider;
    }

    protected LogicTree(List<LogicTreeLevel<? extends E>> levels, Collection<? extends LogicTreeBranch<E>> branches, BranchWeightProvider weightProvider) {
        Preconditions.checkState((levels != null ? 1 : 0) != 0);
        Preconditions.checkState((branches != null ? 1 : 0) != 0);
        this.levels = ImmutableList.copyOf(levels);
        this.branches = ImmutableList.copyOf(branches);
        this.weightProvider = weightProvider;
        for (LogicTreeBranch<E> branch : branches) {
            Preconditions.checkState((branch.size() == levels.size() ? 1 : 0) != 0, (String)"Branch has %s levels but expected %s", (int)branch.size(), (int)levels.size());
            for (int i = 0; i < levels.size(); ++i) {
                LogicTreeLevel<E> myLevel = levels.get(i);
                LogicTreeLevel<E> branchLevel = branch.getLevel(i);
                Preconditions.checkState((boolean)myLevel.equals(branchLevel), (String)"Branch has different level at index %s:\nLogic tree level: %s\nBranch level: %s\nBranch: %s", (Object)i, myLevel, branchLevel, branch);
            }
        }
    }

    public int size() {
        return this.branches.size();
    }

    public LogicTreeBranch<E> getBranch(int index) {
        return (LogicTreeBranch)this.branches.get(index);
    }

    public double getBranchWeight(int index) {
        return this.weightProvider.getWeight(this.getBranch(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(LogicTreeBranch<?> branch) {
        if (this.branchesSet == null) {
            LogicTree logicTree = this;
            synchronized (logicTree) {
                if (this.branchesSet == null) {
                    this.branchesSet = new HashSet<LogicTreeBranch<LogicTreeBranch<E>>>(this.branches);
                }
            }
        }
        return this.branchesSet.contains(branch);
    }

    public double getBranchWeight(LogicTreeBranch<?> branch) {
        return this.weightProvider.getWeight(branch);
    }

    public BranchWeightProvider getWeightProvider() {
        return this.weightProvider;
    }

    public void setWeightProvider(BranchWeightProvider weightProvider) {
        Preconditions.checkNotNull((Object)weightProvider);
        this.weightProvider = weightProvider;
    }

    @Override
    public Iterator<LogicTreeBranch<E>> iterator() {
        return this.branches.iterator();
    }

    public ImmutableList<LogicTreeLevel<? extends E>> getLevels() {
        return this.levels;
    }

    public ImmutableList<LogicTreeBranch<E>> getBranches() {
        return this.branches;
    }

    public double getTotalWeight() {
        double totalWeight = 0.0;
        for (LogicTreeBranch branch : this.branches) {
            totalWeight += branch.getBranchWeight();
        }
        return totalWeight;
    }

    @SafeVarargs
    public final LogicTree<E> matchingAll(LogicTreeNode ... values) {
        ImmutableList.Builder matching = ImmutableList.builder();
        for (LogicTreeBranch branch : this.branches) {
            boolean matches = true;
            for (LogicTreeNode value : values) {
                if (branch.hasValue(value)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            matching.add((Object)branch);
        }
        LogicTree<E> ret = new LogicTree<E>(this.weightProvider);
        ret.branches = matching.build();
        ret.levels = this.levels;
        return ret;
    }

    @SafeVarargs
    public final LogicTree<E> matchingAny(LogicTreeNode ... values) {
        ImmutableList.Builder matching = ImmutableList.builder();
        for (LogicTreeBranch branch : this.branches) {
            boolean matches = false;
            for (LogicTreeNode value : values) {
                if (!branch.hasValue(value)) continue;
                matches = true;
                break;
            }
            if (!matches) continue;
            matching.add((Object)branch);
        }
        LogicTree<E> ret = new LogicTree<E>(this.weightProvider);
        ret.branches = matching.build();
        ret.levels = this.levels;
        return ret;
    }

    @SafeVarargs
    public final LogicTree<E> matchingNone(LogicTreeNode ... values) {
        ImmutableList.Builder matching = ImmutableList.builder();
        for (LogicTreeBranch branch : this.branches) {
            boolean matches = false;
            for (LogicTreeNode value : values) {
                if (!branch.hasValue(value)) continue;
                matches = true;
                break;
            }
            if (matches) continue;
            matching.add((Object)branch);
        }
        LogicTree<E> ret = new LogicTree<E>(this.weightProvider);
        ret.branches = matching.build();
        ret.levels = this.levels;
        return ret;
    }

    public final LogicTree<E> subset(Collection<LogicTreeBranch<?>> subsetBranches) {
        HashSet<Object> set = subsetBranches instanceof HashSet ? (HashSet<Object>)subsetBranches : new HashSet(subsetBranches);
        ImmutableList.Builder matching = ImmutableList.builderWithExpectedSize((int)subsetBranches.size());
        for (LogicTreeBranch branch : this.branches) {
            if (!set.contains(branch)) continue;
            matching.add((Object)branch);
        }
        LogicTree<E> ret = new LogicTree<E>(this.weightProvider);
        ret.branches = matching.build();
        Preconditions.checkState((subsetBranches.size() == ret.branches.size() ? 1 : 0) != 0, (Object)"Not all passed in branches were found in the tree");
        ret.levels = this.levels;
        return ret;
    }

    public final LogicTree<E> sample(int numSamples, boolean redrawDuplicates) {
        return this.sample(numSamples, redrawDuplicates, new Random());
    }

    public final LogicTree<E> sample(int numSamples, boolean redrawDuplicates, Random rand) {
        return this.sample(numSamples, redrawDuplicates, rand, true);
    }

    public final LogicTree<E> sample(int numSamples, boolean redrawDuplicates, Random rand, boolean verbose) {
        if (verbose) {
            System.out.println("Resampling logic tree of size=" + this.size() + " to " + numSamples + " samples...");
        }
        Preconditions.checkArgument((numSamples > 0 ? 1 : 0) != 0);
        Preconditions.checkState((!redrawDuplicates || numSamples <= this.size() ? 1 : 0) != 0, (String)"Cannot randomly sample %s branches from %s values without any duplicates!", (int)numSamples, (int)this.size());
        IntegerPDF_FunctionSampler sampler = this.getSampler();
        int[] indexCounts = new int[this.branches.size()];
        int sampleCountSum = 0;
        int uniqueBranches = 0;
        if (redrawDuplicates) {
            while (uniqueBranches < numSamples) {
                int index = sampler.getRandomInt(rand);
                if (indexCounts[index] == 0) {
                    ++uniqueBranches;
                }
                ++sampleCountSum;
                int n = index;
                indexCounts[n] = indexCounts[n] + 1;
            }
        } else {
            for (int i = 0; i < numSamples; ++i) {
                int index = sampler.getRandomInt(rand);
                if (indexCounts[index] == 0) {
                    ++uniqueBranches;
                }
                ++sampleCountSum;
                int n = index;
                indexCounts[n] = indexCounts[n] + 1;
            }
        }
        double weightEach = 1.0 / (double)sampleCountSum;
        ArrayList<LogicTreeBranch<E>> samples = new ArrayList<LogicTreeBranch<E>>(uniqueBranches);
        HashMap<LogicTreeNode, Integer> sampledNodeCounts = new HashMap<LogicTreeNode, Integer>();
        int mostSamples = 0;
        for (int index = 0; index < indexCounts.length; ++index) {
            int count = indexCounts[index];
            if (count == 0) continue;
            mostSamples = Integer.max(mostSamples, count);
            LogicTreeBranch<E> branch = this.getBranch(index).copy();
            if (redrawDuplicates) {
                branch.setOrigBranchWeight((double)count * weightEach);
                samples.add(branch);
            } else {
                branch.setOrigBranchWeight(weightEach);
                for (int i = 0; i < count; ++i) {
                    samples.add(branch);
                }
            }
            for (LogicTreeNode node : branch) {
                if (sampledNodeCounts.containsKey(node)) {
                    sampledNodeCounts.put(node, (Integer)sampledNodeCounts.get(node) + count);
                    continue;
                }
                sampledNodeCounts.put(node, count);
            }
        }
        BranchWeightProvider weightProv = uniqueBranches == sampleCountSum ? new BranchWeightProvider.ConstantWeights(weightEach) : new BranchWeightProvider.OriginalWeights();
        LogicTree<E> ret = new LogicTree<E>(weightProv);
        ret.branches = ImmutableList.copyOf(samples);
        ret.levels = this.levels;
        if (verbose) {
            System.out.println("\tSampled " + uniqueBranches + " unique branches a total of " + sampleCountSum + " times. The most any single branch was sampled is " + mostSamples + " time(s).");
            HashMap<LogicTreeNode, Integer> origNodeCounts = new HashMap<LogicTreeNode, Integer>();
            HashMap<LogicTreeNode, Double> origNodeWeights = new HashMap<LogicTreeNode, Double>();
            double totWeight = 0.0;
            for (LogicTreeBranch branch : this.branches) {
                double weight = this.getBranchWeight(branch);
                totWeight += weight;
                for (LogicTreeNode node : branch) {
                    if (origNodeCounts.containsKey(node)) {
                        origNodeCounts.put(node, (Integer)origNodeCounts.get(node) + 1);
                        origNodeWeights.put(node, (Double)origNodeWeights.get(node) + weight);
                        continue;
                    }
                    origNodeCounts.put(node, 1);
                    origNodeWeights.put(node, weight);
                }
            }
            if (totWeight != 1.0) {
                for (LogicTreeNode node : List.copyOf(origNodeWeights.keySet())) {
                    origNodeWeights.put(node, (Double)origNodeWeights.get(node) / totWeight);
                }
            }
            LogicTree.printSamplingStats(this.levels, weightEach, sampledNodeCounts, origNodeCounts, origNodeWeights);
        }
        return ret;
    }

    public static void printSamplingStats(List<? extends LogicTreeLevel<?>> levels, double sampledWeightEach, Map<LogicTreeNode, Integer> sampledNodeCounts, Map<LogicTreeNode, Integer> origNodeCounts, Map<LogicTreeNode, Double> origNodeWeights) {
        HashMap<LogicTreeNode, Double> sampledNodeWeights = new HashMap<LogicTreeNode, Double>(sampledNodeCounts.size());
        for (LogicTreeNode node : sampledNodeCounts.keySet()) {
            sampledNodeWeights.put(node, (double)sampledNodeCounts.get(node).intValue() * sampledWeightEach);
        }
        LogicTree.printSamplingStats(levels, sampledNodeCounts, sampledNodeWeights, origNodeCounts, origNodeWeights);
    }

    public static void printSamplingStats(List<? extends LogicTreeLevel<?>> levels, Map<LogicTreeNode, Integer> sampledNodeCounts, Map<LogicTreeNode, Double> sampledNodeWeights, Map<LogicTreeNode, Integer> origNodeCounts, Map<LogicTreeNode, Double> origNodeWeights) {
        System.out.println("Sampled Logic Tree:");
        DecimalFormat weightDF = new DecimalFormat("0.0000");
        DecimalFormat countDF = new DecimalFormat("0.#");
        countDF.setGroupingSize(3);
        countDF.setGroupingUsed(true);
        for (LogicTreeLevel<?> level : levels) {
            ArrayList<LogicTreeNode> origNodes = new ArrayList<LogicTreeNode>();
            for (LogicTreeNode node : level.getNodes()) {
                if (!origNodeCounts.containsKey(node)) continue;
                origNodes.add(node);
            }
            if (origNodes.size() < 2) continue;
            System.out.println("\t" + level.getName());
            int minNumSamples = Integer.MAX_VALUE;
            int maxNumSamples = 0;
            int totNumSamples = 0;
            boolean abbreviate = origNodes.size() > 20;
            int abbrevPrintCount = 10;
            for (int i = 0; i < origNodes.size(); ++i) {
                Double sampledWeight;
                LogicTreeNode node = (LogicTreeNode)origNodes.get(i);
                int origCount = origNodeCounts.get(node);
                double origWeight = origNodeWeights.get(node);
                Integer sampleCount = sampledNodeCounts.get(node);
                if (sampleCount == null) {
                    sampleCount = 0;
                }
                if ((sampledWeight = sampledNodeWeights.get(node)) == null) {
                    System.out.println("\t\t" + node.getShortName() + ":\tORIG count=" + countDF.format(origCount) + " weight=" + weightDF.format(origWeight) + ";\tNO SAMPLES");
                    continue;
                }
                System.out.println("\t\t" + node.getShortName() + ":\tORIG count=" + countDF.format(origCount) + " weight=" + weightDF.format(origWeight) + ";\tSAMPLED count=" + countDF.format(sampleCount) + " weight=" + weightDF.format(sampledWeight));
                if (abbreviate && i == abbrevPrintCount - 1) {
                    int skipped = 0;
                    int skippedOrigCount = 0;
                    double skippedOrigWeight = 0.0;
                    int skippedSampledCount = 0;
                    double skippedSampledWeight = 0.0;
                    while (i < origNodes.size() - 2) {
                        node = (LogicTreeNode)origNodes.get(i);
                        origCount = origNodeCounts.get(node);
                        origWeight = origNodeWeights.get(node);
                        sampleCount = sampledNodeCounts.get(node);
                        if (sampleCount == null) {
                            sampleCount = 0;
                        }
                        sampledWeight = sampledNodeWeights.get(node);
                        ++skipped;
                        skippedOrigCount += origCount;
                        skippedOrigWeight += origWeight;
                        skippedSampledCount += sampleCount.intValue();
                        skippedSampledWeight += sampledWeight.doubleValue();
                        minNumSamples = Integer.min(minNumSamples, sampleCount);
                        maxNumSamples = Integer.max(maxNumSamples, sampleCount);
                        totNumSamples += sampleCount.intValue();
                        ++i;
                    }
                    System.out.println("\t\t(...Skipping " + skipped + " branches with:\tORIG count=" + skippedOrigCount + ", weight=" + weightDF.format(skippedOrigWeight) + ";\tSAMPLED count=" + skippedSampledCount + ", weight=" + weightDF.format(skippedSampledWeight) + "...)");
                    continue;
                }
                minNumSamples = Integer.min(minNumSamples, sampleCount);
                maxNumSamples = Integer.max(maxNumSamples, sampleCount);
                totNumSamples += sampleCount.intValue();
            }
            System.out.println("\t\t\tSAMPLE COUNTS: [" + minNumSamples + ", " + maxNumSamples + "]; avg=" + countDF.format((double)totNumSamples / (double)origNodes.size()));
        }
    }

    public IntegerPDF_FunctionSampler getSampler() {
        if (this.sampler == null) {
            double[] weights = new double[this.size()];
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = this.getBranchWeight(i);
            }
            this.sampler = new IntegerPDF_FunctionSampler(weights);
        }
        return this.sampler;
    }

    public static <E extends LogicTreeNode> LogicTree<E> buildExhaustive(List<LogicTreeLevel<? extends E>> levels, boolean onlyNonZeroWeight, LogicTreeNode ... required) {
        return LogicTree.buildExhaustive(levels, onlyNonZeroWeight, new BranchWeightProvider.CurrentWeights(), required);
    }

    public static <E extends LogicTreeNode> LogicTree<E> buildExhaustive(List<LogicTreeLevel<? extends E>> levels, boolean onlyNonZeroWeight, BranchWeightProvider weightProv, LogicTreeNode ... required) {
        ArrayList<LogicTreeBranch<E>> branches = new ArrayList<LogicTreeBranch<E>>();
        LogicTreeBranch<? extends E> emptyBranch = new LogicTreeBranch<E>(levels);
        LogicTree.buildBranchesRecursive(levels, branches, emptyBranch, 0, onlyNonZeroWeight, weightProv, required);
        return new LogicTree<E>(levels, branches, DEFAULT_WEIGHTS);
    }

    private static <E extends LogicTreeNode> void buildBranchesRecursive(List<LogicTreeLevel<? extends E>> levels, List<LogicTreeBranch<E>> branches, LogicTreeBranch<E> curBranch, int curIndex, boolean onlyNonZeroWeight, BranchWeightProvider weightProv, LogicTreeNode[] required) {
        LogicTreeLevel<E> level = levels.get(curIndex);
        for (LogicTreeNode node : level.getNodes()) {
            if (onlyNonZeroWeight && weightProv == null && node.getNodeWeight(curBranch) == 0.0) continue;
            if (required != null) {
                boolean hasRequired = true;
                for (LogicTreeNode requiredNode : required) {
                    if (!level.isMember(requiredNode) || node.equals(requiredNode)) continue;
                    hasRequired = false;
                    break;
                }
                if (!hasRequired) continue;
            }
            LogicTreeBranch<LogicTreeNode> copy = curBranch.copy();
            copy.setValue(curIndex, node);
            if (onlyNonZeroWeight && weightProv != null && weightProv.getWeight(copy) == 0.0) continue;
            if (curIndex == levels.size() - 1) {
                Preconditions.checkState((boolean)copy.isFullySpecified());
                if (weightProv != null) {
                    double weight = weightProv.getWeight(copy);
                    copy.setOrigBranchWeight(weight);
                    if (onlyNonZeroWeight) {
                        Preconditions.checkState((weight > 0.0 ? 1 : 0) != 0);
                    }
                } else if (onlyNonZeroWeight) {
                    double weight = copy.getBranchWeight();
                    Preconditions.checkState((weight > 0.0 ? 1 : 0) != 0);
                }
                if (required != null) {
                    for (LogicTreeNode requiredNode : required) {
                        Preconditions.checkState((boolean)copy.hasValue(requiredNode), (String)"Built a branch but missed a required node: %s. Full branch: %s", (Object)requiredNode.getShortName(), copy);
                    }
                }
                branches.add(copy);
                continue;
            }
            LogicTree.buildBranchesRecursive(levels, branches, copy, curIndex + 1, onlyNonZeroWeight, weightProv, required);
        }
    }

    public static <E extends LogicTreeNode> LogicTree<E> fromExisting(List<LogicTreeLevel<? extends E>> levels, Collection<? extends LogicTreeBranch<E>> branches) {
        return new LogicTree<E>(levels, branches, DEFAULT_WEIGHTS);
    }

    public static void main(String[] args) {
        LogicTree fullU3 = LogicTree.buildExhaustive(U3LogicTreeBranch.getLogicTreeLevels(), true, new LogicTreeNode[0]);
        System.out.println("Built " + fullU3.branches.size() + " U3 branches. Weight: " + (float)fullU3.getTotalWeight());
        System.out.println("FM3.1 branches: " + fullU3.matchingAll((LogicTreeNode[])new LogicTreeNode[]{FaultModels.FM3_1}).branches.size());
        System.out.println("FM3.1or2 branches: " + fullU3.matchingAny((LogicTreeNode[])new LogicTreeNode[]{FaultModels.FM3_1, FaultModels.FM3_2}).branches.size());
    }

    @Override
    public String getFileName() {
        return "logic_tree.json";
    }

    @Override
    public String getName() {
        return "Logic Tree";
    }

    @Override
    public void writeToJSON(JsonWriter out, Gson gson) throws IOException {
        Adapter adapter = new Adapter();
        adapter.write(out, this);
    }

    @Override
    public void initFromJSON(JsonReader in, Gson gson) throws IOException {
        Adapter adapter = new Adapter();
        Object tree = adapter.read(in);
        this.levels = ((LogicTree)tree).levels;
        this.branches = ((LogicTree)tree).branches;
    }

    public void write(File jsonFile) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        BufferedWriter writer = new BufferedWriter(new FileWriter(jsonFile));
        gson.toJson((Object)this, LogicTree.class, (Appendable)writer);
        writer.close();
    }

    public static LogicTree<LogicTreeNode> read(File jsonFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        return LogicTree.read(reader);
    }

    public static LogicTree<LogicTreeNode> read(Reader jsonReader) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return (LogicTree)gson.fromJson(jsonReader, TypeToken.getParameterized(LogicTree.class, (Type[])new Type[]{LogicTreeNode.class}).getType());
    }

    public LogicTree<E> sorted(Comparator<? super LogicTreeBranch<E>> comparator) {
        ArrayList<LogicTreeBranch<? super LogicTreeBranch<E>>> sorted = new ArrayList<LogicTreeBranch<? super LogicTreeBranch<E>>>(this.branches);
        sorted.sort(comparator);
        return new LogicTree<E>(this.levels, sorted, this.weightProvider);
    }

    private static String simplifyChoiceString(String str) {
        str = str.replace(" ", "").replace("_", "").replace(",", "").toLowerCase();
        return str;
    }

    public static LogicTree<LogicTreeNode> readFileBacked(File jsonFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        return LogicTree.readFileBacked(reader);
    }

    public static LogicTree<LogicTreeNode> readFileBacked(Reader jsonReader) throws IOException {
        LogicTreeLevel.Adapter levelAdapter = new LogicTreeLevel.Adapter(true, true);
        Adapter treeAdapter = new Adapter(levelAdapter);
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LogicTreeLevel.class, levelAdapter).registerTypeHierarchyAdapter(LogicTreeLevel.class, levelAdapter).registerTypeAdapter(LogicTree.class, treeAdapter).registerTypeHierarchyAdapter(LogicTree.class, treeAdapter).create();
        return (LogicTree)gson.fromJson(jsonReader, TypeToken.getParameterized(LogicTree.class, (Type[])new Type[]{LogicTreeNode.class}).getType());
    }

    public static class Adapter<E extends LogicTreeNode>
    extends TypeAdapter<LogicTree<E>> {
        private final LogicTreeLevel.Adapter<E> levelAdapter;
        private final BranchWeightProvider.Adapter weightAdapter = new BranchWeightProvider.Adapter();

        public Adapter() {
            this(new LogicTreeLevel.Adapter());
        }

        public Adapter(LogicTreeLevel.Adapter<E> levelAdapter) {
            this.levelAdapter = levelAdapter;
        }

        public void write(JsonWriter out, LogicTree<E> value) throws IOException {
            out.beginObject();
            Class<?> type = null;
            for (LogicTreeBranch<E> logicTreeBranch : value) {
                if (type == null) {
                    type = logicTreeBranch.getClass();
                    continue;
                }
                if (type.equals(logicTreeBranch.getClass())) continue;
                type = null;
                break;
            }
            if (type != null) {
                out.name("type").value(type.getName());
            }
            out.name("levels").beginArray();
            for (LogicTreeLevel logicTreeLevel : value.levels) {
                this.levelAdapter.write(out, logicTreeLevel);
            }
            out.endArray();
            out.name("weightProvider");
            this.weightAdapter.write(out, value.weightProvider);
            out.name("branches").beginArray();
            for (LogicTreeBranch logicTreeBranch : value.branches) {
                out.beginArray();
                for (int i = 0; i < logicTreeBranch.size(); ++i) {
                    Object node = logicTreeBranch.getValue(i);
                    if (node == null) {
                        out.nullValue();
                        continue;
                    }
                    out.value(node.getFilePrefix());
                }
                out.endArray();
            }
            out.endArray();
            out.name("origWeights").beginArray();
            for (LogicTreeBranch logicTreeBranch : value.branches) {
                out.value(logicTreeBranch.getOrigBranchWeight());
            }
            out.endArray();
            out.endObject();
        }

        public LogicTree<E> read(JsonReader in) throws IOException {
            in.beginObject();
            Class<?> type = null;
            ArrayList<LogicTreeLevel<Object>> levels = null;
            ArrayList branches = null;
            ArrayList<Double> origWeights = null;
            BranchWeightProvider weightProvider = null;
            ArrayList nodeMatchCache = null;
            block18: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "type": {
                        try {
                            type = Class.forName(in.nextString());
                        }
                        catch (Exception e) {
                            System.err.println("WARNING: can't load branches for logic tree as given type: " + e.getMessage());
                        }
                        continue block18;
                    }
                    case "levels": {
                        levels = new ArrayList<LogicTreeLevel<Object>>();
                        in.beginArray();
                        nodeMatchCache = new ArrayList();
                        while (in.hasNext()) {
                            Object level = this.levelAdapter.read(in);
                            HashMap<String, LogicTreeNode> cache = new HashMap<String, LogicTreeNode>();
                            for (LogicTreeNode node : ((LogicTreeLevel)level).getNodes()) {
                                String perfectMatch = node.getFilePrefix();
                                if (cache.containsKey(perfectMatch)) {
                                    cache.clear();
                                    break;
                                }
                                cache.put(perfectMatch, node);
                            }
                            nodeMatchCache.add(cache);
                            levels.add((LogicTreeLevel<Object>)level);
                        }
                        in.endArray();
                        continue block18;
                    }
                    case "weightProvider": {
                        weightProvider = this.weightAdapter.read(in);
                        continue block18;
                    }
                    case "branches": {
                        Preconditions.checkNotNull(levels, (Object)"levels must be supplied before branches");
                        branches = new ArrayList();
                        in.beginArray();
                        while (in.hasNext()) {
                            LogicTreeBranch<Object> branch;
                            if (type == null) {
                                branch = new LogicTreeBranch<Object>(levels);
                            } else {
                                try {
                                    Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
                                    constructor.setAccessible(true);
                                    branch = (LogicTreeBranch<Object>)constructor.newInstance(new Object[0]);
                                }
                                catch (Exception e) {
                                    System.err.println("WARNING: cannot instantiate empty branch as '" + type.getName() + "', will load as default type. Exception: " + e.getMessage());
                                    branch = new LogicTreeBranch<Object>(levels);
                                }
                            }
                            branch.init(levels, null);
                            in.beginArray();
                            int index = 0;
                            while (in.hasNext()) {
                                LogicTreeLevel level = (LogicTreeLevel)levels.get(index);
                                String choice = in.nextString();
                                Map matchCache = (Map)nodeMatchCache.get(index);
                                LogicTreeNode node = (LogicTreeNode)matchCache.get(choice);
                                if (node == null) {
                                    String modChoice = LogicTree.simplifyChoiceString(choice);
                                    int numFuzzyMatches = 0;
                                    boolean perfectMatch = false;
                                    for (LogicTreeNode possible : level.getNodes()) {
                                        if (!choice.equals(possible.getFilePrefix())) continue;
                                        Preconditions.checkState((!perfectMatch ? 1 : 0) != 0, (String)"Multiple choices for %s match %s", (Object)level.getName(), (Object)choice);
                                        node = possible;
                                        perfectMatch = true;
                                    }
                                    if (!perfectMatch) {
                                        for (LogicTreeNode possible : level.getNodes()) {
                                            boolean match = modChoice.equals(LogicTree.simplifyChoiceString(possible.getShortName()));
                                            match = match || modChoice.equals(LogicTree.simplifyChoiceString(possible.getFilePrefix()));
                                            if (!(match = match || possible instanceof Enum && modChoice.equals(LogicTree.simplifyChoiceString(((Enum)((Object)possible)).name())))) continue;
                                            node = possible;
                                            ++numFuzzyMatches;
                                        }
                                    }
                                    Preconditions.checkNotNull((Object)node, (String)"No matching node found for intputName=%s for level %s", (Object)choice, (Object)level.getName());
                                    Preconditions.checkState((perfectMatch || numFuzzyMatches == 1 ? 1 : 0) != 0, (String)"%s choices for %s match %s", (Object)numFuzzyMatches, (Object)level.getName(), (Object)choice);
                                    matchCache.put(choice, node);
                                }
                                branch.setValue(index, node);
                                ++index;
                            }
                            in.endArray();
                            branches.add(branch);
                        }
                        in.endArray();
                        continue block18;
                    }
                    case "origWeights": {
                        origWeights = new ArrayList<Double>();
                        in.beginArray();
                        while (in.hasNext()) {
                            origWeights.add(in.nextDouble());
                        }
                        in.endArray();
                        continue block18;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            if (weightProvider == null) {
                weightProvider = DEFAULT_WEIGHTS;
            }
            if (origWeights != null) {
                Preconditions.checkState((origWeights.size() == branches.size() ? 1 : 0) != 0, (Object)"branch orig weights size does not match branch count");
                for (int i = 0; i < branches.size(); ++i) {
                    ((LogicTreeBranch)branches.get(i)).setOrigBranchWeight((Double)origWeights.get(i));
                }
            }
            return new LogicTree(levels, branches, weightProvider);
        }
    }
}

