/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt.elements;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.mapping.gmt.elements.PSXYElement;

public class PSXYPolygon
extends PSXYElement {
    private static final long serialVersionUID = 1L;
    private List<Point2D> points = new ArrayList<Point2D>();

    public PSXYPolygon(Point2D point1, Point2D point2) {
        this.points.add(point1);
        this.points.add(point2);
    }

    public PSXYPolygon(Location loc1, Location loc2) {
        this.points.add(new Point2D.Double(loc1.getLongitude(), loc1.getLatitude()));
        this.points.add(new Point2D.Double(loc2.getLongitude(), loc2.getLatitude()));
    }

    public PSXYPolygon(List<Point2D> points) {
        this.points = points;
    }

    public PSXYPolygon(LocationList locs) {
        for (Location loc : locs) {
            this.points.add(new Point2D.Double(loc.getLongitude(), loc.getLatitude()));
        }
    }

    public PSXYPolygon() {
    }

    public List<Point2D> getPoints() {
        return this.points;
    }

    public void addPoint(Point2D point) {
        this.points.add(point);
    }

    public boolean isValid() {
        return this.points != null && this.points.size() >= 2;
    }

    public int size() {
        return this.points.size();
    }
}

