/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;

public class CPTPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BufferedImage bi;
    private BufferedImageOp bufImgOp;
    private float minVal;
    private float maxVal;
    private Map<Float, JLabel> labelTable;
    private int tickWidth;
    private int barX;
    private int barY;
    private int barWidth;
    private int barHeight;
    private DecimalFormat df = null;
    private Font font = new Font("SansSerif", 1, 16);

    public CPTPanel(BufferedImage bufImg, Map<Float, JLabel> labelTable, int tickWidth, float minVal, float maxVal) {
        this.update(bufImg, labelTable, tickWidth, minVal, maxVal);
        this.init();
    }

    public CPTPanel(CPT cpt, int width, int height, int numTicks, int tickWidth) {
        this.update(cpt, width, height, numTicks, tickWidth);
        this.init();
    }

    private void init() {
        this.bufImgOp = new AffineTransformOp(new AffineTransform(), 1);
        this.setLayout(null);
    }

    public void setDecimalFormat(DecimalFormat df) {
        this.df = df;
    }

    public void update(CPT cpt, int width, int height, int numTicks, int tickWidth) {
        float maxVal;
        float minVal;
        HashMap<Float, JLabel> labelTable;
        BufferedImage bi = new BufferedImage(width, height, 2);
        if (cpt == null) {
            labelTable = null;
            minVal = 0.0f;
            maxVal = 1.0f;
        } else {
            labelTable = new HashMap<Float, JLabel>();
            minVal = (float)cpt.getMinValueRaw();
            maxVal = (float)cpt.getMaxValueRaw();
            cpt.paintGrid(bi);
            if (numTicks >= 0) {
                float delta = (maxVal - minVal) / (float)(numTicks + 1);
                for (float tickVal = minVal; tickVal <= maxVal; tickVal += delta) {
                    JLabel label = new JLabel(this.getTickLabel(tickVal));
                    labelTable.put(Float.valueOf(tickVal), label);
                }
            } else {
                int num = cpt.size();
                int mod = 1;
                while (num / mod > 10) {
                    ++mod;
                }
                for (int i = 0; i < num; ++i) {
                    if (i % mod != 0) continue;
                    float tickVal = (float)((CPTVal)cpt.get((int)i)).start;
                    JLabel label = new JLabel(this.getTickLabel(tickVal));
                    labelTable.put(Float.valueOf(tickVal), label);
                }
                if (num > 0) {
                    float tickVal = (float)((CPTVal)cpt.get((int)(num - 1))).end;
                    JLabel label = new JLabel(this.getTickLabel(tickVal));
                    labelTable.put(Float.valueOf(tickVal), label);
                }
            }
        }
        this.update(bi, labelTable, tickWidth, minVal, maxVal);
    }

    private String getTickLabel(float tickVal) {
        if (this.df == null) {
            return "" + tickVal;
        }
        return this.df.format(tickVal);
    }

    public void updateCPT(CPT cpt) {
        this.bi = new BufferedImage(this.bi.getWidth(), this.bi.getHeight(), 2);
        if (cpt != null) {
            cpt.paintGrid(this.bi);
        }
    }

    public void update(BufferedImage bufImg, Map<Float, JLabel> labelTable, int tickWidth, float minVal, float maxVal) {
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.labelTable = labelTable;
        this.tickWidth = tickWidth;
        this.bi = bufImg;
        this.removeAll();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        super.paintComponents(graphics);
        this.barX = (this.getWidth() - this.bi.getWidth()) / 2;
        this.barY = 27;
        this.barY = (this.getHeight() - this.bi.getHeight()) / 2;
        this.barWidth = this.bi.getWidth();
        this.barHeight = this.bi.getHeight();
        if (this.labelTable != null) {
            this.removeAll();
            float pixSpace = (this.maxVal - this.minVal) / (float)this.barWidth;
            for (float dist : this.labelTable.keySet()) {
                int pixOver = (int)((dist - this.minVal) / pixSpace);
                JLabel label = this.labelTable.get(Float.valueOf(dist));
                label.updateUI();
                Dimension d = label.getPreferredSize();
                label.setBounds(this.barX + pixOver - d.width / 2, this.barY + this.barHeight + this.tickWidth + 4, d.width, d.height);
                this.add(label);
            }
            this.invalidate();
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.drawImage(this.bi, this.bufImgOp, this.barX, this.barY);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(this.barX - 1, this.barY - 1, this.barWidth + 1, this.barHeight + 1);
        if (this.labelTable != null) {
            float pixSpace = (this.maxVal - this.minVal) / (float)this.barWidth;
            for (float dist : this.labelTable.keySet()) {
                int pixOver = (int)((dist - this.minVal) / pixSpace);
                if (pixOver == 0) {
                    pixOver = -1;
                }
                g2d.drawLine(this.barX + pixOver, this.barY + this.barHeight, this.barX + pixOver, this.barY + this.barHeight + this.tickWidth);
            }
        }
    }
}

