/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.constraint.impl;

import java.util.ArrayList;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.param.constraint.AbstractParameterConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;

public class EstimateConstraint
extends AbstractParameterConstraint<Estimate> {
    private static final long serialVersionUID = 1L;
    protected static final String C = "DoubleEstimateConstraint";
    protected static final boolean D = false;
    protected Double min = null;
    protected Double max = null;
    protected StringConstraint allowedEstimateList = null;

    public EstimateConstraint() {
    }

    public EstimateConstraint(ArrayList<String> allowedEstimateList) {
        this(null, null, allowedEstimateList);
    }

    public EstimateConstraint(double min, double max) {
        this(min, max, (ArrayList)null);
    }

    public EstimateConstraint(double min, double max, ArrayList allowedEstimateList) {
        this((Double)min, (Double)max, (ArrayList<String>)allowedEstimateList);
    }

    public EstimateConstraint(Double min, Double max, ArrayList<String> allowedEstimateList) {
        this.min = min;
        this.max = max;
        this.setAllowedEstimateList(allowedEstimateList);
    }

    public void setAllowedEstimateList(ArrayList<String> allowedEstimateList) throws EditableException {
        String S = "DoubleEstimateConstraint: setAllowedEstimateList(StringConstraint): ";
        this.checkEditable(S);
        this.allowedEstimateList = new StringConstraint(allowedEstimateList);
    }

    public ArrayList getAllowedEstimateList() {
        return this.allowedEstimateList.getAllowedStrings();
    }

    @Override
    public boolean isAllowed(Estimate estimate) {
        if (this.allowedEstimateList == null) {
            return true;
        }
        ArrayList<String> list = this.allowedEstimateList.getAllowedStrings();
        for (int i = 0; i < list.size(); ++i) {
            String name = list.get(i);
            if (!estimate.getName().equalsIgnoreCase(name)) continue;
            Double estimateMinValue = estimate.getMin();
            Double estimateMaxValue = estimate.getMax();
            if (this.min == null && this.max == null) {
                return true;
            }
            if (this.min == null || this.max == null || estimateMinValue.compareTo(this.min) < 0 || estimateMaxValue.compareTo(this.max) > 0) break;
            return true;
        }
        return false;
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        if (this.allowedEstimateList != null) {
            b.append(TAB + "Allowed Estimates = " + this.allowedEstimateList.toString());
        }
        return b.toString();
    }

    @Override
    public Object clone() {
        EstimateConstraint c1 = new EstimateConstraint(this.min, this.max, (ArrayList<String>)((ArrayList)this.allowedEstimateList.getAllowedStrings().clone()));
        c1.setName(this.name);
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }

    public static ArrayList createConstraintForPositiveDoubleValues() {
        ArrayList<String> allowedEstimateTypes = new ArrayList<String>();
        allowedEstimateTypes.add("Normal (Gaussian)");
        allowedEstimateTypes.add("Fractile List");
        allowedEstimateTypes.add("Discrete Values");
        allowedEstimateTypes.add("Min, Max and Preferred");
        allowedEstimateTypes.add("PDF");
        return allowedEstimateTypes;
    }

    public static ArrayList createConstraintForPositiveIntValues() {
        ArrayList<String> allowedEstimateTypes = new ArrayList<String>();
        allowedEstimateTypes.add("Integer");
        return allowedEstimateTypes;
    }

    public static ArrayList createConstraintForAllEstimates() {
        ArrayList<String> allowedEstimateTypes = new ArrayList<String>();
        allowedEstimateTypes.add("Normal (Gaussian)");
        allowedEstimateTypes.add("Fractile List");
        allowedEstimateTypes.add("Discrete Values");
        allowedEstimateTypes.add("Integer");
        allowedEstimateTypes.add("Min, Max and Preferred");
        allowedEstimateTypes.add("PDF");
        return allowedEstimateTypes;
    }

    public static ArrayList createConstraintForDateEstimates() {
        ArrayList<String> allowedEstimateTypes = new ArrayList<String>();
        allowedEstimateTypes.add("Normal (Gaussian)");
        allowedEstimateTypes.add("Discrete Values");
        allowedEstimateTypes.add("Min, Max and Preferred");
        allowedEstimateTypes.add("PDF");
        return allowedEstimateTypes;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }
}

