/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.constraint.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.param.constraint.AbstractParameterConstraint;
import org.opensha.commons.param.constraint.DiscreteParameterConstraint;

public class StringConstraint
extends AbstractParameterConstraint<String>
implements DiscreteParameterConstraint<String> {
    private static final long serialVersionUID = 1L;
    protected static final String C = "StringConstraint";
    protected static final boolean D = false;
    private ArrayList<String> strings = new ArrayList();

    public StringConstraint() {
    }

    public StringConstraint(String ... strings) {
        this(Lists.newArrayList((Object[])strings));
    }

    public StringConstraint(List<String> strings) throws ConstraintException {
        if (strings.size() <= 0) {
            String S = "StringConstraint: Constructor(ArrayList strings): ";
            throw new ConstraintException(S + "Input vector of constraint values cannot be empty");
        }
        this.strings.addAll(strings);
    }

    public void setStrings(ArrayList strings) throws ConstraintException, EditableException {
        String S = "StringConstraint: setStrings(): ";
        this.checkEditable(S);
        if (strings == null || strings.size() <= 0) {
            throw new ConstraintException(S + "Input vector of constraint values cannot be null or empty");
        }
        this.strings = strings;
    }

    public ArrayList<String> getAllowedStrings() {
        return (ArrayList)this.strings.clone();
    }

    @Override
    public ArrayList<String> getAllowedValues() {
        return this.getAllowedStrings();
    }

    @Override
    public boolean isAllowed(String obj) {
        if (this.nullAllowed && obj == null) {
            return true;
        }
        if (!(obj instanceof String)) {
            return false;
        }
        return this.containsString(obj.toString());
    }

    @Override
    public ListIterator listIterator() {
        return this.strings.listIterator();
    }

    public void addString(String str) throws EditableException {
        this.checkEditable("StringConstraint: addString(): ");
        if (!this.containsString(str)) {
            this.strings.add(str);
        }
    }

    public void removeString(String str) throws EditableException {
        this.checkEditable("StringConstraint: removeString(): ");
        if (this.containsString(str)) {
            this.strings.remove(str);
        }
    }

    public boolean containsString(String str) {
        return this.strings.contains(str);
    }

    @Override
    public int size() {
        return this.strings.size();
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer b = new StringBuffer();
        b.append(C);
        if (this.name != null) {
            b.append(TAB + "Name = " + this.name + "\n");
        }
        b.append(TAB + "Allowed values = ");
        boolean first = true;
        ListIterator<String> it = this.strings.listIterator();
        while (it.hasNext()) {
            if (!first) {
                b.append(TAB + ", " + String.valueOf(it.next()));
                continue;
            }
            b.append(TAB + String.valueOf(it.next()));
            first = false;
        }
        b.append(TAB + "Null Allowed = " + this.nullAllowed + "\n");
        return b.toString();
    }

    @Override
    public Object clone() {
        StringConstraint c1 = new StringConstraint();
        c1.name = this.name;
        ArrayList<String> v = this.getAllowedStrings();
        ListIterator<String> it = v.listIterator();
        while (it.hasNext()) {
            String val = it.next();
            c1.addString(val);
        }
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }
}

