/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.constraint.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.param.constraint.AbstractParameterConstraint;
import org.opensha.commons.param.constraint.DiscreteParameterConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;

public class StringListConstraint
extends AbstractParameterConstraint<List<String>>
implements DiscreteParameterConstraint<List<String>> {
    private static final long serialVersionUID = 1L;
    private StringConstraint strConst;

    public StringListConstraint() {
        this(null);
    }

    public StringListConstraint(List<String> strings) throws ConstraintException {
        this.strConst = strings == null ? new StringConstraint() : new StringConstraint(strings);
    }

    @Override
    public boolean isAllowed(List<String> valsList) {
        int size = valsList.size();
        for (int i = 0; i < size; ++i) {
            if (!(valsList.get(i) instanceof String)) {
                return false;
            }
            if (this.strConst.isAllowed(valsList.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object clone() {
        StringListConstraint c1 = new StringListConstraint();
        c1.name = this.name;
        ArrayList<String> v = this.strConst.getAllowedStrings();
        ListIterator<String> it = v.listIterator();
        while (it.hasNext()) {
            String val = it.next();
            c1.addString(val);
        }
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }

    public void addString(String str) throws EditableException {
        this.checkEditable("ParameterConstraint: addString(): ");
        this.strConst.addString(str);
    }

    public ArrayList getAllowedValues() {
        return this.strConst.getAllowedValues();
    }

    @Override
    public ListIterator listIterator() {
        return this.strConst.listIterator();
    }

    @Override
    public int size() {
        return this.strConst.size();
    }
}

