/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.IntegerDiscreteConstraint;
import org.opensha.commons.param.editor.AbstractParameterEditor;

public class ConstrainedIntegerDiscreteParameterEditor
extends AbstractParameterEditor<Integer>
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final String C = "ConstrainedDoubleDiscreteParameterEditor";
    protected static final boolean D = false;
    private JComponent widget;

    public ConstrainedIntegerDiscreteParameterEditor() {
    }

    public ConstrainedIntegerDiscreteParameterEditor(Parameter<Integer> model) throws ConstraintException {
        super(model);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String S = "ConstrainedDoubleDiscreteParameterEditor: itemStateChanged(): ";
        Integer value = (Integer)((JComboBox)this.widget).getSelectedItem();
        this.setValue(value);
    }

    @Override
    public boolean isParameterSupported(Parameter<Integer> param) {
        if (param == null) {
            return false;
        }
        if (!(param.getValue() instanceof Integer)) {
            return false;
        }
        ParameterConstraint constraint = param.getConstraint();
        if (constraint == null) {
            return false;
        }
        if (constraint.isNullAllowed()) {
            return false;
        }
        if (!(constraint instanceof IntegerDiscreteConstraint)) {
            return false;
        }
        IntegerDiscreteConstraint iconst = (IntegerDiscreteConstraint)constraint;
        int numConstriants = iconst.size();
        return numConstriants >= 1;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.widget != null) {
            this.widget.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.widget != null && this.widget.isEnabled();
    }

    @Override
    protected JComponent buildWidget() {
        IntegerDiscreteConstraint con = (IntegerDiscreteConstraint)this.getParameter().getConstraint();
        ArrayList<Integer> vals = con.getAllowed();
        if (vals.size() > 1) {
            JComboBox<Object> combo = new JComboBox<Object>(vals.toArray());
            combo.setMaximumRowCount(32);
            this.widget = combo;
            this.widget.setPreferredSize(WIGET_PANEL_DIM);
            this.widget.setMinimumSize(WIGET_PANEL_DIM);
            combo.setSelectedIndex(vals.indexOf(this.getParameter().getValue()));
            combo.addItemListener(this);
        } else {
            JLabel label = ConstrainedIntegerDiscreteParameterEditor.makeSingleConstraintValueLabel(vals.get(0).toString());
            this.widget = new JPanel(new BorderLayout());
            this.widget.setBackground(Color.LIGHT_GRAY);
            this.widget.add(label);
        }
        return this.widget;
    }

    @Override
    protected JComponent updateWidget() {
        IntegerDiscreteConstraint con = (IntegerDiscreteConstraint)this.getParameter().getConstraint();
        ArrayList<Integer> vals = con.getAllowed();
        if (vals.size() > 1) {
            if (this.widget instanceof JComboBox) {
                JComboBox combo = (JComboBox)this.widget;
                combo.removeItemListener(this);
                combo.setModel(new DefaultComboBoxModel<Object>(vals.toArray()));
                combo.setSelectedIndex(vals.indexOf(this.getParameter().getValue()));
                combo.addItemListener(this);
                return this.widget;
            }
            return this.buildWidget();
        }
        return this.buildWidget();
    }
}

