/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.WarningException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.editor.impl.NumericTextField;

public class DoubleParameterEditor
extends AbstractParameterEditor<Double>
implements FocusListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    protected static final String C = "DoubleParameterEditor";
    protected static final boolean D = false;
    private NumericTextField widget;
    private boolean focusLostProcessing = false;
    private boolean keyTypeProcessing = false;

    protected DoubleParameterEditor() {
    }

    public DoubleParameterEditor(Parameter model) throws Exception {
        super(model);
    }

    @Override
    protected JComponent buildWidget() {
        String S = "DoubleParameterEditorDoubleParameterEditor: addWidget(): ";
        this.widget = new NumericTextField();
        this.widget.setMinimumSize(LABEL_DIM);
        this.widget.setPreferredSize(LABEL_DIM);
        this.widget.setBorder(ETCHED);
        this.widget.setFont(DEFAULT_FONT);
        this.widget.addFocusListener(this);
        this.widget.addKeyListener(this);
        this.updateWidget();
        return this.widget;
    }

    @Override
    public void keyTyped(KeyEvent e) throws NumberFormatException {
        String S = "DoubleParameterEditor: keyTyped(): ";
        this.keyTypeProcessing = false;
        if (this.focusLostProcessing) {
            return;
        }
        if (e.getKeyChar() == '\n') {
            this.keyTypeProcessing = true;
            String value = this.widget.getText();
            try {
                Double d = null;
                if (!value.equals("")) {
                    d = Double.valueOf(value);
                }
                this.setValue(d);
                this.refreshParamEditor();
                this.widget.validate();
                this.widget.repaint();
            }
            catch (ConstraintException ee) {
                Object obj = this.getValue();
                if (obj != null) {
                    this.widget.setText(obj.toString());
                } else {
                    this.widget.setText("");
                }
                this.unableToSetValue(value);
                this.keyTypeProcessing = false;
            }
            catch (NumberFormatException ee) {
                Object obj = this.getValue();
                if (obj != null) {
                    this.widget.setText(obj.toString());
                } else {
                    this.widget.setText("");
                }
                this.unableToSetValue(value);
                this.keyTypeProcessing = false;
            }
            catch (WarningException ee) {
                this.keyTypeProcessing = false;
                this.refreshParamEditor();
                this.widget.validate();
                this.widget.repaint();
            }
        }
        this.keyTypeProcessing = false;
    }

    @Override
    public void focusLost(FocusEvent e) throws ConstraintException {
        String S = "DoubleParameterEditor: focusLost(): ";
        this.focusLostProcessing = false;
        if (this.keyTypeProcessing) {
            return;
        }
        this.focusLostProcessing = true;
        String value = this.widget.getText();
        try {
            Double d = null;
            if (!value.equals("")) {
                d = Double.valueOf(value);
            }
            this.setValue(d);
            this.refreshParamEditor();
            this.widget.validate();
            this.widget.repaint();
        }
        catch (ConstraintException ee) {
            Object obj = this.getValue();
            if (obj != null) {
                this.widget.setText(obj.toString());
            } else {
                this.widget.setText("");
            }
            this.unableToSetValue(value);
            this.focusLostProcessing = false;
        }
        catch (NumberFormatException ee) {
            Object obj = this.getValue();
            if (obj != null) {
                this.widget.setText(obj.toString());
            } else {
                this.widget.setText("");
            }
            this.unableToSetValue(value);
            this.keyTypeProcessing = false;
        }
        catch (WarningException ee) {
            this.focusLostProcessing = false;
            this.refreshParamEditor();
            this.widget.validate();
            this.widget.repaint();
        }
        this.focusLostProcessing = false;
    }

    @Override
    public boolean isParameterSupported(Parameter<Double> param) {
        if (param == null) {
            return false;
        }
        return param.getValue() == null || param.getValue() instanceof Double;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.widget != null) {
            this.widget.setEditable(enabled);
            this.widget.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.widget != null && this.widget.isEnabled();
    }

    @Override
    protected JComponent updateWidget() {
        Double val = (Double)this.getValue();
        if (val == null) {
            this.widget.setText("");
        } else {
            this.widget.setText(val.toString());
        }
        return this.widget;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

