/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.impl.EnumConstraint;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.impl.EnumParameter;

public class EnumParameterEditor<E extends Enum<E>>
extends AbstractParameterEditor<E>
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final String C = "EnumParameterEditor";
    protected static final boolean D = false;
    private JComboBox widget;
    private Class<E> clazz;

    public EnumParameterEditor(EnumParameter<E> model, Class<E> clazz) {
        super(model);
        this.clazz = clazz;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object obj = this.widget.getSelectedItem();
        this.setValue(obj instanceof String ? null : (Enum)this.clazz.cast(obj));
    }

    @Override
    public boolean isParameterSupported(Parameter<E> param) {
        return param != null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.widget != null) {
            this.widget.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.widget != null && this.widget.isEnabled();
    }

    @Override
    protected JComponent buildWidget() {
        this.widget = new JComboBox(new DefaultComboBoxModel(this.buildModel()));
        this.widget.setModel(new DefaultComboBoxModel(this.buildModel()));
        this.widget.setMaximumRowCount(40);
        String nullOption = ((EnumParameter)this.getParameter()).getNullOption();
        Enum value = (Enum)this.getParameter().getValue();
        this.widget.setSelectedItem(value == null ? nullOption : value);
        this.widget.addItemListener(this);
        this.widget.setPreferredSize(WIGET_PANEL_DIM);
        this.widget.setMinimumSize(WIGET_PANEL_DIM);
        return this.widget;
    }

    @Override
    protected JComponent updateWidget() {
        this.widget.removeItemListener(this);
        this.widget.setModel(new DefaultComboBoxModel(this.buildModel()));
        String nullOption = ((EnumParameter)this.getParameter()).getNullOption();
        Enum value = (Enum)this.getParameter().getValue();
        this.widget.setSelectedItem(value == null ? nullOption : value);
        this.widget.addItemListener(this);
        return this.widget;
    }

    private Vector<?> buildModel() {
        EnumConstraint con = (EnumConstraint)this.getParameter().getConstraint();
        Vector<String> v = new Vector<String>();
        String nullOption = ((EnumParameter)this.getParameter()).getNullOption();
        if (nullOption != null) {
            v.add(nullOption);
        }
        v.addAll(con.getAllowedValues());
        return v;
    }
}

