/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.WarningException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.editor.impl.IntegerTextField;

public class IntegerParameterEditor
extends AbstractParameterEditor<Integer>
implements FocusListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private boolean focusLostProcessing = false;
    private boolean keyTypeProcessing = false;
    private IntegerTextField widget;
    protected static final String C = "IntegerParameterEditor";
    protected static final boolean D = false;

    public IntegerParameterEditor() {
    }

    public IntegerParameterEditor(Parameter model) throws Exception {
        super(model);
    }

    @Override
    public void keyTyped(KeyEvent e) throws NumberFormatException {
        String S = "IntegerParameterEditor: valueEditor_keyTyped(): ";
        this.keyTypeProcessing = false;
        if (this.focusLostProcessing) {
            return;
        }
        if (e.getKeyChar() == '\n') {
            this.keyTypeProcessing = true;
            String value = this.widget.getText();
            try {
                Integer d = null;
                if (!value.trim().equals("")) {
                    d = Integer.valueOf(value);
                }
                this.setValue(d);
                this.refreshParamEditor();
                this.widget.validate();
                this.widget.repaint();
            }
            catch (ConstraintException ee) {
                Object obj = this.getValue();
                if (obj != null) {
                    this.widget.setText(obj.toString());
                } else {
                    this.widget.setText(" ");
                }
                this.unableToSetValue(value);
                this.keyTypeProcessing = false;
            }
            catch (WarningException ee) {
                this.keyTypeProcessing = false;
                this.refreshParamEditor();
                this.widget.validate();
                this.widget.repaint();
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) throws ConstraintException {
        String S = "IntegerParameterEditor: focusLost(): ";
        this.focusLostProcessing = false;
        if (this.keyTypeProcessing) {
            return;
        }
        this.focusLostProcessing = true;
        String value = this.widget.getText();
        try {
            Integer d = null;
            if (!value.trim().equals("")) {
                d = Integer.valueOf(value);
            }
            this.setValue(d);
            this.refreshParamEditor();
            this.widget.validate();
            this.widget.repaint();
        }
        catch (ConstraintException ee) {
            Object obj = this.getValue();
            if (obj != null) {
                this.widget.setText(obj.toString());
            } else {
                this.widget.setText(" ");
            }
            this.unableToSetValue(value);
            this.focusLostProcessing = false;
        }
        catch (WarningException ee) {
            this.focusLostProcessing = false;
            this.refreshParamEditor();
            this.widget.validate();
            this.widget.repaint();
        }
        this.focusLostProcessing = false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.widget != null) {
            this.widget.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.widget != null && this.widget.isEnabled();
    }

    @Override
    protected JComponent buildWidget() {
        this.widget = new IntegerTextField();
        this.widget.setMinimumSize(LABEL_DIM);
        this.widget.setPreferredSize(LABEL_DIM);
        this.widget.setBorder(ETCHED);
        this.widget.setFont(DEFAULT_FONT);
        this.widget.addFocusListener(this);
        this.widget.addKeyListener(this);
        this.updateWidget();
        return this.widget;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    protected JComponent updateWidget() {
        Integer value = (Integer)this.getValue();
        if (value != null) {
            this.widget.setText(value.toString());
        } else {
            this.widget.setText("");
        }
        return this.widget;
    }

    @Override
    public boolean isParameterSupported(Parameter<Integer> param) {
        if (param == null) {
            return false;
        }
        return param.getValue() instanceof Integer;
    }
}

