/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.ParameterListParameter;

public class ParameterListParameterEditor
extends AbstractParameterEditor<ParameterList>
implements ActionListener,
ParameterChangeListener {
    private static final long serialVersionUID = 1L;
    protected static final String C = "ParameterListParameterEditor";
    protected static final boolean D = false;
    protected ParameterListEditor editor;
    private JButton button;
    protected JDialog frame;
    protected boolean parameterChangeFlag;
    private boolean useButton;
    private boolean modal = true;
    private Dimension dialogDims = new Dimension(300, 400);
    private Point dialogPosition = null;

    public ParameterListParameterEditor(Parameter<ParameterList> model) {
        this(model, true);
    }

    public ParameterListParameterEditor(Parameter<ParameterList> model, boolean useButton) {
        super(model);
        this.useButton = useButton;
        this.refreshParamEditor();
    }

    public void setDialogDimensions(Dimension dialogDims) {
        this.dialogDims = dialogDims;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.editor.setEnabled(isEnabled);
        if (this.useButton) {
            this.button.setEnabled(isEnabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.editor != null && this.editor.isEnabled();
    }

    public void setParameterVisible(String parameterName, boolean visible) {
        this.editor.setParameterVisible(parameterName, visible);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button) {
            if (this.frame != null && this.frame.getWidth() > 0) {
                this.dialogDims = this.frame.getSize();
            }
            if (this.frame != null) {
                this.dialogPosition = this.frame.getLocation();
            }
            this.parameterChangeFlag = false;
            this.frame = new JDialog();
            this.frame.setModal(this.modal);
            this.frame.setSize(this.dialogDims);
            if (this.dialogPosition != null) {
                this.frame.setLocation(this.dialogPosition);
            }
            this.frame.setTitle(this.getParameter().getName());
            this.frame.getContentPane().setLayout(new GridBagLayout());
            this.frame.getContentPane().add((Component)this.editor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
            JButton button = new JButton();
            button.setText("Update " + this.getParameter().getName());
            button.setForeground(new Color(80, 80, 133));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParameterListParameterEditor.this.button_actionPerformed(e);
                }
            });
            this.frame.getContentPane().add((Component)button, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.frame.setVisible(true);
        }
    }

    protected void button_actionPerformed(ActionEvent e) {
        ParameterList paramList = this.editor.getParameterList();
        if (this.parameterChangeFlag) {
            Parameter<ParameterList> param = this.getParameter();
            param.setValue(paramList);
            param.firePropertyChange(new ParameterChangeEvent(param, param.getName(), param.getValue(), param.getValue()));
            this.parameterChangeFlag = false;
        }
        this.frame.dispose();
    }

    @Override
    public boolean isParameterSupported(Parameter<ParameterList> param) {
        if (param == null) {
            return false;
        }
        return param instanceof ParameterListParameter;
    }

    @Override
    protected JComponent buildWidget() {
        ParameterList paramList = (ParameterList)this.getParameter().getValue();
        ListIterator<Parameter<?>> it = paramList.getParametersIterator();
        while (it.hasNext()) {
            it.next().addParameterChangeListener(this);
        }
        this.editor = new ParameterListEditor(paramList);
        this.editor.setTitle("Set " + this.getParameter().getName());
        if (this.useButton) {
            this.button = new JButton(this.getParameter().getName());
            this.button.addActionListener(this);
            return this.button;
        }
        return this.editor;
    }

    @Override
    protected JComponent updateWidget() {
        ParameterList paramList = (ParameterList)this.getParameter().getValue();
        ListIterator<Parameter<?>> it = paramList.getParametersIterator();
        while (it.hasNext()) {
            it.next().addParameterChangeListener(this);
        }
        this.editor.setParameterList(paramList);
        if (this.useButton) {
            if (this.button == null) {
                this.button = new JButton(this.getParameter().getName());
                this.button.addActionListener(this);
            } else {
                this.button.setText(this.getParameter().getName());
            }
            return this.button;
        }
        return this.editor;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
        if (this.frame != null) {
            this.frame.setModal(modal);
        }
    }
}

