/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.WarningException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.impl.StringParameter;

public class StringParameterEditor
extends AbstractParameterEditor<String>
implements FocusListener,
KeyListener {
    private boolean focusLostProcessing = false;
    private boolean keyTypeProcessing = false;
    private static final long serialVersionUID = 1L;
    protected static final String C = "StringParameterEditor";
    protected static final boolean D = false;
    private JTextField widget;

    protected StringParameterEditor() {
    }

    public StringParameterEditor(Parameter model) throws Exception {
        super(model);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        String S = "StringParameterEditor: keyTyped(): ";
        this.keyTypeProcessing = false;
        if (this.focusLostProcessing) {
            return;
        }
        if (e.getKeyChar() == '\n') {
            this.keyTypeProcessing = true;
            String value = this.widget.getText();
            try {
                String d = "";
                if (!value.equals("")) {
                    d = value;
                }
                this.setValue(d);
                this.refreshParamEditor();
                this.widget.validate();
                this.widget.repaint();
            }
            catch (ConstraintException ee) {
                Object obj = this.getValue();
                if (obj == null) {
                    this.widget.setText("");
                } else {
                    this.widget.setText(obj.toString());
                }
                this.unableToSetValue(value);
                this.keyTypeProcessing = false;
            }
            catch (WarningException ee) {
                this.keyTypeProcessing = false;
                this.refreshParamEditor();
                this.widget.validate();
                this.widget.repaint();
            }
        }
        this.keyTypeProcessing = false;
    }

    @Override
    public void focusLost(FocusEvent e) {
        String S = "StringParameterEditor: focusLost(): ";
        this.focusLostProcessing = false;
        if (this.keyTypeProcessing) {
            return;
        }
        this.focusLostProcessing = true;
        String value = this.widget.getText();
        try {
            String d = "";
            if (!value.equals("")) {
                d = value;
            }
            this.setValue(d);
            this.refreshParamEditor();
            this.widget.validate();
            this.widget.repaint();
        }
        catch (ConstraintException ee) {
            Object obj = this.getValue();
            if (obj == null) {
                this.widget.setText("");
            } else {
                this.widget.setText(obj.toString());
            }
            this.unableToSetValue(value);
            this.focusLostProcessing = false;
        }
        catch (WarningException ee) {
            this.focusLostProcessing = false;
            this.refreshParamEditor();
            this.widget.validate();
            this.widget.repaint();
        }
        this.focusLostProcessing = false;
    }

    @Override
    public boolean isParameterSupported(Parameter<String> param) {
        return this.getParameter() == null || this.getParameter() instanceof StringParameter;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.widget != null) {
            this.widget.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.widget != null && this.widget.isEnabled();
    }

    @Override
    protected JComponent buildWidget() {
        this.widget = new JTextField();
        this.widget.setPreferredSize(LABEL_DIM);
        this.widget.setMinimumSize(LABEL_DIM);
        this.widget.setBorder(ETCHED);
        this.widget.addFocusListener(this);
        this.widget.addKeyListener(this);
        this.updateWidget();
        return this.widget;
    }

    @Override
    protected JComponent updateWidget() {
        String val = (String)this.getValue();
        if (val == null || val.length() == 0) {
            this.widget.setText("");
        } else {
            this.widget.setText(val);
        }
        return this.widget;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

