/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.impl;

import java.util.List;
import java.util.NoSuchElementException;
import org.dom4j.Element;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.constraint.impl.ListBasedConstraint;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedCPTParameterEditor;
import org.opensha.commons.util.cpt.CPT;

public class CPTParameter
extends AbstractParameter<CPT> {
    private static final long serialVersionUID = 1L;
    private transient ParameterEditor<CPT> editor;

    public CPTParameter(String name) {
        this(name, null);
    }

    public CPTParameter(String name, CPT value) {
        super(name, null, null, value);
    }

    public CPTParameter(String name, List<CPT> allowed, CPT value) {
        this(name, new ListBasedConstraint<CPT>(allowed), value);
    }

    public CPTParameter(String name, ListBasedConstraint<CPT> constraint, CPT value) {
        super(name, constraint, null, value);
    }

    @Override
    public ParameterEditor<CPT> getEditor() {
        if (this.hasValidConstraint()) {
            if (this.editor == null) {
                this.editor = new ConstrainedCPTParameterEditor(this);
            }
            return this.editor;
        }
        return null;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.editor != null;
    }

    @Override
    protected boolean setIndividualParamValueFromXML(Element el) {
        return false;
    }

    private boolean hasValidConstraint() {
        return this.getConstraint() != null && this.getConstraint() instanceof ListBasedConstraint;
    }

    public void setByName(String name) throws NoSuchElementException, UnsupportedOperationException {
        if (this.hasValidConstraint()) {
            ListBasedConstraint lconst = (ListBasedConstraint)this.getConstraint();
            for (CPT cpt : lconst.getAllowed()) {
                if (!name.equals(cpt.getName())) continue;
                this.setValue(cpt);
                return;
            }
            throw new NoSuchElementException("No CPT named '" + name + "'");
        }
        throw new UnsupportedOperationException("Can't set by name without a constraint");
    }

    @Override
    public void setValue(String name) {
        this.setByName(name);
    }

    @Override
    public Object clone() {
        return null;
    }
}

