/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.impl;

import org.dom4j.Element;
import org.jfree.data.Range;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.constraint.impl.RangeConstraint;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.RangeParameterEditor;

public class RangeParameter
extends AbstractParameter<Range> {
    private RangeParameterEditor editor;

    public RangeParameter(String name, Range value) {
        this(name, null, value);
    }

    public RangeParameter(String name, Range constraintRange, Range value) {
        super(name, RangeParameter.buildConstraint(constraintRange), null, value);
    }

    private static RangeConstraint buildConstraint(Range constraintRange) {
        if (constraintRange == null) {
            return null;
        }
        return new RangeConstraint(constraintRange);
    }

    @Override
    public synchronized ParameterEditor getEditor() {
        if (this.editor == null) {
            this.editor = new RangeParameterEditor(this);
        }
        return this.editor;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.editor != null;
    }

    @Override
    public Object clone() {
        RangeParameter param = new RangeParameter(this.getName(), (Range)this.getValue());
        param.setUnits(this.getUnits());
        if (this.constraint != null) {
            param.setConstraint((RangeConstraint)this.constraint.clone());
        }
        return param;
    }

    @Override
    protected boolean setIndividualParamValueFromXML(Element el) {
        try {
            String str = el.attributeValue("value").trim();
            if (!str.startsWith("Range[") || !str.endsWith("]")) {
                return false;
            }
            str = str.substring(str.indexOf("[") + 1);
            if (!(str = str.substring(0, str.length() - 1)).contains(",")) {
                return false;
            }
            String[] split = str.split(",");
            if (split.length != 2) {
                return false;
            }
            double lower = Double.parseDouble(split[0]);
            double upper = Double.parseDouble(split[1]);
            this.setValue(new Range(lower, upper));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(new Range(0.5, 10.0));
    }
}

