/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.impl;

import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.exceptions.WarningException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.AbstractParameterConstraint;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.TranslatedWarningDoubleParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.WarningDoubleParameter;
import org.opensha.commons.param.translate.LogTranslator;
import org.opensha.commons.param.translate.TranslatorAPI;

public class TranslatedWarningDoubleParameter
extends WarningDoubleParameter {
    private static final long serialVersionUID = 1L;
    protected static final String C = "TranslatedWarningDoubleParameter";
    protected static final boolean D = false;
    protected TranslatorAPI trans = new LogTranslator();
    protected boolean translate = true;
    protected WarningDoubleParameter param = null;
    private transient ParameterEditor<Double> paramEdit = null;

    public boolean isTranslate() {
        return this.translate;
    }

    public void setTranslate(boolean translate) {
        this.translate = translate;
    }

    public TranslatedWarningDoubleParameter(WarningDoubleParameter param) {
        super(param.getName() + "Translated");
        this.param = param;
    }

    public TranslatedWarningDoubleParameter(WarningDoubleParameter param, TranslatorAPI trans) {
        super(param.getName() + "Translated");
        this.trans = trans;
        this.param = param;
    }

    public void setParameter(WarningDoubleParameter param) {
        this.param = param;
    }

    public WarningDoubleParameter getParameter() {
        return this.param;
    }

    @Override
    public Double getWarningMin() {
        Double min = this.param.getWarningMin();
        if (min == null || !this.translate) {
            return min;
        }
        return this.trans.reverse(min);
    }

    @Override
    public boolean isAllowed(Double value) {
        if (value == null || value instanceof Double || !this.translate) {
            return this.param.isAllowed(value);
        }
        double d = value;
        return this.param.isAllowed(this.trans.translate(d));
    }

    @Override
    public Double getWarningMax() {
        Double max = this.param.getWarningMax();
        if (max == null || !this.translate) {
            return max;
        }
        return this.trans.reverse(max);
    }

    @Override
    public synchronized void setValue(Double value) throws ConstraintException, WarningException {
        String S = this.getName() + ": setValue(): ";
        if (value == null || !this.translate || !(value instanceof Double)) {
            this.param.setValue(value);
        } else {
            Double dUntranslated = value;
            Double dTranslated = this.trans.translate(dUntranslated);
            if (!this.param.isAllowed(dTranslated)) {
                String err = S + "Value is not allowed: ";
                if (value != null) {
                    err = err + dUntranslated.toString();
                }
                throw new ConstraintException(err);
            }
            if (!this.param.isRecommended(dTranslated)) {
                ParameterChangeWarningEvent event = new ParameterChangeWarningEvent(this, this, this.getValue(), dUntranslated);
                this.fireParameterChangeWarning(event);
                throw new WarningException(S + "Value is not recommended: " + dUntranslated.toString());
            }
            this.param.setValue(dTranslated);
            ParameterChangeEvent event = new ParameterChangeEvent(this, this.getName(), this.getValue(), value);
            this.firePropertyChange(event);
        }
    }

    @Override
    public void unableToSetValue(Object value) throws ConstraintException {
        this.param.unableToSetValue(value);
    }

    @Override
    public Double getValue() {
        Double value = (Double)this.param.getValue();
        if (value == null || !this.translate || !(value instanceof Double)) {
            return value;
        }
        double d = value;
        d = this.trans.reverse(d);
        return d;
    }

    @Override
    public void setDefaultValue(Double defaultValue) throws ConstraintException {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public void setValueAsDefault() throws ConstraintException, ParameterException {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public Double getDefaultValue() {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public void setValueIgnoreWarning(Double value) throws ConstraintException, ParameterException {
        String S = "TranslatedWarningDoubleParameter: setValueIgnoreWarning(): ";
        if (value == null || !this.translate || !(value instanceof Double)) {
            this.param.setValueIgnoreWarning(value);
        } else {
            double d = this.trans.translate(value);
            this.param.setValueIgnoreWarning(d);
        }
    }

    @Override
    public boolean isRecommended(Double obj) {
        if (obj == null || !this.translate || !(obj instanceof Double)) {
            return this.param.isRecommended(obj);
        }
        double d = this.trans.translate(obj);
        return this.param.isRecommended(d);
    }

    @Override
    public Double getMin() throws Exception {
        Double min = this.param.getMin();
        if (min == null || !this.translate) {
            return min;
        }
        return this.trans.reverse(min);
    }

    @Override
    public Double getMax() {
        Double max = this.param.getMax();
        if (max == null || !this.translate) {
            return max;
        }
        return this.trans.reverse(max);
    }

    @Override
    public void setIgnoreWarning(boolean ignoreWarning) {
        this.param.setIgnoreWarning(ignoreWarning);
    }

    @Override
    public boolean isIgnoreWarning() {
        return this.param.isIgnoreWarning();
    }

    @Override
    public void setWarningConstraint(AbstractParameterConstraint warningConstraint) {
        this.param.setWarningConstraint(warningConstraint);
    }

    @Override
    public AbstractParameterConstraint getWarningConstraint() throws ParameterException {
        return this.param.getWarningConstraint();
    }

    @Override
    public void addParameterChangeWarningListener(ParameterChangeWarningListener listener) {
        this.param.addParameterChangeWarningListener(listener);
    }

    @Override
    public void removeParameterChangeWarningListener(ParameterChangeWarningListener listener) {
        this.param.removeParameterChangeWarningListener(listener);
    }

    @Override
    public synchronized void addParameterChangeFailListener(ParameterChangeFailListener listener) {
        this.param.addParameterChangeFailListener(listener);
    }

    @Override
    public synchronized void removeParameterChangeFailListener(ParameterChangeFailListener listener) {
        this.param.removeParameterChangeFailListener(listener);
    }

    @Override
    public synchronized void addParameterChangeListener(ParameterChangeListener listener) {
        this.param.addParameterChangeListener(listener);
    }

    @Override
    public synchronized void removeParameterChangeListener(ParameterChangeListener listener) {
        this.param.removeParameterChangeListener(listener);
    }

    @Override
    public void firePropertyChange(ParameterChangeEvent event) {
        this.param.firePropertyChange(event);
    }

    @Override
    public void firePropertyChangeFailed(ParameterChangeFailEvent event) {
        this.param.firePropertyChangeFailed(event);
    }

    @Override
    public void fireParameterChangeWarning(ParameterChangeWarningEvent event) {
        this.param.fireParameterChangeWarning(event);
    }

    @Override
    public Object clone() {
        TranslatedWarningDoubleParameter param1 = new TranslatedWarningDoubleParameter((WarningDoubleParameter)this.param.clone());
        param1.setTranslate(this.translate);
        return param1;
    }

    @Override
    public ParameterList getIndependentParameterList() {
        return this.param.getIndependentParameterList();
    }

    @Override
    public Parameter getIndependentParameter(String name) throws ParameterException {
        return this.param.getIndependentParameter(name);
    }

    @Override
    public void setIndependentParameters(ParameterList list) {
        this.param.setIndependentParameters(list);
    }

    @Override
    public void addIndependentParameter(Parameter parameter) throws ParameterException {
        this.param.addIndependentParameter(parameter);
    }

    @Override
    public boolean containsIndependentParameter(String name) {
        return this.param.containsIndependentParameter(name);
    }

    @Override
    public void removeIndependentParameter(String name) throws ParameterException {
        this.param.removeIndependentParameter(name);
    }

    @Override
    public String getIndependentParametersKey() {
        return this.param.getIndependentParametersKey();
    }

    @Override
    public int getNumIndependentParameters() {
        return this.param.getNumIndependentParameters();
    }

    @Override
    public String getName() {
        return this.param.getName();
    }

    @Override
    public void setName(String name) {
        this.param.setName(name);
    }

    @Override
    public String getConstraintName() {
        return this.param.getConstraintName();
    }

    @Override
    public ParameterConstraint getConstraint() {
        if (this.param.getConstraint() == null || !this.translate) {
            return this.param.getConstraint();
        }
        DoubleConstraint constraint = (DoubleConstraint)this.param.getConstraint();
        double transMin = this.trans.reverse(constraint.getMin());
        double transMax = this.trans.reverse(constraint.getMax());
        DoubleConstraint constraint2 = new DoubleConstraint(transMin, transMax);
        return constraint2;
    }

    @Override
    public void setConstraint(ParameterConstraint constraint) {
        this.param.setConstraint(constraint);
    }

    @Override
    public String getUnits() {
        return this.param.getUnits();
    }

    @Override
    public void setUnits(String units) {
        this.param.setUnits(units);
    }

    @Override
    public String getInfo() {
        return this.param.getInfo();
    }

    @Override
    public void setInfo(String info) {
        this.param.setInfo(info);
    }

    @Override
    public String getType() {
        return C;
    }

    @Override
    public boolean isEditable() {
        return this.param.isEditable();
    }

    @Override
    public void setNonEditable() {
        this.param.setNonEditable();
    }

    @Override
    public String getMetadataString() {
        return this.getName() + " = " + this.getValue().toString();
    }

    @Override
    public String getDependentParamMetadataString() {
        StringBuffer metadata = new StringBuffer();
        metadata.append(this.getName() + " [ ");
        for (Parameter<?> tempParam : this.getIndependentParameterList()) {
            metadata.append(tempParam.getMetadataString() + " ; ");
        }
        metadata.replace(metadata.length() - 2, metadata.length(), " ]");
        return metadata.toString();
    }

    @Override
    public boolean isNullAllowed() {
        return this.param.isNullAllowed();
    }

    public TranslatorAPI getTrans() {
        return this.trans;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        return this.toXMLMetadata(root, "");
    }

    @Override
    public Element toXMLMetadata(Element root, String elementName) {
        return null;
    }

    @Override
    public ParameterEditor<Double> getEditor() {
        if (this.paramEdit == null) {
            try {
                this.paramEdit = new TranslatedWarningDoubleParameterEditor((Parameter)this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.paramEdit;
    }
}

