/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.impl;

import java.util.ListIterator;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.TreeBranchWeightsParameterEditor;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.ParameterListParameter;

public class TreeBranchWeightsParameter
extends ParameterListParameter {
    private static final long serialVersionUID = 1L;
    protected static final String C = "TreeBranchWeightsParameter";
    protected static final boolean D = false;
    protected static final String PARAM_TYPE = "TreeBranchWeightsParameter";
    private double tolerance = 0.01;
    private transient ParameterEditor<ParameterList> paramEdit = null;

    public TreeBranchWeightsParameter(String name) {
        super(name);
    }

    public TreeBranchWeightsParameter(String name, ParameterList paramList) {
        super(name, paramList);
    }

    public void setTolerence(double tolerance) {
        this.tolerance = tolerance;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public void setValue(ParameterList value) throws ParameterException {
        ListIterator<Parameter<?>> it = value.getParametersIterator();
        while (it.hasNext()) {
            Parameter<?> param = it.next();
            if (param instanceof DoubleParameter) continue;
            throw new RuntimeException("TreeBranchWeightsParameter Only DoubleParameter allowed in this Parameter");
        }
        super.setValue(value);
    }

    public boolean doWeightsSumToOne(ParameterList paramList) {
        ListIterator<Parameter<?>> it = paramList.getParametersIterator();
        double paramsSum = 0.0;
        while (it.hasNext()) {
            paramsSum += ((Double)it.next().getValue()).doubleValue();
        }
        return this.isInTolerence(paramsSum);
    }

    private boolean isInTolerence(double num) {
        return num <= 1.0 + this.tolerance && num >= 1.0 - this.tolerance;
    }

    @Override
    public String getType() {
        String type = "TreeBranchWeightsParameter";
        return type;
    }

    @Override
    public ParameterEditor<ParameterList> getEditor() {
        if (this.paramEdit == null) {
            this.paramEdit = new TreeBranchWeightsParameterEditor(this);
        }
        return this.paramEdit;
    }
}

