/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.ext.heading.anchor.HeadingAnchorExtension;
import org.commonmark.ext.heading.anchor.IdGenerator;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Image;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlNodeRendererFactory;
import org.commonmark.renderer.html.HtmlRenderer;
import org.commonmark.renderer.html.HtmlWriter;
import org.opensha.commons.data.CSVFile;

public class MarkdownUtils {
    public static int MAX_WIDTH = 1000;
    private static final Pattern htmlEntityPattern = Pattern.compile("&(#[xX][a-fA-F0-9]{1,8}|#[0-9]{1,8}|[a-zA-Z][a-zA-Z0-9]{1,31});");

    public static TableBuilder tableBuilder() {
        return new TableBuilder();
    }

    public static TableBuilder tableFromCSV(CSVFile<String> csv, boolean boldFirstColumn) {
        TableBuilder table = MarkdownUtils.tableBuilder();
        for (int row = 0; row < csv.getNumRows(); ++row) {
            ArrayList<String> line = new ArrayList<String>(csv.getLine(row));
            if (line.isEmpty()) continue;
            if (boldFirstColumn) {
                line.set(0, "**" + (String)line.get(0) + "**");
            }
            table.addLine(line);
        }
        return table;
    }

    private static String generateTableDashLine(int numVals, TableTextAlignment defaultAlignment, TableTextAlignment[] colSpecificAlignments) {
        Preconditions.checkState((numVals >= 1 ? 1 : 0) != 0);
        String[] vals = new String[numVals];
        for (int i = 0; i < vals.length; ++i) {
            TableTextAlignment alignment = defaultAlignment;
            if (colSpecificAlignments != null && colSpecificAlignments.length > i && colSpecificAlignments[i] != null) {
                alignment = colSpecificAlignments[i];
            }
            vals[i] = alignment.dashes;
        }
        return MarkdownUtils.tableLine(vals).replaceAll(" ", "");
    }

    private static String tableLine(String[] vals) {
        Preconditions.checkState((vals.length >= 1 ? 1 : 0) != 0);
        StringBuilder line = new StringBuilder().append("| ");
        for (int i = 0; i < vals.length; ++i) {
            if (i > 0) {
                line.append(" | ");
            }
            if (vals[i] == null) continue;
            line.append(vals[i]);
        }
        line.append(" |");
        return line.toString();
    }

    public static void writeReadmeAndHTML(List<String> lines, File outputDir) throws IOException {
        File mdFile = new File(outputDir, "README.md");
        FileWriter fw = new FileWriter(mdFile);
        for (String line : lines) {
            fw.write(line + "\n");
        }
        fw.close();
        File htmlFile = new File(outputDir, "index.html");
        MarkdownUtils.writeHTML(lines, htmlFile);
    }

    public static void writeReadmeAndHTML(List<String> lines, File outputDir, String prefix) throws IOException {
        File mdFile = new File(outputDir, prefix + ".md");
        FileWriter fw = new FileWriter(mdFile);
        for (String line : lines) {
            fw.write(line + "\n");
        }
        fw.close();
        File htmlFile = new File(outputDir, prefix + ".html");
        MarkdownUtils.writeHTML(lines, htmlFile);
    }

    public static String getTitle(File markdownPage) throws IOException {
        for (String line : Files.readLines((File)markdownPage, (Charset)Charset.defaultCharset())) {
            if (!line.startsWith("#")) continue;
            return line.replaceAll("#", "").trim();
        }
        return null;
    }

    public static List<String> buildTOC(List<String> lines, int minLevel) {
        return MarkdownUtils.buildTOC(lines, minLevel, 0);
    }

    public static List<String> buildTOC(List<String> lines, int minLevel, int maxLevel) {
        LinkedList<String> toc = new LinkedList<String>();
        IdGenerator idGen = IdGenerator.builder().build();
        for (int i = 0; i < lines.size(); ++i) {
            int level;
            String line = lines.get(i);
            if (!line.startsWith("#")) continue;
            String headerPart = line.substring(0, line.lastIndexOf(35) + 1);
            String title = line.substring(headerPart.length()).trim();
            String anchor = MarkdownUtils.getAnchorName(title, idGen);
            if (level < minLevel || maxLevel > 0 && level > maxLevel) continue;
            Object tocLine = "";
            for (level = headerPart.length(); level > minLevel; --level) {
                tocLine = (String)tocLine + "  ";
            }
            Object link = null;
            for (int j = i + 1; j < lines.size(); ++j) {
                String l2 = lines.get(j).trim();
                if (l2.isEmpty() || l2.contains("[(top)]")) continue;
                if (l2.startsWith("#")) break;
                if (l2.startsWith("[") && l2.contains("](") && l2.endsWith(")")) {
                    if (link == null) {
                        link = l2.substring(l2.lastIndexOf("(") + 1);
                        link = ((String)link).substring(0, ((String)link).length() - 1);
                        continue;
                    }
                    link = null;
                    break;
                }
                link = null;
                break;
            }
            if (link == null) {
                link = "#" + anchor;
            }
            tocLine = (String)tocLine + "* [" + title + "](" + (String)link + ")";
            toc.add((String)tocLine);
        }
        return toc;
    }

    public static String getAnchorName(String heading) {
        return MarkdownUtils.getAnchorName(heading, IdGenerator.builder().build());
    }

    public static String getAnchorName(String heading, IdGenerator idGen) {
        heading = StringEscapeUtils.unescapeHtml4((String)heading).trim();
        while (heading.startsWith("#")) {
            heading = heading.substring(1).trim();
        }
        return idGen.generateId(heading);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeHTML(List<String> lines, File outputFile) throws IOException {
        StringBuilder str = new StringBuilder();
        for (String string : lines) {
            void var4_4;
            void var4_7;
            if (string.contains("[") && string.contains("](") && (string.contains("README.md)") || string.contains("README.md#"))) {
                String string2 = string.replace("README.md", "index.html");
            }
            if (var4_7.contains("[") && var4_7.contains("](") && (var4_7.contains(".md)") || var4_7.contains(".md#"))) {
                String lineLeft = var4_7;
                Object newLine = "";
                boolean update = false;
                while (lineLeft.contains("](")) {
                    String prefix;
                    int mdIndex;
                    int linkEndIndex;
                    int index = lineLeft.indexOf("](") + 2;
                    newLine = (String)newLine + lineLeft.substring(0, index);
                    Object linkStr = (lineLeft = lineLeft.substring(index)).substring(0, linkEndIndex = lineLeft.indexOf(")"));
                    if (((String)linkStr).endsWith(".md")) {
                        mdIndex = ((String)linkStr).length() - 3;
                        prefix = ((String)linkStr).substring(0, mdIndex);
                        linkStr = prefix + ".html";
                        update = true;
                    } else if (((String)linkStr).contains(".md#")) {
                        mdIndex = ((String)linkStr).indexOf(".md#");
                        prefix = ((String)linkStr).substring(0, mdIndex);
                        String suffix = ((String)linkStr).substring(mdIndex + 3);
                        linkStr = prefix + ".html#" + suffix;
                        update = true;
                    }
                    newLine = (String)newLine + (String)linkStr;
                    lineLeft = lineLeft.substring(linkEndIndex);
                    if (linkEndIndex >= 0) continue;
                    update = false;
                    break;
                }
                newLine = (String)newLine + lineLeft;
                if (update) {
                    Object object = newLine;
                }
            }
            str.append((String)var4_4).append("\n");
        }
        MarkdownUtils.writeHTML(str.toString(), outputFile);
    }

    public static void writeHTML(String markdown, File outputFile) throws IOException {
        List<Extension> extensions = Arrays.asList(TablesExtension.create(), HeadingAnchorExtension.create());
        Parser parser = Parser.builder().extensions(extensions).build();
        HashMap<String, String> htmlSymbols = new HashMap<String, String>();
        Matcher symbolMatcher = htmlEntityPattern.matcher(markdown);
        while (symbolMatcher.find()) {
            String symbol = symbolMatcher.group();
            if (htmlSymbols.containsKey(symbol)) continue;
            String concrete = StringEscapeUtils.unescapeHtml4((String)symbol);
            htmlSymbols.put(symbol, concrete);
        }
        Node document = parser.parse(markdown);
        HtmlRenderer renderer = HtmlRenderer.builder().nodeRendererFactory(new HtmlNodeRendererFactory(){

            public NodeRenderer create(HtmlNodeRendererContext context) {
                return new ImageLinkNodeRenderer(context, true);
            }
        }).extensions(extensions).build();
        Scanner scanner = new Scanner(markdown);
        String name = null;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (!line.startsWith("#")) continue;
            name = line.replaceAll("#", "").trim();
            break;
        }
        scanner.close();
        File css = new File(outputFile.getParentFile(), "markdown.css");
        MarkdownUtils.copyCSS(css);
        FileWriter fw = new FileWriter(outputFile);
        fw.write("<!DOCTYPE html>\n");
        fw.write("<html>\n");
        fw.write("<head>\n");
        if (name != null) {
            fw.write("<title>" + name + "</title>\n");
        }
        fw.write("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n");
        fw.write("<link rel=\"stylesheet\" href=\"markdown.css\">\n");
        fw.write("<style>\n");
        fw.write("\t.markdown-body {\n");
        fw.write("\t\tbox-sizing: border-box;\n");
        fw.write("\t\tmin-width: 200px;\n");
        fw.write("\t\tmax-width: " + MAX_WIDTH + "px;\n");
        fw.write("\t\tmargin: 0 auto;\n");
        fw.write("\t\tpadding: 45px;\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t@media (max-width: 767px) {\n");
        fw.write("\t\t.markdown-body {\n");
        fw.write("\t\t\tpadding: 15px;\n");
        fw.write("\t\t}\n");
        fw.write("\t}\n");
        fw.write("</style>\n");
        fw.write("</head>\n");
        fw.write("<article class=\"markdown-body\">\n");
        String html = renderer.render(document);
        for (String symbol : htmlSymbols.keySet()) {
            html = html.replaceAll((String)htmlSymbols.get(symbol), symbol);
        }
        fw.write(html);
        fw.write("</article>\n");
        fw.write("</html>\n");
        fw.close();
    }

    private static void copyCSS(File dest) throws IOException {
        InputStream is = MarkdownUtils.class.getResourceAsStream("/markdown/markdown.css");
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        IOUtils.copy((InputStream)is, (OutputStream)out);
        is.close();
        ((OutputStream)out).close();
    }

    public static String boldCentered(String text) {
        return "<p align=\"center\">**" + text + "**</p>";
    }

    public static String centered(String text) {
        return "<p align=\"center\">" + text + "</p>";
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("USAGE: <input-file.md> <output-file.html>");
            System.exit(1);
        }
        File input = new File(args[0]);
        Preconditions.checkState((boolean)input.exists(), (String)"Input markdown file doesn't exist: %s", (Object)input);
        File output = new File(args[1]);
        System.out.println("Reading markdown from " + input.getAbsolutePath());
        List lines = Files.readLines((File)input, (Charset)Charset.defaultCharset());
        System.out.println("Read " + lines.size() + " lines");
        System.out.println("Writing HTML to " + output.getAbsolutePath());
        MarkdownUtils.writeHTML(lines, output);
        System.out.println("DONE");
        System.exit(0);
    }

    public static class TableBuilder {
        private TableTextAlignment colAlignment = TableTextAlignment.DEFAULT;
        private TableTextAlignment[] colSpecificAlignments = null;
        private List<String[]> lines = new LinkedList<String[]>();
        private List<String> curLine;

        private TableBuilder() {
        }

        public TableBuilder textAlign(TableTextAlignment colAlignment) {
            this.colAlignment = colAlignment;
            return this;
        }

        public TableBuilder textAlign(TableTextAlignment[] colSpecificAlignments) {
            this.colSpecificAlignments = colSpecificAlignments;
            return this;
        }

        public TableBuilder textAlign(int colIndex, TableTextAlignment colSpecificAlignment) {
            Preconditions.checkState((colIndex >= 0 ? 1 : 0) != 0);
            if (this.colSpecificAlignments == null) {
                this.colSpecificAlignments = new TableTextAlignment[colIndex + 1];
            } else if (this.colSpecificAlignments.length <= colIndex) {
                this.colSpecificAlignments = Arrays.copyOf(this.colSpecificAlignments, colIndex + 1);
            }
            this.colSpecificAlignments[colIndex] = colSpecificAlignment;
            return this;
        }

        public TableBuilder addLine(List<String> vals) {
            return this.addLine(vals.toArray(new String[vals.size()]));
        }

        public TableBuilder addLine(Object ... vals) {
            String[] strs = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                strs[i] = vals[i].toString();
            }
            return this.addLine(strs);
        }

        public TableBuilder addLine(String ... vals) {
            this.lines.add(vals);
            return this;
        }

        public TableBuilder initNewLine() {
            if (this.curLine != null && !this.curLine.isEmpty()) {
                this.finalizeLine();
            }
            this.curLine = new ArrayList<String>();
            return this;
        }

        public TableBuilder addColumn(Object val) {
            return this.addColumn(val.toString());
        }

        public TableBuilder addColumns(Object ... vals) {
            for (Object val : vals) {
                this.addColumn(val);
            }
            return this;
        }

        public TableBuilder addColumns(List<?> vals) {
            for (Object val : vals) {
                this.addColumn(val);
            }
            return this;
        }

        public TableBuilder addColumn(String val) {
            if (this.curLine == null) {
                this.initNewLine();
            }
            this.curLine.add(val);
            return this;
        }

        public TableBuilder finalizeLine() {
            Preconditions.checkState((this.curLine != null && !this.curLine.isEmpty() ? 1 : 0) != 0, (Object)"Can't finalize an empty line");
            this.addLine(this.curLine);
            this.curLine = null;
            return this;
        }

        public TableBuilder wrap(int maxDataCols, int headerCols) {
            int i;
            int curDataCols;
            if (this.curLine != null) {
                this.finalizeLine();
            }
            if ((curDataCols = this.lines.get(0).length - headerCols) <= maxDataCols) {
                return this;
            }
            int numWraps = (int)Math.ceil((double)curDataCols / (double)maxDataCols);
            int newDataCols = (int)Math.ceil((double)curDataCols / (double)numWraps);
            ArrayList<String[]> newLines = new ArrayList<String[]>(this.lines.size() * numWraps);
            for (i = 0; i < this.lines.size() * numWraps; ++i) {
                String[] newLine = new String[headerCols + newDataCols];
                for (int h = 0; h < headerCols; ++h) {
                    newLine[h] = this.lines.get(i % this.lines.size())[h];
                }
                newLines.add(newLine);
            }
            for (i = 0; i < this.lines.size(); ++i) {
                for (int c = 0; c < curDataCols; ++c) {
                    int row = i + c / newDataCols * this.lines.size();
                    int srcCol = headerCols + c;
                    int destCol = headerCols + c % newDataCols;
                    ((String[])newLines.get((int)row))[destCol] = this.lines.get(i)[srcCol];
                }
            }
            this.lines = newLines;
            return this;
        }

        public TableBuilder invert() {
            if (this.curLine != null) {
                this.finalizeLine();
            }
            List<String[]> origLines = this.lines;
            this.lines = new ArrayList<String[]>();
            this.curLine = null;
            int maxCols = 0;
            for (String[] line : origLines) {
                maxCols = Integer.max(maxCols, line.length);
            }
            for (int row = 0; row < maxCols; ++row) {
                this.initNewLine();
                for (int col = 0; col < origLines.size(); ++col) {
                    String[] thatLine = origLines.get(col);
                    if (thatLine.length < row) {
                        this.addColumn("");
                        continue;
                    }
                    this.addColumn(thatLine[row]);
                }
                this.finalizeLine();
            }
            return this;
        }

        public List<String> build() {
            Preconditions.checkState((this.lines.size() >= 1 ? 1 : 0) != 0);
            ArrayList<String> strings = new ArrayList<String>(this.lines.size() + 1);
            for (int i = 0; i < this.lines.size(); ++i) {
                strings.add(MarkdownUtils.tableLine(this.lines.get(i)));
                if (i != 0) continue;
                strings.add(MarkdownUtils.generateTableDashLine(this.lines.get(i).length, this.colAlignment, this.colSpecificAlignments));
            }
            return strings;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < this.lines.size(); ++i) {
                if (i > 0) {
                    str.append("\n");
                }
                str.append(MarkdownUtils.tableLine(this.lines.get(i)));
                if (i != 0) continue;
                str.append("\n").append(MarkdownUtils.generateTableDashLine(this.lines.get(i).length, this.colAlignment, this.colSpecificAlignments));
            }
            return str.toString();
        }

        public CSVFile<String> toCSV() {
            return this.toCSV(false);
        }

        public CSVFile<String> toCSV(boolean stripFormatting) {
            boolean sameSize = true;
            int len = this.lines.get(0).length;
            for (String[] line : this.lines) {
                sameSize = sameSize && line.length == len;
            }
            CSVFile<String> csv = new CSVFile<String>(sameSize);
            for (String[] line : this.lines) {
                ArrayList<String> csvLine = new ArrayList<String>(line.length);
                for (String val : line) {
                    if (stripFormatting) {
                        if (val.startsWith("_") && val.endsWith("_")) {
                            val = val.substring(1, val.length() - 1);
                        }
                        if (val.startsWith("**") && val.endsWith("**")) {
                            val = val.substring(2, val.length() - 2);
                        } else if (val.startsWith("*") && val.endsWith("*")) {
                            val = val.substring(1, val.length() - 1);
                        }
                    }
                    csvLine.add(val);
                }
                csv.addLine((List<String>)csvLine);
            }
            return csv;
        }

        public int getNumLines() {
            return this.lines.size();
        }
    }

    public static enum TableTextAlignment {
        DEFAULT("-----"),
        LEFT(":----"),
        CENTER(":---:"),
        RIGHT("----:");

        private final String dashes;

        private TableTextAlignment(String dashes) {
            this.dashes = dashes;
        }
    }

    private static class ImageLinkNodeRenderer
    implements NodeRenderer {
        private final HtmlNodeRendererContext context;
        private final HtmlWriter html;
        private final boolean newWindow;

        ImageLinkNodeRenderer(HtmlNodeRendererContext context, boolean newWindow) {
            this.context = context;
            this.newWindow = newWindow;
            this.html = context.getWriter();
        }

        public Set<Class<? extends Node>> getNodeTypes() {
            return Collections.singleton(Image.class);
        }

        public void render(Node node) {
            Image image = (Image)node;
            String url = this.context.encodeUrl(image.getDestination());
            AltTextVisitor altTextVisitor = new AltTextVisitor();
            image.accept((Visitor)altTextVisitor);
            String altText = altTextVisitor.getAltText();
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("src", url);
            attrs.put("alt", altText);
            if (image.getTitle() != null) {
                attrs.put("title", image.getTitle());
            }
            HashMap<String, String> linkAttrs = new HashMap<String, String>();
            linkAttrs.put("href", url);
            if (this.newWindow) {
                linkAttrs.put("target", "_blank");
            }
            this.html.tag("a", linkAttrs, false);
            this.html.tag("img", this.context.extendAttributes((Node)image, "img", attrs), true);
            this.html.tag("/a");
        }
    }

    private static class AltTextVisitor
    extends AbstractVisitor {
        private final StringBuilder sb = new StringBuilder();

        private AltTextVisitor() {
        }

        String getAltText() {
            return this.sb.toString();
        }

        public void visit(Text text) {
            this.sb.append(text.getLiteral());
        }

        public void visit(SoftLineBreak softLineBreak) {
            this.sb.append('\n');
        }

        public void visit(HardLineBreak hardLineBreak) {
            this.sb.append('\n');
        }
    }
}

