/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import com.google.common.base.Preconditions;
import org.opensha.sha.earthquake.faultSysSolution.util.SolHazardMapCalc;

public class ReturnPeriodUtils {
    public static double calcExceedanceProb(double referenceProb, double referenceDuration, double calcDuration) {
        Preconditions.checkArgument((referenceProb >= 0.0 && referenceProb <= 1.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((referenceDuration >= 0.0 && Double.isFinite(referenceDuration) ? 1 : 0) != 0);
        Preconditions.checkArgument((calcDuration >= 0.0 && Double.isFinite(calcDuration) ? 1 : 0) != 0);
        double p1star = ReturnPeriodUtils.calcProbStar(referenceProb);
        double p2star = p1star * calcDuration / referenceDuration;
        return ReturnPeriodUtils.calcProbFromPorbStar(p2star);
    }

    private static double calcProbStar(double prob) {
        return -Math.log(1.0 - prob);
    }

    private static double calcProbFromPorbStar(double probStar) {
        return 1.0 - Math.exp(-probStar);
    }

    public static double calcDurationWithExceedanceProb(double exceedProb, double referenceProb, double referenceDuration) {
        double targetProbStar = ReturnPeriodUtils.calcProbStar(exceedProb);
        double referenceProbStar = ReturnPeriodUtils.calcProbStar(referenceProb);
        return referenceDuration * targetProbStar / referenceProbStar;
    }

    private static double calcDurationWithExceedanceProb(double exceedProb, double referenceReturnPeriod) {
        double targetProbStar = ReturnPeriodUtils.calcProbStar(exceedProb);
        return referenceReturnPeriod * targetProbStar;
    }

    public static double calcReturnPeriod(double exceedProb, double duration) {
        return duration / ReturnPeriodUtils.calcProbStar(exceedProb);
    }

    public static double calcExceedanceProbForReturnPeriod(double returnPeriod, double calcDuration) {
        double probStar = calcDuration / returnPeriod;
        return ReturnPeriodUtils.calcProbFromPorbStar(probStar);
    }

    public static void main(String[] args) {
        double[] rps = new double[]{2475.0, 975.0, 475.0};
        double[] durs = new double[]{1.0, 50.0};
        for (double rp : rps) {
            for (double dur : durs) {
                System.out.println("Prob for " + (float)rp + ", " + (float)dur + " year: " + ReturnPeriodUtils.calcExceedanceProbForReturnPeriod(rp, dur));
            }
        }
        for (SolHazardMapCalc.ReturnPeriods rp : SolHazardMapCalc.ReturnPeriods.values()) {
            System.out.println(rp.label);
            System.out.println("\tReturn period: " + rp.returnPeriod);
            System.out.println("\tOne year prob: " + rp.oneYearProb);
        }
    }
}

