/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.io.File;
import java.util.NoSuchElementException;
import org.opensha.commons.util.DevStatus;
import org.opensha.commons.util.ServerPrefUtils;

public enum ServerPrefs {
    DEV_PREFS("opensha.scec.org", ServerPrefUtils.OPENSHA_SERVLET_DEV_URL, ServerPrefUtils.OPENSHA_TOMCAT_DEV_DIR, ServerPrefUtils.DATA_DIR, ServerPrefUtils.TEMP_DIR, DevStatus.DEVELOPMENT),
    PRODUCTION_PREFS("opensha.scec.org", ServerPrefUtils.OPENSHA_SERVLET_PRODUCTION_URL, ServerPrefUtils.OPENSHA_TOMCAT_PRODUCTION_DIR, ServerPrefUtils.DATA_DIR, ServerPrefUtils.TEMP_DIR, DevStatus.PRODUCTION);

    private String hostName;
    private String servletURL;
    private File tomcatDir;
    private File dataDir;
    private File tempDir;
    private DevStatus buildType;

    private ServerPrefs(String hostName, String servletURL, File tomcatDir, File dataDir, File tempDir, DevStatus buildType) {
        this.hostName = hostName;
        this.servletURL = servletURL;
        this.tomcatDir = tomcatDir;
        this.dataDir = dataDir;
        this.tempDir = tempDir;
        this.buildType = buildType;
    }

    public String getServletBaseURL() {
        return this.servletURL;
    }

    public File getTomcatDir() {
        return this.tomcatDir;
    }

    public File getTomcatProjectDir() {
        return new File(this.tomcatDir, "opensha");
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public DevStatus getBuildType() {
        return this.buildType;
    }

    public String getHostName() {
        return this.hostName;
    }

    public static ServerPrefs fromBuildType(String buildType) {
        for (ServerPrefs prefs : ServerPrefs.values()) {
            if (!prefs.getBuildType().equals(buildType)) continue;
            return prefs;
        }
        throw new NoSuchElementException("No ServerPrefs instance exists with build type '" + buildType + "'");
    }
}

