/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.opensha.commons.metadata.XMLSaveable;

public class XMLUtils {
    public static String DEFAULT_ROOT_NAME = "OpenSHA";
    public static OutputFormat format = OutputFormat.createPrettyPrint();

    public static void writeDocumentToFile(File file, Document document) throws IOException {
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(file), format);
        writer.write(document);
        writer.close();
    }

    public static String getDocumentAsString(Document document) throws IOException {
        StringWriter swrite = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)swrite, format);
        writer.write(document);
        writer.close();
        return swrite.getBuffer().toString();
    }

    public static Document createDocumentWithRoot() {
        return XMLUtils.createDocumentWithRoot(DEFAULT_ROOT_NAME);
    }

    public static Document createDocumentWithRoot(String rootName) {
        Document doc = DocumentHelper.createDocument();
        doc.addElement(rootName);
        return doc;
    }

    public static Document loadDocument(File file) throws MalformedURLException, DocumentException {
        SAXReader read = new SAXReader();
        return read.read(file);
    }

    public static Document loadDocument(String path) throws MalformedURLException, DocumentException {
        return XMLUtils.loadDocument(new File(path));
    }

    public static Document loadDocument(URL url) throws MalformedURLException, DocumentException {
        SAXReader read = new SAXReader();
        return read.read(url);
    }

    public static Document loadDocument(InputStream is) throws DocumentException {
        SAXReader read = new SAXReader();
        return read.read(is);
    }

    public static void writeObjectToXMLAsRoot(XMLSaveable obj, File file) throws IOException {
        Document document = XMLUtils.createDocumentWithRoot();
        Element root = document.getRootElement();
        root = obj.toXMLMetadata(root);
        XMLUtils.writeDocumentToFile(file, document);
    }

    public static void colorToXML(Element parent, Color color) {
        XMLUtils.colorToXML(parent, color, "Color");
    }

    public static void colorToXML(Element parent, Color color, String elName) {
        Element el = parent.addElement(elName);
        el.addAttribute("r", "" + color.getRed());
        el.addAttribute("g", "" + color.getGreen());
        el.addAttribute("b", "" + color.getBlue());
        el.addAttribute("a", "" + color.getAlpha());
    }

    public static Color colorFromXML(Element colorEl) {
        int r = Integer.parseInt(colorEl.attributeValue("r"));
        int g = Integer.parseInt(colorEl.attributeValue("g"));
        int b = Integer.parseInt(colorEl.attributeValue("b"));
        int a = Integer.parseInt(colorEl.attributeValue("a"));
        return new Color(r, g, b, a);
    }

    public static void doubleArrayToXML(Element parent, double[] array, String elName) {
        byte[] bytes = new byte[array.length * 8];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        for (double val : array) {
            buf.putDouble(val);
        }
        XMLUtils.byteArrayToXML(parent, buf.array(), elName);
    }

    public static double[] doubleArrayFromXML(Element doubleArrayEl) {
        byte[] data = XMLUtils.byteArrayFromXML(doubleArrayEl);
        Preconditions.checkState((data.length % 8 == 0 ? 1 : 0) != 0, (Object)"binary data not a multiple of 8 bits");
        int size = data.length / 8;
        ByteBuffer buf = ByteBuffer.wrap(data);
        double[] array = new double[size];
        for (int i = 0; i < size; ++i) {
            array[i] = buf.getDouble();
        }
        return array;
    }

    public static void intArrayToXML(Element parent, int[] array, String elName) {
        byte[] bytes = new byte[array.length * 4];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        for (int val : array) {
            buf.putInt(val);
        }
        XMLUtils.byteArrayToXML(parent, buf.array(), elName);
    }

    public static int[] intArrayFromXML(Element intArrayEl) {
        byte[] data = XMLUtils.byteArrayFromXML(intArrayEl);
        Preconditions.checkState((data.length % 4 == 0 ? 1 : 0) != 0, (Object)"binary data not a multiple of 4 bits");
        int size = data.length / 4;
        ByteBuffer buf = ByteBuffer.wrap(data);
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = buf.getInt();
        }
        return array;
    }

    public static void byteArrayToXML(Element parent, byte[] array, String elName) {
        Preconditions.checkNotNull((Object)parent, (Object)"parent element can't be null");
        Preconditions.checkNotNull((Object)array, (Object)"array cannot be null");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array cannot be empty");
        Preconditions.checkNotNull((Object)elName, (Object)"elName cannot be null");
        Preconditions.checkArgument((!elName.isEmpty() ? 1 : 0) != 0, (Object)"elName cannot be empty");
        Element el = parent.addElement(elName);
        String str = Base64.encodeBase64String((byte[])array);
        el.addCDATA(str);
    }

    public static byte[] byteArrayFromXML(Element byteArrayEl) {
        Preconditions.checkNotNull((Object)byteArrayEl, (Object)"byteArrayEl element can't be null");
        String str = byteArrayEl.getText().trim();
        byte[] data = Base64.decodeBase64((String)str);
        return data;
    }

    public List<Element> getSortedChildElements(Element parentEl, String sortAttributeName) {
        return XMLUtils.getSortedChildElements(parentEl, null, sortAttributeName);
    }

    public static List<Element> getSortedChildElements(Element parentEl, String subElName, final String sortAttributeName) {
        Iterator it = subElName != null && !subElName.isEmpty() ? parentEl.elementIterator(subElName) : parentEl.elementIterator();
        ArrayList elems = Lists.newArrayList((Iterator)it);
        Collections.sort(elems, new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                double d1 = Double.parseDouble(e1.attributeValue(sortAttributeName));
                double d2 = Double.parseDouble(e2.attributeValue(sortAttributeName));
                return Double.compare(d1, d2);
            }
        });
        return elems;
    }

    public static List<Element> getSubElementsList(Element parentEl) {
        return XMLUtils.getSubElementsList(parentEl, null);
    }

    public static List<Element> getSubElementsList(Element parentEl, String subElName) {
        if (subElName != null && !subElName.isEmpty()) {
            return parentEl.elements(subElName);
        }
        return parentEl.elements();
    }
}

