/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.binFile;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import org.opensha.commons.data.xyz.ArbDiscrXYZ_DataSet;
import org.opensha.commons.util.binFile.BinaryRandomAccessFile;

public class BinaryXYZRandomAccessFile
extends BinaryRandomAccessFile {
    private double placeholder = Double.NaN;
    private BinaryRandomAccessFile.BufferWrapper<DoubleBuffer> threeDoubleBuffer = this.getDoubleBuffer(3);

    public BinaryXYZRandomAccessFile(File file, ByteOrder byteOrder, int numRecords) {
        super(file, byteOrder, numRecords);
    }

    @Override
    protected int getHeaderLen() {
        return 4;
    }

    @Override
    protected int getRecordLen() {
        return 24;
    }

    @Override
    protected byte[] getHeader() {
        BinaryRandomAccessFile.BufferWrapper<IntBuffer> wrap = this.getIntBuffer(1);
        ((IntBuffer)wrap.buffer).put(0, this.getNumRecords());
        return BinaryXYZRandomAccessFile.cloneBytes(wrap.bytes);
    }

    public void setPlaceholder(double placeholder) {
        this.placeholder = placeholder;
    }

    @Override
    protected synchronized byte[] getBlankRecord() {
        ((DoubleBuffer)this.threeDoubleBuffer.buffer).position(0);
        ((DoubleBuffer)this.threeDoubleBuffer.buffer).put(this.placeholder);
        ((DoubleBuffer)this.threeDoubleBuffer.buffer).put(this.placeholder);
        ((DoubleBuffer)this.threeDoubleBuffer.buffer).put(this.placeholder);
        return BinaryXYZRandomAccessFile.cloneBytes(this.threeDoubleBuffer.bytes);
    }

    public synchronized void write(int index, double x, double y, double z) throws IOException {
        ((DoubleBuffer)this.threeDoubleBuffer.buffer).position(0);
        ((DoubleBuffer)this.threeDoubleBuffer.buffer).put(x);
        ((DoubleBuffer)this.threeDoubleBuffer.buffer).put(y);
        ((DoubleBuffer)this.threeDoubleBuffer.buffer).put(z);
        this.writeRecord(index, BinaryXYZRandomAccessFile.cloneBytes(this.threeDoubleBuffer.getBytes()));
    }

    public synchronized boolean isCalculated(int index) throws IOException {
        byte[] record = this.readRecord(index);
        for (int i = 0; i < record.length; ++i) {
            this.threeDoubleBuffer.getBytes()[i] = record[i];
        }
        this.threeDoubleBuffer.getBuffer().position(0);
        double x = this.threeDoubleBuffer.getBuffer().get();
        double y = this.threeDoubleBuffer.getBuffer().get();
        double z = this.threeDoubleBuffer.getBuffer().get();
        return !this.isPlaceholder(x) && !this.isPlaceholder(y) && !this.isPlaceholder(z);
    }

    private boolean isPlaceholder(double val) {
        if (Double.isNaN(this.placeholder)) {
            return Double.isNaN(val);
        }
        return val == this.placeholder;
    }

    public static ArbDiscrXYZ_DataSet loadXYZ(File file) throws IOException {
        long length = file.length();
        Preconditions.checkState((length > 0L ? 1 : 0) != 0, (Object)"file is empty!");
        Preconditions.checkState(((length - 4L) % 8L == 0L ? 1 : 0) != 0, (Object)"file size after header isn't evenly divisible by 8, thus not a sequence of double values.");
        InputStream is = new FileInputStream(file);
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        DataInputStream in = new DataInputStream(is);
        int size = in.readInt();
        ArbDiscrXYZ_DataSet xyz = new ArbDiscrXYZ_DataSet();
        for (int i = 0; i < size; ++i) {
            double x = in.readDouble();
            double y = in.readDouble();
            double z = in.readDouble();
            xyz.set(x, y, z);
        }
        in.close();
        return xyz;
    }
}

