/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.binFile;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.binFile.BinaryMesh2DCalculator;

public class GeolocatedRectangularBinaryMesh2DCalculator
extends BinaryMesh2DCalculator {
    public static final boolean D = false;
    private double minLat;
    private double maxLat;
    private double minLon;
    private double maxLon;
    private double gridSpacingX;
    private double gridSpacingY;
    private boolean startBottom;
    private boolean startLeft;
    private boolean wrapX = false;
    private boolean wrapY = false;
    private boolean allLonPos = false;

    public GeolocatedRectangularBinaryMesh2DCalculator(BinaryMesh2DCalculator.DataType numType, int nx, int ny, double minLat, double minLon, double gridSpacing) {
        this(numType, nx, ny, minLat, minLon, true, true, gridSpacing);
    }

    public GeolocatedRectangularBinaryMesh2DCalculator(BinaryMesh2DCalculator.DataType numType, int nx, int ny, double startLat, double startLon, boolean startBottom, boolean startLeft, double gridSpacing) {
        this(numType, nx, ny, startLat, startLon, startBottom, startLeft, gridSpacing, gridSpacing);
    }

    public GeolocatedRectangularBinaryMesh2DCalculator(BinaryMesh2DCalculator.DataType numType, int nx, int ny, double startLat, double startLon, boolean startBottom, boolean startLeft, double gridSpacingX, double gridSpacingY) {
        super(numType, nx, ny);
        if (startBottom) {
            this.minLat = startLat;
            this.maxLat = startLat + gridSpacingY * (double)(ny - 1);
        } else {
            this.maxLat = startLat;
            this.minLat = startLat - gridSpacingY * (double)(ny - 1);
        }
        if (startLeft) {
            this.minLon = startLon;
            this.maxLon = startLon + gridSpacingX * (double)(nx - 1);
        } else {
            this.maxLon = startLon;
            this.minLon = startLon - gridSpacingX * (double)(nx - 1);
        }
        this.startBottom = startBottom;
        this.startLeft = startLeft;
        this.gridSpacingX = gridSpacingX;
        this.gridSpacingY = gridSpacingY;
        if (this.minLon >= 0.0) {
            this.allLonPos = true;
        }
        if (this.minLat + 180.0 == this.maxLat + gridSpacingY) {
            this.wrapY = true;
        }
        if (this.minLon + 360.0 == this.maxLon + gridSpacingX) {
            this.wrapX = true;
        }
    }

    public static GeolocatedRectangularBinaryMesh2DCalculator readHDR(File hdrFile) throws IOException {
        BinaryMesh2DCalculator.DataType dataType = null;
        Integer nx = null;
        Integer ny = null;
        BinaryMesh2DCalculator.MeshOrder meshOrder = BinaryMesh2DCalculator.MeshOrder.FAST_XY;
        Double gridSpacing = null;
        Double startLat = null;
        Double startLon = null;
        for (String line : Files.readLines((File)hdrFile, (Charset)Charset.defaultCharset())) {
            String[] split = (line = line.trim()).split("\\s+");
            Preconditions.checkState((split.length == 2 ? 1 : 0) != 0, (Object)("Bad split on line: " + line));
            switch (split[0]) {
                case "PIXELTYPE": {
                    dataType = BinaryMesh2DCalculator.DataType.valueOf(split[1]);
                    Preconditions.checkNotNull((Object)((Object)dataType), (String)"Unkown data type: %s", (Object)split[1]);
                    break;
                }
                case "NROWS": {
                    ny = Integer.parseInt(split[1]);
                    break;
                }
                case "NCOLS": {
                    nx = Integer.parseInt(split[1]);
                    break;
                }
                case "LAYOUT": {
                    Preconditions.checkState((boolean)split[1].equals("BIL"), (Object)"Only BIL layout currently supported");
                    break;
                }
                case "XDIM": {
                    if (gridSpacing == null) {
                        gridSpacing = Double.parseDouble(split[1]);
                        break;
                    }
                    Preconditions.checkState((gridSpacing == Double.parseDouble(split[1]) ? 1 : 0) != 0, (Object)"XDIM must equal YDIM");
                    break;
                }
                case "YDIM": {
                    if (gridSpacing == null) {
                        gridSpacing = Double.parseDouble(split[1]);
                        break;
                    }
                    Preconditions.checkState((gridSpacing == Double.parseDouble(split[1]) ? 1 : 0) != 0, (Object)"XDIM must equal YDIM");
                    break;
                }
                case "ULXMAP": {
                    startLon = Double.parseDouble(split[1]);
                    break;
                }
                case "ULYMAP": {
                    startLat = Double.parseDouble(split[1]);
                    break;
                }
            }
        }
        Preconditions.checkNotNull(dataType, (Object)"data type not specified in input file (no PIXELTYPE line)");
        Preconditions.checkNotNull(nx, (Object)"nx not specified in input file (no NCOLS line)");
        Preconditions.checkNotNull(ny, (Object)"ny not specified in input file (no NROWS line)");
        Preconditions.checkNotNull(gridSpacing, (Object)"gridSpacing not specified in input file (no XDIM/YDIM lines)");
        Preconditions.checkNotNull(startLat, (Object)"startLat not specified in input file (no ULYMAP line)");
        Preconditions.checkNotNull(startLon, (Object)"startLon not specified in input file (no ULXMAP line)");
        GeolocatedRectangularBinaryMesh2DCalculator calc = new GeolocatedRectangularBinaryMesh2DCalculator(dataType, nx, ny, startLat, startLon, false, true, gridSpacing);
        calc.setMeshOrder(meshOrder);
        return calc;
    }

    public long[] calcClosestLocationIndices(Location loc) {
        return this.calcClosestLocationIndices(loc.getLatitude(), loc.getLongitude());
    }

    public long[] calcClosestLocationIndices(double lat, double lon) {
        long x = this.calcX(lon);
        long y = this.calcY(lat);
        if (x < 0L || y < 0L) {
            return null;
        }
        if (x >= this.nx) {
            if (this.wrapX) {
                x %= this.nx;
            } else {
                return null;
            }
        }
        if (y >= this.ny) {
            if (this.wrapY) {
                y %= this.ny;
            } else {
                return null;
            }
        }
        long[] pt = new long[]{x, y};
        return pt;
    }

    public long calcClosestLocationIndex(Location loc) {
        return this.calcClosestLocationIndex(loc.getLatitude(), loc.getLongitude());
    }

    public long calcClosestLocationIndex(double lat, double lon) {
        long[] pt = this.calcClosestLocationIndices(lat, lon);
        if (pt == null) {
            return -1L;
        }
        return this.calcMeshIndex(pt[0], pt[1]);
    }

    public long calcClosestLocationFileIndex(Location loc) {
        return this.calcClosestLocationFileIndex(loc.getLatitude(), loc.getLongitude());
    }

    public long calcClosestLocationFileIndex(double lat, double lon) {
        long[] pt = this.calcClosestLocationIndices(lat, lon);
        if (pt == null) {
            return -1L;
        }
        return this.calcFileIndex(pt[0], pt[1]);
    }

    public Location getLocationForPoint(long x, long y) {
        double lat = this.startBottom ? this.minLat + (double)y * this.gridSpacingY : this.maxLat - (double)y * this.gridSpacingY;
        double lon = this.startLeft ? this.minLon + (double)x * this.gridSpacingX : this.maxLon - (double)x * this.gridSpacingX;
        return new Location(lat, lon);
    }

    public Location getLocationForFileIndex(long pos) {
        long y = this.calcFileY(pos);
        long x = this.calcFileX(pos);
        double lat = this.startBottom ? this.minLat + (double)y * this.gridSpacingY : this.maxLat - (double)y * this.gridSpacingY;
        double lon = this.startLeft ? this.minLon + (double)x * this.gridSpacingX : this.maxLon - (double)x * this.gridSpacingX;
        return new Location(lat, lon);
    }

    public Location getLocationForMeshIndex(long index) {
        long y = this.calcMeshY(index);
        long x = this.calcMeshX(index);
        double lat = this.startBottom ? this.minLat + (double)y * this.gridSpacingY : this.maxLat - (double)y * this.gridSpacingY;
        double lon = this.startLeft ? this.minLon + (double)x * this.gridSpacingX : this.maxLon - (double)x * this.gridSpacingX;
        return new Location(lat, lon);
    }

    public Location calcClosestLocation(Location loc) {
        return this.calcClosestLocation(loc.getLatitude(), loc.getLongitude());
    }

    public Location calcClosestLocation(double lat, double lon) {
        long[] pt = this.calcClosestLocationIndices(lat, lon);
        if (pt == null) {
            return null;
        }
        return this.getLocationForPoint(pt[0], pt[1]);
    }

    private long calcX(double lon) {
        if (this.allLonPos && lon < 0.0) {
            lon += 360.0;
        }
        if (this.startLeft) {
            return (long)((lon - this.minLon) / this.gridSpacingX + 0.5);
        }
        return (long)((this.maxLon - lon) / this.gridSpacingX + 0.5);
    }

    private long calcY(double lat) {
        if (this.startBottom) {
            return (long)((lat - this.minLat) / this.gridSpacingY + 0.5);
        }
        return (long)((this.maxLat - lat) / this.gridSpacingY + 0.5);
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public double getGridSpacingX() {
        return this.gridSpacingX;
    }

    public double getGridSpacingY() {
        return this.gridSpacingY;
    }

    public boolean isStartBottom() {
        return this.startBottom;
    }

    public void setStartBottom(boolean startBottom) {
        this.startBottom = startBottom;
    }

    public boolean isStartLeft() {
        return this.startLeft;
    }

    public void setStartLeft(boolean startLeft) {
        this.startLeft = startLeft;
    }

    public Region getApplicableRegion() {
        return new Region(new Location(this.minLat, this.minLon), new Location(this.maxLat, this.maxLon));
    }

    public boolean isWrapLat() {
        return this.wrapY;
    }

    public boolean isWrapLon() {
        return this.wrapX;
    }
}

