/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class InstallSSLCert {
    char[] passphrase = "changeit".toCharArray();
    int port = 443;
    String expectedMD5;
    String host;
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public InstallSSLCert(String expectedMD5, String host) {
        this.expectedMD5 = expectedMD5;
        this.host = host;
    }

    public File getKeyStore() {
        try {
            File file = File.createTempFile("openSHA_SSLKeyStore_", ".ks");
            if (this.createKeyStore(file)) {
                return file;
            }
            return null;
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean createKeyStore(File file) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, this.passphrase);
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
        context.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory factory = context.getSocketFactory();
        System.out.println("Opening connection to " + this.host + ":" + this.port + "...");
        SSLSocket socket = (SSLSocket)factory.createSocket(this.host, this.port);
        socket.setSoTimeout(10000);
        try {
            System.out.println("Starting SSL handshake...");
            socket.startHandshake();
            socket.close();
            System.out.println();
            System.out.println("No errors, certificate is already trusted");
            return false;
        }
        catch (SSLException e) {
            System.out.println("Certificate needs to be added");
            X509Certificate[] chain = tm.chain;
            if (chain == null) {
                System.out.println("Could not obtain server certificate chain");
                return false;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            int i = 0;
            X509Certificate cert = chain[i];
            sha1.update(cert.getEncoded());
            md5.update(cert.getEncoded());
            String md5String = InstallSSLCert.toHexString(md5.digest()).trim();
            md5String = this.stripMD5(md5String);
            this.expectedMD5 = this.stripMD5(this.expectedMD5);
            if (this.expectedMD5.length() == 0) {
                System.err.println("WARNING: The server's MD5 will not be verified.");
                System.err.println("Server MD5:\t" + md5String);
                this.expectedMD5 = md5String;
            }
            if (md5String.equals(this.expectedMD5)) {
                System.out.println("Server's MD5 checks out...adding to keystore!");
                String alias = this.host + "-" + (i + 1);
                ks.setCertificateEntry(alias, cert);
                FileOutputStream out = new FileOutputStream(file);
                ks.store(out, this.passphrase);
                ((OutputStream)out).close();
                System.out.println("Added certificate to keystore '" + file.getAbsolutePath() + "' using alias '" + alias + "'");
                return true;
            }
            System.err.println("Server's MD5 does not match expected md5! Will not connect...");
            System.err.println("\nSubject:\t" + String.valueOf(cert.getSubjectDN()));
            System.err.println("Issuer:\t\t" + String.valueOf(cert.getIssuerDN()));
            System.err.println("sha1:\t\t" + this.stripMD5(InstallSSLCert.toHexString(sha1.digest())));
            System.err.println("Expected MD5:\t" + this.expectedMD5);
            System.err.println("Actual MD5:\t" + md5String);
            return false;
        }
    }

    private String stripMD5(String md5) {
        md5 = md5.trim();
        md5 = md5.replaceAll(" ", "");
        md5 = md5.replaceAll("-", "");
        md5 = md5.replaceAll(":", "");
        md5 = md5.replaceAll("_", "");
        return md5;
    }

    public static void main(String[] args) throws Exception {
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

