/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.interp;

public class BicubicInterpolation2D {
    static double[][] M = new double[][]{{-0.5, 1.5, -1.5, 0.5}, {1.0, -2.5, 2.0, -0.5}, {-0.5, 0.0, 0.5, 0.0}, {0.0, 1.0, 0.0, 0.0}};
    double[][] C = new double[4][4];
    double[] X3 = this.C[0];
    double[] X2 = this.C[1];
    double[] X1 = this.C[2];
    double[] X0 = this.C[3];

    public BicubicInterpolation2D(double[][] G) {
        int k;
        int j;
        int i;
        double[][] T = new double[4][4];
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                for (k = 0; k < 4; ++k) {
                    double[] dArray = T[i];
                    int n = j;
                    dArray[n] = dArray[n] + G[i][k] * M[j][k];
                }
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                for (k = 0; k < 4; ++k) {
                    double[] dArray = this.C[i];
                    int n = j;
                    dArray[n] = dArray[n] + M[i][k] * T[k][j];
                }
            }
        }
    }

    public double eval(double x, double y) {
        return x * (x * (x * (y * (y * (y * this.X3[0] + this.X3[1]) + this.X3[2]) + this.X3[3]) + (y * (y * (y * this.X2[0] + this.X2[1]) + this.X2[2]) + this.X2[3])) + (y * (y * (y * this.X1[0] + this.X1[1]) + this.X1[2]) + this.X1[3])) + (y * (y * (y * this.X0[0] + this.X0[1]) + this.X0[2]) + this.X0[3]);
    }

    public static void main(String[] args) {
        double[][] G = new double[4][4];
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                G[x][y] = x * y;
                System.out.print(G[x][y] + " ");
            }
            System.out.println();
            System.out.println();
        }
        BicubicInterpolation2D interp = new BicubicInterpolation2D(G);
        System.out.println();
        System.out.println(interp.eval(0.37, 0.5));
    }
}

