/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.io.archive;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class CopyAvoidantInMemorySeekableByteChannel
implements SeekableByteChannel {
    private static final int DEFAULT_INITIAL_SIZE = 0xA00000;
    private static final boolean D = false;
    private static final boolean DD = false;
    private int curBlockSize;
    private int maxBlockSize;
    private List<byte[]> allData;
    private List<Integer> allDataStartPos;
    private int curDataIndex;
    private int curDataStartPos;
    private int posIndexInCur;
    private byte[] curData;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean closeable = new AtomicBoolean(true);
    private int position;
    private int size;

    public CopyAvoidantInMemorySeekableByteChannel(byte[] data) {
        this.init(data, data.length);
    }

    public CopyAvoidantInMemorySeekableByteChannel(byte[] data, int size) {
        this.init(data, size);
    }

    public CopyAvoidantInMemorySeekableByteChannel() {
        this(0xA00000);
    }

    public CopyAvoidantInMemorySeekableByteChannel(int size) {
        this.init(new byte[size], 0);
    }

    private void init(byte[] initial, int size) {
        Preconditions.checkState((size <= initial.length ? 1 : 0) != 0);
        this.curData = initial;
        this.curDataStartPos = 0;
        this.size = size;
        this.position = 0;
        this.curBlockSize = Integer.min(0x4000000, Integer.max(size, 0x100000));
        this.maxBlockSize = this.curBlockSize * 16;
        this.allData = new ArrayList<byte[]>();
        this.allData.add(this.curData);
        this.allDataStartPos = new ArrayList<Integer>();
        this.allDataStartPos.add(0);
        this.curDataIndex = 0;
        this.posIndexInCur = 0;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.ensureOpen();
        if (newPosition < 0L || newPosition > Integer.MAX_VALUE) {
            throw new IOException("Position has to be in range 0.. 2147483647");
        }
        this.setPositionInternal((int)newPosition);
        return this;
    }

    private void setPositionInternal(int newPosition) {
        Preconditions.checkState((newPosition >= 0 ? 1 : 0) != 0);
        if (newPosition == 0) {
            this.curDataIndex = 0;
            this.curData = this.allData.get(0);
            this.curDataStartPos = 0;
            this.posIndexInCur = 0;
            this.position = 0;
            return;
        }
        int posInCur = newPosition - this.curDataStartPos;
        if (posInCur < 0) {
            do {
                Preconditions.checkState((this.curDataIndex > 0 ? 1 : 0) != 0);
                --this.curDataIndex;
                this.curData = this.allData.get(this.curDataIndex);
                this.curDataStartPos = this.allDataStartPos.get(this.curDataIndex);
            } while (newPosition < this.curDataStartPos);
        } else if (posInCur >= this.curData.length) {
            while (this.curDataIndex < this.allData.size() - 1) {
                ++this.curDataIndex;
                this.curData = this.allData.get(this.curDataIndex);
                this.curDataStartPos = this.allDataStartPos.get(this.curDataIndex);
                if (newPosition >= this.curDataStartPos + this.curData.length) continue;
            }
        }
        this.posIndexInCur = newPosition - this.curDataStartPos;
        Preconditions.checkState((this.posIndexInCur >= 0 ? 1 : 0) != 0, (String)"Bad posIndexInCur=%s with newPosition=%s, curDataStartPos=%s, and curDataIndex=%s", (Object)this.posIndexInCur, (Object)newPosition, (Object)this.curDataStartPos, (Object)this.curDataIndex);
        this.position = newPosition;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public SeekableByteChannel truncate(long newSize) {
        if (newSize < 0L || newSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size has to be in range 0.. 2147483647");
        }
        if ((long)this.size > newSize) {
            this.size = (int)newSize;
        }
        if ((long)this.position > newSize) {
            this.setPositionInternal((int)newSize);
        }
        return this;
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        this.ensureOpen();
        int wanted = buf.remaining();
        int possible = this.size - this.position;
        if (possible <= 0) {
            return -1;
        }
        if (wanted > possible) {
            wanted = possible;
        }
        int read = 0;
        while (wanted > 0) {
            int possibleInCur = this.curData.length - this.posIndexInCur;
            if (wanted <= possibleInCur) {
                buf.put(this.curData, this.posIndexInCur, wanted);
                this.setPositionInternal(this.position + wanted);
                read += wanted;
                wanted = 0;
                continue;
            }
            int readLen = possibleInCur;
            buf.put(this.curData, this.posIndexInCur, readLen);
            wanted -= readLen;
            this.setPositionInternal(this.position + readLen);
            read += readLen;
            if (this.posIndexInCur <= this.curData.length) continue;
            break;
        }
        return read;
    }

    @Override
    public void close() {
        if (this.closeable.get()) {
            this.closed.set(true);
        }
    }

    public void open() {
        this.closed.set(false);
    }

    public void setCloseable(boolean closeable) {
        this.closeable.set(closeable);
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public int write(ByteBuffer b) throws IOException {
        this.ensureOpen();
        int wanted = b.remaining();
        int newSize = this.position + wanted;
        if (newSize < 0) {
            wanted = Integer.MAX_VALUE - this.position;
        }
        int origWanted = wanted;
        while (wanted > 0) {
            int possibleInCur = this.curData.length - this.posIndexInCur;
            if (wanted <= possibleInCur) {
                b.get(this.curData, this.posIndexInCur, wanted);
                this.setPositionInternal(this.position + wanted);
                this.size = Integer.max(this.size, this.position);
                wanted = 0;
                continue;
            }
            if (possibleInCur > 0) {
                int writeLen = possibleInCur;
                b.get(this.curData, this.posIndexInCur, writeLen);
                wanted -= writeLen;
                this.setPositionInternal(this.position + writeLen);
                this.size = Integer.max(this.size, this.position);
            }
            while (this.posIndexInCur >= this.curData.length) {
                Preconditions.checkState((this.curBlockSize > 0 ? 1 : 0) != 0);
                byte[] next = new byte[this.curBlockSize];
                int nextBlockSize = Integer.max(this.curBlockSize * 2, this.maxBlockSize);
                if (nextBlockSize > 0) {
                    this.curBlockSize = nextBlockSize;
                }
                int startPos = this.allDataStartPos.get(this.allDataStartPos.size() - 1) + this.allData.get(this.allData.size() - 1).length;
                this.allData.add(next);
                this.allDataStartPos.add(startPos);
                this.curData = next;
                this.curDataIndex = this.allDataStartPos.size() - 1;
                this.curDataStartPos = startPos;
                this.posIndexInCur = this.position - startPos;
                Preconditions.checkState((this.posIndexInCur >= 0 ? 1 : 0) != 0);
            }
        }
        return origWanted;
    }

    public byte[] array() {
        if (this.allData.size() == 1) {
            return this.curData;
        }
        byte[] bigArray = new byte[this.size];
        int destPos = 0;
        for (byte[] source : this.allData) {
            int len;
            int destEnd = destPos + source.length;
            int n = len = destEnd > this.size ? this.size - destPos : source.length;
            if (len <= 0) break;
            System.arraycopy(source, 0, bigArray, destPos, len);
            destPos += len;
        }
        int curBlockSize = this.curBlockSize;
        int maxBlockSize = this.maxBlockSize;
        this.init(bigArray, this.size);
        this.curBlockSize = curBlockSize;
        this.maxBlockSize = maxBlockSize;
        return bigArray;
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    public CopyAvoidantInMemorySeekableByteChannel copy() {
        CopyAvoidantInMemorySeekableByteChannel ret = new CopyAvoidantInMemorySeekableByteChannel(this.allData.get(0));
        for (int i = 1; i < this.allData.size(); ++i) {
            ret.allData.add(this.allData.get(i));
            ret.allDataStartPos.add(this.allDataStartPos.get(i));
        }
        ret.size = this.size;
        ret.setPositionInternal(this.position);
        ret.setCloseable(this.closeable.get());
        return ret;
    }

    public OutputStream getOutputStream() {
        final ByteBuffer singleByteBuffer = ByteBuffer.allocate(1);
        return new OutputStream(this){
            final /* synthetic */ CopyAvoidantInMemorySeekableByteChannel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void write(int b) throws IOException {
                singleByteBuffer.clear();
                singleByteBuffer.put(0, (byte)b);
                singleByteBuffer.flip();
                this.this$0.write(singleByteBuffer);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
                this.this$0.write(buffer);
            }
        };
    }

    public InputStream getInputStream() {
        final ByteBuffer singleByteBuffer = ByteBuffer.allocate(1);
        return new InputStream(this){
            final /* synthetic */ CopyAvoidantInMemorySeekableByteChannel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int read() throws IOException {
                singleByteBuffer.clear();
                int bytesRead = this.this$0.read(singleByteBuffer);
                if (bytesRead == -1) {
                    return -1;
                }
                singleByteBuffer.flip();
                return singleByteBuffer.get() & 0xFF;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || len < 0 || len > b.length - off) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
                int bytesRead = this.this$0.read(buffer);
                return bytesRead == 0 ? -1 : bytesRead;
            }

            @Override
            public long skip(long n) throws IOException {
                long size;
                if (n < 0L) {
                    return 0L;
                }
                long currentPosition = this.this$0.position();
                long newPosition = currentPosition + n;
                if (newPosition > (size = this.this$0.size())) {
                    newPosition = size;
                }
                this.this$0.position(newPosition);
                return newPosition - currentPosition;
            }

            @Override
            public int available() throws IOException {
                long size = this.this$0.size();
                long position = this.this$0.position();
                return (int)Math.min(Integer.MAX_VALUE, size - position);
            }
        };
    }
}

