/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.modules.helpers;

import com.google.common.base.Preconditions;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.ModuleHelper;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;

@ModuleHelper
public abstract class AbstractDoubleArrayCSV_BackedModule
implements CSV_BackedModule {
    protected double[] values;

    protected AbstractDoubleArrayCSV_BackedModule() {
    }

    public AbstractDoubleArrayCSV_BackedModule(double[] values) {
        this.values = values;
    }

    public double get(int index) {
        return this.values[index];
    }

    public double[] get() {
        return this.values;
    }

    protected abstract String getIndexHeading();

    protected abstract String getValueHeading();

    public CSVFile<String> getCSV() {
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine(this.getIndexHeading(), this.getValueHeading());
        for (int r = 0; r < this.values.length; ++r) {
            csv.addLine((String[])new String[]{"" + r, "" + this.values[r]});
        }
        return csv;
    }

    @Override
    public void initFromCSV(CSVFile<String> csv) {
        double[] vals = new double[csv.getNumRows() - 1];
        String heading = this.getIndexHeading();
        for (int row = 1; row < csv.getNumRows(); ++row) {
            int r = row - 1;
            Preconditions.checkState((r == csv.getInt(row, 0) ? 1 : 0) != 0, (String)"%s must be 0-based and in order. Expected %s at row %s", (Object)heading, (Object)r, (Object)row);
            vals[r] = csv.getDouble(row, 1);
        }
        this.values = vals;
    }

    @ModuleHelper
    public static abstract class Averageable<E extends Averageable<E>>
    extends AbstractDoubleArrayCSV_BackedModule
    implements AverageableModule<E> {
        protected Averageable() {
        }

        public Averageable(double[] values) {
            super(values);
        }

        @Override
        public AverageableModule.AveragingAccumulator<E> averagingAccumulator() {
            return new AverageableModule.AveragingAccumulator<E>(){
                private double[] avgValues = null;
                private double sumWeight = 0.0;

                @Override
                public void process(E module, double relWeight) {
                    if (this.avgValues == null) {
                        this.avgValues = new double[((Averageable)module).values.length];
                    } else {
                        Preconditions.checkState((((Averageable)module).values.length == this.avgValues.length ? 1 : 0) != 0);
                    }
                    for (int i = 0; i < this.avgValues.length; ++i) {
                        int n = i;
                        this.avgValues[n] = this.avgValues[n] + ((Averageable)module).values[i] * relWeight;
                    }
                    this.sumWeight += relWeight;
                }

                @Override
                public E getAverage() {
                    AverageableModule.scaleToTotalWeight(this.avgValues, this.sumWeight);
                    return this.averageInstance(this.avgValues);
                }

                @Override
                public Class<E> getType() {
                    return this.getClass();
                }
            };
        }

        protected abstract E averageInstance(double[] var1);
    }
}

