/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.modules.helpers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.modules.ModuleHelper;
import org.opensha.commons.util.modules.helpers.FileBackedModule;

@ModuleHelper
public interface JSON_BackedModule
extends FileBackedModule {
    public void writeToJSON(JsonWriter var1, Gson var2) throws IOException;

    public void initFromJSON(JsonReader var1, Gson var2) throws IOException;

    default public Gson buildGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        return builder.create();
    }

    @Override
    default public void writeToStream(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        this.writeToWriter(writer);
    }

    default public String getJSON() throws IOException {
        StringWriter writer = new StringWriter();
        this.writeToWriter(writer);
        return writer.toString();
    }

    private void writeToWriter(Writer writer) throws IOException {
        Gson gson = this.buildGson();
        JsonWriter jout = gson.newJsonWriter(writer);
        this.writeToJSON(jout, gson);
        writer.flush();
    }

    default public void initFromJSON(String json) throws IOException {
        this.initFromReader(new StringReader(json));
    }

    @Override
    default public void initFromStream(BufferedInputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        this.initFromReader(reader);
    }

    private void initFromReader(Reader reader) throws IOException {
        Gson gson = this.buildGson();
        JsonReader jin = gson.newJsonReader(reader);
        this.initFromJSON(jin, gson);
    }

    public static <E extends JSON_BackedModule> E loadFromArchive(ArchiveInput input, String entryPrefix, String fileName, Class<E> type) throws IOException {
        Constructor<E> constructor;
        BufferedInputStream zin = FileBackedModule.getInputStream(input, entryPrefix, fileName);
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        try {
            constructor.setAccessible(true);
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        try {
            System.out.println("Building instance: " + type.getName());
            JSON_BackedModule module = (JSON_BackedModule)constructor.newInstance(new Object[0]);
            module.initFromStream(zin);
            return (E)module;
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }
}

