/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.modules.helpers;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.opensha.commons.util.modules.ModuleHelper;
import org.opensha.commons.util.modules.helpers.FileBackedModule;

@ModuleHelper
public interface TextBackedModule
extends FileBackedModule {
    public String getText();

    public void setText(String var1);

    @Override
    default public void writeToStream(OutputStream out) throws IOException {
        TextBackedModule.writeToStream(out, this.getText());
    }

    public static void writeToStream(OutputStream out, String text) throws IOException {
        Preconditions.checkNotNull((Object)text, (Object)"Text is null, cannot write to stream");
        BufferedWriter bWrite = new BufferedWriter(new OutputStreamWriter(out));
        bWrite.write(text);
        bWrite.flush();
    }

    @Override
    default public void initFromStream(BufferedInputStream in) throws IOException {
        this.setText(TextBackedModule.readFromStream(in));
    }

    public static String readFromStream(InputStream in) throws IOException {
        int charsRead;
        InputStreamReader read = new InputStreamReader(in);
        StringBuilder text = new StringBuilder();
        char[] buff = new char[1000];
        while ((charsRead = read.read(buff)) != -1) {
            text.append(buff, 0, charsRead);
        }
        return text.toString();
    }
}

