/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.nshmp2.erf.NSHMP_ListERF;
import org.opensha.nshmp2.erf.source.FaultERF;
import org.opensha.nshmp2.erf.source.GridERF;
import org.opensha.nshmp2.erf.source.NSHMP_ERF;
import org.opensha.nshmp2.erf.source.Sources;
import org.opensha.nshmp2.erf.source.SubductionERF;
import org.opensha.nshmp2.util.FaultType;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.sha.util.FocalMech;

public class NSHMP2008
extends NSHMP_ListERF {
    private static final String BASE_NAME = "USGS NSHMP 2008";
    private static final String NSHMP_FAULT_TYPE_FILTER_PARAM_NAME = "Fault Type Filter";
    private static final String NSHMP_FOCAL_MECH_FILTER_PARAM_NAME = "Focal Mech Filter";

    private NSHMP2008(String name) {
        super((String)(name == null ? BASE_NAME : "USGS NSHMP 2008: " + name));
        System.out.println("Loading sources...");
    }

    private void initParams() {
    }

    private void initFaultParams() {
        EnumParameter<Object> faultTypeFilter = new EnumParameter<Object>(NSHMP_FAULT_TYPE_FILTER_PARAM_NAME, EnumSet.allOf(FaultType.class), null, "All");
        faultTypeFilter.addParameterChangeListener(this);
        EnumParameter<Object> focalMechFilter = new EnumParameter<Object>(NSHMP_FOCAL_MECH_FILTER_PARAM_NAME, EnumSet.allOf(FocalMech.class), null, "All");
        focalMechFilter.addParameterChangeListener(this);
    }

    public static NSHMP2008 create() {
        NSHMP2008 erf = new NSHMP2008(null);
        erf.addERFs(Sources.getGridList(SourceRegion.CEUS));
        erf.addERFs(Sources.getFaultList(SourceRegion.CEUS));
        erf.addERFs(Sources.getClusterList(SourceRegion.CEUS));
        erf.addERFs(Sources.getGridList(SourceRegion.WUS));
        erf.addERFs(Sources.getFaultList(SourceRegion.WUS));
        erf.addERFs(Sources.getGridList(SourceRegion.CA));
        erf.addERFs(Sources.getFaultList(SourceRegion.CA));
        erf.addERFs(Sources.getSubductionList(SourceRegion.CASC));
        return erf;
    }

    public static NSHMP2008 createSingleSource(String name) {
        NSHMP2008 erf = new NSHMP2008(name);
        erf.addERF(Sources.get(name));
        return erf;
    }

    public static NSHMP2008 createCalifornia() {
        NSHMP2008 erf = new NSHMP2008(null);
        List<GridERF> gridERFs = Sources.getGridList(SourceRegion.CA);
        ArrayList removals = Lists.newArrayList();
        for (GridERF gerf : gridERFs) {
            if (!gerf.getName().equals("CAdeep.in")) continue;
            removals.add(gerf);
        }
        gridERFs.removeAll(removals);
        erf.addERFs(gridERFs);
        erf.addERFs(Sources.getFaultList(SourceRegion.CA));
        erf.addERF(Sources.get("EXTmap.ch.in"));
        erf.addERF(Sources.get("EXTmap.gr.in"));
        erf.addERF(Sources.get("WUSmap.ch.in"));
        erf.addERF(Sources.get("WUSmap.gr.in"));
        return erf;
    }

    public static NSHMP2008 createCaliforniaNW() {
        NSHMP2008 erf = new NSHMP2008(null);
        erf.addERFs(Sources.getGridList(SourceRegion.CA));
        erf.addERFs(Sources.getFaultList(SourceRegion.CA));
        erf.addERFs(Sources.getSubductionList(SourceRegion.CASC));
        erf.addERF(Sources.get("EXTmap.ch.in"));
        erf.addERF(Sources.get("EXTmap.gr.in"));
        erf.addERF(Sources.get("WUSmap.ch.in"));
        erf.addERF(Sources.get("WUSmap.gr.in"));
        return erf;
    }

    public static NSHMP2008 createCaliforniaCSEP() {
        NSHMP2008 erf = new NSHMP2008("CSEP");
        List<GridERF> gridERFs = Sources.getGridList(SourceRegion.CA);
        erf.addERFs(gridERFs);
        erf.addERF(Sources.get("EXTmap.ch.in"));
        erf.addERF(Sources.get("EXTmap.gr.in"));
        erf.addERF(Sources.get("WUSmap.ch.in"));
        erf.addERF(Sources.get("WUSmap.gr.in"));
        List<FaultERF> caFaults = Sources.getFaultList(SourceRegion.CA);
        erf.addERFs(caFaults);
        erf.addERF(Sources.get("brange.3dip.65.in"));
        erf.addERF(Sources.get("brange.3dip.ch.in"));
        erf.addERF(Sources.get("brange.3dip.gr.in"));
        erf.addERF(Sources.get("nv.3dip.ch.in"));
        erf.addERF(Sources.get("nv.3dip.gr.in"));
        erf.addERF(Sources.get("nvut.3dip.65.in"));
        erf.addERF(Sources.get("orwa_n.3dip.ch.in"));
        erf.addERF(Sources.get("orwa_n.3dip.gr.in"));
        erf.addERF(Sources.get("orwa_c.in"));
        List<SubductionERF> subs = Sources.getSubductionList(SourceRegion.CASC);
        erf.addERFs(subs);
        return erf;
    }

    public static NSHMP2008 createCaliforniaFault() {
        NSHMP2008 erf = new NSHMP2008(null);
        erf.addERFs(Sources.getFaultList(SourceRegion.CA));
        return erf;
    }

    public static NSHMP2008 createCaliforniaGridded() {
        NSHMP2008 erf = new NSHMP2008(null);
        List<GridERF> gridERFs = Sources.getGridList(SourceRegion.CA);
        ArrayList removals = Lists.newArrayList();
        for (GridERF gerf : gridERFs) {
            if (!gerf.getName().equals("CAdeep.in")) continue;
            removals.add(gerf);
        }
        gridERFs.removeAll(removals);
        erf.addERFs(gridERFs);
        erf.addERF(Sources.get("EXTmap.ch.in"));
        erf.addERF(Sources.get("EXTmap.gr.in"));
        erf.addERF(Sources.get("WUSmap.ch.in"));
        erf.addERF(Sources.get("WUSmap.gr.in"));
        return erf;
    }

    public static NSHMP2008 createCaliforniaFixedStrk() {
        NSHMP2008 erf = new NSHMP2008(null);
        ArrayList gridERFs = Lists.newArrayList();
        erf.addERF(Sources.get("brawmap.in"));
        erf.addERF(Sources.get("creepmap.in"));
        erf.addERF(Sources.get("sangorg.in"));
        erf.addERF(Sources.get("mendo.in"));
        erf.addERF(Sources.get("mojave.in"));
        erf.addERF(Sources.get("shear1.in"));
        erf.addERF(Sources.get("shear2.in"));
        erf.addERF(Sources.get("shear3.in"));
        erf.addERF(Sources.get("shear4.in"));
        return erf;
    }

    public static NSHMP2008 createCaliforniaPointSrc() {
        NSHMP2008 erf = new NSHMP2008(null);
        ArrayList gridERFs = Lists.newArrayList();
        erf.addERF(Sources.get("CAmap.24.ch.in"));
        erf.addERF(Sources.get("CAmap.21.ch.in"));
        erf.addERF(Sources.get("CAmap.21.gr.in"));
        erf.addERF(Sources.get("CAmap.24.gr.in"));
        erf.addERF(Sources.get("impext.ch.in"));
        erf.addERF(Sources.get("impext.gr.in"));
        erf.addERF(Sources.get("EXTmap.ch.in"));
        erf.addERF(Sources.get("EXTmap.gr.in"));
        erf.addERF(Sources.get("WUSmap.ch.in"));
        erf.addERF(Sources.get("WUSmap.gr.in"));
        return erf;
    }

    public static NSHMP2008 createCUES_Memphis() {
        NSHMP2008 erf = new NSHMP2008(null);
        erf.addERF(Sources.get("CEUS.2007all8.AB.in"));
        erf.addERF(Sources.get("CEUS.2007all8.J.in"));
        erf.addERF(Sources.get("newmad.500.cluster.in"));
        erf.addERF(Sources.get("newmad.750.cluster.in"));
        erf.addERF(Sources.get("newmad.1000.cluster.in"));
        erf.addERF(Sources.get("newmad.1500.cluster.in"));
        erf.addERF(Sources.get("NMSZnocl.500yr.5branch.in"));
        erf.addERF(Sources.get("NMSZnocl.1000yr.5branch.in"));
        return erf;
    }

    private void init() {
        this.addERFs(Sources.getGridList(SourceRegion.CEUS));
        System.out.println("CEUS_GRD " + this.getSourceCount());
        this.addERFs(Sources.getFaultList(SourceRegion.CEUS));
        System.out.println("CEUS_FLT " + this.getSourceCount());
        this.addERFs(Sources.getClusterList(SourceRegion.CEUS));
        System.out.println("CEUS_CLU " + this.getSourceCount());
        this.addERFs(Sources.getGridList(SourceRegion.WUS));
        System.out.println("WUS_GRD  " + this.getSourceCount());
        this.addERFs(Sources.getFaultList(SourceRegion.WUS));
        System.out.println("WUS_FLT  " + this.getSourceCount());
        this.addERFs(Sources.getGridList(SourceRegion.CA));
        System.out.println("CA_GRD   " + this.getSourceCount());
        this.addERFs(Sources.getFaultList(SourceRegion.CA));
        System.out.println("CA_FLT   " + this.getSourceCount());
        this.addERFs(Sources.getSubductionList(SourceRegion.CASC));
        System.out.println("WUS_SUB  " + this.getSourceCount());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (NSHMP_ERF src : this) {
            sb.append(StringUtils.rightPad((String)src.getName(), (int)30));
            sb.append(StringUtils.rightPad((String)src.getSourceRegion().name(), (int)6));
            sb.append(StringUtils.rightPad((String)src.getSourceType().name(), (int)14));
            sb.append(StringUtils.rightPad((String)src.getSourceIMR().name(), (int)12));
            sb.append(StringUtils.rightPad((String)String.valueOf(src.getSourceWeight()), (int)12));
            sb.append(StringUtils.rightPad((String)String.valueOf(src.getRuptureCount()), (int)10));
            sb.append(StringUtils.leftPad((String)String.valueOf(src.getMaxDistance()), (int)10));
            sb.append(IOUtils.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        NSHMP2008 erf = NSHMP2008.createCUES_Memphis();
        TimeSpan ts = new TimeSpan("None", "Years");
        ts.setDuration(1.0);
        erf.setTimeSpan(ts);
        erf.updateForecast();
        System.out.println(erf.getSourceCount());
        System.out.println(erf.getRuptureCount());
    }
}

