/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.Location;
import org.opensha.nshmp2.erf.source.NSHMP_ERF;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.nshmp2.util.SourceType;
import org.opensha.sha.earthquake.AbstractEpistemicListERF;
import org.opensha.sha.earthquake.ERF;

public abstract class NSHMP_ListERF
extends AbstractEpistemicListERF
implements Iterable<NSHMP_ERF> {
    private String name;
    private Multimap<SourceType, NSHMP_ERF> typeMap;
    private Multimap<SourceRegion, NSHMP_ERF> regionMap;
    private static final double CEUS_LIMIT = -115.0;
    private static final double WUS_LIMIT = -100.0;

    public NSHMP_ListERF(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"Must supply a name for this ERF");
        this.name = name;
        this.typeMap = ArrayListMultimap.create();
        this.regionMap = ArrayListMultimap.create();
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.setDuration(1.0);
        this.timeSpan.addParameterChangeListener(this);
    }

    protected void addERF(NSHMP_ERF erf) {
        Preconditions.checkNotNull((Object)erf, (Object)"Supplied ERF is null");
        this.typeMap.put((Object)erf.getSourceType(), (Object)erf);
        this.regionMap.put((Object)erf.getSourceRegion(), (Object)erf);
        super.addERF(erf, erf.getSourceWeight());
    }

    protected void addERFs(List<? extends NSHMP_ERF> erfs) {
        Preconditions.checkNotNull(erfs, (Object)"Supplied ERF list is null");
        for (NSHMP_ERF nSHMP_ERF : erfs) {
            this.addERF(nSHMP_ERF);
        }
    }

    @Override
    public NSHMP_ERF getERF(int idx) {
        return (NSHMP_ERF)super.getERF(idx);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getRuptureCount() {
        int count = 0;
        for (int i = 0; i < this.getNumERFs(); ++i) {
            count += this.getERF(i).getRuptureCount();
        }
        return count;
    }

    public int getSourceCount(int idx) {
        return this.getERF(idx).getNumSources();
    }

    public int getSourceCount() {
        int count = 0;
        for (ERF erf : this.erf_List) {
            count += erf.getNumSources();
        }
        return count;
    }

    public int getNumSources(SourceType type) {
        Collection erfList = this.typeMap.get((Object)type);
        if (erfList == null) {
            return 0;
        }
        int count = 0;
        for (ERF erf : erfList) {
            count += erf.getNumSources();
        }
        return count;
    }

    @Override
    public Iterator<NSHMP_ERF> iterator() {
        return new Iterator<NSHMP_ERF>(){
            Iterator<ERF> it;
            {
                this.it = NSHMP_ListERF.this.erf_List.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public NSHMP_ERF next() {
                return (NSHMP_ERF)this.it.next();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    public Iterable<NSHMP_ERF> asFilteredIterable(Location loc) {
        return Iterables.filter((Iterable)this, (Predicate)new SourceRegionPredicate(loc));
    }

    private static class SourceRegionPredicate
    implements Predicate<NSHMP_ERF> {
        Set<SourceRegion> regions;

        SourceRegionPredicate(Location loc) {
            double lon = loc.getLongitude();
            this.regions = lon <= -115.0 ? EnumSet.of(SourceRegion.WUS, SourceRegion.CA, SourceRegion.CASC) : (lon >= -100.0 ? EnumSet.of(SourceRegion.CEUS) : EnumSet.allOf(SourceRegion.class));
        }

        public boolean apply(NSHMP_ERF erf) {
            return this.regions.contains((Object)erf.getSourceRegion());
        }
    }
}

