/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.opensha.commons.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.LocationList;
import org.opensha.nshmp2.erf.source.CA_MagAreaRelationship;
import org.opensha.nshmp2.erf.source.SourceFile;
import org.opensha.nshmp2.util.FaultType;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.nshmp2.util.SourceType;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FloatingPoissonFaultSource;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.FocalMech;

public class FaultSource
extends ProbEqkSource {
    private static final MagScalingRelationship WCLmsr = new WC1994_MagLengthRelationship();
    private static final MagScalingRelationship CAFmsr = new CA_MagAreaRelationship();
    FaultTrace trace;
    List<IncrementalMagFreqDist> mfds;
    SourceFile file;
    String name;
    FaultType type;
    FocalMech mech;
    int nMag;
    boolean floats;
    double dip;
    double width;
    double top;
    int size = 0;
    StirlingGriddedSurface surface;
    List<FloatingPoissonFaultSource> sources;
    List<Integer> rupCount;

    FaultSource() {
    }

    public void init() {
        double lowerSeis = this.top + this.width * Math.sin(this.dip * GeoTools.TO_RAD);
        SimpleFaultData sfd = new SimpleFaultData(this.dip, lowerSeis, this.top, this.trace);
        this.surface = new StirlingGriddedSurface(sfd, 1.0, 1.0);
        if (this.mfds.size() == 0) {
            return;
        }
        this.sources = Lists.newArrayList();
        this.rupCount = Lists.newArrayList();
        this.rupCount.add(0);
        this.size = 0;
        MagScalingRelationship msr = this.file.getType() == SourceType.FAULT && this.file.getRegion() == SourceRegion.CA && this.floats ? CAFmsr : WCLmsr;
        for (IncrementalMagFreqDist mfd : this.mfds) {
            FloatingPoissonFaultSource source = new FloatingPoissonFaultSource(mfd, this.surface, msr, 0.0, 1.0, 1.0, this.mech.rake(), 1.0, 0.0, 0, this.floats ? 10.0 : 0.0);
            this.sources.add(source);
            int rups = source.getNumRuptures();
            this.size += rups;
            this.rupCount.add(this.size);
        }
    }

    @Override
    public LocationList getAllSourceLocs() {
        return this.surface.getEvenlyDiscritizedListOfLocsOnSurface();
    }

    @Override
    public EvenlyGriddedSurface getSourceSurface() {
        return this.surface;
    }

    @Override
    public double getMinDistance(Site site) {
        if (this.sources == null || this.sources.size() == 0) {
            return Double.NaN;
        }
        return this.sources.get(0).getMinDistance(site);
    }

    @Override
    public int getNumRuptures() {
        return this.size;
    }

    @Override
    public ProbEqkRupture getRupture(int idx) {
        if (this.getNumRuptures() == 0) {
            return null;
        }
        for (int i = 0; i < this.rupCount.size(); ++i) {
            if (idx >= this.rupCount.get(i)) continue;
            return this.sources.get(i - 1).getRupture(idx - this.rupCount.get(i - 1));
        }
        return null;
    }

    @Override
    public List<ProbEqkRupture> getRuptureList() {
        throw new UnsupportedOperationException("A FaultSource does not allow access to the list of all possible sources.");
    }

    @Override
    public Iterator<ProbEqkRupture> iterator() {
        return new Iterator<ProbEqkRupture>(){
            int size;
            int caret;
            {
                this.size = FaultSource.this.getNumRuptures();
                this.caret = 0;
            }

            @Override
            public boolean hasNext() {
                return this.caret < this.size;
            }

            @Override
            public ProbEqkRupture next() {
                return FaultSource.this.getRupture(this.caret++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "==========  Fault Source  ==========" + IOUtils.LINE_SEPARATOR + "   Fault name: " + this.name + IOUtils.LINE_SEPARATOR + "         type: " + (Object)((Object)this.type) + IOUtils.LINE_SEPARATOR + "         mech: " + (Object)((Object)this.mech) + IOUtils.LINE_SEPARATOR + "         mags: " + this.nMag + IOUtils.LINE_SEPARATOR + "         mfds: " + this.mfds.size() + IOUtils.LINE_SEPARATOR + "       floats: " + this.floats + IOUtils.LINE_SEPARATOR + "          dip: " + this.dip + IOUtils.LINE_SEPARATOR + "        width: " + this.width + IOUtils.LINE_SEPARATOR + "          top: " + this.top + IOUtils.LINE_SEPARATOR;
    }

    public List<IncrementalMagFreqDist> getMFDs() {
        return this.mfds;
    }
}

