/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import java.util.Map;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.nshmp2.erf.source.PointSource13;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.FocalMech;

public class FixedStrikeSource
extends PointSource13 {
    private static final String NAME = "NSHMP Fixed Strike Source";
    private static final String RUP_NAME = "NSHMP Fixed Strike Fault";
    private MagLengthRelationship mlr;
    private double strike = 0.0;
    private FrankelGriddedSurface surface;

    public FixedStrikeSource(Location loc, IncrementalMagFreqDist mfd, MagLengthRelationship mlr, double duration, double[] depths, Map<FocalMech, Double> mechWtMap, double strike) {
        super(loc, mfd, duration, depths, mechWtMap);
        this.name = NAME;
        this.mlr = mlr;
        this.strike = strike;
    }

    @Override
    protected void updateRupture(double mag, double dip, double rake, double depth, double width, boolean footwall) {
        if (mag >= 6.0) {
            double halfLen = this.mlr.getMedianLength(mag) / 2.0;
            Location faultEnd1 = LocationUtils.location(this.getLocation(), new LocationVector(this.strike, halfLen, 0.0));
            LocationVector faultVec = LocationUtils.vector(faultEnd1, this.getLocation());
            faultVec.setHorzDistance(halfLen * 2.0);
            Location faultEnd2 = LocationUtils.location(faultEnd1, faultVec);
            FaultTrace fault = new FaultTrace(RUP_NAME);
            fault.add(faultEnd1);
            fault.add(faultEnd2);
            this.surface = new FrankelGriddedSurface(fault, dip, depth, depth + 0.01, 1.0);
            this.probEqkRupture.setMag(mag);
            this.probEqkRupture.setAveRake(rake);
            this.probEqkRupture.setRuptureSurface(this.surface);
        } else {
            super.updateRupture(mag, dip, rake, depth, width, footwall);
        }
    }
}

