/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.util.Precision;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.nshmp2.util.SourceType;

class SourceFile {
    private SourceRegion region;
    private SourceType type;
    private URL url;
    private double weight;
    private String name;

    SourceFile(URL url, SourceRegion region, SourceType type, double weight) {
        this.url = url;
        this.region = region;
        this.type = type;
        this.weight = weight;
        this.name = StringUtils.substringAfterLast((String)url.toString(), (String)"/");
    }

    public String toString() {
        return new StringBuffer(StringUtils.rightPad((String)this.region.toString(), (int)24)).append(StringUtils.rightPad((String)this.type.toString(), (int)12)).append(StringUtils.rightPad((String)Double.valueOf(Precision.round((double)this.weight, (int)7)).toString(), (int)11)).append(this.name).toString();
    }

    SourceRegion getRegion() {
        return this.region;
    }

    SourceType getType() {
        return this.type;
    }

    String getName() {
        return this.name;
    }

    double getWeight() {
        return this.weight;
    }

    List<String> readLines() {
        List lines = null;
        try {
            lines = Resources.readLines((URL)this.url, (Charset)Charsets.US_ASCII);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return lines;
    }
}

