/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.opensha.commons.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.LocationList;
import org.opensha.nshmp2.erf.source.FaultSource;
import org.opensha.nshmp2.erf.source.GeoMat_MagLenthRelationship;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.rupForecastImpl.FloatingPoissonFaultSource;
import org.opensha.sha.faultSurface.ApproxEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class SubductionSource
extends FaultSource {
    private static final MagScalingRelationship SUBmsr = new GeoMat_MagLenthRelationship();
    FaultTrace lowerTrace;
    int size = 0;
    ApproxEvenlyGriddedSurface surface;
    List<FloatingPoissonFaultSource> sources;
    List<Integer> rupCount;

    SubductionSource() {
    }

    @Override
    public void init() {
        this.surface = new ApproxEvenlyGriddedSurface(this.trace, this.lowerTrace, 5.0);
        if (this.mfds.size() == 0) {
            return;
        }
        this.sources = Lists.newArrayList();
        this.rupCount = Lists.newArrayList();
        this.rupCount.add(0);
        this.size = 0;
        for (IncrementalMagFreqDist mfd : this.mfds) {
            FloatingPoissonFaultSource source = new FloatingPoissonFaultSource(mfd, this.surface, SUBmsr, 0.0, 1.0, 5.0, this.mech.rake(), 1.0, 0.0, 0, this.floats ? 10.0 : 0.0);
            this.sources.add(source);
            int rups = source.getNumRuptures();
            this.size += rups;
            this.rupCount.add(this.size);
        }
    }

    @Override
    public LocationList getAllSourceLocs() {
        return this.surface.getEvenlyDiscritizedListOfLocsOnSurface();
    }

    @Override
    public EvenlyGriddedSurface getSourceSurface() {
        return this.surface;
    }

    @Override
    public double getMinDistance(Site site) {
        if (this.sources == null || this.sources.size() == 0) {
            return Double.NaN;
        }
        return this.sources.get(0).getMinDistance(site);
    }

    @Override
    public int getNumRuptures() {
        return this.size;
    }

    @Override
    public ProbEqkRupture getRupture(int idx) {
        if (this.getNumRuptures() == 0) {
            return null;
        }
        for (int i = 0; i < this.rupCount.size(); ++i) {
            if (idx >= this.rupCount.get(i)) continue;
            return this.sources.get(i - 1).getRupture(idx - this.rupCount.get(i - 1));
        }
        return null;
    }

    @Override
    public Iterator<ProbEqkRupture> iterator() {
        return new Iterator<ProbEqkRupture>(){
            int caret = 0;

            @Override
            public boolean hasNext() {
                return this.caret < SubductionSource.this.size;
            }

            @Override
            public ProbEqkRupture next() {
                return SubductionSource.this.getRupture(this.caret++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return "=============  Source  =============" + IOUtils.LINE_SEPARATOR + "   Fault name: " + this.name + IOUtils.LINE_SEPARATOR + "         type: " + (Object)((Object)this.type) + IOUtils.LINE_SEPARATOR + "         mech: " + (Object)((Object)this.mech) + IOUtils.LINE_SEPARATOR + "         mags: " + this.nMag + IOUtils.LINE_SEPARATOR + "         mfds: " + this.mfds.size() + IOUtils.LINE_SEPARATOR + "       floats: " + this.floats + IOUtils.LINE_SEPARATOR + "          dip: " + this.dip + IOUtils.LINE_SEPARATOR + "        width: " + this.width + IOUtils.LINE_SEPARATOR + "          top: " + this.top + IOUtils.LINE_SEPARATOR;
    }
}

