/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.nshmp2.util.NSHMP_IMR_Util;
import org.opensha.nshmp2.util.Period;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.BA_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CY_2008_AttenRel;
import org.opensha.sha.imr.param.EqkRuptureParams.DipParam;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncLevelParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncTypeParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusDistX_OverRupParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusJB_OverRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;

public class NSHMP08_WUS
extends AttenuationRelationship
implements ParameterChangeListener {
    public static final String NAME = "NSHMP 2008 Western US Combined";
    public static final String SHORT_NAME = "NSHMP08_WUS";
    private static final long serialVersionUID = 1L;
    private static final double VS30_WARN_MIN = 80.0;
    private static final double VS30_WARN_MAX = 1300.0;
    Map<ScalarIMR, Double> imrMap;
    public static final String IMR_UNCERT_PARAM_NAME = "IMR uncertainty";
    private boolean includeImrUncert = true;
    private static final String HW_EFFECT_PARAM_NAME = "Hanging Wall Effect Approx.";
    private boolean hwEffectApprox = true;
    private static final int EPI_CT = 3;
    private static final double[] EPI_SIGN = new double[]{-1.0, 0.0, 1.0, 0.0};
    private static final double[] EPI_WT = new double[]{0.185, 0.63, 0.185};
    private static final double[][] EPI_VAL = new double[][]{{0.375, 0.23, 0.4}, {0.21, 0.225, 0.36}, {0.245, 0.23, 0.31}};

    public NSHMP08_WUS() {
        this.initImrMap();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initParameterEventListeners();
        this.setParamDefaults();
    }

    void initImrMap() {
        this.imrMap = Maps.newHashMap();
        this.imrMap.put(new NSHMP_BA_2008(), 0.3333);
        this.imrMap.put(new NSHMP_CB_2008(), 0.3333);
        this.imrMap.put(new NSHMP_CY_2008(), 0.3334);
    }

    @Override
    public void setUserMaxDistance(double maxDist) {
        for (ScalarIMR imr : this.imrMap.keySet()) {
            imr.setUserMaxDistance(maxDist);
        }
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.sigmaTruncTypeParam.setValueAsDefault();
        this.sigmaTruncLevelParam.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.rupTopDepthParam.setValueAsDefault();
        this.dipParam.setValueAsDefault();
        this.distanceJBParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.distRupMinusJB_OverRupParam.setValueAsDefault();
        this.distRupMinusDistX_OverRupParam.setValueAsDefault();
        this.depthTo2pt5kmPerSecParam.setValueAsDefault();
        this.depthTo1pt0kmPerSecParam.setValueAsDefault();
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        ArrayList perVals = Lists.newArrayList();
        for (Period p : Period.getWUS()) {
            perVals.add(p.getValue());
        }
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint(perVals);
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint, 1.0, false);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initSiteParams() {
        this.siteParams.clear();
        this.vs30Param = new Vs30_Param(80.0, 1300.0);
        this.siteParams.addParameter(this.vs30Param);
        this.depthTo2pt5kmPerSecParam = new DepthTo2pt5kmPerSecParam(null, 0.0, 10.0, true);
        this.depthTo2pt5kmPerSecParam.setValueAsDefault();
        this.siteParams.addParameter(this.depthTo2pt5kmPerSecParam);
        this.depthTo1pt0kmPerSecParam = new DepthTo1pt0kmPerSecParam(null, true);
        this.depthTo1pt0kmPerSecParam.setValueAsDefault();
        this.siteParams.addParameter(this.depthTo1pt0kmPerSecParam);
        this.vs30_TypeParam = new Vs30_TypeParam();
        this.siteParams.addParameter(this.vs30_TypeParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.GMRotI50, Component.GMRotI50);
        this.componentParam.setValueAsDefault();
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.stdDevTypeParam.setValueAsDefault();
        BooleanParameter imrUncertParam = new BooleanParameter(IMR_UNCERT_PARAM_NAME, this.includeImrUncert);
        BooleanParameter hwEffectApproxParam = new BooleanParameter(HW_EFFECT_PARAM_NAME, this.hwEffectApprox);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
        this.otherParams.addParameter(imrUncertParam);
        this.otherParams.addParameter(hwEffectApproxParam);
        this.sigmaTruncTypeParam.setValue("1 Sided");
        this.sigmaTruncLevelParam.setValue(3.0);
        imrUncertParam.addParameterChangeListener(this);
        hwEffectApproxParam.addParameterChangeListener(this);
        for (ScalarIMR imr : this.imrMap.keySet()) {
            ParameterList list = imr.getOtherParams();
            ComponentParam cp = (ComponentParam)list.getParameter("Component");
            cp.setValue(Component.GMRotI50);
            StdDevTypeParam stp = (StdDevTypeParam)list.getParameter("Std Dev Type");
            stp.setValue("Total");
            SigmaTruncTypeParam sttp = (SigmaTruncTypeParam)list.getParameter("Gaussian Truncation");
            sttp.setValue("1 Sided");
            SigmaTruncLevelParam stlp = (SigmaTruncLevelParam)list.getParameter("Truncation Level");
            stlp.setValue(3.0);
        }
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(5.0, 8.0);
        this.dipParam = new DipParam(15.0, 90.0);
        this.rupTopDepthParam = new RupTopDepthParam(0.0, 15.0);
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Strike-Slip");
        constraint.addString("Normal");
        constraint.addString("Reverse");
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, "Strike-Slip");
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
        this.eqkRuptureParams.addParameter(this.dipParam);
        this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceJBParam = new DistanceJBParameter(0.0);
        DoubleConstraint warn = new DoubleConstraint(0.0, 200.0);
        this.distanceJBParam.setWarningConstraint(warn);
        this.distanceJBParam.setNonEditable();
        this.distanceRupParam = new DistanceRupParameter(0.0);
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.distRupMinusJB_OverRupParam = new DistRupMinusJB_OverRupParameter(0.0);
        DoubleConstraint warnJB = new DoubleConstraint(0.0, 50.0);
        this.distRupMinusJB_OverRupParam.setWarningConstraint(warnJB);
        this.distRupMinusJB_OverRupParam.setNonEditable();
        this.distRupMinusDistX_OverRupParam = new DistRupMinusDistX_OverRupParam();
        this.propagationEffectParams.addParameter(this.distanceJBParam);
        this.propagationEffectParams.addParameter(this.distanceRupParam);
        this.propagationEffectParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.propagationEffectParams.addParameter(this.distRupMinusDistX_OverRupParam);
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceJBParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.fltTypeParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
        this.vs30_TypeParam.addParameterChangeListener(this);
        this.rupTopDepthParam.addParameterChangeListener(this);
        this.dipParam.addParameterChangeListener(this);
        this.depthTo1pt0kmPerSecParam.addParameterChangeListener(this);
        this.depthTo2pt5kmPerSecParam.addParameterChangeListener(this);
        this.distanceRupParam.addParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.addParameterChangeListener(this);
        this.distRupMinusDistX_OverRupParam.addParameterChangeListener(this);
        this.sigmaTruncTypeParam.addParameterChangeListener(this);
        this.sigmaTruncLevelParam.addParameterChangeListener(this);
        this.tectonicRegionTypeParam.addParameterChangeListener(this);
        this.componentParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
    }

    @Override
    public void setSite(Site site) {
        this.site = site;
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        for (ScalarIMR imr : this.imrMap.keySet()) {
            imr.setSite(site);
        }
        this.setPropagationEffectParams();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        this.eqkRupture = eqkRupture;
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        for (ScalarIMR imr : this.imrMap.keySet()) {
            imr.setEqkRupture(eqkRupture);
        }
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceJBParam.setValue(this.eqkRupture, this.site);
        }
    }

    public String getEpsilonDataVals() {
        Object data = "";
        for (ScalarIMR imr : this.imrMap.keySet()) {
            data = (String)data + imr.getShortName() + " " + String.valueOf(this.im.getValue()) + " " + imr.getMean() + " " + imr.getStdDev() + "\n";
        }
        return data;
    }

    public String getPEs() {
        Object data = "";
        for (ScalarIMR imr : this.imrMap.keySet()) {
            double mean = imr.getMean();
            double std = imr.getStdDev();
            double iml = (Double)this.im.getValue();
            double pe1 = ((AttenuationRelationship)imr).getExceedProbability();
            double pe2 = Utils.getExceedProbability(iml, mean, std, false, 0.0);
            data = (String)data + imr.getShortName() + " " + pe1 + " " + pe2 + "\n";
        }
        return data;
    }

    @Override
    public double getMean() {
        double mean = 0.0;
        for (ScalarIMR imr : this.imrMap.keySet()) {
            mean += 0.3333 * Math.exp(imr.getMean());
        }
        return Math.log(mean);
    }

    @Override
    public double getStdDev() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getEpsilon() {
        int curveCount = this.imrMap.size();
        if (this.includeImrUncert) {
            curveCount *= 3;
        }
        double[] means = new double[curveCount];
        double[] sigmas = new double[curveCount];
        double[] weights = new double[curveCount];
        int idx = 0;
        for (ScalarIMR imr : this.imrMap.keySet()) {
            double m = imr.getMean();
            double s = imr.getStdDev();
            double w = this.imrMap.get(imr);
            if (this.includeImrUncert) {
                double mag = (Double)this.magParam.getValue();
                double dist = (Double)this.distanceJBParam.getValue();
                double epiVal = NSHMP08_WUS.getUncertainty(mag, dist);
                for (int i = 0; i < 3; ++i) {
                    means[idx] = m + epiVal * EPI_SIGN[i];
                    weights[idx] = w * EPI_WT[i];
                    sigmas[idx] = s;
                    ++idx;
                }
                continue;
            }
            means[idx] = m;
            sigmas[idx] = s;
            weights[idx] = w;
            ++idx;
        }
        double iml = (Double)this.im.getValue();
        double epsilon = 0.0;
        for (int i = 0; i < means.length; ++i) {
            epsilon += (iml - means[i]) / sigmas[i] * weights[i];
        }
        return epsilon;
    }

    @Override
    public double getEpsilon(double iml) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) throws ParameterException {
        int curveCount = this.imrMap.size();
        if (this.includeImrUncert) {
            curveCount *= 3;
        }
        double[] means = new double[curveCount];
        double[] sigmas = new double[curveCount];
        double[] weights = new double[curveCount];
        int idx = 0;
        for (ScalarIMR imr : this.imrMap.keySet()) {
            double m = imr.getMean();
            double s = imr.getStdDev();
            double w = this.imrMap.get(imr);
            if (this.includeImrUncert) {
                double mag = (Double)this.magParam.getValue();
                double dist = (Double)this.distanceJBParam.getValue();
                double epiVal = NSHMP08_WUS.getUncertainty(mag, dist);
                for (int i = 0; i < 3; ++i) {
                    means[idx] = m + epiVal * EPI_SIGN[i];
                    weights[idx] = w * EPI_WT[i];
                    sigmas[idx] = s;
                    ++idx;
                }
                continue;
            }
            means[idx] = m;
            sigmas[idx] = s;
            weights[idx] = w;
            ++idx;
        }
        Utils.zeroFunc(imls);
        DiscretizedFunc f = imls.deepClone();
        for (int i = 0; i < means.length; ++i) {
            f = Utils.getExceedProbabilities(f, means[i], sigmas[i], false, 0.0);
            f.scale(weights[i]);
            Utils.addFunc(imls, f);
        }
        return imls;
    }

    private String buildParamString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("mag=").append(String.format("%.3f", this.eqkRupture.getMag())).append(", ");
        sb.append("rjb=").append(String.format("%.3f", this.eqkRupture.getRuptureSurface().getDistanceJB(this.site.getLocation()))).append(", ");
        sb.append("rrup=").append(String.format("%.3f", this.eqkRupture.getRuptureSurface().getDistanceRup(this.site.getLocation()))).append(", ");
        sb.append("rx=").append(String.format("%.3f", this.eqkRupture.getRuptureSurface().getDistanceX(this.site.getLocation()))).append(", ");
        sb.append("dip=").append(String.format("%.3f", this.eqkRupture.getRuptureSurface().getAveDip())).append(", ");
        sb.append("width=").append(String.format("%.3f", this.eqkRupture.getRuptureSurface().getAveWidth())).append(", ");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public double getExceedProbability() throws ParameterException, IMRException {
        int curveCount = this.imrMap.size();
        if (this.includeImrUncert) {
            curveCount *= 3;
        }
        double[] means = new double[curveCount];
        double[] sigmas = new double[curveCount];
        double[] weights = new double[curveCount];
        int idx = 0;
        for (ScalarIMR imr : this.imrMap.keySet()) {
            double m = imr.getMean();
            double s = imr.getStdDev();
            double w = this.imrMap.get(imr);
            if (this.includeImrUncert) {
                double mag = (Double)this.magParam.getValue();
                double dist = (Double)this.distanceJBParam.getValue();
                double epiVal = NSHMP08_WUS.getUncertainty(mag, dist);
                for (int i = 0; i < 3; ++i) {
                    means[idx] = m + epiVal * EPI_SIGN[i];
                    weights[idx] = w * EPI_WT[i];
                    sigmas[idx] = s;
                    ++idx;
                }
                continue;
            }
            means[idx] = m;
            sigmas[idx] = s;
            weights[idx] = w;
            ++idx;
        }
        double pe = 0.0;
        for (int i = 0; i < means.length; ++i) {
            pe += Utils.getExceedProbability(Math.exp((Double)this.im.getValue()), means[i], sigmas[i], false, 0.0) * weights[i];
        }
        return pe;
    }

    @Override
    protected double getExceedProbability(double mean, double stdDev, double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getExceedProbability(double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getIML_AtExceedProb() throws ParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getIML_AtExceedProb(double exceedProb) throws ParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiscretizedFunc getSA_ExceedProbSpectrum(double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiscretizedFunc getSA_IML_AtExceedProbSpectrum(double exceedProb) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIntensityMeasureLevel(Double iml) throws ParameterException {
        for (ScalarIMR ar : this.imrMap.keySet()) {
            ar.setIntensityMeasureLevel(iml);
        }
    }

    @Override
    public void setIntensityMeasureLevel(Object iml) throws ParameterException {
        for (ScalarIMR ar : this.imrMap.keySet()) {
            ar.setIntensityMeasureLevel(iml);
        }
    }

    @Override
    public void setIntensityMeasure(String intensityMeasureName) throws ParameterException {
        super.setIntensityMeasure(intensityMeasureName);
        for (ScalarIMR ar : this.imrMap.keySet()) {
            ar.setIntensityMeasure(intensityMeasureName);
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        ParameterList pList;
        for (ScalarIMR ar : this.imrMap.keySet()) {
            try {
                Parameter p = ar.getParameter(e.getParameterName());
                Object value = e.getNewValue();
                if (p instanceof WarningParameter) {
                    ((WarningParameter)p).setValueIgnoreWarning(value);
                    continue;
                }
                p.setValue(value);
            }
            catch (ParameterException p) {}
        }
        if (this.otherParams.containsParameter(e.getParameter())) {
            for (ScalarIMR ar : this.imrMap.keySet()) {
                String pName;
                pList = ar.getOtherParams();
                if (!pList.containsParameter(pName = e.getParameterName())) continue;
                Parameter param = ar.getOtherParams().getParameter(e.getParameterName());
                if (param instanceof StringParameter) {
                    ((StringParameter)param).setValue((String)e.getParameter().getValue());
                    continue;
                }
                ((DoubleParameter)param).setValue((Double)e.getParameter().getValue());
            }
        }
        if (e.getParameterName().equals("SA Period")) {
            for (ScalarIMR ar : this.imrMap.keySet()) {
                pList = ar.getSupportedIntensityMeasures();
                SA_Param sap = (SA_Param)pList.getParameter("SA");
                sap.getPeriodParam().setValue((Double)this.saPeriodParam.getValue());
            }
        }
        if (e.getParameterName().equals(IMR_UNCERT_PARAM_NAME)) {
            this.includeImrUncert = (Boolean)e.getParameter().getValue();
        }
        if (e.getParameterName().equals(HW_EFFECT_PARAM_NAME)) {
            this.hwEffectApprox = (Boolean)e.getParameter().getValue();
        }
    }

    private static double getUncertainty(double M, double D) {
        int mi;
        int n = M < 6.0 ? 0 : (mi = M < 7.0 ? 1 : 2);
        int di = D < 10.0 ? 0 : (D < 30.0 ? 1 : 2);
        return EPI_VAL[di][mi];
    }

    private String getFaultTypeForRake(double rake) {
        if (rake >= 45.0 && rake <= 135.0) {
            return "Reverse";
        }
        if (rake >= -135.0 && rake <= -45.0) {
            return "Normal";
        }
        return "Strike-Slip";
    }

    public class NSHMP_BA_2008
    extends BA_2008_AttenRel {
        public NSHMP_BA_2008() {
            super(null);
            this.setParamDefaults();
        }

        @Override
        public void setFaultTypeFromRake(double rake) {
            this.fltTypeParam.setValue(NSHMP08_WUS.this.getFaultTypeForRake(rake));
        }
    }

    public class NSHMP_CB_2008
    extends CB_2008_AttenRel {
        public NSHMP_CB_2008() {
            super(null);
            this.setParamDefaults();
        }

        @Override
        public void setFaultTypeFromRake(double rake) {
            this.fltTypeParam.setValue(NSHMP08_WUS.this.getFaultTypeForRake(rake));
        }

        @Override
        public double getMean(int iper, double vs30, double rRup, double distJB, double f_rv, double f_nm, double mag, double dip, double depthTop, double depthTo2pt5kmPerSec, boolean magSaturation, double pga_rock) {
            double fmag = mag <= 5.5 ? this.c0[iper] + this.c1[iper] * mag : (mag > 5.5 && mag <= 6.5 ? this.c0[iper] + this.c1[iper] * mag + this.c2[iper] * (mag - 5.5) : this.c0[iper] + this.c1[iper] * mag + this.c2[iper] * (mag - 5.5) + this.c3[iper] * (mag - 6.5));
            double fdis = (this.c4[iper] + this.c5[iper] * mag) * Math.log(Math.sqrt(rRup * rRup + this.c6[iper] * this.c6[iper]));
            double ffltz = depthTop < 1.0 ? depthTop : 1.0;
            double fflt = this.c7[iper] * f_rv * ffltz + this.c8[iper] * f_nm;
            double fhng = 0.0;
            if (NSHMP08_WUS.this.hwEffectApprox && (this.eqkRupture == null || this.eqkRupture.getRuptureSurface() instanceof PointSurface)) {
                double hwScale = f_rv + f_nm;
                if (hwScale > 0.0) {
                    fhng = NSHMP_IMR_Util.getAvgHW_CB(mag, distJB, this.per[iper]) * hwScale;
                }
            } else {
                double fhngr = distJB == 0.0 ? 1.0 : (depthTop < 1.0 && distJB > 0.0 ? (Math.max(rRup, Math.sqrt(distJB * distJB + 1.0)) - distJB) / Math.max(rRup, Math.sqrt(distJB * distJB + 1.0)) : (rRup - distJB) / rRup);
                double fhngm = mag <= 6.0 ? 0.0 : (mag > 6.0 && mag < 6.5 ? 2.0 * (mag - 6.0) : 1.0);
                double fhngz = depthTop >= 20.0 ? 0.0 : (20.0 - depthTop) / 20.0;
                double fhngd = dip <= 70.0 ? 1.0 : (90.0 - dip) / 20.0;
                fhng = this.c9[iper] * fhngr * fhngm * fhngz * fhngd;
            }
            double fsite = vs30 < this.k1[iper] ? this.c10[iper] * Math.log(vs30 / this.k1[iper]) + this.k2[iper] * (Math.log(pga_rock + 1.88 * Math.pow(vs30 / this.k1[iper], 1.18)) - Math.log(pga_rock + 1.88)) : (vs30 < 1100.0 ? (this.c10[iper] + this.k2[iper] * 1.18) * Math.log(vs30 / this.k1[iper]) : (this.c10[iper] + this.k2[iper] * 1.18) * Math.log(1100.0 / this.k1[iper]));
            double fsed = depthTo2pt5kmPerSec < 1.0 ? this.c11[iper] * (depthTo2pt5kmPerSec - 1.0) : (depthTo2pt5kmPerSec <= 3.0 ? 0.0 : this.c12[iper] * this.k3[iper] * Math.exp(-0.75) * (1.0 - Math.exp(-0.25 * (depthTo2pt5kmPerSec - 3.0))));
            return fmag + fdis + fflt + fhng + fsite + fsed;
        }
    }

    public class NSHMP_CY_2008
    extends CY_2008_AttenRel {
        public NSHMP_CY_2008() {
            super(null);
            this.setParamDefaults();
        }

        @Override
        public void setFaultTypeFromRake(double rake) {
            this.fltTypeParam.setValue(NSHMP08_WUS.this.getFaultTypeForRake(rake));
        }

        @Override
        protected void compute_lnYref(int iper, double f_rv, double f_nm, double rRup, double distRupMinusJB_OverRup, double distRupMinusDistX_OverRup, double f_hw, double dip, double mag, double depthTop, double aftershock) {
            double distanceJB = rRup - distRupMinusJB_OverRup * rRup;
            double distX = rRup - distRupMinusDistX_OverRup * rRup;
            double cosDelta = Math.cos(dip * Math.PI / 180.0);
            double altDist = Math.sqrt(distanceJB * distanceJB + depthTop * depthTop);
            double hw_effect = 0.0;
            if (NSHMP08_WUS.this.hwEffectApprox && (this.eqkRupture == null || this.eqkRupture.getRuptureSurface() instanceof PointSurface)) {
                double hwScale = f_rv + f_nm;
                if (hwScale > 0.0) {
                    hw_effect = NSHMP_IMR_Util.getAvgHW_CY(mag, distanceJB, period[iper]) * hwScale;
                }
            } else {
                hw_effect = c9[iper] * f_hw * Math.tanh(distX * cosDelta * cosDelta / c9a[iper]) * (1.0 - altDist / (rRup + 0.001));
            }
            double r1 = c1[iper] + 1.06 * (mag - 6.0) + -2.39 / cn[iper] * Math.log(1.0 + Math.exp(cn[iper] * (cm[iper] - mag)));
            double r2 = -2.1 * Math.log(rRup + c5[iper] * Math.cosh(c6[iper] * Math.max(mag - 3.0, 0.0)));
            double r3 = 0.8 * Math.log(rRup * rRup + 2500.0) + (cg1[iper] + cg2[iper] / Math.cosh(Math.max(mag - 4.0, 0.0))) * rRup;
            double r4 = (c1a[iper] * f_rv + c1b[iper] * f_nm + c7[iper] * (depthTop - 4.0)) * (1.0 - aftershock);
            double r5 = (c10[iper] + c7a[iper] * (depthTop - 4.0)) * aftershock;
            this.lnYref = r1 + r2 + r3 + r4 + r5 + hw_effect;
            this.lnYref_is_not_fresh = false;
        }
    }
}

