/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr;

import com.google.common.base.Function;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.nshmp2.imr.GridIMR;
import org.opensha.nshmp2.imr.NSHMP08_WUS;
import org.opensha.nshmp2.util.CurveTable;
import org.opensha.nshmp2.util.Period;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.ScalarIMR;

public class NSHMP08_WUS_Grid
extends NSHMP08_WUS
implements GridIMR {
    public static final String NAME = "NSHMP 2008 WUS Combined (Grid)";
    public static final String SHORT_NAME = "NSHMP08_WUS_GRID";
    private static Table<Period, MechID, CurveTable> tables = HashBasedTable.create();
    private CurveTable table;
    private boolean isGridHybrid = false;
    private static final double R = 200.0;
    private static final double dR = 1.0;
    private static final double minM = 5.0;
    private static final double maxM = 7.6;
    private static final double dM = 0.1;

    public NSHMP08_WUS_Grid() {
        this.getParameter("Depth 1.0 km/sec").setValue(null);
        this.getParameter("Depth 2.5 km/sec").setValue(null);
    }

    public void setGridHybrid(boolean isGridHybrid) {
        this.isGridHybrid = isGridHybrid;
    }

    @Override
    void initImrMap() {
        this.imrMap = Maps.newHashMap();
        this.imrMap.put(new NSHMP_BA_2008_Grid(), 0.3333);
        this.imrMap.put(new NSHMP_CB_2008_Grid(), 0.3333);
        this.imrMap.put(new NSHMP_CY_2008_Grid(), 0.3334);
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setSite(Site site) {
        this.site = site;
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        this.eqkRupture = eqkRupture;
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) throws ParameterException {
        double d = this.eqkRupture.getRuptureSurface().getDistanceJB(this.site.getLocation());
        double m = this.eqkRupture.getMag();
        return this.table.get(d, m);
    }

    @Override
    public DiscretizedFunc getExceedProbFromParent(DiscretizedFunc imls) {
        return super.getExceedProbabilities(imls);
    }

    public void setTable(Function<Double, Double> depthForMag) {
        String ft = (String)this.fltTypeParam.getValue();
        MechID mechID = ft.equals("Strike-Slip") ? MechID.STRIKE_SLIP : (ft.equals("Reverse") ? MechID.STRIKE_REVERSE : MechID.STRIKE_NORMAL);
        String imrName = this.getIntensityMeasure().getName();
        Period p = imrName.equals("PGA") ? Period.GM0P00 : Period.valueForPeriod((Double)this.getParameter("SA Period").getValue());
        this.table = (CurveTable)tables.get((Object)p, (Object)mechID);
        if (this.table == null) {
            this.table = NSHMP08_WUS_Grid.initTable(p, depthForMag, mechID, this);
        }
    }

    private static synchronized CurveTable initTable(Period period, Function<Double, Double> depthForMag, MechID mechID, ScalarIMR imr) {
        CurveTable table = (CurveTable)tables.get((Object)period, (Object)mechID);
        if (table != null) {
            System.out.println("Cached NGA table [" + String.valueOf((Object)period) + ", " + String.valueOf((Object)mechID) + "]");
            return table;
        }
        System.out.println("Building NGA table [" + String.valueOf((Object)period) + ", " + String.valueOf((Object)mechID) + "]");
        imr.setIntensityMeasure(period == Period.GM0P00 ? "PGA" : "SA");
        if (period != Period.GM0P00) {
            imr.getParameter("SA Period").setValue(period.getValue());
        }
        table = CurveTable.create(200.0, 1.0, 5.0, 7.6, 0.1, imr, period.getFunction(), depthForMag);
        tables.put((Object)period, (Object)mechID, (Object)table);
        return table;
    }

    public static void main(String[] args) {
        NSHMP08_WUS_Grid imr = new NSHMP08_WUS_Grid();
        Period per = Period.GM0P00;
        imr.setIntensityMeasure(per == Period.GM0P00 ? "PGA" : "SA");
        if (per != Period.GM0P00) {
            imr.getParameter("SA Period").setValue(per.getValue());
        }
        imr.getParameter("Fault Type").setValue("Reverse");
        imr.setGridHybrid(true);
        Function<Double, Double> func = new Function<Double, Double>(){

            public Double apply(Double mag) {
                return mag < 6.5 ? 5.0 : 1.0;
            }
        };
        imr.setTable(func);
        System.out.println(((CurveTable)tables.get((Object)per, (Object)MechID.STRIKE_REVERSE)).get(10.5, 6.65));
    }

    class NSHMP_BA_2008_Grid
    extends NSHMP08_WUS.NSHMP_BA_2008 {
        NSHMP_BA_2008_Grid() {
            super(NSHMP08_WUS_Grid.this);
        }

        @Override
        public double getMean(int iper, double vs30, double rjb, double mag, String fltType, double pga4nl) {
            double Fs;
            double U = 0.0;
            double S = 0.0;
            double N = 0.0;
            double R = 0.0;
            if (fltType.equals("Unknown")) {
                U = 1.0;
            } else if (fltType.equals("Normal")) {
                N = NSHMP08_WUS_Grid.this.isGridHybrid ? 0.5 : 1.0;
                S = NSHMP08_WUS_Grid.this.isGridHybrid ? 0.5 : 0.0;
            } else if (fltType.equals("Reverse")) {
                R = NSHMP08_WUS_Grid.this.isGridHybrid ? 0.5 : 1.0;
                S = NSHMP08_WUS_Grid.this.isGridHybrid ? 0.5 : 0.0;
            } else {
                S = 1.0;
            }
            double magDiff = mag - this.mh[iper];
            double Fm = mag <= this.mh[iper] ? this.e1[iper] * U + this.e2[iper] * S + this.e3[iper] * N + this.e4[iper] * R + this.e5[iper] * magDiff + this.e6[iper] * magDiff * magDiff : this.e1[iper] * U + this.e2[iper] * S + this.e3[iper] * N + this.e4[iper] * R + this.e7[iper] * (mag - this.mh[iper]);
            double r = Math.sqrt(rjb * rjb + this.h[iper] * this.h[iper]);
            double Fd = (this.c1[iper] + this.c2[iper] * (mag - this.m_ref)) * Math.log(r / this.r_ref) + this.c3[iper] * (r - this.r_ref);
            if (iper == 0) {
                Fs = 0.0;
            } else {
                double Fnl;
                double Flin = this.b_lin[iper] * Math.log(vs30 / this.v_ref);
                double bnl = 0.0;
                bnl = vs30 <= this.v1 ? this.b1[iper] : (vs30 <= this.v2 && vs30 > this.v1 ? (this.b1[iper] - this.b2[iper]) * Math.log(vs30 / this.v2) / Math.log(this.v1 / this.v2) + this.b2[iper] : (vs30 < this.v_ref && vs30 > this.v2 ? this.b2[iper] * Math.log(vs30 / this.v_ref) / Math.log(this.v2 / this.v_ref) : 0.0));
                if (pga4nl <= this.a1) {
                    Fnl = bnl * Math.log(this.pgalow / 0.1);
                } else if (pga4nl <= this.a2 & pga4nl > this.a1) {
                    double dX = Math.log(this.a2 / this.a1);
                    double dY = bnl * Math.log(this.a2 / this.pgalow);
                    double c = (3.0 * dY - bnl * dX) / (dX * dX);
                    double d = -(2.0 * dY - bnl * dX) / (dX * dX * dX);
                    Fnl = bnl * Math.log(this.pgalow / 0.1) + c * Math.pow(Math.log(pga4nl / this.a1), 2.0) + d * Math.pow(Math.log(pga4nl / this.a1), 3.0);
                } else {
                    Fnl = bnl * Math.log(pga4nl / 0.1);
                }
                Fs = Flin + Fnl;
            }
            return Fm + Fd + Fs;
        }

        @Override
        public double getStdDev(int iper, String stdDevType, String fltType) {
            return super.getStdDev(iper, stdDevType, "Unknown");
        }
    }

    class NSHMP_CB_2008_Grid
    extends NSHMP08_WUS.NSHMP_CB_2008 {
        NSHMP_CB_2008_Grid() {
            super(NSHMP08_WUS_Grid.this);
        }

        @Override
        public double getMean(int iper, double vs30, double rRup, double distJB, double f_rv, double f_nm, double mag, double dip, double depthTop, double depthTo2pt5kmPerSec, boolean magSaturation, double pga_rock) {
            if (NSHMP08_WUS_Grid.this.isGridHybrid) {
                if (f_nm > 0.0) {
                    f_nm = 0.5;
                }
                if (f_rv > 0.0) {
                    f_rv = 0.5;
                }
            }
            return super.getMean(iper, vs30, rRup, distJB, f_rv, f_nm, mag, dip, depthTop, depthTo2pt5kmPerSec, magSaturation, pga_rock);
        }
    }

    class NSHMP_CY_2008_Grid
    extends NSHMP08_WUS.NSHMP_CY_2008 {
        NSHMP_CY_2008_Grid() {
            super(NSHMP08_WUS_Grid.this);
        }

        @Override
        protected void compute_lnYref(int iper, double f_rv, double f_nm, double rRup, double distRupMinusJB_OverRup, double distRupMinusDistX_OverRup, double f_hw, double dip, double mag, double depthTop, double aftershock) {
            if (NSHMP08_WUS_Grid.this.isGridHybrid) {
                if (f_nm > 0.0) {
                    f_nm = 0.5;
                }
                if (f_rv > 0.0) {
                    f_rv = 0.5;
                }
            }
            super.compute_lnYref(iper, f_rv, f_nm, rRup, distRupMinusJB_OverRup, distRupMinusDistX_OverRup, f_hw, dip, mag, depthTop, aftershock);
        }
    }

    private static enum MechID {
        STRIKE_SLIP,
        STRIKE_REVERSE,
        STRIKE_NORMAL;

    }
}

